/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.rabbit.health;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.reactivecommons.async.rabbit.config.ConnectionFactoryProvider;
import org.springframework.boot.actuate.health.AbstractReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import reactor.core.publisher.Mono;

public class RabbitReactiveHealthIndicator
extends AbstractReactiveHealthIndicator {
    private static final String VERSION = "version";
    private final ConnectionFactoryProvider provider;

    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        return Mono.defer(this::getVersion).map(version -> builder.up().withDetail(VERSION, version).build());
    }

    private Mono<String> getVersion() {
        return Mono.just((Object)this.provider).map(ConnectionFactoryProvider::getConnectionFactory).map(this::getRawVersion);
    }

    private String getRawVersion(ConnectionFactory factory) {
        String string;
        block8: {
            Connection connection = factory.newConnection();
            try {
                string = connection.getServerProperties().get(VERSION).toString();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            connection.close();
        }
        return string;
    }

    @ConstructorProperties(value={"provider"})
    @Generated
    public RabbitReactiveHealthIndicator(ConnectionFactoryProvider provider) {
        this.provider = provider;
    }
}

