/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.impl;

import java.util.function.Function;
import org.reactivecommons.api.domain.Command;
import org.reactivecommons.async.api.handlers.CommandHandler;
import org.reactivecommons.async.impl.communications.Message;
import reactor.core.publisher.Mono;

public class CommandExecutor<T> {
    private final CommandHandler<T> eventHandler;
    private final Function<Message, Command<T>> converter;

    public CommandExecutor(CommandHandler<T> eventHandler, Function<Message, Command<T>> converter) {
        this.eventHandler = eventHandler;
        this.converter = converter;
    }

    public Mono<Void> execute(Message rawMessage) {
        return this.eventHandler.handle(this.converter.apply(rawMessage));
    }
}

