/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.impl;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.reactivecommons.async.api.handlers.registered.RegisteredCommandHandler;
import org.reactivecommons.async.api.handlers.registered.RegisteredEventListener;
import org.reactivecommons.async.api.handlers.registered.RegisteredQueryHandler;

public class HandlerResolver {
    private final Map<String, RegisteredQueryHandler> queryHandlers;
    private final Map<String, RegisteredEventListener> eventListeners;
    private final Map<String, RegisteredCommandHandler> commandHandlers;
    private final Map<String, RegisteredEventListener> eventNotificationListeners;

    public <T, R> RegisteredQueryHandler<T, R> getQueryHandler(String path) {
        return this.queryHandlers.get(path);
    }

    public <T> RegisteredCommandHandler<T> getCommandHandler(String path) {
        return this.commandHandlers.get(path);
    }

    public <T> RegisteredEventListener<T> getEventListener(String path) {
        return this.eventListeners.get(path);
    }

    public Collection<RegisteredEventListener> getNotificationListeners() {
        return this.eventNotificationListeners.values();
    }

    public <T> RegisteredEventListener<T> getNotificationListener(String path) {
        return this.eventNotificationListeners.get(path);
    }

    public Collection<RegisteredEventListener> getEventListeners() {
        return this.eventListeners.values();
    }

    void addEventListener(RegisteredEventListener listener) {
        this.eventListeners.put(listener.getPath(), listener);
    }

    @ConstructorProperties(value={"queryHandlers", "eventListeners", "commandHandlers", "eventNotificationListeners"})
    @Generated
    public HandlerResolver(Map<String, RegisteredQueryHandler> queryHandlers, Map<String, RegisteredEventListener> eventListeners, Map<String, RegisteredCommandHandler> commandHandlers, Map<String, RegisteredEventListener> eventNotificationListeners) {
        this.queryHandlers = queryHandlers;
        this.eventListeners = eventListeners;
        this.commandHandlers = commandHandlers;
        this.eventNotificationListeners = eventNotificationListeners;
    }
}

