/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.impl;

import java.util.Collections;
import org.reactivecommons.api.domain.DomainEvent;
import org.reactivecommons.api.domain.DomainEventBus;
import org.reactivecommons.async.impl.communications.ReactiveMessageSender;
import org.reactivecommons.async.impl.config.BrokerConfig;
import reactor.core.publisher.Mono;

public class RabbitDomainEventBus
implements DomainEventBus {
    private final ReactiveMessageSender sender;
    private final String exchange;
    private final boolean persistentEvents;

    public RabbitDomainEventBus(ReactiveMessageSender sender, String exchange) {
        this(sender, exchange, new BrokerConfig());
    }

    public RabbitDomainEventBus(ReactiveMessageSender sender, String exchange, BrokerConfig config) {
        this.sender = sender;
        this.exchange = exchange;
        this.persistentEvents = config.isPersistentEvents();
    }

    public <T> Mono<Void> emit(DomainEvent<T> event) {
        return this.sender.sendWithConfirm(event, this.exchange, event.getName(), Collections.emptyMap(), this.persistentEvents).onErrorMap(err -> new RuntimeException("Event send failure: " + event.getName(), (Throwable)err));
    }
}

