/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.impl;

import com.rabbitmq.client.Delivery;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.reactivecommons.async.impl.communications.Message;

public class RabbitMessage
implements Message {
    private final byte[] body;
    private final Message.Properties properties;

    public static RabbitMessage fromDelivery(Delivery delivery) {
        return new RabbitMessage(delivery.getBody(), RabbitMessage.createMessageProps(delivery));
    }

    private static Message.Properties createMessageProps(Delivery msj) {
        RabbitMessageProperties properties = new RabbitMessageProperties();
        properties.setHeaders(msj.getProperties().getHeaders());
        properties.setContentType(msj.getProperties().getContentType());
        properties.setContentEncoding(msj.getProperties().getContentEncoding());
        return properties;
    }

    @ConstructorProperties(value={"body", "properties"})
    @Generated
    public RabbitMessage(byte[] body, Message.Properties properties) {
        this.body = body;
        this.properties = properties;
    }

    @Override
    @Generated
    public byte[] getBody() {
        return this.body;
    }

    @Override
    @Generated
    public Message.Properties getProperties() {
        return this.properties;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RabbitMessage)) {
            return false;
        }
        RabbitMessage other = (RabbitMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getBody(), other.getBody())) {
            return false;
        }
        Message.Properties this$properties = this.getProperties();
        Message.Properties other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !this$properties.equals(other$properties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RabbitMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getBody());
        Message.Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RabbitMessage(body=" + Arrays.toString(this.getBody()) + ", properties=" + this.getProperties() + ")";
    }

    public static class RabbitMessageProperties
    implements Message.Properties {
        private String contentType;
        private String contentEncoding;
        private long contentLength;
        private Map<String, Object> headers = new HashMap<String, Object>();

        @Generated
        public RabbitMessageProperties() {
        }

        @Override
        @Generated
        public String getContentType() {
            return this.contentType;
        }

        @Override
        @Generated
        public String getContentEncoding() {
            return this.contentEncoding;
        }

        @Override
        @Generated
        public long getContentLength() {
            return this.contentLength;
        }

        @Override
        @Generated
        public Map<String, Object> getHeaders() {
            return this.headers;
        }

        @Generated
        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Generated
        public void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        @Generated
        public void setContentLength(long contentLength) {
            this.contentLength = contentLength;
        }

        @Generated
        public void setHeaders(Map<String, Object> headers) {
            this.headers = headers;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RabbitMessageProperties)) {
                return false;
            }
            RabbitMessageProperties other = (RabbitMessageProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$contentType = this.getContentType();
            String other$contentType = other.getContentType();
            if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
                return false;
            }
            String this$contentEncoding = this.getContentEncoding();
            String other$contentEncoding = other.getContentEncoding();
            if (this$contentEncoding == null ? other$contentEncoding != null : !this$contentEncoding.equals(other$contentEncoding)) {
                return false;
            }
            if (this.getContentLength() != other.getContentLength()) {
                return false;
            }
            Map<String, Object> this$headers = this.getHeaders();
            Map<String, Object> other$headers = other.getHeaders();
            return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RabbitMessageProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $contentType = this.getContentType();
            result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
            String $contentEncoding = this.getContentEncoding();
            result = result * 59 + ($contentEncoding == null ? 43 : $contentEncoding.hashCode());
            long $contentLength = this.getContentLength();
            result = result * 59 + (int)($contentLength >>> 32 ^ $contentLength);
            Map<String, Object> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RabbitMessage.RabbitMessageProperties(contentType=" + this.getContentType() + ", contentEncoding=" + this.getContentEncoding() + ", contentLength=" + this.getContentLength() + ", headers=" + this.getHeaders() + ")";
        }
    }
}

