/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.impl.config;

import java.time.Duration;
import java.util.UUID;

public class BrokerConfig {
    private final String routingKey = UUID.randomUUID().toString().replaceAll("-", "");
    private final boolean persistentQueries;
    private final boolean persistentCommands;
    private final boolean persistentEvents;
    private final Duration replyTimeout;

    public BrokerConfig() {
        this.persistentQueries = false;
        this.persistentCommands = true;
        this.persistentEvents = true;
        this.replyTimeout = Duration.ofSeconds(15L);
    }

    public BrokerConfig(boolean persistentQueries, boolean persistentCommands, boolean persistentEvents, Duration replyTimeout) {
        this.persistentQueries = persistentQueries;
        this.persistentCommands = persistentCommands;
        this.persistentEvents = persistentEvents;
        this.replyTimeout = replyTimeout;
    }

    public boolean isPersistentQueries() {
        return this.persistentQueries;
    }

    public boolean isPersistentCommands() {
        return this.persistentCommands;
    }

    public boolean isPersistentEvents() {
        return this.persistentEvents;
    }

    public Duration getReplyTimeout() {
        return this.replyTimeout;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }
}

