/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.impl.converters.json;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.Charset;
import lombok.Generated;
import org.reactivecommons.api.domain.Command;
import org.reactivecommons.api.domain.DomainEvent;
import org.reactivecommons.async.api.AsyncQuery;
import org.reactivecommons.async.impl.RabbitMessage;
import org.reactivecommons.async.impl.communications.Message;
import org.reactivecommons.async.impl.converters.MessageConverter;
import org.reactivecommons.async.impl.exceptions.MessageConversionException;

public class JacksonMessageConverter
implements MessageConverter {
    private static final String ENCODING = Charset.defaultCharset().name();
    private static final String CONTENT_TYPE = "application/json";
    private final ObjectMapper objectMapper;

    public JacksonMessageConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> AsyncQuery<T> readAsyncQuery(Message message, Class<T> bodyClass) {
        try {
            AsyncQueryJson asyncQueryJson = (AsyncQueryJson)this.objectMapper.readValue(message.getBody(), AsyncQueryJson.class);
            Object value = this.objectMapper.treeToValue((TreeNode)asyncQueryJson.getQueryData(), bodyClass);
            return new AsyncQuery(asyncQueryJson.getResource(), value);
        }
        catch (IOException e) {
            throw new MessageConversionException("Failed to convert Message content", e);
        }
    }

    @Override
    public <T> DomainEvent<T> readDomainEvent(Message message, Class<T> bodyClass) {
        try {
            DomainEventJson domainEventJson = (DomainEventJson)this.objectMapper.readValue(message.getBody(), DomainEventJson.class);
            Object value = this.objectMapper.treeToValue((TreeNode)domainEventJson.getData(), bodyClass);
            return new DomainEvent(domainEventJson.getName(), domainEventJson.getEventId(), value);
        }
        catch (IOException e) {
            throw new MessageConversionException("Failed to convert Message content", e);
        }
    }

    @Override
    public <T> Command<T> readCommand(Message message, Class<T> bodyClass) {
        try {
            CommandJson commandJson = (CommandJson)this.objectMapper.readValue(message.getBody(), CommandJson.class);
            Object value = this.objectMapper.treeToValue((TreeNode)commandJson.getData(), bodyClass);
            return new Command(commandJson.getName(), commandJson.getCommandId(), value);
        }
        catch (IOException e) {
            throw new MessageConversionException("Failed to convert Message content", e);
        }
    }

    @Override
    public <T> T readValue(Message message, Class<T> valueClass) {
        try {
            return (T)this.objectMapper.readValue(message.getBody(), valueClass);
        }
        catch (IOException e) {
            throw new MessageConversionException("Failed to convert Message content", e);
        }
    }

    @Override
    public <T> Command<T> readCommandStructure(Message message) {
        try {
            CommandJson commandJson = (CommandJson)this.objectMapper.readValue(message.getBody(), CommandJson.class);
            return new Command(commandJson.getName(), commandJson.getCommandId(), (Object)commandJson.getData());
        }
        catch (IOException e) {
            throw new MessageConversionException("Failed to convert Message content", e);
        }
    }

    @Override
    public Message toMessage(Object object) {
        byte[] bytes;
        try {
            String jsonString = this.objectMapper.writeValueAsString(object);
            bytes = jsonString.getBytes(ENCODING);
        }
        catch (IOException e) {
            throw new MessageConversionException("Failed to convert Message content", e);
        }
        RabbitMessage.RabbitMessageProperties props = new RabbitMessage.RabbitMessageProperties();
        props.setContentType(CONTENT_TYPE);
        props.setContentEncoding(ENCODING);
        props.setContentLength(bytes.length);
        return new RabbitMessage(bytes, props);
    }

    private static class CommandJson {
        private String name;
        private String commandId;
        private JsonNode data;

        @Generated
        public CommandJson() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getCommandId() {
            return this.commandId;
        }

        @Generated
        public JsonNode getData() {
            return this.data;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        @Generated
        public void setData(JsonNode data) {
            this.data = data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CommandJson)) {
                return false;
            }
            CommandJson other = (CommandJson)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$commandId = this.getCommandId();
            String other$commandId = other.getCommandId();
            if (this$commandId == null ? other$commandId != null : !this$commandId.equals(other$commandId)) {
                return false;
            }
            JsonNode this$data = this.getData();
            JsonNode other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CommandJson;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $commandId = this.getCommandId();
            result = result * 59 + ($commandId == null ? 43 : $commandId.hashCode());
            JsonNode $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JacksonMessageConverter.CommandJson(name=" + this.getName() + ", commandId=" + this.getCommandId() + ", data=" + this.getData() + ")";
        }
    }

    private static class DomainEventJson {
        private String name;
        private String eventId;
        private JsonNode data;

        @Generated
        public DomainEventJson() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getEventId() {
            return this.eventId;
        }

        @Generated
        public JsonNode getData() {
            return this.data;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Generated
        public void setData(JsonNode data) {
            this.data = data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DomainEventJson)) {
                return false;
            }
            DomainEventJson other = (DomainEventJson)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$eventId = this.getEventId();
            String other$eventId = other.getEventId();
            if (this$eventId == null ? other$eventId != null : !this$eventId.equals(other$eventId)) {
                return false;
            }
            JsonNode this$data = this.getData();
            JsonNode other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DomainEventJson;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $eventId = this.getEventId();
            result = result * 59 + ($eventId == null ? 43 : $eventId.hashCode());
            JsonNode $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JacksonMessageConverter.DomainEventJson(name=" + this.getName() + ", eventId=" + this.getEventId() + ", data=" + this.getData() + ")";
        }
    }

    private static class AsyncQueryJson {
        private String resource;
        private JsonNode queryData;

        @Generated
        public AsyncQueryJson() {
        }

        @Generated
        public String getResource() {
            return this.resource;
        }

        @Generated
        public JsonNode getQueryData() {
            return this.queryData;
        }

        @Generated
        public void setResource(String resource) {
            this.resource = resource;
        }

        @Generated
        public void setQueryData(JsonNode queryData) {
            this.queryData = queryData;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsyncQueryJson)) {
                return false;
            }
            AsyncQueryJson other = (AsyncQueryJson)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$resource = this.getResource();
            String other$resource = other.getResource();
            if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
                return false;
            }
            JsonNode this$queryData = this.getQueryData();
            JsonNode other$queryData = other.getQueryData();
            return !(this$queryData == null ? other$queryData != null : !this$queryData.equals(other$queryData));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AsyncQueryJson;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $resource = this.getResource();
            result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
            JsonNode $queryData = this.getQueryData();
            result = result * 59 + ($queryData == null ? 43 : $queryData.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JacksonMessageConverter.AsyncQueryJson(resource=" + this.getResource() + ", queryData=" + this.getQueryData() + ")";
        }
    }
}

