/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.impl.listeners;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Delivery;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;
import lombok.Generated;
import org.reactivecommons.api.domain.Command;
import org.reactivecommons.async.api.handlers.registered.RegisteredCommandHandler;
import org.reactivecommons.async.impl.CommandExecutor;
import org.reactivecommons.async.impl.DiscardNotifier;
import org.reactivecommons.async.impl.HandlerResolver;
import org.reactivecommons.async.impl.RabbitMessage;
import org.reactivecommons.async.impl.communications.Message;
import org.reactivecommons.async.impl.communications.ReactiveMessageListener;
import org.reactivecommons.async.impl.communications.TopologyCreator;
import org.reactivecommons.async.impl.converters.MessageConverter;
import org.reactivecommons.async.impl.listeners.GenericMessageListener;
import reactor.core.publisher.Mono;
import reactor.rabbitmq.AcknowledgableDelivery;
import reactor.rabbitmq.BindingSpecification;
import reactor.rabbitmq.ExchangeSpecification;

public class ApplicationCommandListener
extends GenericMessageListener {
    @Generated
    private static final Logger log = Logger.getLogger(ApplicationCommandListener.class.getName());
    private final MessageConverter messageConverter;
    private final HandlerResolver resolver;
    private final String directExchange;
    private final boolean withDLQRetry;
    private final int retryDelay;
    private final Optional<Integer> maxLengthBytes;

    public ApplicationCommandListener(ReactiveMessageListener listener, String queueName, HandlerResolver resolver, String directExchange, MessageConverter messageConverter, boolean withDLQRetry, long maxRetries, int retryDelay, Optional<Integer> maxLengthBytes, DiscardNotifier discardNotifier) {
        super(queueName, listener, withDLQRetry, maxRetries, discardNotifier, "command");
        this.retryDelay = retryDelay;
        this.withDLQRetry = withDLQRetry;
        this.resolver = resolver;
        this.directExchange = directExchange;
        this.messageConverter = messageConverter;
        this.maxLengthBytes = maxLengthBytes;
    }

    @Override
    protected Mono<Void> setUpBindings(TopologyCreator creator) {
        if (this.withDLQRetry) {
            Mono<AMQP.Exchange.DeclareOk> declareExchange = creator.declare(ExchangeSpecification.exchange((String)this.directExchange).durable(true).type("direct"));
            Mono<AMQP.Exchange.DeclareOk> declareExchangeDLQ = creator.declare(ExchangeSpecification.exchange((String)(this.directExchange + ".DLQ")).durable(true).type("direct"));
            Mono<AMQP.Queue.DeclareOk> declareQueue = creator.declareQueue(this.queueName, this.directExchange + ".DLQ", this.maxLengthBytes);
            Mono<AMQP.Queue.DeclareOk> declareDLQ = creator.declareDLQ(this.queueName, this.directExchange, this.retryDelay, this.maxLengthBytes);
            Mono<AMQP.Queue.BindOk> binding = creator.bind(BindingSpecification.binding((String)this.directExchange, (String)this.queueName, (String)this.queueName));
            Mono<AMQP.Queue.BindOk> bindingDLQ = creator.bind(BindingSpecification.binding((String)(this.directExchange + ".DLQ"), (String)this.queueName, (String)(this.queueName + ".DLQ")));
            return declareExchange.then(declareExchangeDLQ).then(declareDLQ).then(declareQueue).then(bindingDLQ).then(binding).then();
        }
        Mono<AMQP.Exchange.DeclareOk> declareExchange = creator.declare(ExchangeSpecification.exchange((String)this.directExchange).durable(true).type("direct"));
        Mono<AMQP.Queue.DeclareOk> declareQueue = creator.declareQueue(this.queueName, this.maxLengthBytes);
        Mono<AMQP.Queue.BindOk> binding = creator.bind(BindingSpecification.binding((String)this.directExchange, (String)this.queueName, (String)this.queueName));
        return declareExchange.then(declareQueue).then(binding).then();
    }

    @Override
    protected Function<Message, Mono<Object>> rawMessageHandler(String executorPath) {
        RegisteredCommandHandler handler = this.resolver.getCommandHandler(executorPath);
        Class eventClass = handler.getInputClass();
        Function converter = msj -> this.messageConverter.readCommand((Message)msj, eventClass);
        CommandExecutor executor = new CommandExecutor(handler.getHandler(), converter);
        return msj -> executor.execute((Message)msj).cast(Object.class);
    }

    @Override
    protected String getExecutorPath(AcknowledgableDelivery msj) {
        Command command = this.messageConverter.readCommandStructure(RabbitMessage.fromDelivery((Delivery)msj));
        return command.getName();
    }
}

