/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.impl.listeners;

import com.rabbitmq.client.AMQP;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.reactivecommons.async.api.handlers.registered.RegisteredEventListener;
import org.reactivecommons.async.impl.DiscardNotifier;
import org.reactivecommons.async.impl.EventExecutor;
import org.reactivecommons.async.impl.HandlerResolver;
import org.reactivecommons.async.impl.communications.Message;
import org.reactivecommons.async.impl.communications.ReactiveMessageListener;
import org.reactivecommons.async.impl.communications.TopologyCreator;
import org.reactivecommons.async.impl.converters.MessageConverter;
import org.reactivecommons.async.impl.listeners.GenericMessageListener;
import org.reactivecommons.async.impl.utils.matcher.KeyMatcher;
import org.reactivecommons.async.impl.utils.matcher.Matcher;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.rabbitmq.AcknowledgableDelivery;
import reactor.rabbitmq.BindingSpecification;
import reactor.rabbitmq.ExchangeSpecification;

public class ApplicationEventListener
extends GenericMessageListener {
    @Generated
    private static final Logger log = Logger.getLogger(ApplicationEventListener.class.getName());
    private final MessageConverter messageConverter;
    private final HandlerResolver resolver;
    private final String eventsExchange;
    private final boolean withDLQRetry;
    private final int retryDelay;
    private final Optional<Integer> maxLengthBytes;
    private final Matcher keyMatcher;

    public ApplicationEventListener(ReactiveMessageListener receiver, String queueName, HandlerResolver resolver, String eventsExchange, MessageConverter messageConverter, boolean withDLQRetry, long maxRetries, int retryDelay, Optional<Integer> maxLengthBytes, DiscardNotifier discardNotifier) {
        super(queueName, receiver, withDLQRetry, maxRetries, discardNotifier, "event");
        this.retryDelay = retryDelay;
        this.withDLQRetry = withDLQRetry;
        this.resolver = resolver;
        this.eventsExchange = eventsExchange;
        this.messageConverter = messageConverter;
        this.maxLengthBytes = maxLengthBytes;
        this.keyMatcher = new KeyMatcher();
    }

    @Override
    protected Mono<Void> setUpBindings(TopologyCreator creator) {
        if (this.withDLQRetry) {
            Mono<AMQP.Exchange.DeclareOk> declareExchange = creator.declare(ExchangeSpecification.exchange((String)this.eventsExchange).durable(true).type("topic"));
            Mono<AMQP.Exchange.DeclareOk> declareExchangeDLQ = creator.declare(ExchangeSpecification.exchange((String)(this.eventsExchange + ".DLQ")).durable(true).type("topic"));
            Mono<AMQP.Queue.DeclareOk> declareDLQ = creator.declareDLQ(this.queueName, this.eventsExchange, this.retryDelay, this.maxLengthBytes);
            Mono<AMQP.Queue.DeclareOk> declareQueue = creator.declareQueue(this.queueName, this.eventsExchange + ".DLQ", this.maxLengthBytes);
            Flux bindings = Flux.fromIterable(this.resolver.getEventListeners()).flatMap(listener -> creator.bind(BindingSpecification.binding((String)this.eventsExchange, (String)listener.getPath(), (String)this.queueName)));
            Flux bindingDLQ = Flux.fromIterable(this.resolver.getEventListeners()).flatMap(listener -> creator.bind(BindingSpecification.binding((String)(this.eventsExchange + ".DLQ"), (String)listener.getPath(), (String)(this.queueName + ".DLQ"))));
            return declareExchange.then(declareExchangeDLQ).then(declareQueue).then(declareDLQ).thenMany((Publisher)bindings).thenMany((Publisher)bindingDLQ).then();
        }
        Flux bindings = Flux.fromIterable(this.resolver.getEventListeners()).flatMap(listener -> creator.bind(BindingSpecification.binding((String)this.eventsExchange, (String)listener.getPath(), (String)this.queueName)));
        Mono<AMQP.Exchange.DeclareOk> declareExchange = creator.declare(ExchangeSpecification.exchange((String)this.eventsExchange).durable(true).type("topic"));
        Mono<AMQP.Queue.DeclareOk> declareQueue = creator.declareQueue(this.queueName, this.maxLengthBytes);
        return declareExchange.then(declareQueue).thenMany((Publisher)bindings).then();
    }

    @Override
    protected Function<Message, Mono<Object>> rawMessageHandler(String executorPath) {
        Set<String> listenerKeys = this.resolver.getEventListeners().stream().map(RegisteredEventListener::getPath).collect(Collectors.toSet());
        String matchedKey = this.keyMatcher.match(listenerKeys, executorPath);
        RegisteredEventListener handler = this.resolver.getEventListener(matchedKey);
        Class eventClass = handler.getInputClass();
        Function converter = msj -> this.messageConverter.readDomainEvent((Message)msj, eventClass);
        EventExecutor executor = new EventExecutor(handler.getHandler(), converter);
        return msj -> executor.execute((Message)msj).cast(Object.class);
    }

    @Override
    protected String getExecutorPath(AcknowledgableDelivery msj) {
        return msj.getEnvelope().getRoutingKey();
    }
}

