/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.impl.listeners;

import com.rabbitmq.client.AMQP;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;
import lombok.Generated;
import org.reactivecommons.async.api.handlers.registered.RegisteredQueryHandler;
import org.reactivecommons.async.impl.DiscardNotifier;
import org.reactivecommons.async.impl.HandlerResolver;
import org.reactivecommons.async.impl.QueryExecutor;
import org.reactivecommons.async.impl.communications.Message;
import org.reactivecommons.async.impl.communications.ReactiveMessageListener;
import org.reactivecommons.async.impl.communications.ReactiveMessageSender;
import org.reactivecommons.async.impl.communications.TopologyCreator;
import org.reactivecommons.async.impl.converters.MessageConverter;
import org.reactivecommons.async.impl.listeners.GenericMessageListener;
import reactor.core.publisher.Mono;
import reactor.rabbitmq.AcknowledgableDelivery;
import reactor.rabbitmq.BindingSpecification;
import reactor.rabbitmq.ExchangeSpecification;

public class ApplicationQueryListener
extends GenericMessageListener {
    @Generated
    private static final Logger log = Logger.getLogger(ApplicationQueryListener.class.getName());
    private final MessageConverter converter;
    private final HandlerResolver handlerResolver;
    private final ReactiveMessageSender sender;
    private final String replyExchange;
    private final String directExchange;
    private final boolean withDLQRetry;
    private final int retryDelay;
    private final Optional<Integer> maxLengthBytes;

    public ApplicationQueryListener(ReactiveMessageListener listener, String queueName, HandlerResolver resolver, ReactiveMessageSender sender, String directExchange, MessageConverter converter, String replyExchange, boolean withDLQRetry, long maxRetries, int retryDelay, Optional<Integer> maxLengthBytes, DiscardNotifier discardNotifier) {
        super(queueName, listener, withDLQRetry, maxRetries, discardNotifier, "query");
        this.retryDelay = retryDelay;
        this.withDLQRetry = withDLQRetry;
        this.converter = converter;
        this.handlerResolver = resolver;
        this.sender = sender;
        this.replyExchange = replyExchange;
        this.directExchange = directExchange;
        this.maxLengthBytes = maxLengthBytes;
    }

    @Override
    protected Function<Message, Mono<Object>> rawMessageHandler(String executorPath) {
        RegisteredQueryHandler handler1 = this.handlerResolver.getQueryHandler(executorPath);
        if (handler1 == null) {
            return message -> Mono.error((Throwable)new RuntimeException("Handler Not registered for Query: " + executorPath));
        }
        Class handlerClass = handler1.getQueryClass();
        Function<Message, Object> messageConverter = msj -> this.converter.readAsyncQuery((Message)msj, handlerClass).getQueryData();
        QueryExecutor executor = new QueryExecutor(handler1.getHandler(), messageConverter);
        return executor::execute;
    }

    @Override
    protected Mono<Void> setUpBindings(TopologyCreator creator) {
        if (this.withDLQRetry) {
            Mono<AMQP.Exchange.DeclareOk> declareExchange = creator.declare(ExchangeSpecification.exchange((String)this.directExchange).durable(true).type("direct"));
            Mono<AMQP.Exchange.DeclareOk> declareExchangeDLQ = creator.declare(ExchangeSpecification.exchange((String)(this.directExchange + ".DLQ")).durable(true).type("direct"));
            Mono<AMQP.Queue.DeclareOk> declareQueue = creator.declareQueue(this.queueName, this.directExchange + ".DLQ", this.maxLengthBytes);
            Mono<AMQP.Queue.DeclareOk> declareDLQ = creator.declareDLQ(this.queueName, this.directExchange, this.retryDelay, this.maxLengthBytes);
            Mono<AMQP.Queue.BindOk> binding = creator.bind(BindingSpecification.binding((String)this.directExchange, (String)this.queueName, (String)this.queueName));
            Mono<AMQP.Queue.BindOk> bindingDLQ = creator.bind(BindingSpecification.binding((String)(this.directExchange + ".DLQ"), (String)this.queueName, (String)(this.queueName + ".DLQ")));
            return declareExchange.then(declareExchangeDLQ).then(declareQueue).then(declareDLQ).then(binding).then(bindingDLQ).then();
        }
        Mono<AMQP.Exchange.DeclareOk> declareExchange = creator.declare(ExchangeSpecification.exchange((String)this.directExchange).durable(true).type("direct"));
        Mono<AMQP.Queue.DeclareOk> declareQueue = creator.declareQueue(this.queueName, this.maxLengthBytes);
        Mono<AMQP.Queue.BindOk> binding = creator.bind(BindingSpecification.binding((String)this.directExchange, (String)this.queueName, (String)this.queueName));
        return declareExchange.then(declareQueue).then(binding).then();
    }

    @Override
    protected String getExecutorPath(AcknowledgableDelivery msj) {
        return msj.getProperties().getHeaders().get("x-serveQuery-id").toString();
    }

    @Override
    protected Function<Mono<Object>, Mono<Object>> enrichPostProcess(Message msg) {
        return m -> m.materialize().flatMap(signal -> {
            if (signal.isOnError()) {
                return Mono.error((Throwable)Optional.ofNullable(signal.getThrowable()).orElseGet(RuntimeException::new));
            }
            String replyID = msg.getProperties().getHeaders().get("x-reply_id").toString();
            String correlationID = msg.getProperties().getHeaders().get("x-correlation-id").toString();
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("x-correlation-id", correlationID);
            if (!signal.hasValue()) {
                headers.put("x-empty-completion", Boolean.TRUE.toString());
            }
            return this.sender.sendNoConfirm(signal.get(), this.replyExchange, replyID, headers, false);
        });
    }
}

