/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.impl.listeners;

import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import org.reactivecommons.async.impl.RabbitMessage;
import org.reactivecommons.async.impl.communications.ReactiveMessageListener;
import org.reactivecommons.async.impl.communications.TopologyCreator;
import org.reactivecommons.async.impl.reply.ReactiveReplyRouter;
import org.reactivestreams.Publisher;
import reactor.rabbitmq.Receiver;
import reactor.rabbitmq.ResourcesSpecification;

public class ApplicationReplyListener {
    @Generated
    private static final Logger log = Logger.getLogger(ApplicationReplyListener.class.getName());
    private final ReactiveReplyRouter router;
    private final Receiver receiver;
    private final TopologyCreator creator;
    private final String queueName;

    public ApplicationReplyListener(ReactiveReplyRouter router, ReactiveMessageListener listener, String queueName) {
        this.router = router;
        this.queueName = queueName;
        this.receiver = listener.getReceiver();
        this.creator = listener.getTopologyCreator();
    }

    public void startListening(String routeKey) {
        this.creator.declare(ResourcesSpecification.exchange((String)"globalReply").type("topic").durable(true)).then(this.creator.declare(ResourcesSpecification.queue((String)this.queueName).durable(false).autoDelete(true).exclusive(true))).then(this.creator.bind(ResourcesSpecification.binding((String)"globalReply", (String)routeKey, (String)this.queueName))).thenMany((Publisher)this.receiver.consumeAutoAck(this.queueName).doOnNext(delivery -> {
            try {
                boolean isEmpty;
                String correlationID = delivery.getProperties().getHeaders().get("x-correlation-id").toString();
                boolean bl = isEmpty = delivery.getProperties().getHeaders().get("x-empty-completion") != null;
                if (isEmpty) {
                    this.router.routeEmpty(correlationID);
                } else {
                    this.router.routeReply(correlationID, RabbitMessage.fromDelivery(delivery));
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error in reply reception", e);
            }
        })).subscribe();
    }
}

