/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.impl.utils;

import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.UUID;

public class NameGenerator {
    public static String generateNameFrom(String applicationName, String suffix) {
        return NameGenerator.generateName(applicationName, suffix);
    }

    public static String generateNameFrom(String applicationName) {
        return NameGenerator.generateName(applicationName, "");
    }

    private static String generateName(String applicationName, String suffix) {
        UUID uuid = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
        return applicationName + "-" + suffix + "-" + NameGenerator.encodeToUrlSafeString(bb.array()).replace("=", "");
    }

    private static String encodeToUrlSafeString(byte[] src) {
        return new String(NameGenerator.encodeUrlSafe(src));
    }

    private static byte[] encodeUrlSafe(byte[] src) {
        if (src.length == 0) {
            return src;
        }
        return Base64.getUrlEncoder().encode(src);
    }
}

