/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.impl.utils.matcher;

import java.util.Set;
import java.util.stream.IntStream;
import lombok.Generated;
import org.reactivecommons.async.impl.utils.matcher.Candidate;
import org.reactivecommons.async.impl.utils.matcher.Matcher;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class KeyMatcher
implements Matcher {
    private static final String WILD_CARD = "*";
    private static final String SEGMENT_DELIMITER_REGEX = "\\.";

    private String[] getSegments(String s) {
        return s.split(SEGMENT_DELIMITER_REGEX);
    }

    private boolean isBoundedToTarget(String[] current, String[] target) {
        String lastSegment = current[current.length - 1];
        return current.length == target.length || current.length < target.length && WILD_CARD.equals(lastSegment);
    }

    private boolean isRootSegmentCoincident(String[] current, String[] target) {
        String currentFirstSegment = current[0];
        String targetFirstSegment = target[0];
        return currentFirstSegment.equalsIgnoreCase(targetFirstSegment);
    }

    private boolean isCandidate(String[] current, String[] target) {
        return this.isRootSegmentCoincident(current, target) && this.isBoundedToTarget(current, target);
    }

    private long calculateMatchingScore(String[] current, String[] target) {
        return IntStream.range(0, Math.min(current.length, target.length)).filter(segment -> current[segment].equals(WILD_CARD) || current[segment].equalsIgnoreCase(target[segment])).count();
    }

    private long getMatchingScore(String[] current, String[] target) {
        long totalMatches = this.calculateMatchingScore(current, target);
        boolean allSegmentsMatched = totalMatches == (long)current.length;
        return allSegmentsMatched ? totalMatches : 0L;
    }

    private Candidate getScoredCandidate(Tuple2<String, String[]> candidate, String[] target) {
        long matchingScore = this.getMatchingScore((String[])candidate.getT2(), target);
        return new Candidate((String)candidate.getT1(), matchingScore);
    }

    private String matchMissingKey(Set<String> sources, String target) {
        String[] targetSegments = this.getSegments(target);
        return sources.stream().map(source -> Tuples.of((Object)source, (Object)this.getSegments((String)source))).filter(source -> this.isCandidate((String[])source.getT2(), targetSegments)).map(candidate -> this.getScoredCandidate((Tuple2<String, String[]>)candidate, targetSegments)).max(Candidate::compareTo).map(Candidate::getKey).orElse(target);
    }

    @Override
    public String match(Set<String> sources, String target) {
        return sources.contains(target) || sources.isEmpty() ? target : this.matchMissingKey(sources, target);
    }

    @Generated
    public KeyMatcher() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyMatcher)) {
            return false;
        }
        KeyMatcher other = (KeyMatcher)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeyMatcher;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "KeyMatcher()";
    }
}

