/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api.bson;

import java.time.Instant;
import reactivemongo.api.bson.BSONReader;
import reactivemongo.api.bson.BSONString$;
import reactivemongo.api.bson.BSONValue;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001E4Aa\u0005\u000b\u00037!Aa\u0005\u0001BC\u0002\u0013\u0005q\u0005\u0003\u00054\u0001\t\u0005\t\u0015!\u0003)\u0011\u0019!\u0004\u0001\"\u0001\u0015k!9\u0001\b\u0001b\u0001\n\u0003I\u0004BB\u001f\u0001A\u0003%!\bC\u0004?\u0001\t\u0007I\u0011A \t\r\r\u0003\u0001\u0015!\u0003A\u0011%!\u0005\u0001#b\u0001\n\u0003B\u0012\bC\u0005F\u0001!\u0015\r\u0011\"\u0011\u0019\r\")Q\n\u0001C!\u001d\")q\n\u0001C!!\")\u0011\f\u0001C!5\u001e)1\f\u0006E\u00019\u001a)1\u0003\u0006E\u0001;\")AG\u0004C\u0001=\")qL\u0004C\u0001A\")QM\u0004C\u0001M\")AN\u0004C\u0001[\nQ!iU(O'R\u0014\u0018N\\4\u000b\u0005U1\u0012\u0001\u00022t_:T!a\u0006\r\u0002\u0007\u0005\u0004\u0018NC\u0001\u001a\u00035\u0011X-Y2uSZ,Wn\u001c8h_\u000e\u00011c\u0001\u0001\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004\"a\t\u0013\u000e\u0003QI!!\n\u000b\u0003\u0013\t\u001bvJ\u0014,bYV,\u0017!\u0002<bYV,W#\u0001\u0015\u0011\u0005%\u0002dB\u0001\u0016/!\tYc$D\u0001-\u0015\ti#$\u0001\u0004=e>|GOP\u0005\u0003_y\ta\u0001\u0015:fI\u00164\u0017BA\u00193\u0005\u0019\u0019FO]5oO*\u0011qFH\u0001\u0007m\u0006dW/\u001a\u0011\u0002\rqJg.\u001b;?)\t1t\u0007\u0005\u0002$\u0001!)ae\u0001a\u0001Q\u0005!1m\u001c3f+\u0005Q\u0004CA\u000f<\u0013\tadDA\u0002J]R\fQaY8eK\u0002\n\u0001BY=uK\u000e{G-Z\u000b\u0002\u0001B\u0011Q$Q\u0005\u0003\u0005z\u0011AAQ=uK\u0006I!-\u001f;f\u0007>$W\rI\u0001\tEf$XmU5{K\u0006A\u0011m]*ue&tw-F\u0001H!\rA5\nK\u0007\u0002\u0013*\u0011!JH\u0001\u0005kRLG.\u0003\u0002M\u0013\n\u0019AK]=\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012AO\u0001\u0007KF,\u0018\r\\:\u0015\u0005E#\u0006CA\u000fS\u0013\t\u0019fDA\u0004C_>dW-\u00198\t\u000bU[\u0001\u0019\u0001,\u0002\tQD\u0017\r\u001e\t\u0003;]K!\u0001\u0017\u0010\u0003\u0007\u0005s\u00170\u0001\u0005u_N#(/\u001b8h)\u0005A\u0013A\u0003\"T\u001f:\u001bFO]5oOB\u00111ED\n\u0003\u001dq!\u0012\u0001X\u0001\bk:\f\u0007\u000f\u001d7z)\t\tG\rE\u0002\u001eE\"J!a\u0019\u0010\u0003\r=\u0003H/[8o\u0011\u0015)\u0006\u00031\u0001W\u0003\u0015\t\u0007\u000f\u001d7z)\t1t\rC\u0003'#\u0001\u0007\u0001\u0006\u000b\u0002\u0012SB\u0011QD[\u0005\u0003Wz\u0011a!\u001b8mS:,\u0017A\u00029sKR$\u0018\u0010\u0006\u0002)]\")qN\u0005a\u0001m\u0005\u00191\u000f\u001e:)\u0005II\u0007")
public final class BSONString
implements BSONValue {
    private int byteSize;
    private Try<String> asString;
    private final String value;
    private final int code;
    private final byte byteCode;
    private volatile byte bitmap$0;

    public static String pretty(BSONString bSONString) {
        return BSONString$.MODULE$.pretty(bSONString);
    }

    public static BSONString apply(String string) {
        return BSONString$.MODULE$.apply(string);
    }

    public static Option<String> unapply(Object object) {
        return BSONString$.MODULE$.unapply(object);
    }

    @Override
    public final <T> Try<T> asTry(BSONReader<T> reader) {
        return BSONValue.asTry$(this, reader);
    }

    @Override
    public final <T> Option<T> asOpt(BSONReader<T> reader) {
        return BSONValue.asOpt$(this, reader);
    }

    @Override
    public Try<Object> asBoolean() {
        return BSONValue.asBoolean$(this);
    }

    @Override
    public Try<BigDecimal> asDecimal() {
        return BSONValue.asDecimal$(this);
    }

    @Override
    public Try<Instant> asDateTime() {
        return BSONValue.asDateTime$(this);
    }

    @Override
    public Try<Object> toDouble() {
        return BSONValue.toDouble$(this);
    }

    @Override
    public Try<Object> toFloat() {
        return BSONValue.toFloat$(this);
    }

    @Override
    public Try<Object> asLong() {
        return BSONValue.asLong$(this);
    }

    @Override
    public Try<Object> asInt() {
        return BSONValue.asInt$(this);
    }

    public String value() {
        return this.value;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public byte byteCode() {
        return this.byteCode;
    }

    private int byteSize$lzycompute() {
        BSONString bSONString = this;
        synchronized (bSONString) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.byteSize = 5 + new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.value().getBytes())).size();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.byteSize;
    }

    @Override
    public int byteSize() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.byteSize$lzycompute() : this.byteSize;
    }

    private Try<String> asString$lzycompute() {
        BSONString bSONString = this;
        synchronized (bSONString) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.asString = new Success((Object)this.value());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.asString;
    }

    @Override
    public Try<String> asString() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.asString$lzycompute() : this.asString;
    }

    public int hashCode() {
        return this.value().hashCode();
    }

    public boolean equals(Object that) {
        boolean bl;
        Object object = that;
        if (object instanceof BSONString) {
            BSONString bSONString = (BSONString)object;
            String string = this.value();
            String string2 = bSONString.value();
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public String toString() {
        return new StringBuilder(12).append("BSONString(").append(this.value()).append(")").toString();
    }

    public BSONString(String value) {
        this.value = value;
        BSONValue.$init$(this);
        this.code = 2;
        this.byteCode = (byte)2;
    }
}

