/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api.bson;

import java.time.Instant;
import reactivemongo.api.bson.BSONReader;
import reactivemongo.api.bson.BSONString$;
import reactivemongo.api.bson.BSONValue;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001a4A\u0001F\u000b\u00039!Aq\u0005\u0001BC\u0002\u0013\u0005\u0001\u0006\u0003\u00055\u0001\t\u0005\t\u0015!\u0003*\u0011\u0019)\u0004\u0001\"\u0001\u0016m!9\u0011\b\u0001b\u0001\n\u0003Q\u0004B\u0002 \u0001A\u0003%1\bC\u0004@\u0001\t\u0007I\u0011\u0001!\t\r\u0011\u0003\u0001\u0015!\u0003B\u0011%)\u0005\u0001#b\u0001\n\u0003J\"\bC\u0005G\u0001!\u0015\r\u0011\"\u0011\u001a\u000f\"Aa\n\u0001EC\u0002\u0013\u0005s\nC\u0003U\u0001\u0011\u0005S\u000bC\u0003W\u0001\u0011\u0005s\u000bC\u0003a\u0001\u0011\u0005\u0013mB\u0003c+!\u00051MB\u0003\u0015+!\u0005A\rC\u00036\u001f\u0011\u0005Q\rC\u0003g\u001f\u0011\u0005q\rC\u0003m\u001f\u0011\u0005Q\u000eC\u0003t\u001f\u0011\u0005AO\u0001\u0006C'>s5\u000b\u001e:j]\u001eT!AF\f\u0002\t\t\u001cxN\u001c\u0006\u00031e\t1!\u00199j\u0015\u0005Q\u0012!\u0004:fC\u000e$\u0018N^3n_:<wn\u0001\u0001\u0014\u0007\u0001i2\u0005\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VM\u001a\t\u0003I\u0015j\u0011!F\u0005\u0003MU\u0011\u0011BQ*P\u001dZ\u000bG.^3\u0002\u000bY\fG.^3\u0016\u0003%\u0002\"AK\u0019\u000f\u0005-z\u0003C\u0001\u0017 \u001b\u0005i#B\u0001\u0018\u001c\u0003\u0019a$o\\8u}%\u0011\u0001gH\u0001\u0007!J,G-\u001a4\n\u0005I\u001a$AB*ue&twM\u0003\u00021?\u00051a/\u00197vK\u0002\na\u0001P5oSRtDCA\u001c9!\t!\u0003\u0001C\u0003(\u0007\u0001\u0007\u0011&\u0001\u0003d_\u0012,W#A\u001e\u0011\u0005ya\u0014BA\u001f \u0005\rIe\u000e^\u0001\u0006G>$W\rI\u0001\tEf$XmQ8eKV\t\u0011\t\u0005\u0002\u001f\u0005&\u00111i\b\u0002\u0005\u0005f$X-A\u0005csR,7i\u001c3fA\u0005A!-\u001f;f'&TX-\u0001\u0005bgN#(/\u001b8h+\u0005A\u0005cA%MS5\t!J\u0003\u0002L?\u0005!Q\u000f^5m\u0013\ti%JA\u0002Uef\fa!Y:DQ\u0006\u0014X#\u0001)\u0011\u0007%c\u0015\u000b\u0005\u0002\u001f%&\u00111k\b\u0002\u0005\u0007\"\f'/\u0001\u0005iCND7i\u001c3f)\u0005Y\u0014AB3rk\u0006d7\u000f\u0006\u0002Y7B\u0011a$W\u0005\u00035~\u0011qAQ8pY\u0016\fg\u000eC\u0003]\u0019\u0001\u0007Q,\u0001\u0003uQ\u0006$\bC\u0001\u0010_\u0013\tyvDA\u0002B]f\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002S\u0005Q!iU(O'R\u0014\u0018N\\4\u0011\u0005\u0011z1CA\b\u001e)\u0005\u0019\u0017aB;oCB\u0004H.\u001f\u000b\u0003Q.\u00042AH5*\u0013\tQwD\u0001\u0004PaRLwN\u001c\u0005\u00069F\u0001\r!X\u0001\u0006CB\u0004H.\u001f\u000b\u0003o9DQa\n\nA\u0002%B#A\u00059\u0011\u0005y\t\u0018B\u0001: \u0005\u0019Ig\u000e\\5oK\u00061\u0001O]3uif$\"!K;\t\u000bY\u001c\u0002\u0019A\u001c\u0002\u0007M$(\u000f\u000b\u0002\u0014a\u0002")
public final class BSONString
implements BSONValue {
    private int byteSize;
    private Try<String> asString;
    private Try<Object> asChar;
    private final String value;
    private final int code;
    private final byte byteCode;
    private volatile byte bitmap$0;

    public static String pretty(BSONString bSONString) {
        return BSONString$.MODULE$.pretty(bSONString);
    }

    public static BSONString apply(String string) {
        return BSONString$.MODULE$.apply(string);
    }

    public static Option<String> unapply(Object object) {
        return BSONString$.MODULE$.unapply(object);
    }

    @Override
    public final <T> Try<T> asTry(BSONReader<T> reader) {
        return BSONValue.asTry$(this, reader);
    }

    @Override
    public final <T> Option<T> asOpt(BSONReader<T> reader) {
        return BSONValue.asOpt$(this, reader);
    }

    @Override
    public Try<Object> asBoolean() {
        return BSONValue.asBoolean$(this);
    }

    @Override
    public Try<BigDecimal> asDecimal() {
        return BSONValue.asDecimal$(this);
    }

    @Override
    public Try<Instant> asDateTime() {
        return BSONValue.asDateTime$(this);
    }

    @Override
    public Try<Object> toDouble() {
        return BSONValue.toDouble$(this);
    }

    @Override
    public Try<Object> toFloat() {
        return BSONValue.toFloat$(this);
    }

    @Override
    public Try<Object> asLong() {
        return BSONValue.asLong$(this);
    }

    @Override
    public Try<Object> asInt() {
        return BSONValue.asInt$(this);
    }

    @Override
    public Try<Object> asShort() {
        return BSONValue.asShort$(this);
    }

    @Override
    public Try<Object> asByte() {
        return BSONValue.asByte$(this);
    }

    public String value() {
        return this.value;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public byte byteCode() {
        return this.byteCode;
    }

    private int byteSize$lzycompute() {
        BSONString bSONString = this;
        synchronized (bSONString) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.byteSize = 5 + new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.value().getBytes())).size();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.byteSize;
    }

    @Override
    public int byteSize() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.byteSize$lzycompute();
        }
        return this.byteSize;
    }

    private Try<String> asString$lzycompute() {
        BSONString bSONString = this;
        synchronized (bSONString) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.asString = new Success((Object)this.value());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.asString;
    }

    @Override
    public Try<String> asString() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.asString$lzycompute();
        }
        return this.asString;
    }

    private Try<Object> asChar$lzycompute() {
        BSONString bSONString = this;
        synchronized (bSONString) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.asChar = this.value().length() == 1 ? new Success((Object)BoxesRunTime.boxToCharacter((char)this.value().charAt(0))) : BSONValue.asChar$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.asChar;
    }

    @Override
    public Try<Object> asChar() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.asChar$lzycompute();
        }
        return this.asChar;
    }

    public int hashCode() {
        return this.value().hashCode();
    }

    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof BSONString) {
            BSONString bSONString = (BSONString)object;
            String string = this.value();
            String string2 = bSONString.value();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }
        return false;
    }

    public String toString() {
        return new StringBuilder(12).append("BSONString(").append(this.value()).append(")").toString();
    }

    public BSONString(String value) {
        this.value = value;
        BSONValue.$init$(this);
        this.code = 2;
        this.byteCode = (byte)2;
    }
}

