/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api.bson;

import java.io.Serializable;
import java.util.Locale;
import java.util.UUID;
import reactivemongo.api.bson.KeyReader;
import reactivemongo.api.bson.SafeKeyReader;
import reactivemongo.api.bson.exceptions.ValueDoesNotMatchException$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class KeyReader$ {
    public static KeyReader$ MODULE$;
    private KeyReader<Locale> localeReader;
    private KeyReader<UUID> uuidReader;
    private volatile byte bitmap$0;

    static {
        new KeyReader$();
    }

    public <T> KeyReader<T> apply(Function1<String, T> read) {
        return new KeyReader.FunctionalReader<T>(read);
    }

    public <T> KeyReader<T> safe(Function1<String, T> read) {
        return new SafeKeyReader<T>(read);
    }

    public <T> KeyReader<T> from(Function1<String, Try<T>> readTry) {
        return new KeyReader.Default<T>(readTry);
    }

    public <T> KeyReader<T> option(Function1<String, Option<T>> read) {
        return this.from((Function1 & Serializable & scala.Serializable)value -> {
            Option option = (Option)read.apply(value);
            if (option instanceof Some) {
                Some some = (Some)option;
                Object key = some.value();
                return new Success(key);
            }
            return new Failure((Throwable)ValueDoesNotMatchException$.MODULE$.apply((String)value));
        });
    }

    public <T> KeyReader<T> collect(PartialFunction<String, T> read) {
        return this.option((Function1 & Serializable & scala.Serializable)x$1 -> (Option)read.lift().apply(x$1));
    }

    public <T> KeyReader<T> keyReader(Function1<String, T> conv) {
        return this.apply(conv);
    }

    public KeyReader<BigDecimal> bigDecimalKeyReader() {
        return this.apply((Function1 & Serializable & scala.Serializable)x -> package$.MODULE$.BigDecimal().apply(x));
    }

    public KeyReader<BigInt> bigIntKeyReader() {
        return this.apply((Function1 & Serializable & scala.Serializable)x -> package$.MODULE$.BigInt().apply(x));
    }

    public KeyReader<Object> byteKeyReader() {
        return this.apply((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToByte((byte)KeyReader$.$anonfun$byteKeyReader$1(x$2)));
    }

    public KeyReader<Object> charKeyReader() {
        return this.from((Function1 & Serializable & scala.Serializable)key -> {
            if (new StringOps(Predef$.MODULE$.augmentString(key)).size() == 1) {
                return new Success(new StringOps(Predef$.MODULE$.augmentString(key)).head());
            }
            return new Failure((Throwable)ValueDoesNotMatchException$.MODULE$.apply(new StringBuilder(19).append("Invalid character: ").append((String)key).toString()));
        });
    }

    public KeyReader<Object> doubleKeyReader() {
        return this.apply((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)KeyReader$.$anonfun$doubleKeyReader$1(x$3)));
    }

    public KeyReader<Object> floatKeyReader() {
        return this.apply((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToFloat((float)KeyReader$.$anonfun$floatKeyReader$1(x$4)));
    }

    public KeyReader<Object> intKeyReader() {
        return this.apply((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)KeyReader$.$anonfun$intKeyReader$1(x$5)));
    }

    public KeyReader<Object> longKeyReader() {
        return this.apply((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)KeyReader$.$anonfun$longKeyReader$1(x$6)));
    }

    public KeyReader<Object> shortKeyReader() {
        return this.apply((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToShort((short)KeyReader$.$anonfun$shortKeyReader$1(x$7)));
    }

    private KeyReader<Locale> localeReader$lzycompute() {
        KeyReader$ keyReader$ = this;
        synchronized (keyReader$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.localeReader = this.from((Function1 & Serializable & scala.Serializable)languageTag -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Locale.forLanguageTag(languageTag)));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.localeReader;
    }

    public KeyReader<Locale> localeReader() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.localeReader$lzycompute();
        }
        return this.localeReader;
    }

    private KeyReader<UUID> uuidReader$lzycompute() {
        KeyReader$ keyReader$ = this;
        synchronized (keyReader$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.uuidReader = this.from((Function1 & Serializable & scala.Serializable)repr -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> UUID.fromString(repr)));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.uuidReader;
    }

    public KeyReader<UUID> uuidReader() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.uuidReader$lzycompute();
        }
        return this.uuidReader;
    }

    public static final /* synthetic */ byte $anonfun$byteKeyReader$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toByte();
    }

    public static final /* synthetic */ double $anonfun$doubleKeyReader$1(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toDouble();
    }

    public static final /* synthetic */ float $anonfun$floatKeyReader$1(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toFloat();
    }

    public static final /* synthetic */ int $anonfun$intKeyReader$1(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toInt();
    }

    public static final /* synthetic */ long $anonfun$longKeyReader$1(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toLong();
    }

    public static final /* synthetic */ short $anonfun$shortKeyReader$1(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toShort();
    }

    private KeyReader$() {
        MODULE$ = this;
    }
}

