/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api.bson;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.UUID;
import reactivemongo.api.bson.BSONBinary$;
import reactivemongo.api.bson.BSONReader;
import reactivemongo.api.bson.BSONValue;
import reactivemongo.api.bson.Subtype;
import reactivemongo.api.bson.buffer.ReadableBuffer;
import reactivemongo.api.bson.buffer.ReadableBuffer$;
import scala.Option;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;
import scala.util.Try;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001\u0002\u000b\u0016\u0005qA\u0011b\n\u0001\u0003\u0006\u0004%\t!\u0006\u0015\t\u0011=\u0002!\u0011!Q\u0001\n%B\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!\r\u0005\tk\u0001\u0011\t\u0011)A\u0005e!1a\u0007\u0001C\u0001+]Bqa\u000f\u0001C\u0002\u0013\u0005A\b\u0003\u0004A\u0001\u0001\u0006I!\u0010\u0005\u0006\u0003\u0002!\tA\u0011\u0005\n\r\u0002A)\u0019!C!3\u001dC\u0001b\u0013\u0001\t\u0006\u0004%\te\u0012\u0005\u0006\u0019\u0002!\t%\u0014\u0005\t-\u0002A)\u0019!C!/\u001e)1-\u0006E\u0001I\u001a)A#\u0006E\u0001K\")aG\u0004C\u0001M\")qM\u0004C\u0001Q\")QN\u0004C\u0001]\")QN\u0004C\u0001c\")AP\u0004C\u0001{\nQ!iU(O\u0005&t\u0017M]=\u000b\u0005Y9\u0012\u0001\u00022t_:T!\u0001G\r\u0002\u0007\u0005\u0004\u0018NC\u0001\u001b\u00035\u0011X-Y2uSZ,Wn\u001c8h_\u000e\u00011c\u0001\u0001\u001eGA\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\u0004\"\u0001J\u0013\u000e\u0003UI!AJ\u000b\u0003\u0013\t\u001bvJ\u0014,bYV,\u0017!\u0002<bYV,W#A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00051*\u0012A\u00022vM\u001a,'/\u0003\u0002/W\tq!+Z1eC\ndWMQ;gM\u0016\u0014\u0018A\u0002<bYV,\u0007%A\u0004tk\n$\u0018\u0010]3\u0016\u0003I\u0002\"\u0001J\u001a\n\u0005Q*\"aB*vERL\b/Z\u0001\tgV\u0014G/\u001f9fA\u00051A(\u001b8jiz\"2\u0001O\u001d;!\t!\u0003\u0001C\u0003(\u000b\u0001\u0007\u0011\u0006C\u00031\u000b\u0001\u0007!'\u0001\u0003d_\u0012,W#A\u001f\u0011\u0005yq\u0014BA  \u0005\u0011\u0011\u0015\u0010^3\u0002\u000b\r|G-\u001a\u0011\u0002\u0013\tLH/Z!se\u0006LX#A\"\u0011\u0007y!U(\u0003\u0002F?\t)\u0011I\u001d:bs\u0006A!-\u001f;f'&TX-F\u0001I!\tq\u0012*\u0003\u0002K?\t\u0019\u0011J\u001c;\u0002\u0011!\f7\u000f[\"pI\u0016\fa!Z9vC2\u001cHC\u0001(R!\tqr*\u0003\u0002Q?\t9!i\\8mK\u0006t\u0007\"\u0002*\f\u0001\u0004\u0019\u0016\u0001\u0002;iCR\u0004\"A\b+\n\u0005U{\"aA!os\u0006AAo\\*ue&tw-F\u0001Y!\tI\u0006M\u0004\u0002[=B\u00111lH\u0007\u00029*\u0011QlG\u0001\u0007yI|w\u000e\u001e \n\u0005}{\u0012A\u0002)sK\u0012,g-\u0003\u0002bE\n11\u000b\u001e:j]\u001eT!aX\u0010\u0002\u0015\t\u001bvJ\u0014\"j]\u0006\u0014\u0018\u0010\u0005\u0002%\u001dM\u0011a\"\b\u000b\u0002I\u00069QO\\1qa2LHCA5m!\rq\"NM\u0005\u0003W~\u0011aa\u00149uS>t\u0007\"\u0002*\u0011\u0001\u0004\u0019\u0016!B1qa2LHc\u0001\u001dpa\")q%\u0005a\u0001\u0007\")\u0001'\u0005a\u0001eQ\u0011\u0001H\u001d\u0005\u0006gJ\u0001\r\u0001^\u0001\u0003S\u0012\u0004\"!\u001e>\u000e\u0003YT!a\u001e=\u0002\tU$\u0018\u000e\u001c\u0006\u0002s\u0006!!.\u0019<b\u0013\tYhO\u0001\u0003V+&#\u0015A\u00029sKR$\u0018\u0010\u0006\u0002Y}\")qp\u0005a\u0001q\u0005\u0019!-\u001b8")
public final class BSONBinary
implements BSONValue {
    private int byteSize;
    private int hashCode;
    private String toString;
    private final ByteBuffer value;
    private final Subtype subtype;
    private final byte code;
    private volatile byte bitmap$0;

    public static String pretty(BSONBinary bSONBinary) {
        return BSONBinary$.MODULE$.pretty(bSONBinary);
    }

    public static BSONBinary apply(UUID uUID) {
        return BSONBinary$.MODULE$.apply(uUID);
    }

    public static BSONBinary apply(byte[] byArray, Subtype subtype) {
        return BSONBinary$.MODULE$.apply(byArray, subtype);
    }

    public static Option<Subtype> unapply(Object object) {
        return BSONBinary$.MODULE$.unapply(object);
    }

    @Override
    public final <T> Try<T> asTry(BSONReader<T> reader) {
        return BSONValue.asTry$(this, reader);
    }

    @Override
    public final <T> Option<T> asOpt(BSONReader<T> reader) {
        return BSONValue.asOpt$(this, reader);
    }

    @Override
    public Try<Object> asBoolean() {
        return BSONValue.asBoolean$(this);
    }

    @Override
    public Try<BigDecimal> asDecimal() {
        return BSONValue.asDecimal$(this);
    }

    @Override
    public Try<Instant> asDateTime() {
        return BSONValue.asDateTime$(this);
    }

    @Override
    public Try<Object> asDouble() {
        return BSONValue.asDouble$(this);
    }

    @Override
    public Try<Object> asLong() {
        return BSONValue.asLong$(this);
    }

    @Override
    public Try<Object> asInt() {
        return BSONValue.asInt$(this);
    }

    @Override
    public Try<String> asString() {
        return BSONValue.asString$(this);
    }

    public ByteBuffer value() {
        return this.value;
    }

    public Subtype subtype() {
        return this.subtype;
    }

    @Override
    public byte code() {
        return this.code;
    }

    public byte[] byteArray() {
        return ReadableBuffer$.MODULE$.readArray$extension(ReadableBuffer$.MODULE$.duplicate$extension(this.value()), ReadableBuffer$.MODULE$.size$extension(this.value()));
    }

    private int byteSize$lzycompute() {
        BSONBinary bSONBinary = this;
        synchronized (bSONBinary) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.byteSize = 5 + ReadableBuffer$.MODULE$.readable$extension(this.value());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.byteSize;
    }

    @Override
    public int byteSize() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.byteSize$lzycompute() : this.byteSize;
    }

    private int hashCode$lzycompute() {
        BSONBinary bSONBinary = this;
        synchronized (bSONBinary) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                int nh = MurmurHash3$.MODULE$.mix(-889275714, Statics.anyHash((Object)this.subtype()));
                this.hashCode = MurmurHash3$.MODULE$.mixLast(nh, ReadableBuffer$.MODULE$.hashCode$extension(this.value()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.hashCode;
    }

    public int hashCode() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.hashCode$lzycompute() : this.hashCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof BSONBinary)) return false;
        BSONBinary bSONBinary = (BSONBinary)object;
        Subtype subtype = this.subtype();
        Subtype subtype2 = bSONBinary.subtype();
        if (subtype == null) {
            if (subtype2 != null) {
                return false;
            }
        } else if (!subtype.equals(subtype2)) return false;
        ByteBuffer byteBuffer = this.value();
        ByteBuffer byteBuffer2 = bSONBinary.value();
        if (byteBuffer == null) {
            if (byteBuffer2 == null) return true;
        } else if (((Object)byteBuffer).equals(byteBuffer2)) return true;
        if (!ReadableBuffer$.MODULE$.equals$extension(ReadableBuffer$.MODULE$.duplicate$extension(this.value()), new ReadableBuffer(ReadableBuffer$.MODULE$.duplicate$extension(bSONBinary.value())))) return false;
        return true;
    }

    private String toString$lzycompute() {
        BSONBinary bSONBinary = this;
        synchronized (bSONBinary) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.toString = new StringBuilder(21).append("BSONBinary(").append(this.subtype()).append(", size = ").append(ReadableBuffer$.MODULE$.readable$extension(this.value())).append(")").toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.toString;
    }

    public String toString() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.toString$lzycompute() : this.toString;
    }

    public BSONBinary(ByteBuffer value, Subtype subtype) {
        this.value = value;
        this.subtype = subtype;
        BSONValue.$init$(this);
        this.code = (byte)5;
    }
}

