/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api.bson;

import java.io.Serializable;
import reactivemongo.api.bson.BSONArray$;
import reactivemongo.api.bson.BSONBinary;
import reactivemongo.api.bson.BSONBinary$;
import reactivemongo.api.bson.BSONBoolean$;
import reactivemongo.api.bson.BSONDateTime;
import reactivemongo.api.bson.BSONDateTime$;
import reactivemongo.api.bson.BSONDecimal;
import reactivemongo.api.bson.BSONDecimal$;
import reactivemongo.api.bson.BSONDocument$;
import reactivemongo.api.bson.BSONDouble$;
import reactivemongo.api.bson.BSONElement;
import reactivemongo.api.bson.BSONElement$;
import reactivemongo.api.bson.BSONInteger$;
import reactivemongo.api.bson.BSONLong;
import reactivemongo.api.bson.BSONLong$;
import reactivemongo.api.bson.BSONMaxKey$;
import reactivemongo.api.bson.BSONMinKey$;
import reactivemongo.api.bson.BSONNull$;
import reactivemongo.api.bson.BSONObjectID;
import reactivemongo.api.bson.BSONObjectID$;
import reactivemongo.api.bson.BSONString;
import reactivemongo.api.bson.BSONString$;
import reactivemongo.api.bson.BSONTimestamp;
import reactivemongo.api.bson.BSONTimestamp$;
import reactivemongo.api.bson.BSONUndefined$;
import reactivemongo.api.bson.BSONValue;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class BSONIterator$ {
    public static final BSONIterator$ MODULE$ = new BSONIterator$();

    public String pretty(int i, Iterable<BSONElement> it, Function1<String, String> f) {
        String indent = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), i).map((Function1 & Serializable)x$1 -> BSONIterator$.$anonfun$pretty$1(BoxesRunTime.unboxToInt((Object)x$1))).mkString("");
        return ((IterableOnceOps)it.map((Function1 & Serializable)x0$1 -> {
            Option<Tuple2<String, BSONValue>> option;
            BSONElement bSONElement = x0$1;
            if (bSONElement == null || (option = BSONElement$.MODULE$.unapply(bSONElement)).isEmpty()) {
                throw new MatchError((Object)bSONElement);
            }
            String name = (String)((Tuple2)option.get())._1();
            BSONValue value = (BSONValue)((Tuple2)option.get())._2();
            String string = MODULE$.pretty(i, indent, name, value, f);
            return string;
        })).mkString(",\n");
    }

    public String pretty(int i, Iterable<BSONValue> it) {
        String indent = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), i).map((Function1 & Serializable)x$2 -> BSONIterator$.$anonfun$pretty$3(BoxesRunTime.unboxToInt((Object)x$2))).mkString("");
        return ((IterableOnceOps)it.map((Function1 & Serializable)x$3 -> MODULE$.pretty(i, indent, "", (BSONValue)x$3, (Function1<String, String>)(Function1 & Serializable)x$4 -> (String)Predef$.MODULE$.identity(x$4)))).mkString(",\n");
    }

    public String pretty(Iterable<BSONElement> it) {
        return new StringBuilder(4).append("{\n").append(this.pretty(0, it, this.pretty$default$3())).append("\n}").toString();
    }

    private String pretty(int i, String indent, String name, BSONValue value, Function1<String, String> f) {
        Option<Object> option;
        Option<Object> option2;
        Option<Seq<BSONElement>> option3;
        Option<Object> option4;
        String string;
        Option<IndexedSeq<BSONValue>> option5;
        String prefix = new StringBuilder(0).append(indent).append(f.apply((Object)name)).toString();
        BSONValue bSONValue = value;
        if (bSONValue != null && !(option5 = BSONArray$.MODULE$.unapply(bSONValue)).isEmpty()) {
            IndexedSeq vs = (IndexedSeq)option5.get();
            string = new StringBuilder(0).append(new StringBuilder(2).append(prefix).append("[\n").toString()).append(this.pretty(i + 1, (Iterable<BSONValue>)vs)).append(new StringBuilder(2).append("\n").append(indent).append("]").toString()).toString();
        } else if (bSONValue instanceof BSONBinary) {
            BSONBinary bSONBinary = (BSONBinary)bSONValue;
            string = new StringBuilder(0).append(prefix).append(BSONBinary$.MODULE$.pretty(bSONBinary)).toString();
        } else if (bSONValue != null && !(option4 = BSONBoolean$.MODULE$.unapply(bSONValue)).isEmpty()) {
            boolean bool = BoxesRunTime.unboxToBoolean((Object)option4.get());
            string = new StringBuilder(0).append(prefix).append(bool).toString();
        } else if (bSONValue instanceof BSONDateTime) {
            BSONDateTime bSONDateTime = (BSONDateTime)bSONValue;
            string = new StringBuilder(0).append(prefix).append(BSONDateTime$.MODULE$.pretty(bSONDateTime)).toString();
        } else if (bSONValue != null && !(option3 = BSONDocument$.MODULE$.unapply(bSONValue)).isEmpty()) {
            Seq elements = (Seq)option3.get();
            string = new StringBuilder(0).append(new StringBuilder(2).append(prefix).append("{\n").toString()).append(this.pretty(i + 1, (Iterable<BSONElement>)elements, this.pretty$default$3())).append(new StringBuilder(2).append("\n").append(indent).append("}").toString()).toString();
        } else if (bSONValue != null && !(option2 = BSONDouble$.MODULE$.unapply(bSONValue)).isEmpty()) {
            double d = BoxesRunTime.unboxToDouble((Object)option2.get());
            string = new StringBuilder(0).append(prefix).append(d).toString();
        } else if (bSONValue != null && !(option = BSONInteger$.MODULE$.unapply(bSONValue)).isEmpty()) {
            int i2 = BoxesRunTime.unboxToInt((Object)option.get());
            string = new StringBuilder(0).append(prefix).append(i2).toString();
        } else if (bSONValue instanceof BSONLong) {
            BSONLong bSONLong = (BSONLong)bSONValue;
            string = new StringBuilder(0).append(prefix).append(BSONLong$.MODULE$.pretty(bSONLong)).toString();
        } else if (bSONValue instanceof BSONDecimal) {
            BSONDecimal bSONDecimal = (BSONDecimal)bSONValue;
            string = new StringBuilder(0).append(prefix).append(BSONDecimal$.MODULE$.pretty(bSONDecimal)).toString();
        } else if (bSONValue instanceof BSONString) {
            BSONString bSONString = (BSONString)bSONValue;
            string = new StringBuilder(0).append(prefix).append(BSONString$.MODULE$.pretty(bSONString)).toString();
        } else if (bSONValue instanceof BSONObjectID) {
            BSONObjectID bSONObjectID = (BSONObjectID)bSONValue;
            string = new StringBuilder(0).append(prefix).append(BSONObjectID$.MODULE$.pretty(bSONObjectID)).toString();
        } else if (bSONValue instanceof BSONTimestamp) {
            BSONTimestamp bSONTimestamp = (BSONTimestamp)bSONValue;
            string = new StringBuilder(0).append(prefix).append(BSONTimestamp$.MODULE$.pretty(bSONTimestamp)).toString();
        } else {
            string = BSONNull$.MODULE$.equals(bSONValue) ? new StringBuilder(0).append(prefix).append(BSONNull$.MODULE$.pretty()).toString() : (BSONUndefined$.MODULE$.equals(bSONValue) ? new StringBuilder(0).append(prefix).append(BSONUndefined$.MODULE$.pretty()).toString() : (BSONMinKey$.MODULE$.equals(bSONValue) ? new StringBuilder(0).append(prefix).append(BSONMinKey$.MODULE$.pretty()).toString() : (BSONMaxKey$.MODULE$.equals(bSONValue) ? new StringBuilder(0).append(prefix).append(BSONMaxKey$.MODULE$.pretty()).toString() : new StringBuilder(0).append(prefix).append(value).toString())));
        }
        return string;
    }

    public Function1<String, String> pretty$default$3() {
        return (Function1 & Serializable)name -> new StringBuilder(4).append("'").append((String)name).append("': ").toString();
    }

    public static final /* synthetic */ String $anonfun$pretty$1(int x$1) {
        return "  ";
    }

    public static final /* synthetic */ String $anonfun$pretty$3(int x$2) {
        return "  ";
    }

    private BSONIterator$() {
    }
}

