/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api.bson;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetPermission;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import reactivemongo.api.bson.BSONObjectID;
import reactivemongo.api.bson.Digest$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Random$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class BSONObjectID$ {
    public static final BSONObjectID$ MODULE$;
    private static final int maxCounterValue;
    private static final AtomicInteger increment;
    private static final byte[] machineId;

    static {
        byte[] byArray;
        MODULE$ = new BSONObjectID$();
        maxCounterValue = 0x1000000;
        increment = new AtomicInteger(Random$.MODULE$.nextInt(MODULE$.maxCounterValue()));
        boolean validPlatform = BSONObjectID$.liftedTree1$1();
        boolean permitted = BSONObjectID$.liftedTree2$1();
        if (validPlatform && permitted) {
            byte[] ha = MODULE$.resolveAddr$1(NetworkInterface.getNetworkInterfaces());
            byArray = (byte[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.byteArrayOps(Digest$.MODULE$.md5(ha)), 3);
        } else {
            int threadId = (int)Thread.currentThread().getId();
            byArray = (byte[])Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{(byte)(threadId & 0xFF), (byte)(threadId >> 8 & 0xFF), (byte)(threadId >> 16 & 0xFF)}), (ClassTag)ClassTag$.MODULE$.Byte());
        }
        machineId = byArray;
    }

    private int maxCounterValue() {
        return maxCounterValue;
    }

    private AtomicInteger increment() {
        return increment;
    }

    private int counter() {
        return (this.increment().getAndIncrement() + this.maxCounterValue()) % this.maxCounterValue();
    }

    private byte[] machineId() {
        return machineId;
    }

    public Option<byte[]> unapply(Object that) {
        None$ none$;
        Object object = that;
        if (object instanceof BSONObjectID) {
            BSONObjectID bSONObjectID = (BSONObjectID)object;
            none$ = new Some((Object)bSONObjectID.byteArray());
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Try<BSONObjectID> parse(String id) {
        return id.length() != 24 ? new Failure((Throwable)new IllegalArgumentException(new StringBuilder(33).append("Wrong ObjectId (length != 24): '").append(id).append("'").toString())) : this.parse(Digest$.MODULE$.str2Hex(id));
    }

    public Try<BSONObjectID> parse(byte[] bytes) {
        return bytes.length != 12 ? new Failure((Throwable)new IllegalArgumentException(new StringBuilder(30).append("Wrong ObjectId: length(").append(bytes.length).append(") != 12").toString())) : Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> bytes[0] << 24 | bytes[1] << 255 << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF).map((Function1 & Serializable)timeSec -> BSONObjectID$.$anonfun$parse$2(bytes, BoxesRunTime.unboxToInt((Object)timeSec)));
    }

    public BSONObjectID generate() {
        return this.fromTime(System.currentTimeMillis(), false);
    }

    public BSONObjectID fromTime(long timeMillis, boolean fillOnlyTimestamp) {
        int timestamp = (int)(timeMillis / 1000L);
        byte[] id = (byte[])Array$.MODULE$.ofDim(12, (ClassTag)ClassTag$.MODULE$.Byte());
        id[0] = (byte)(timestamp >>> 24);
        id[1] = (byte)(timestamp >> 16 & 0xFF);
        id[2] = (byte)(timestamp >> 8 & 0xFF);
        id[3] = (byte)(timestamp & 0xFF);
        if (!fillOnlyTimestamp) {
            id[4] = this.machineId()[0];
            id[5] = this.machineId()[1];
            id[6] = this.machineId()[2];
            int threadId = (int)Thread.currentThread().getId();
            id[7] = (byte)(threadId & 0xFF);
            id[8] = (byte)(threadId >> 8 & 0xFF);
            int c = this.counter();
            id[9] = (byte)(c >> 16 & 0xFF);
            id[10] = (byte)(c >> 8 & 0xFF);
            id[11] = (byte)(c & 0xFF);
        }
        return new BSONObjectID(id, timestamp){
            private final byte[] raw;
            private final int timeSecond;

            public byte[] raw() {
                return this.raw;
            }

            public int timeSecond() {
                return this.timeSecond;
            }
            {
                this.raw = id$1;
                this.timeSecond = timestamp$1;
            }
        };
    }

    public boolean fromTime$default$2() {
        return false;
    }

    public String pretty(BSONObjectID oid) {
        return new StringBuilder(12).append("ObjectId('").append(oid.stringify()).append("')").toString();
    }

    private static final String p$1(String n) {
        return System.getProperty(n);
    }

    private static final boolean liftedTree1$1() {
        boolean bl;
        block4: {
            try {
                boolean isLinux;
                boolean correctVersion = (double)StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(BSONObjectID$.p$1("java.version").substring(0, 3))) >= 1.8;
                boolean noIpv6 = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(BSONObjectID$.p$1("java.net.preferIPv4Stack")));
                String string = BSONObjectID$.p$1("os.name");
                String string2 = "Linux";
                boolean bl2 = !(string != null ? !string.equals(string2) : string2 != null) ? true : (isLinux = false);
                if (!isLinux || correctVersion || noIpv6) {
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                boolean bl3 = false;
                bl = bl3;
            }
        }
        return bl;
    }

    private static final boolean liftedTree2$1() {
        boolean bl;
        try {
            System.getSecurityManager().checkPermission(new NetPermission("getNetworkInformation"));
            bl = true;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    private final byte[] resolveAddr$1(Enumeration ifaces) {
        byte[] byArray;
        block4: {
            while (ifaces.hasMoreElements()) {
                byte[] hwAddr;
                byte[] byArray2;
                try {
                    byArray2 = ((NetworkInterface)ifaces.nextElement()).getHardwareAddress();
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        throw throwable;
                    }
                    Object var3_2 = null;
                    byArray2 = hwAddr = var3_2;
                }
                if (hwAddr == null || hwAddr.length != 6) continue;
                byArray = hwAddr;
                break block4;
            }
            byArray = InetAddress.getLocalHost().getHostName().getBytes("UTF-8");
        }
        return byArray;
    }

    public static final /* synthetic */ BSONObjectID $anonfun$parse$2(byte[] bytes$1, int timeSec) {
        return new BSONObjectID(timeSec, bytes$1){
            private final int timeSecond;
            private final byte[] raw;

            public int timeSecond() {
                return this.timeSecond;
            }

            public byte[] raw() {
                return this.raw;
            }
            {
                this.timeSecond = timeSec$1;
                this.raw = bytes$1;
            }
        };
    }

    private BSONObjectID$() {
    }
}

