/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api.bson.buffer;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import reactivemongo.api.bson.BSONArray;
import reactivemongo.api.bson.BSONArray$;
import reactivemongo.api.bson.BSONBinary;
import reactivemongo.api.bson.BSONBoolean;
import reactivemongo.api.bson.BSONBoolean$;
import reactivemongo.api.bson.BSONDateTime;
import reactivemongo.api.bson.BSONDateTime$;
import reactivemongo.api.bson.BSONDecimal;
import reactivemongo.api.bson.BSONDecimal$;
import reactivemongo.api.bson.BSONDocument;
import reactivemongo.api.bson.BSONDocument$;
import reactivemongo.api.bson.BSONDouble;
import reactivemongo.api.bson.BSONDouble$;
import reactivemongo.api.bson.BSONElement;
import reactivemongo.api.bson.BSONElement$;
import reactivemongo.api.bson.BSONInteger;
import reactivemongo.api.bson.BSONInteger$;
import reactivemongo.api.bson.BSONJavaScript;
import reactivemongo.api.bson.BSONJavaScript$;
import reactivemongo.api.bson.BSONJavaScriptWS;
import reactivemongo.api.bson.BSONJavaScriptWS$;
import reactivemongo.api.bson.BSONLong;
import reactivemongo.api.bson.BSONLong$;
import reactivemongo.api.bson.BSONMaxKey$;
import reactivemongo.api.bson.BSONMinKey$;
import reactivemongo.api.bson.BSONNull$;
import reactivemongo.api.bson.BSONObjectID;
import reactivemongo.api.bson.BSONObjectID$;
import reactivemongo.api.bson.BSONRegex;
import reactivemongo.api.bson.BSONRegex$;
import reactivemongo.api.bson.BSONString;
import reactivemongo.api.bson.BSONString$;
import reactivemongo.api.bson.BSONSymbol;
import reactivemongo.api.bson.BSONSymbol$;
import reactivemongo.api.bson.BSONTimestamp;
import reactivemongo.api.bson.BSONTimestamp$;
import reactivemongo.api.bson.BSONUndefined$;
import reactivemongo.api.bson.BSONValue;
import reactivemongo.api.bson.Subtype;
import reactivemongo.api.bson.Subtype$;
import reactivemongo.api.bson.buffer.ReadableBuffer;
import reactivemongo.api.bson.buffer.ReadableBuffer$;
import reactivemongo.api.bson.buffer.WritableBuffer;
import reactivemongo.api.bson.buffer.WritableBuffer$;
import reactivemongo.io.netty.buffer.ByteBuf;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Builder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyByte;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class DefaultBufferHandler$ {
    public static final DefaultBufferHandler$ MODULE$ = new DefaultBufferHandler$();

    public ByteBuf serialize(BSONValue bson, ByteBuf buffer) {
        Option<Object> option;
        Option<Object> option2;
        Option<Object> option3;
        Option<Tuple2<String, BSONDocument>> option4;
        Option<String> option5;
        Option<String> option6;
        Option<Object> option7;
        Option<Object> option8;
        Option<IndexedSeq<BSONValue>> option9;
        Option<String> option10;
        ByteBuf byteBuf;
        Option<Object> option11;
        BSONValue bSONValue = bson;
        if (bSONValue != null && !(option11 = BSONDouble$.MODULE$.unapply(bSONValue)).isEmpty()) {
            double v = BoxesRunTime.unboxToDouble((Object)option11.get());
            byteBuf = WritableBuffer$.MODULE$.writeDouble$extension(buffer, v);
        } else if (bSONValue != null && !(option10 = BSONString$.MODULE$.unapply(bSONValue)).isEmpty()) {
            String v = (String)option10.get();
            byteBuf = WritableBuffer$.MODULE$.writeBsonString$extension(buffer, v);
        } else if (bSONValue instanceof BSONDocument) {
            BSONDocument bSONDocument = (BSONDocument)bSONValue;
            byteBuf = this.writeDocument(bSONDocument, buffer);
        } else if (bSONValue != null && !(option9 = BSONArray$.MODULE$.unapply(bSONValue)).isEmpty()) {
            IndexedSeq vs = (IndexedSeq)option9.get();
            byteBuf = this.writeArray((IndexedSeq<BSONValue>)vs, buffer);
        } else if (bSONValue instanceof BSONBinary) {
            BSONBinary bSONBinary = (BSONBinary)bSONValue;
            byteBuf = this.writeBinary(bSONBinary, buffer);
        } else if (bSONValue instanceof BSONObjectID) {
            BSONObjectID bSONObjectID = (BSONObjectID)bSONValue;
            byteBuf = this.writeObjectID(bSONObjectID, buffer);
        } else if (bSONValue != null && !(option8 = BSONBoolean$.MODULE$.unapply(bSONValue)).isEmpty()) {
            boolean v = BoxesRunTime.unboxToBoolean((Object)option8.get());
            byteBuf = WritableBuffer$.MODULE$.writeByte$extension(buffer, v ? (byte)1 : 0);
        } else if (bSONValue != null && !(option7 = BSONDateTime$.MODULE$.unapply(bSONValue)).isEmpty()) {
            long time = BoxesRunTime.unboxToLong((Object)option7.get());
            byteBuf = WritableBuffer$.MODULE$.writeLong$extension(buffer, time);
        } else if (bSONValue instanceof BSONRegex) {
            BSONRegex bSONRegex = (BSONRegex)bSONValue;
            byteBuf = this.writeRegex(bSONRegex, buffer);
        } else if (bSONValue != null && !(option6 = BSONJavaScript$.MODULE$.unapply(bSONValue)).isEmpty()) {
            String v = (String)option6.get();
            byteBuf = WritableBuffer$.MODULE$.writeBsonString$extension(buffer, v);
        } else if (bSONValue != null && !(option5 = BSONSymbol$.MODULE$.unapply(bSONValue)).isEmpty()) {
            String name = (String)option5.get();
            byteBuf = WritableBuffer$.MODULE$.writeBsonString$extension(buffer, name);
        } else if (bSONValue != null && !(option4 = BSONJavaScriptWS$.MODULE$.unapply(bSONValue)).isEmpty()) {
            String v = (String)((Tuple2)option4.get())._1();
            BSONDocument s = (BSONDocument)((Tuple2)option4.get())._2();
            WritableBuffer$.MODULE$.writeBsonString$extension(buffer, v);
            byteBuf = this.writeDocument(s, buffer);
        } else if (bSONValue != null && !(option3 = BSONInteger$.MODULE$.unapply(bSONValue)).isEmpty()) {
            int v = BoxesRunTime.unboxToInt((Object)option3.get());
            byteBuf = WritableBuffer$.MODULE$.writeInt$extension(buffer, v);
        } else if (bSONValue != null && !(option2 = BSONTimestamp$.MODULE$.unapply(bSONValue)).isEmpty()) {
            long time = BoxesRunTime.unboxToLong((Object)option2.get());
            byteBuf = WritableBuffer$.MODULE$.writeLong$extension(buffer, time);
        } else if (bSONValue != null && !(option = BSONLong$.MODULE$.unapply(bSONValue)).isEmpty()) {
            long v = BoxesRunTime.unboxToLong((Object)option.get());
            byteBuf = WritableBuffer$.MODULE$.writeLong$extension(buffer, v);
        } else if (bSONValue instanceof BSONDecimal) {
            BSONDecimal bSONDecimal = (BSONDecimal)bSONValue;
            byteBuf = this.writeDecimal(bSONDecimal, buffer);
        } else {
            byteBuf = buffer;
        }
        return byteBuf;
    }

    public Try<BSONValue> deserialize(ByteBuffer buffer) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.readValue(buffer, ReadableBuffer$.MODULE$.readByte$extension(buffer)));
    }

    public ByteBuf writeArray(IndexedSeq<BSONValue> vs, ByteBuf buffer) {
        int szBefore = WritableBuffer$.MODULE$.size$extension(buffer);
        WritableBuffer$.MODULE$.writeInt$extension(buffer, 0);
        IntRef i = IntRef.create((int)0);
        vs.foreach((Function1 & Serializable)v -> {
            DefaultBufferHandler$.$anonfun$writeArray$1(buffer, i, v);
            return BoxedUnit.UNIT;
        });
        WritableBuffer$.MODULE$.setInt$extension(buffer, szBefore, WritableBuffer$.MODULE$.size$extension(buffer) - szBefore + 1);
        WritableBuffer$.MODULE$.writeByte$extension(buffer, (byte)0);
        return buffer;
    }

    public ByteBuf writeDocument(BSONDocument document, ByteBuf buffer) {
        int szBefore = WritableBuffer$.MODULE$.size$extension(buffer);
        WritableBuffer$.MODULE$.writeInt$extension(buffer, 0);
        document.elements().foreach((Function1 & Serializable)x0$1 -> new WritableBuffer(DefaultBufferHandler$.$anonfun$writeDocument$1(buffer, x0$1)));
        WritableBuffer$.MODULE$.setInt$extension(buffer, szBefore, WritableBuffer$.MODULE$.size$extension(buffer) - szBefore + 1);
        WritableBuffer$.MODULE$.writeByte$extension(buffer, (byte)0);
        return buffer;
    }

    private BSONDouble readDouble(ByteBuffer buffer) {
        return BSONDouble$.MODULE$.apply(ReadableBuffer$.MODULE$.readDouble$extension(buffer));
    }

    public BSONString readString(ByteBuffer buffer) {
        return BSONString$.MODULE$.apply(ReadableBuffer$.MODULE$.readBsonString$extension(buffer));
    }

    public BSONDocument readDocument(ByteBuffer buffer) {
        int n = ReadableBuffer$.MODULE$.readInt$extension(buffer);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        Builder builder = Seq$.MODULE$.newBuilder();
        return BSONDocument$.MODULE$.apply((Iterable<Tuple2<String, BSONValue>>)this.elements$1(buffer, builder));
    }

    public BSONArray readArray(ByteBuffer buffer) {
        int n = ReadableBuffer$.MODULE$.readInt$extension(buffer);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        Builder builder = IndexedSeq$.MODULE$.newBuilder();
        return new BSONArray((IndexedSeq<BSONValue>)this.makeSeq$1(buffer, builder));
    }

    public ByteBuf writeBinary(BSONBinary binary, ByteBuf buffer) {
        return WritableBuffer$.MODULE$.writeBytes$extension(WritableBuffer$.MODULE$.writeByte$extension(WritableBuffer$.MODULE$.writeInt$extension(buffer, ReadableBuffer$.MODULE$.readable$extension(binary.value())), binary.subtype().value()), ReadableBuffer$.MODULE$.duplicate$extension(binary.value()));
    }

    public BSONBinary readBinary(ByteBuffer buffer) {
        ByteBuffer data;
        int readable = ReadableBuffer$.MODULE$.readInt$extension(buffer);
        Subtype subtype = Subtype$.MODULE$.apply(ReadableBuffer$.MODULE$.readByte$extension(buffer));
        Tuple2<ByteBuffer, ByteBuffer> tuple2 = ReadableBuffer$.MODULE$.splitAt$extension(buffer, readable);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ByteBuffer byteBuffer = data = ((ReadableBuffer)tuple2._1()).buffer();
        ByteBuffer data2 = byteBuffer;
        return new BSONBinary(data2, subtype);
    }

    public ByteBuf writeObjectID(BSONObjectID oid, ByteBuf buffer) {
        return WritableBuffer$.MODULE$.writeBytes$extension(buffer, oid.byteArray());
    }

    public BSONObjectID readObjectID(ByteBuffer buffer) {
        BSONObjectID oid;
        Try<BSONObjectID> try_ = BSONObjectID$.MODULE$.parse(ReadableBuffer$.MODULE$.readArray$extension(buffer, 12));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                throw err;
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        BSONObjectID bSONObjectID = oid = (BSONObjectID)success.value();
        return bSONObjectID;
    }

    private BSONBoolean readBoolean(ByteBuffer buffer) {
        return BSONBoolean$.MODULE$.apply(ReadableBuffer$.MODULE$.readByte$extension(buffer) == 1);
    }

    private BSONDateTime readDateTime(ByteBuffer buffer) {
        return BSONDateTime$.MODULE$.apply(ReadableBuffer$.MODULE$.readLong$extension(buffer));
    }

    public ByteBuf writeRegex(BSONRegex regex, ByteBuf buffer) {
        WritableBuffer$.MODULE$.writeCString$extension(buffer, regex.value());
        return WritableBuffer$.MODULE$.writeCString$extension(buffer, regex.flags());
    }

    private BSONRegex readRegex(ByteBuffer buffer) {
        return BSONRegex$.MODULE$.apply(ReadableBuffer$.MODULE$.readCString$extension(buffer), ReadableBuffer$.MODULE$.readCString$extension(buffer));
    }

    private BSONJavaScript readJavaScript(ByteBuffer buffer) {
        return BSONJavaScript$.MODULE$.apply(ReadableBuffer$.MODULE$.readBsonString$extension(buffer));
    }

    private BSONSymbol readSymbol(ByteBuffer buffer) {
        return BSONSymbol$.MODULE$.apply(ReadableBuffer$.MODULE$.readBsonString$extension(buffer));
    }

    private BSONJavaScriptWS readJavaScriptWS(ByteBuffer buffer) {
        return BSONJavaScriptWS$.MODULE$.apply(ReadableBuffer$.MODULE$.readBsonString$extension(buffer), this.readDocument(buffer));
    }

    private BSONInteger readInteger(ByteBuffer buffer) {
        return BSONInteger$.MODULE$.apply(ReadableBuffer$.MODULE$.readInt$extension(buffer));
    }

    private BSONTimestamp readTimestamp(ByteBuffer buffer) {
        return BSONTimestamp$.MODULE$.apply(ReadableBuffer$.MODULE$.readLong$extension(buffer));
    }

    private BSONLong readLong(ByteBuffer buffer) {
        return BSONLong$.MODULE$.apply(ReadableBuffer$.MODULE$.readLong$extension(buffer));
    }

    public ByteBuf writeDecimal(BSONDecimal decimal, ByteBuf buffer) {
        return WritableBuffer$.MODULE$.writeLong$extension(WritableBuffer$.MODULE$.writeLong$extension(buffer, decimal.low()), decimal.high());
    }

    public BSONDecimal readDecimal(ByteBuffer buffer) {
        long x$1 = ReadableBuffer$.MODULE$.readLong$extension(buffer);
        long x$2 = ReadableBuffer$.MODULE$.readLong$extension(buffer);
        return BSONDecimal$.MODULE$.apply(x$2, x$1);
    }

    public BSONValue readValue(ByteBuffer buffer, byte code) {
        BSONValue bSONValue;
        if (ReadableBuffer$.MODULE$.readable$extension(buffer) > 0) {
            byte by = code;
            switch (by) {
                case 1: {
                    bSONValue = this.readDouble(buffer);
                    break;
                }
                case 2: {
                    bSONValue = this.readString(buffer);
                    break;
                }
                case 3: {
                    bSONValue = this.readDocument(buffer);
                    break;
                }
                case 4: {
                    bSONValue = this.readArray(buffer);
                    break;
                }
                case 5: {
                    bSONValue = this.readBinary(buffer);
                    break;
                }
                case 6: {
                    bSONValue = BSONUndefined$.MODULE$;
                    break;
                }
                case 7: {
                    bSONValue = this.readObjectID(buffer);
                    break;
                }
                case 8: {
                    bSONValue = this.readBoolean(buffer);
                    break;
                }
                case 9: {
                    bSONValue = this.readDateTime(buffer);
                    break;
                }
                case 16: {
                    bSONValue = this.readInteger(buffer);
                    break;
                }
                case 17: {
                    bSONValue = this.readTimestamp(buffer);
                    break;
                }
                case 18: {
                    bSONValue = this.readLong(buffer);
                    break;
                }
                case 19: {
                    bSONValue = this.readDecimal(buffer);
                    break;
                }
                case 10: {
                    bSONValue = BSONNull$.MODULE$;
                    break;
                }
                case 11: {
                    bSONValue = this.readRegex(buffer);
                    break;
                }
                case 13: {
                    bSONValue = this.readJavaScript(buffer);
                    break;
                }
                case 14: {
                    bSONValue = this.readSymbol(buffer);
                    break;
                }
                case 15: {
                    bSONValue = this.readJavaScriptWS(buffer);
                    break;
                }
                case 255: {
                    bSONValue = BSONMinKey$.MODULE$;
                    break;
                }
                case 127: {
                    bSONValue = BSONMaxKey$.MODULE$;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(19).append("invalid type code: ").append(code).toString());
                }
            }
        } else {
            throw new NoSuchElementException("buffer can not be read, end of buffer reached");
        }
        return bSONValue;
    }

    public static final /* synthetic */ void $anonfun$writeArray$1(ByteBuf buffer$2, IntRef i$1, BSONValue v) {
        WritableBuffer$.MODULE$.writeByte$extension(buffer$2, v.code());
        WritableBuffer$.MODULE$.writeCString$extension(buffer$2, ((Object)BoxesRunTime.boxToInteger((int)i$1.elem)).toString());
        MODULE$.serialize(v, buffer$2);
        ++i$1.elem;
    }

    public static final /* synthetic */ ByteBuf $anonfun$writeDocument$1(ByteBuf buffer$3, BSONElement x0$1) {
        Option<Tuple2<String, BSONValue>> option;
        BSONElement bSONElement = x0$1;
        if (bSONElement == null || (option = BSONElement$.MODULE$.unapply(bSONElement)).isEmpty()) {
            throw new MatchError((Object)bSONElement);
        }
        String k = (String)((Tuple2)option.get())._1();
        BSONValue v = (BSONValue)((Tuple2)option.get())._2();
        WritableBuffer$.MODULE$.writeByte$extension(buffer$3, v.code());
        WritableBuffer$.MODULE$.writeCString$extension(buffer$3, k);
        ByteBuf byteBuf = MODULE$.serialize(v, buffer$3);
        return byteBuf;
    }

    private static final /* synthetic */ byte code$lzycompute$1(LazyByte code$lzy$1, ByteBuffer buffer$4) {
        byte by;
        LazyByte lazyByte = code$lzy$1;
        synchronized (lazyByte) {
            by = code$lzy$1.initialized() ? code$lzy$1.value() : code$lzy$1.initialize(ReadableBuffer$.MODULE$.readByte$extension(buffer$4));
        }
        return by;
    }

    private static final byte code$1(LazyByte code$lzy$1, ByteBuffer buffer$4) {
        return code$lzy$1.initialized() ? code$lzy$1.value() : DefaultBufferHandler$.code$lzycompute$1(code$lzy$1, buffer$4);
    }

    private final Seq elements$1(ByteBuffer buffer$4, Builder builder$1) {
        while (true) {
            LazyByte code$lzy = new LazyByte();
            if (ReadableBuffer$.MODULE$.readable$extension(buffer$4) <= 1 || DefaultBufferHandler$.code$1(code$lzy, buffer$4) == 0) break;
            builder$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReadableBuffer$.MODULE$.readCString$extension(buffer$4)), (Object)this.readValue(buffer$4, DefaultBufferHandler$.code$1(code$lzy, buffer$4))));
        }
        return (Seq)builder$1.result();
    }

    private static final /* synthetic */ byte code$lzycompute$2(LazyByte code$lzy$2, ByteBuffer buffer$5) {
        byte by;
        LazyByte lazyByte = code$lzy$2;
        synchronized (lazyByte) {
            by = code$lzy$2.initialized() ? code$lzy$2.value() : code$lzy$2.initialize(ReadableBuffer$.MODULE$.readByte$extension(buffer$5));
        }
        return by;
    }

    private static final byte code$2(LazyByte code$lzy$2, ByteBuffer buffer$5) {
        return code$lzy$2.initialized() ? code$lzy$2.value() : DefaultBufferHandler$.code$lzycompute$2(code$lzy$2, buffer$5);
    }

    public static final /* synthetic */ boolean $anonfun$readArray$1(byte x$3) {
        return x$3 == 0;
    }

    private final IndexedSeq makeSeq$1(ByteBuffer buffer$5, Builder builder$2) {
        while (true) {
            LazyByte code$lzy = new LazyByte();
            if (ReadableBuffer$.MODULE$.readable$extension(buffer$5) <= 1 || DefaultBufferHandler$.code$2(code$lzy, buffer$5) == 0) break;
            ReadableBuffer$.MODULE$.skipUntil$extension(buffer$5, (Function1<Object, Object>)(Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DefaultBufferHandler$.$anonfun$readArray$1(BoxesRunTime.unboxToByte((Object)x$3))));
            builder$2.$plus$eq((Object)this.readValue(buffer$5, DefaultBufferHandler$.code$2(code$lzy, buffer$5)));
        }
        return (IndexedSeq)builder$2.result();
    }

    private DefaultBufferHandler$() {
    }
}

