/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.bson;

import java.net.NetworkInterface;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import reactivemongo.bson.BSONObjectID;
import reactivemongo.bson.BSONObjectID$;
import reactivemongo.bson.utils.Converters$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;
import scala.util.Try;
import scala.util.Try$;

public final class BSONObjectID$
implements Serializable {
    public static final BSONObjectID$ MODULE$;
    private final int maxCounterValue;
    private final AtomicInteger increment;
    private final byte[] machineId;

    static {
        new BSONObjectID$();
    }

    private int maxCounterValue() {
        return this.maxCounterValue;
    }

    private AtomicInteger increment() {
        return this.increment;
    }

    private int counter() {
        return (this.increment().getAndIncrement() + this.maxCounterValue()) % this.maxCounterValue();
    }

    private byte[] machineId() {
        return this.machineId;
    }

    public BSONObjectID apply(String id) {
        if (id.length() != 24) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"wrong ObjectId: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})));
        }
        return new BSONObjectID(Converters$.MODULE$.str2Hex(id));
    }

    public BSONObjectID apply(byte[] array) {
        if (array.length != 12) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"wrong byte array for an ObjectId (size ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)array.length)})));
        }
        return new BSONObjectID(Arrays.copyOf(array, 12));
    }

    public Option<byte[]> unapply(BSONObjectID id) {
        return new Some((Object)id.valueAsArray());
    }

    public Try<BSONObjectID> parse(String str) {
        return Try$.MODULE$.apply((Function0)new Serializable(str){
            public static final long serialVersionUID = 0L;
            private final String str$1;

            public final BSONObjectID apply() {
                return BSONObjectID$.MODULE$.apply(this.str$1);
            }
            {
                this.str$1 = str$1;
            }
        });
    }

    public BSONObjectID generate() {
        return this.fromTime(System.currentTimeMillis(), false);
    }

    public BSONObjectID fromTime(long timeMillis, boolean fillOnlyTimestamp) {
        int timestamp = (int)(timeMillis / 1000L);
        byte[] id = new byte[12];
        id[0] = (byte)(timestamp >>> 24);
        id[1] = (byte)(timestamp >> 16 & 0xFF);
        id[2] = (byte)(timestamp >> 8 & 0xFF);
        id[3] = (byte)(timestamp & 0xFF);
        if (!fillOnlyTimestamp) {
            id[4] = this.machineId()[0];
            id[5] = this.machineId()[1];
            id[6] = this.machineId()[2];
            int threadId = (int)Thread.currentThread().getId();
            id[7] = (byte)(threadId & 0xFF);
            id[8] = (byte)(threadId >> 8 & 0xFF);
            int c = this.counter();
            id[9] = (byte)(c >> 16 & 0xFF);
            id[10] = (byte)(c >> 8 & 0xFF);
            id[11] = (byte)(c & 0xFF);
        }
        return this.apply(id);
    }

    public boolean fromTime$default$2() {
        return true;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BSONObjectID$() {
        byte[] byArray;
        MODULE$ = this;
        this.maxCounterValue = 0x1000000;
        this.increment = new AtomicInteger(Random$.MODULE$.nextInt(this.maxCounterValue()));
        boolean validPlatform = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new anonfun.1()).getOrElse((Function0)new anonfun.2()));
        SecurityManager sec = System.getSecurityManager();
        boolean permitted = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new anonfun.3(sec)).toOption().map((Function1)new anonfun.5()).getOrElse((Function0)new anonfun.4()));
        if (validPlatform && permitted) {
            Enumeration<NetworkInterface> networkInterfacesEnum = NetworkInterface.getNetworkInterfaces();
            Iterator networkInterfaces = (Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(networkInterfacesEnum).asScala();
            byte[] ha = (byte[])networkInterfaces.find((Function1)new anonfun.6()).map((Function1)new anonfun.7()).getOrElse((Function0)new anonfun.8());
            byArray = (byte[])Predef$.MODULE$.byteArrayOps(Converters$.MODULE$.md5(ha)).take(3);
        } else {
            int threadId = (int)Thread.currentThread().getId();
            byte[] arr = new byte[]{(byte)(threadId & 0xFF), (byte)(threadId >> 8 & 0xFF), (byte)(threadId >> 16 & 0xFF)};
            byArray = arr;
        }
        this.machineId = byArray;
    }
}

