/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.datadog;

import com.timgroup.statsd.Event;
import com.timgroup.statsd.StatsDClient;
import java.io.Serializable;
import org.slf4j.Logger;
import reactivemongo.api.MongoConnectionOptions;
import reactivemongo.core.nodeset.NodeInfo;
import reactivemongo.core.nodeset.NodeSetInfo;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005]a\u0001\u0002\u0007\u000e\u0005IA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!)a\u0007\u0001C\u0001o!)A\b\u0001C\u0001{!9Q\n\u0001b\u0001\n\u0013q\u0005B\u00021\u0001A\u0003%q\nC\u0004b\u0001\t\u0007I\u0011\u00022\t\r5\u0004\u0001\u0015!\u0003d\u0011\u0015q\u0007\u0001\"\u0001p\u0011\u0015q\b\u0001\"\u0001\u0000\u0011\u001d\t)\u0001\u0001C\u0005\u0003\u000f\u0011!cQ8o]\u0016\u001cG/[8o\u0019&\u001cH/\u001a8fe*\u0011abD\u0001\bI\u0006$\u0018\rZ8h\u0015\u0005\u0001\u0012!\u0004:fC\u000e$\u0018N^3n_:<wn\u0001\u0001\u0014\u0007\u0001\u0019\u0012\u0004\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VM\u001a\t\u00035yi\u0011a\u0007\u0006\u0003!qQ\u0011!H\u0001\tKb$XM\u001d8bY&\u0011AbG\u0001\tQ>\u001cHO\\1nKB\u0011\u0011\u0005\u000b\b\u0003E\u0019\u0002\"aI\u000b\u000e\u0003\u0011R!!J\t\u0002\rq\u0012xn\u001c;?\u0013\t9S#\u0001\u0004Qe\u0016$WMZ\u0005\u0003S)\u0012aa\u0015;sS:<'BA\u0014\u0016\u0003\u0019\u0019G.[3oiB\u0011Q\u0006N\u0007\u0002])\u0011q\u0006M\u0001\u0007gR\fGo\u001d3\u000b\u0005E\u0012\u0014\u0001\u0003;j[\u001e\u0014x.\u001e9\u000b\u0003M\n1aY8n\u0013\t)dF\u0001\u0007Ti\u0006$8\u000fR\"mS\u0016tG/\u0001\u0004=S:LGO\u0010\u000b\u0004qiZ\u0004CA\u001d\u0001\u001b\u0005i\u0001\"B\u0010\u0004\u0001\u0004\u0001\u0003\"B\u0016\u0004\u0001\u0004a\u0013a\u00039p_2\u001c%/Z1uK\u0012$BAP!J\u0017B\u0011AcP\u0005\u0003\u0001V\u0011A!\u00168ji\")!\t\u0002a\u0001\u0007\u00069q\u000e\u001d;j_:\u001c\bC\u0001#H\u001b\u0005)%B\u0001$\u0010\u0003\r\t\u0007/[\u0005\u0003\u0011\u0016\u0013a#T8oO>\u001cuN\u001c8fGRLwN\\(qi&|gn\u001d\u0005\u0006\u0015\u0012\u0001\r\u0001I\u0001\u000bgV\u0004XM\u001d<jg>\u0014\b\"\u0002'\u0005\u0001\u0004\u0001\u0013AC2p]:,7\r^5p]\u0006A\u0001o\\8m)\u0006<7/F\u0001P!\u0011\u0001Vk\u0016.\u000e\u0003ES!AU*\u0002\u000f5,H/\u00192mK*\u0011A+F\u0001\u000bG>dG.Z2uS>t\u0017B\u0001,R\u0005\ri\u0015\r\u001d\t\u0005)a\u0003\u0003%\u0003\u0002Z+\t1A+\u001e9mKJ\u00022a\u00170!\u001b\u0005a&BA/T\u0003%IW.\\;uC\ndW-\u0003\u0002`9\n\u00191+\u001a;\u0002\u0013A|w\u000e\u001c+bON\u0004\u0013!\u00028pI\u0016\u001cX#A2\u0011\tA+v\u000b\u001a\t\u0004K*\u0004cB\u00014i\u001d\t\u0019s-C\u0001\u0017\u0013\tIW#A\u0004qC\u000e\\\u0017mZ3\n\u0005-d'A\u0002,fGR|'O\u0003\u0002j+\u00051an\u001c3fg\u0002\naB\\8eKN+G/\u00169eCR,G\rF\u0003?aF\u0014H\u0010C\u0003K\u0013\u0001\u0007\u0001\u0005C\u0003M\u0013\u0001\u0007\u0001\u0005C\u0003t\u0013\u0001\u0007A/\u0001\u0005qe\u00164\u0018n\\;t!\t)(0D\u0001w\u0015\t9\b0A\u0004o_\u0012,7/\u001a;\u000b\u0005e|\u0011\u0001B2pe\u0016L!a\u001f<\u0003\u00179{G-Z*fi&sgm\u001c\u0005\u0006{&\u0001\r\u0001^\u0001\bkB$\u0017\r^3e\u00031\u0001xn\u001c7TQV$Hm\\<o)\u0015q\u0014\u0011AA\u0002\u0011\u0015Q%\u00021\u0001!\u0011\u0015a%\u00021\u0001!\u0003-!(/Y2f+B$\u0017\r^3\u0015\u000fy\nI!a\u0003\u0002\u0016!)!j\u0003a\u0001A!9\u0011QB\u0006A\u0002\u0005=\u0011\u0001\u00032bg\u0016$\u0016mZ:\u0011\t\u0015\f\t\u0002I\u0005\u0004\u0003'a'aA*fc\")Qp\u0003a\u0001i\u0002")
public final class ConnectionListener
implements external.reactivemongo.ConnectionListener {
    private final String hostname;
    private final StatsDClient client;
    private final Map<Tuple2<String, String>, Set<String>> poolTags;
    private final Map<Tuple2<String, String>, Vector<String>> nodes;
    private Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ConnectionListener connectionListener = this;
        synchronized (connectionListener) {
            if (!this.bitmap$0) {
                this.logger = external.reactivemongo.ConnectionListener.logger$((external.reactivemongo.ConnectionListener)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public void poolCreated(MongoConnectionOptions options, String supervisor, String connection) {
        Event.Builder event = Event.builder().withHostname(this.hostname).withAggregationKey(supervisor).withSourceTypeName("reactivemongo").withAlertType(Event.AlertType.INFO).withDate(System.currentTimeMillis()).withTitle("reactivemongo.pool-created").withText(options.toString());
        this.client.recordEvent(event.build(), new String[]{new StringBuilder(12).append("supervisior:").append(supervisor).toString(), new StringBuilder(12).append("connection:").append(supervisor).append(".").append(connection).toString()});
    }

    private Map<Tuple2<String, String>, Set<String>> poolTags() {
        return this.poolTags;
    }

    private Map<Tuple2<String, String>, Vector<String>> nodes() {
        return this.nodes;
    }

    public void nodeSetUpdated(String supervisor, String connection, NodeSetInfo previous, NodeSetInfo updated) {
        String conPrefix = new StringBuilder(1).append(supervisor).append(".").append(connection).toString();
        String prefix = (String)Option$.MODULE$.option2Iterable(updated.name()).foldLeft((Object)conPrefix, (Function2 & Serializable)(p, n) -> new StringBuilder(1).append((String)p).append(".").append((String)n).toString());
        Tuple2 key = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)supervisor), (Object)connection);
        Set tagSet = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(11).append("supervisor:").append(supervisor).toString(), new StringBuilder(11).append("connection:").append(conPrefix).toString(), new StringBuilder(8).append("nodeset:").append(prefix).toString()}));
        Map<Tuple2<String, String>, Set<String>> map = this.poolTags();
        synchronized (map) {
            this.poolTags().put((Object)key, (Object)tagSet);
        }
        Seq tags = tagSet.toSeq();
        this.traceUpdate(supervisor, (Seq<String>)tags, updated);
        Function2 & Serializable gauge = (Function2 & Serializable)(x$1, x$2) -> {
            this.client.gauge(x$1, BoxesRunTime.unboxToLong((Object)x$2), (String[])tags.toArray(ClassTag$.MODULE$.apply(String.class)));
            return BoxedUnit.UNIT;
        };
        gauge.apply((Object)"awaitingRequests", updated.awaitingRequests().fold((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (Function1)(JFunction1.mcJI.sp & Serializable)x$3 -> x$3));
        gauge.apply((Object)"maxAwaitingRequestsPerChannel", updated.maxAwaitingRequestsPerChannel().fold((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (Function1)(JFunction1.mcJI.sp & Serializable)x$4 -> x$4));
        gauge.apply((Object)"numberOfNodes", (Object)BoxesRunTime.boxToLong((long)updated.nodes().size()));
        gauge.apply((Object)"hasPrimary", (Object)(updated.primary().isDefined() ? BoxesRunTime.boxToLong((long)1L) : BoxesRunTime.boxToLong((long)0L)));
        gauge.apply((Object)"hasNearest", (Object)(updated.nearest().isDefined() ? BoxesRunTime.boxToLong((long)1L) : BoxesRunTime.boxToLong((long)0L)));
        gauge.apply((Object)"isMongos", (Object)(updated.mongos().isDefined() ? BoxesRunTime.boxToLong((long)1L) : BoxesRunTime.boxToLong((long)0L)));
        gauge.apply((Object)"numberOfSecondaries", (Object)BoxesRunTime.boxToLong((long)updated.secondaries().size()));
        Map<Tuple2<String, String>, Vector<String>> map2 = this.nodes();
        synchronized (map2) {
            this.nodes().put((Object)key, updated.nodes().map((Function1 & Serializable)x$5 -> x$5.name()));
        }
        updated.nodes().foreach((Function1 & Serializable)node -> {
            ConnectionListener.$anonfun$nodeSetUpdated$8(this, tags, node);
            return BoxedUnit.UNIT;
        });
    }

    public void poolShutdown(String supervisor, String connection) {
        Option option;
        Option option2;
        Tuple2 key = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)supervisor), (Object)connection);
        Map<Tuple2<String, String>, Set<String>> map = this.poolTags();
        synchronized (map) {
            option2 = this.poolTags().remove((Object)key);
        }
        Seq pts = ((IterableOnceOps)option2.getOrElse((Function0 & Serializable)() -> Set$.MODULE$.empty())).toSeq();
        Function1 & Serializable reset = (Function1 & Serializable)x$6 -> {
            this.client.gauge(x$6, 0L, (String[])pts.toArray(ClassTag$.MODULE$.apply(String.class)));
            return BoxedUnit.UNIT;
        };
        reset.apply((Object)"awaitingRequests");
        reset.apply((Object)"maxAwaitingRequestsPerChannel");
        reset.apply((Object)"numberOfNodes");
        reset.apply((Object)"hasPrimary");
        reset.apply((Object)"hasNearest");
        reset.apply((Object)"isMongos");
        reset.apply((Object)"numberOfSecondaries");
        Map<Tuple2<String, String>, Vector<String>> map2 = this.nodes();
        synchronized (map2) {
            option = this.nodes().remove((Object)key);
        }
        Vector ns = (Vector)option.getOrElse((Function0 & Serializable)() -> package$.MODULE$.Vector().empty());
        ns.foreach((Function1 & Serializable)node -> {
            ConnectionListener.$anonfun$poolShutdown$4(this, pts, node);
            return BoxedUnit.UNIT;
        });
        Event.Builder event = Event.builder().withHostname(this.hostname).withAggregationKey(supervisor).withSourceTypeName("reactivemongo").withAlertType(Event.AlertType.INFO).withDate(System.currentTimeMillis()).withTitle("pool-stopped").withText(ns.mkString(", "));
        this.client.recordEvent(event.build(), new String[]{new StringBuilder(11).append("supervisor:").append(supervisor).toString(), new StringBuilder(12).append("connection:").append(supervisor).append(".").append(connection).toString()});
    }

    private void traceUpdate(String supervisor, Seq<String> baseTags, NodeSetInfo updated) {
        Event.Builder event = Event.builder().withHostname(this.hostname).withAggregationKey(supervisor).withSourceTypeName("reactivemongo").withAlertType(Event.AlertType.INFO).withDate(System.currentTimeMillis()).withTitle("pool-updated").withText(updated.toString());
        Builder tags = (Builder)package$.MODULE$.Seq().newBuilder().$plus$plus$eq(baseTags);
        updated.version().foreach((Function1 & Serializable)v -> ConnectionListener.$anonfun$traceUpdate$1(tags, BoxesRunTime.unboxToLong((Object)v)));
        updated.primary().foreach((Function1 & Serializable)node -> (Builder)tags.$plus$eq((Object)new StringBuilder(8).append("primary:").append(node.name()).toString()));
        updated.mongos().foreach((Function1 & Serializable)node -> (Builder)tags.$plus$eq((Object)new StringBuilder(7).append("mongos:").append(node.name()).toString()));
        updated.nearest().foreach((Function1 & Serializable)node -> (Builder)tags.$plus$eq((Object)new StringBuilder(8).append("nearest:").append(node.name()).toString()));
        this.client.recordEvent(event.build(), (String[])((IterableOnceOps)tags.result()).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    private final void ng$1(String property, int value, Seq nodeTags$1) {
        this.client.gauge(property, (long)value, (String[])nodeTags$1.toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public static final /* synthetic */ void $anonfun$nodeSetUpdated$8(ConnectionListener $this, Seq tags$1, NodeInfo node) {
        Seq nodeTags = (Seq)tags$1.$colon$plus((Object)new StringBuilder(5).append("node:").append(node.name()).toString());
        $this.ng$1("nodeChannels", node.connections(), nodeTags);
        $this.ng$1("connectedChannels", node.connected(), nodeTags);
        $this.ng$1("authenticatedChannels", node.authenticated(), nodeTags);
        $this.client.gauge("pingTime", node.pingInfo().ping() / 1000L, (String[])nodeTags.toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public static final /* synthetic */ void $anonfun$poolShutdown$4(ConnectionListener $this, Seq pts$1, String node) {
        Seq nts = (Seq)pts$1.$colon$plus((Object)new StringBuilder(5).append("node:").append(node).toString());
        Function1 & Serializable g = (Function1 & Serializable)x$7 -> {
            $this.client.gauge(x$7, 0L, (String[])nts.toArray(ClassTag$.MODULE$.apply(String.class)));
            return BoxedUnit.UNIT;
        };
        g.apply((Object)"nodeChannels");
        g.apply((Object)"connectedChannels");
        g.apply((Object)"authenticatedChannels");
        g.apply((Object)"pingTime");
    }

    public static final /* synthetic */ Builder $anonfun$traceUpdate$1(Builder tags$2, long v) {
        return (Builder)tags$2.$plus$eq((Object)new StringBuilder(8).append("version:").append(v).toString());
    }

    public ConnectionListener(String hostname, StatsDClient client) {
        this.hostname = hostname;
        this.client = client;
        external.reactivemongo.ConnectionListener.$init$((external.reactivemongo.ConnectionListener)this);
        this.poolTags = (Map)Map$.MODULE$.empty();
        this.nodes = (Map)Map$.MODULE$.empty();
    }
}

