/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.datadog;

import com.timgroup.statsd.Event;
import com.timgroup.statsd.StatsDClient;
import java.io.Serializable;
import org.slf4j.Logger;
import reactivemongo.api.MongoConnectionOptions;
import reactivemongo.core.nodeset.NodeSetInfo;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ConnectionListener
implements external.reactivemongo.ConnectionListener {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(ConnectionListener.class, "0bitmap$1");
    public Logger logger$lzy1;
    public long 0bitmap$1;
    private final String hostname;
    private final StatsDClient client;
    private final Map<Tuple2<String, String>, Set<String>> poolTags;
    private final Map<Tuple2<String, String>, Vector<String>> nodes;

    public ConnectionListener(String hostname, StatsDClient client) {
        this.hostname = hostname;
        this.client = client;
        this.poolTags = (Map)Map$.MODULE$.empty();
        this.nodes = (Map)Map$.MODULE$.empty();
    }

    public Logger logger() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    Logger logger;
                    this.logger$lzy1 = logger = external.reactivemongo.ConnectionListener.logger$((external.reactivemongo.ConnectionListener)this);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return logger;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.logger$lzy1;
    }

    public void poolCreated(MongoConnectionOptions options, String supervisor, String connection) {
        Event.Builder event = Event.builder().withHostname(this.hostname).withAggregationKey(supervisor).withSourceTypeName("reactivemongo").withAlertType(Event.AlertType.INFO).withDate(System.currentTimeMillis()).withTitle("reactivemongo.pool-created").withText(options.toString());
        this.client.recordEvent(event.build(), new String[]{new StringBuilder(12).append("supervisior:").append(supervisor).toString(), new StringBuilder(12).append("connection:").append(supervisor).append(".").append(connection).toString()});
    }

    public void nodeSetUpdated(String supervisor, String connection, NodeSetInfo previous, NodeSetInfo updated) {
        String conPrefix = new StringBuilder(1).append(supervisor).append(".").append(connection).toString();
        String prefix = (String)Option$.MODULE$.option2Iterable(updated.name()).foldLeft((Object)conPrefix, (Function2 & Serializable)(p, n) -> new StringBuilder(1).append((String)p).append(".").append((String)n).toString());
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)supervisor);
        Tuple2 key = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)connection);
        Set tagSet = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(11).append("supervisor:").append(supervisor).toString(), new StringBuilder(11).append("connection:").append(conPrefix).toString(), new StringBuilder(8).append("nodeset:").append(prefix).toString()}));
        Map<Tuple2<String, String>, Set<String>> map = this.poolTags;
        synchronized (map) {
            this.poolTags.put((Object)key, (Object)tagSet);
        }
        Seq tags = tagSet.toSeq();
        this.traceUpdate(supervisor, (Seq<String>)tags, updated);
        Function2 & Serializable gauge = (Function2 & Serializable)(v1, v2) -> {
            this.$anonfun$2(tags, (String)v1, BoxesRunTime.unboxToLong((Object)v2));
            return BoxedUnit.UNIT;
        };
        gauge.apply((Object)"awaitingRequests", updated.awaitingRequests().fold(ConnectionListener::nodeSetUpdated$$anonfun$1, (Function1)(JFunction1.mcJI.sp & Serializable)_$3 -> _$3));
        gauge.apply((Object)"maxAwaitingRequestsPerChannel", updated.maxAwaitingRequestsPerChannel().fold(ConnectionListener::nodeSetUpdated$$anonfun$3, (Function1)(JFunction1.mcJI.sp & Serializable)_$4 -> _$4));
        gauge.apply((Object)"numberOfNodes", (Object)BoxesRunTime.boxToLong((long)updated.nodes().size()));
        gauge.apply((Object)"hasPrimary", (Object)(updated.primary().isDefined() ? BoxesRunTime.boxToLong((long)1L) : BoxesRunTime.boxToLong((long)0L)));
        gauge.apply((Object)"hasNearest", (Object)(updated.nearest().isDefined() ? BoxesRunTime.boxToLong((long)1L) : BoxesRunTime.boxToLong((long)0L)));
        gauge.apply((Object)"isMongos", (Object)(updated.mongos().isDefined() ? BoxesRunTime.boxToLong((long)1L) : BoxesRunTime.boxToLong((long)0L)));
        gauge.apply((Object)"numberOfSecondaries", (Object)BoxesRunTime.boxToLong((long)updated.secondaries().size()));
        Map<Tuple2<String, String>, Vector<String>> map2 = this.nodes;
        synchronized (map2) {
            this.nodes.put((Object)key, updated.nodes().map((Function1 & Serializable)_$5 -> _$5.name()));
        }
        updated.nodes().foreach((Function1)(JProcedure1 & Serializable)node -> {
            Seq nodeTags = (Seq)tags.$colon$plus((Object)new StringBuilder(5).append("node:").append(node.name()).toString());
            this.ng$1(nodeTags, "nodeChannels", node.connections());
            this.ng$1(nodeTags, "connectedChannels", node.connected());
            this.ng$1(nodeTags, "authenticatedChannels", node.authenticated());
            this.client.gauge("pingTime", node.pingInfo().ping() / 1000L, (String[])Arrays$.MODULE$.seqToArray(nodeTags, String.class));
        });
    }

    public void poolShutdown(String supervisor, String connection) {
        Option option;
        Option option2;
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)supervisor);
        Tuple2 key = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)connection);
        Map<Tuple2<String, String>, Set<String>> map = this.poolTags;
        synchronized (map) {
            option2 = this.poolTags.remove((Object)key);
        }
        Seq pts = ((IterableOnceOps)option2.getOrElse(ConnectionListener::$anonfun$3)).toSeq();
        JProcedure1 & Serializable reset = (JProcedure1 & Serializable)_$6 -> this.client.gauge(_$6, 0L, (String[])Arrays$.MODULE$.seqToArray(pts, String.class));
        reset.apply((Object)"awaitingRequests");
        reset.apply((Object)"maxAwaitingRequestsPerChannel");
        reset.apply((Object)"numberOfNodes");
        reset.apply((Object)"hasPrimary");
        reset.apply((Object)"hasNearest");
        reset.apply((Object)"isMongos");
        reset.apply((Object)"numberOfSecondaries");
        Map<Tuple2<String, String>, Vector<String>> map2 = this.nodes;
        synchronized (map2) {
            option = this.nodes.remove((Object)key);
        }
        Vector ns = (Vector)option.getOrElse(ConnectionListener::$anonfun$5);
        ns.foreach((Function1)(JProcedure1 & Serializable)node -> {
            Seq nts = (Seq)pts.$colon$plus((Object)new StringBuilder(5).append("node:").append((String)node).toString());
            JProcedure1 & Serializable g = (JProcedure1 & Serializable)_$7 -> this.client.gauge(_$7, 0L, (String[])Arrays$.MODULE$.seqToArray(nts, String.class));
            g.apply((Object)"nodeChannels");
            g.apply((Object)"connectedChannels");
            g.apply((Object)"authenticatedChannels");
            g.apply((Object)"pingTime");
        });
        Event.Builder event = Event.builder().withHostname(this.hostname).withAggregationKey(supervisor).withSourceTypeName("reactivemongo").withAlertType(Event.AlertType.INFO).withDate(System.currentTimeMillis()).withTitle("pool-stopped").withText(ns.mkString(", "));
        this.client.recordEvent(event.build(), new String[]{new StringBuilder(11).append("supervisor:").append(supervisor).toString(), new StringBuilder(12).append("connection:").append(supervisor).append(".").append(connection).toString()});
    }

    private void traceUpdate(String supervisor, Seq<String> baseTags, NodeSetInfo updated) {
        Event.Builder event = Event.builder().withHostname(this.hostname).withAggregationKey(supervisor).withSourceTypeName("reactivemongo").withAlertType(Event.AlertType.INFO).withDate(System.currentTimeMillis()).withTitle("pool-updated").withText(updated.toString());
        Builder tags = (Builder)package$.MODULE$.Seq().newBuilder().$plus$plus$eq(baseTags);
        updated.version().foreach((Function1 & Serializable)v -> ConnectionListener.traceUpdate$$anonfun$1(tags, BoxesRunTime.unboxToLong((Object)v)));
        updated.primary().foreach((Function1 & Serializable)node -> (Builder)tags.$plus$eq((Object)new StringBuilder(8).append("primary:").append(node.name()).toString()));
        updated.mongos().foreach((Function1 & Serializable)node -> (Builder)tags.$plus$eq((Object)new StringBuilder(7).append("mongos:").append(node.name()).toString()));
        updated.nearest().foreach((Function1 & Serializable)node -> (Builder)tags.$plus$eq((Object)new StringBuilder(8).append("nearest:").append(node.name()).toString()));
        this.client.recordEvent(event.build(), (String[])Arrays$.MODULE$.seqToArray((Seq)tags.result(), String.class));
    }

    private final /* synthetic */ void $anonfun$2(Seq tags$1, String _$1, long _$2) {
        this.client.gauge(_$1, _$2, (String[])Arrays$.MODULE$.seqToArray(tags$1, String.class));
    }

    private static final long nodeSetUpdated$$anonfun$1() {
        return 0L;
    }

    private static final long nodeSetUpdated$$anonfun$3() {
        return 0L;
    }

    private final void ng$1(Seq nodeTags$1, String property, int value) {
        this.client.gauge(property, (long)value, (String[])Arrays$.MODULE$.seqToArray(nodeTags$1, String.class));
    }

    private static final Set $anonfun$3() {
        return Set$.MODULE$.empty();
    }

    private static final Vector $anonfun$5() {
        return package$.MODULE$.Vector().empty();
    }

    private static final /* synthetic */ Builder traceUpdate$$anonfun$1(Builder tags$3, long v) {
        return (Builder)tags$3.$plus$eq((Object)new StringBuilder(8).append("version:").append(v).toString());
    }
}

