/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.jmx;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;
import reactivemongo.core.nodeset.NodeInfo;
import reactivemongo.core.nodeset.PingInfo;
import reactivemongo.core.protocol.ProtocolMetadata;
import reactivemongo.jmx.Node$;
import reactivemongo.jmx.NodeMBean;
import reactivemongo.jmx.NotificationSupport;
import scala.Function1;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public final class Node
extends NotificationBroadcasterSupport
implements NodeMBean,
NotificationSupport {
    private AtomicLong changeSeq;
    private final String supervisor;
    private final String connection;
    private String name;
    private String aliases;
    private String host;
    private int port;
    private String status;
    private int connections;
    private int connected;
    private int authenticated;
    private String tags;
    private String protocolMetadata;
    private String pingInfo;
    private boolean mongos;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Node$.class.getDeclaredField("0bitmap$3"));

    public static MBeanNotificationInfo[] notificationInfo() {
        return Node$.MODULE$.notificationInfo();
    }

    public Node(String supervisor, String connection) {
        this.supervisor = supervisor;
        this.connection = connection;
        NotificationSupport.$init$(this);
        this.name = "unknown";
        this.aliases = null;
        this.host = "unknown";
        this.port = -1;
        this.status = "unknown";
        this.connections = 0;
        this.connected = 0;
        this.authenticated = 0;
        this.tags = null;
        this.protocolMetadata = "unknown";
        this.pingInfo = "unknown";
        this.mongos = false;
        Statics.releaseFence();
    }

    @Override
    public AtomicLong changeSeq() {
        return this.changeSeq;
    }

    @Override
    public void reactivemongo$jmx$NotificationSupport$_setter_$changeSeq_$eq(AtomicLong x$0) {
        this.changeSeq = x$0;
    }

    public void update(NodeInfo info) {
        String _name = info.name();
        String _aliases = info.aliases().mkString(", ");
        String _host = info.host();
        int _port = info.port();
        String _status = info.status().toString();
        int _connections = info.connections();
        int _connected = info.connected();
        int _authenticated = info.authenticated();
        String _tags = info.tags().mkString("{", ", ", "}");
        boolean _mongos = info.isMongos();
        ProtocolMetadata m = info.protocolMetadata();
        String _protocolMetadata = new StringBuilder(92).append("minWireVersion = ").append(m.minWireVersion()).append(", maxWireVersion = ").append(m.maxWireVersion()).append(", maxMessageSizeBytes = ").append(m.maxMessageSizeBytes()).append(", maxBsonSize = ").append(m.maxBsonSize()).append(", maxBulkSize = ").append(m.maxBulkSize()).toString();
        PingInfo i = info.pingInfo();
        String _pingInfo = new StringBuilder(37).append("sent = ").append(i.ping()).append(", lastIsMaster(time = ").append(i.lastIsMasterTime()).append(", id = ").append(i.lastIsMasterId()).append(")").toString();
        this.attributeChanged("Name", "The node name", this.name, _name, (Function1)(JProcedure1 & Serializable)_$16 -> {
            this.name = _$16;
        }, ClassTag$.MODULE$.apply(String.class));
        this.attributeChanged("Aliases", "The aliases of the node", this.aliases, _aliases, (Function1)(JProcedure1 & Serializable)_$17 -> {
            this.aliases = _$17;
        }, ClassTag$.MODULE$.apply(String.class));
        this.attributeChanged("Host", "The name of the node host", this.host, _host, (Function1)(JProcedure1 & Serializable)_$18 -> {
            this.host = _$18;
        }, ClassTag$.MODULE$.apply(String.class));
        this.attributeChanged("Port", "The MongoDB port on the node", BoxesRunTime.boxToInteger((int)this.port), BoxesRunTime.boxToInteger((int)_port), (Function1)(JFunction1.mcVI.sp & Serializable)_$19 -> {
            this.port = _$19;
        }, ClassTag$.MODULE$.apply(Integer.TYPE));
        this.attributeChanged("Status", "The node status", this.status, _status, (Function1)(JProcedure1 & Serializable)_$20 -> {
            this.status = _$20;
        }, ClassTag$.MODULE$.apply(String.class));
        this.attributeChanged("Connections", "The number of connections to the node", BoxesRunTime.boxToInteger((int)this.connections), BoxesRunTime.boxToInteger((int)_connections), (Function1)(JFunction1.mcVI.sp & Serializable)_$21 -> {
            this.connections = _$21;
        }, ClassTag$.MODULE$.apply(Integer.TYPE));
        this.attributeChanged("Connected", "The number of connections established to the node", BoxesRunTime.boxToInteger((int)this.connected), BoxesRunTime.boxToInteger((int)_connected), (Function1)(JFunction1.mcVI.sp & Serializable)_$22 -> {
            this.connected = _$22;
        }, ClassTag$.MODULE$.apply(Integer.TYPE));
        this.attributeChanged("Authenticated", "The number of authenticated connections to the node", BoxesRunTime.boxToInteger((int)this.authenticated), BoxesRunTime.boxToInteger((int)_authenticated), (Function1)(JFunction1.mcVI.sp & Serializable)_$23 -> {
            this.authenticated = _$23;
        }, ClassTag$.MODULE$.apply(Integer.TYPE));
        this.attributeChanged("Tags", "The tags for the node", this.tags, _tags, (Function1)(JProcedure1 & Serializable)_$24 -> {
            this.tags = _$24;
        }, ClassTag$.MODULE$.apply(String.class));
        this.attributeChanged("ProtocolMetadata", "The metadata for the protocol to connect to the node", this.protocolMetadata, _protocolMetadata, (Function1)(JProcedure1 & Serializable)_$25 -> {
            this.protocolMetadata = _$25;
        }, ClassTag$.MODULE$.apply(String.class));
        this.attributeChanged("PingInfo", "The information about the ping to the node", this.pingInfo, _pingInfo, (Function1)(JProcedure1 & Serializable)_$26 -> {
            this.pingInfo = _$26;
        }, ClassTag$.MODULE$.apply(String.class));
        this.attributeChanged("Mongos", "Indicates whether the node is a Mongos one", BoxesRunTime.boxToBoolean((boolean)this.mongos), BoxesRunTime.boxToBoolean((boolean)_mongos), (Function1 & Serializable)v1 -> {
            this.update$$anonfun$22(BoxesRunTime.unboxToBoolean((Object)v1));
            return BoxedUnit.UNIT;
        }, ClassTag$.MODULE$.apply(Boolean.TYPE));
    }

    @Override
    public String getSupervisor() {
        return this.supervisor;
    }

    @Override
    public String getConnection() {
        return this.connection;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAliases() {
        return this.aliases;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public int getConnections() {
        return this.connections;
    }

    @Override
    public int getConnected() {
        return this.connected;
    }

    @Override
    public int getAuthenticated() {
        return this.authenticated;
    }

    @Override
    public String getTags() {
        return this.tags;
    }

    @Override
    public String getProtocolMetadata() {
        return this.protocolMetadata;
    }

    @Override
    public String getPingInfo() {
        return this.pingInfo;
    }

    @Override
    public boolean isMongos() {
        return this.mongos;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return Node$.MODULE$.notificationInfo();
    }

    private final /* synthetic */ void update$$anonfun$22(boolean _$27) {
        this.mongos = _$27;
    }
}

