/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.kamon;

import java.io.Serializable;
import kamon.Kamon$;
import kamon.metric.Gauge;
import kamon.metric.MeasurementUnit$;
import kamon.metric.Metric;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import kamon.trace.Span;
import kamon.trace.SpanBuilder;
import org.slf4j.Logger;
import reactivemongo.api.MongoConnectionOptions;
import reactivemongo.core.nodeset.NodeInfo;
import reactivemongo.core.nodeset.NodeSetInfo;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001a4AAC\u0006\u0003!!)Q\u0004\u0001C\u0001=!)\u0011\u0005\u0001C\u0001E!9Q\b\u0001b\u0001\n\u0013q\u0004BB)\u0001A\u0003%q\bC\u0004S\u0001\t\u0007I\u0011B*\t\ry\u0003\u0001\u0015!\u0003U\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u0015\u0019\b\u0001\"\u0003u\u0005I\u0019uN\u001c8fGRLwN\u001c'jgR,g.\u001a:\u000b\u00051i\u0011!B6b[>t'\"\u0001\b\u0002\u001bI,\u0017m\u0019;jm\u0016lwN\\4p\u0007\u0001\u00192\u0001A\t\u0018!\t\u0011R#D\u0001\u0014\u0015\u0005!\u0012!B:dC2\f\u0017B\u0001\f\u0014\u0005\u0019\te.\u001f*fMB\u0011\u0001\u0004H\u0007\u00023)\u0011aB\u0007\u0006\u00027\u0005AQ\r\u001f;fe:\fG.\u0003\u0002\u000b3\u00051A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011aC\u0001\fa>|Gn\u0011:fCR,G\r\u0006\u0003$M9Z\u0004C\u0001\n%\u0013\t)3C\u0001\u0003V]&$\b\"B\u0014\u0003\u0001\u0004A\u0013aB8qi&|gn\u001d\t\u0003S1j\u0011A\u000b\u0006\u0003W5\t1!\u00199j\u0013\ti#F\u0001\fN_:<wnQ8o]\u0016\u001cG/[8o\u001fB$\u0018n\u001c8t\u0011\u0015y#\u00011\u00011\u0003)\u0019X\u000f]3sm&\u001cxN\u001d\t\u0003car!A\r\u001c\u0011\u0005M\u001aR\"\u0001\u001b\u000b\u0005Uz\u0011A\u0002\u001fs_>$h(\u0003\u00028'\u00051\u0001K]3eK\u001aL!!\u000f\u001e\u0003\rM#(/\u001b8h\u0015\t94\u0003C\u0003=\u0005\u0001\u0007\u0001'\u0001\u0006d_:tWm\u0019;j_:\f\u0001\u0002]8pYR\u000bwm]\u000b\u0002\u007fA!\u0001)R$K\u001b\u0005\t%B\u0001\"D\u0003\u001diW\u000f^1cY\u0016T!\u0001R\n\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002G\u0003\n\u0019Q*\u00199\u0011\tIA\u0005\u0007M\u0005\u0003\u0013N\u0011a\u0001V;qY\u0016\u0014\u0004CA&P\u001b\u0005a%BA'O\u0003\r!\u0018m\u001a\u0006\u0002\u0019%\u0011\u0001\u000b\u0014\u0002\u0007)\u0006<7+\u001a;\u0002\u0013A|w\u000e\u001c+bON\u0004\u0013!\u00028pI\u0016\u001cX#\u0001+\u0011\t\u0001+u)\u0016\t\u0004-n\u0003dBA,Z\u001d\t\u0019\u0004,C\u0001\u0015\u0013\tQ6#A\u0004qC\u000e\\\u0017mZ3\n\u0005qk&A\u0002,fGR|'O\u0003\u0002['\u00051an\u001c3fg\u0002\naB\\8eKN+G/\u00169eCR,G\rF\u0003$C\n\u001cW\u000eC\u00030\u000f\u0001\u0007\u0001\u0007C\u0003=\u000f\u0001\u0007\u0001\u0007C\u0003e\u000f\u0001\u0007Q-\u0001\u0005qe\u00164\u0018n\\;t!\t17.D\u0001h\u0015\tA\u0017.A\u0004o_\u0012,7/\u001a;\u000b\u0005)l\u0011\u0001B2pe\u0016L!\u0001\\4\u0003\u00179{G-Z*fi&sgm\u001c\u0005\u0006]\u001e\u0001\r!Z\u0001\bkB$\u0017\r^3e\u00031\u0001xn\u001c7TQV$Hm\\<o)\r\u0019\u0013O\u001d\u0005\u0006_!\u0001\r\u0001\r\u0005\u0006y!\u0001\r\u0001M\u0001\fiJ\f7-Z+qI\u0006$X\r\u0006\u0003$kZ<\b\"B\u0018\n\u0001\u0004\u0001\u0004\"\u0002\u001f\n\u0001\u0004\u0001\u0004\"\u00028\n\u0001\u0004)\u0007")
public final class ConnectionListener
implements external.reactivemongo.ConnectionListener {
    private final Map<Tuple2<String, String>, TagSet> poolTags;
    private final Map<Tuple2<String, String>, Vector<String>> nodes;
    private Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ConnectionListener connectionListener = this;
        synchronized (connectionListener) {
            if (!this.bitmap$0) {
                this.logger = external.reactivemongo.ConnectionListener.logger$((external.reactivemongo.ConnectionListener)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public void poolCreated(MongoConnectionOptions options, String supervisor, String connection) {
        Kamon$.MODULE$.spanBuilder("reactivemongo.pool-created").kind((Span.Kind)Span.Kind$.Internal$.MODULE$).doNotTrackMetrics().tag("name", new StringBuilder(1).append(supervisor).append(".").append(connection).toString()).start().finish();
    }

    private Map<Tuple2<String, String>, TagSet> poolTags() {
        return this.poolTags;
    }

    private Map<Tuple2<String, String>, Vector<String>> nodes() {
        return this.nodes;
    }

    public void nodeSetUpdated(String supervisor, String connection, NodeSetInfo previous, NodeSetInfo updated) {
        String prefix = (String)Option$.MODULE$.option2Iterable(updated.name()).foldLeft((Object)new StringBuilder(1).append(supervisor).append(".").append(connection).toString(), (Function2 & Serializable & scala.Serializable)(p, n) -> new StringBuilder(1).append((String)p).append(".").append((String)n).toString());
        Tuple2 key = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)supervisor), (Object)connection);
        Map<Tuple2<String, String>, TagSet> map = this.poolTags();
        synchronized (map) {
            this.poolTags().put((Object)key, (Object)TagSet$.MODULE$.of("pool", prefix));
        }
        this.traceUpdate(supervisor, connection, updated);
        ConnectionListener.pg$1("awaitingRequests", "Total number of requests awaiting to be processed by MongoDB nodes", prefix).update(BoxesRunTime.unboxToDouble((Object)updated.awaitingRequests().fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$1 -> x$1)));
        ConnectionListener.pg$1("maxAwaitingRequestsPerChannel", "Maximum number of requests that were awaiting to be processed for a single channel (see maxInFlightRequestsPerChannel)", prefix).update(BoxesRunTime.unboxToDouble((Object)updated.maxAwaitingRequestsPerChannel().fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$2 -> x$2)));
        ConnectionListener.pg$1("numberOfNodes", "Number of nodes that are part of the set", prefix).update((double)updated.nodes().size());
        ConnectionListener.pg$1("hasPrimary", "Indicates whether the primary node is known (0 or 1)", prefix).update(updated.primary().isDefined() ? 1.0 : 0.0);
        ConnectionListener.pg$1("hasNearest", "Indicates whether the nearest node is known (0 or 1)", prefix).update(updated.nearest().isDefined() ? 1.0 : 0.0);
        ConnectionListener.pg$1("isMongos", "Indicates whether mongos is used (0 or 1)", prefix).update(updated.mongos().isDefined() ? 1.0 : 0.0);
        ConnectionListener.pg$1("numberOfSecondaries", "Number of secondary nodes in the set", prefix).update((double)updated.secondaries().size());
        Map<Tuple2<String, String>, Vector<String>> map2 = this.nodes();
        synchronized (map2) {
            this.nodes().put((Object)key, updated.nodes().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Vector$.MODULE$.canBuildFrom()));
        }
        updated.nodes().foreach((Function1 & Serializable & scala.Serializable)node -> {
            String tag = new StringBuilder(2).append(supervisor).append(".").append(connection).append(".").append(node.name()).toString();
            ConnectionListener.ng$1(tag, "nodeChannels", "Number of network channels to a same MongoDB node, whatever is the status (see connectedChannels)").update((double)node.connections());
            ConnectionListener.ng$1(tag, "connectedChannels", "Number of connected channels to a same MongoDB node (see nodeChannels)").update((double)node.connected());
            ConnectionListener.ng$1(tag, "authenticatedChannels", "Number of authenticated channels to a same MongoDB node (see connectedChannels)").update((double)node.connected());
            return ((Gauge)Kamon$.MODULE$.gauge("reactivemongo.pingTime", "Response delay (in milliseconds) for the last IsMaster request", MeasurementUnit$.MODULE$.time().milliseconds()).withTag("node", tag)).update((double)node.pingInfo().ping() / 1000.0);
        });
    }

    public void poolShutdown(String supervisor, String connection) {
        Option option;
        Option option2;
        Tuple2 key = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)supervisor), (Object)connection);
        Map<Tuple2<String, String>, TagSet> map = this.poolTags();
        synchronized (map) {
            option2 = this.poolTags().remove((Object)key);
        }
        TagSet pts = (TagSet)option2.getOrElse((Function0 & Serializable & scala.Serializable)() -> TagSet$.MODULE$.Empty());
        ConnectionListener.g$1("awaitingRequests").remove(pts);
        ConnectionListener.g$1("maxAwaitingRequestsPerChannel").remove(pts);
        ConnectionListener.g$1("numberOfNodes").remove(pts);
        ConnectionListener.g$1("hasPrimary").remove(pts);
        ConnectionListener.g$1("hasNearest").remove(pts);
        ConnectionListener.g$1("isMongos").remove(pts);
        ConnectionListener.g$1("numberOfSecondaries").remove(pts);
        Map<Tuple2<String, String>, Vector<String>> map2 = this.nodes();
        synchronized (map2) {
            option = this.nodes().remove((Object)key);
        }
        Vector ns = (Vector)option.getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Vector().empty());
        ns.foreach((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)ConnectionListener.$anonfun$poolShutdown$3(supervisor, connection, node)));
        Kamon$.MODULE$.spanBuilder("reactivemongo.pool-stopped").kind((Span.Kind)Span.Kind$.Internal$.MODULE$).tag("name", new StringBuilder(1).append(supervisor).append(".").append(connection).toString()).start().finish();
    }

    private void traceUpdate(String supervisor, String connection, NodeSetInfo updated) {
        ObjectRef span = ObjectRef.create((Object)Kamon$.MODULE$.spanBuilder("reactivemongo.pool-updated").kind((Span.Kind)Span.Kind$.Internal$.MODULE$).tag("name", new StringBuilder(1).append(supervisor).append(".").append(connection).toString()));
        updated.version().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)v -> {
            span$1.elem = ((SpanBuilder)span$1.elem).tag("version", v);
        });
        Option option = updated.primary();
        if (option instanceof Some) {
            Some some = (Some)option;
            NodeInfo node = (NodeInfo)some.value();
            span.elem = ((SpanBuilder)span.elem).tag("primary", node.name());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            span.elem = ((SpanBuilder)span.elem).tag("primary", "<none>");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Option option2 = updated.mongos();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            NodeInfo node = (NodeInfo)some.value();
            span.elem = ((SpanBuilder)span.elem).tag("mongos", node.name());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            span.elem = ((SpanBuilder)span.elem).tag("mongos", "<none>");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Option option3 = updated.nearest();
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            NodeInfo node = (NodeInfo)some.value();
            span.elem = ((SpanBuilder)span.elem).tag("nearest", node.name());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            span.elem = ((SpanBuilder)span.elem).tag("nearest", "<unknown>");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        span.elem = ((SpanBuilder)span.elem).tag("toString", updated.toString());
        ((SpanBuilder)span.elem).start().finish();
    }

    private static final Gauge pg$1(String property, String description, String prefix$1) {
        return (Gauge)Kamon$.MODULE$.gauge(new StringBuilder(14).append("reactivemongo.").append(property).toString(), description).withTag("pool", prefix$1);
    }

    private static final Gauge ng$1(String tag, String property, String description) {
        return (Gauge)Kamon$.MODULE$.gauge(new StringBuilder(14).append("reactivemongo.").append(property).toString(), description).withTag("node", tag);
    }

    private static final Metric.Gauge g$1(String property) {
        return Kamon$.MODULE$.gauge(new StringBuilder(14).append("reactivemongo.").append(property).toString());
    }

    public static final /* synthetic */ boolean $anonfun$poolShutdown$3(String supervisor$2, String connection$2, String node) {
        String tag = new StringBuilder(2).append(supervisor$2).append(".").append(connection$2).append(".").append(node).toString();
        TagSet nts = TagSet$.MODULE$.of("node", tag);
        ConnectionListener.g$1("nodeChannels").remove(nts);
        ConnectionListener.g$1("connectedChannels").remove(nts);
        ConnectionListener.g$1("authenticatedChannels").remove(nts);
        return ConnectionListener.g$1("pingTime").remove(nts);
    }

    public ConnectionListener() {
        external.reactivemongo.ConnectionListener.$init$((external.reactivemongo.ConnectionListener)this);
        this.poolTags = Map$.MODULE$.empty();
        this.nodes = Map$.MODULE$.empty();
    }
}

