/*
 * Decompiled with CFR 0.152.
 */
package shaded.netty.channel.local;

import java.net.SocketAddress;
import shaded.netty.channel.AbstractChannelSink;
import shaded.netty.channel.Channel;
import shaded.netty.channel.ChannelEvent;
import shaded.netty.channel.ChannelException;
import shaded.netty.channel.ChannelFuture;
import shaded.netty.channel.ChannelPipeline;
import shaded.netty.channel.ChannelState;
import shaded.netty.channel.ChannelStateEvent;
import shaded.netty.channel.Channels;
import shaded.netty.channel.MessageEvent;
import shaded.netty.channel.local.DefaultLocalChannel;
import shaded.netty.channel.local.DefaultLocalServerChannel;
import shaded.netty.channel.local.LocalAddress;
import shaded.netty.channel.local.LocalChannelRegistry;

final class LocalServerChannelSink
extends AbstractChannelSink {
    LocalServerChannelSink() {
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        Channel channel = e.getChannel();
        if (channel instanceof DefaultLocalServerChannel) {
            LocalServerChannelSink.handleServerChannel(e);
        } else if (channel instanceof DefaultLocalChannel) {
            LocalServerChannelSink.handleAcceptedChannel(e);
        }
    }

    private static void handleServerChannel(ChannelEvent e) {
        if (!(e instanceof ChannelStateEvent)) {
            return;
        }
        ChannelStateEvent event = (ChannelStateEvent)e;
        DefaultLocalServerChannel channel = (DefaultLocalServerChannel)event.getChannel();
        ChannelFuture future = event.getFuture();
        ChannelState state = event.getState();
        Object value = event.getValue();
        switch (state) {
            case OPEN: {
                if (!Boolean.FALSE.equals(value)) break;
                LocalServerChannelSink.close(channel, future);
                break;
            }
            case BOUND: {
                if (value != null) {
                    LocalServerChannelSink.bind(channel, future, (LocalAddress)value);
                    break;
                }
                LocalServerChannelSink.close(channel, future);
            }
        }
    }

    private static void handleAcceptedChannel(ChannelEvent e) {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            DefaultLocalChannel channel = (DefaultLocalChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    channel.closeNow(future);
                    break;
                }
                case BOUND: 
                case CONNECTED: {
                    if (value != null) break;
                    channel.closeNow(future);
                    break;
                }
                case INTEREST_OPS: {
                    future.setSuccess();
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            DefaultLocalChannel channel = (DefaultLocalChannel)event.getChannel();
            boolean offered = channel.writeBuffer.offer(event);
            assert (offered);
            channel.flushWriteBuffer();
        }
    }

    private static void bind(DefaultLocalServerChannel channel, ChannelFuture future, LocalAddress localAddress) {
        try {
            if (!LocalChannelRegistry.register(localAddress, channel)) {
                throw new ChannelException("address already in use: " + localAddress);
            }
            if (!channel.bound.compareAndSet(false, true)) {
                throw new ChannelException("already bound");
            }
            channel.localAddress = localAddress;
            future.setSuccess();
            Channels.fireChannelBound(channel, (SocketAddress)localAddress);
        }
        catch (Throwable t) {
            LocalChannelRegistry.unregister(localAddress);
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    private static void close(DefaultLocalServerChannel channel, ChannelFuture future) {
        try {
            if (channel.setClosed()) {
                future.setSuccess();
                LocalAddress localAddress = channel.localAddress;
                if (channel.bound.compareAndSet(true, false)) {
                    channel.localAddress = null;
                    LocalChannelRegistry.unregister(localAddress);
                    Channels.fireChannelUnbound(channel);
                }
                Channels.fireChannelClosed(channel);
            } else {
                future.setSuccess();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }
}

