/*
 * Decompiled with CFR 0.152.
 */
package shaded.netty.channel.socket.oio;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import shaded.netty.channel.ChannelPipeline;
import shaded.netty.channel.socket.ClientSocketChannelFactory;
import shaded.netty.channel.socket.SocketChannel;
import shaded.netty.channel.socket.oio.OioClientSocketChannel;
import shaded.netty.channel.socket.oio.OioClientSocketPipelineSink;
import shaded.netty.util.ThreadNameDeterminer;
import shaded.netty.util.internal.ExecutorUtil;

public class OioClientSocketChannelFactory
implements ClientSocketChannelFactory {
    private final Executor workerExecutor;
    final OioClientSocketPipelineSink sink;
    private boolean shutdownExecutor;

    public OioClientSocketChannelFactory() {
        this(Executors.newCachedThreadPool());
        this.shutdownExecutor = true;
    }

    public OioClientSocketChannelFactory(Executor workerExecutor) {
        this(workerExecutor, null);
    }

    public OioClientSocketChannelFactory(Executor workerExecutor, ThreadNameDeterminer determiner) {
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        this.workerExecutor = workerExecutor;
        this.sink = new OioClientSocketPipelineSink(workerExecutor, determiner);
    }

    public SocketChannel newChannel(ChannelPipeline pipeline) {
        return new OioClientSocketChannel(this, pipeline, this.sink);
    }

    public void shutdown() {
        if (this.shutdownExecutor) {
            ExecutorUtil.shutdownNow(this.workerExecutor);
        }
    }

    public void releaseExternalResources() {
        ExecutorUtil.shutdownNow(this.workerExecutor);
    }
}

