/*
 * Decompiled with CFR 0.152.
 */
package shaded.netty.channel.socket.oio;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.concurrent.Executor;
import shaded.netty.channel.Channel;
import shaded.netty.channel.ChannelEvent;
import shaded.netty.channel.ChannelFuture;
import shaded.netty.channel.ChannelPipeline;
import shaded.netty.channel.ChannelState;
import shaded.netty.channel.ChannelStateEvent;
import shaded.netty.channel.Channels;
import shaded.netty.channel.MessageEvent;
import shaded.netty.channel.socket.oio.AbstractOioChannelSink;
import shaded.netty.channel.socket.oio.AbstractOioWorker;
import shaded.netty.channel.socket.oio.OioAcceptedSocketChannel;
import shaded.netty.channel.socket.oio.OioServerSocketChannel;
import shaded.netty.channel.socket.oio.OioServerSocketChannelFactory;
import shaded.netty.channel.socket.oio.OioSocketChannel;
import shaded.netty.channel.socket.oio.OioWorker;
import shaded.netty.logging.InternalLogger;
import shaded.netty.logging.InternalLoggerFactory;
import shaded.netty.util.ThreadNameDeterminer;
import shaded.netty.util.ThreadRenamingRunnable;
import shaded.netty.util.internal.DeadLockProofWorker;

class OioServerSocketPipelineSink
extends AbstractOioChannelSink {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(OioServerSocketPipelineSink.class);
    final Executor workerExecutor;
    private final ThreadNameDeterminer determiner;

    OioServerSocketPipelineSink(Executor workerExecutor, ThreadNameDeterminer determiner) {
        this.workerExecutor = workerExecutor;
        this.determiner = determiner;
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        Channel channel = e.getChannel();
        if (channel instanceof OioServerSocketChannel) {
            this.handleServerSocket(e);
        } else if (channel instanceof OioAcceptedSocketChannel) {
            OioServerSocketPipelineSink.handleAcceptedSocket(e);
        }
    }

    private void handleServerSocket(ChannelEvent e) {
        if (!(e instanceof ChannelStateEvent)) {
            return;
        }
        ChannelStateEvent event = (ChannelStateEvent)e;
        OioServerSocketChannel channel = (OioServerSocketChannel)event.getChannel();
        ChannelFuture future = event.getFuture();
        ChannelState state = event.getState();
        Object value = event.getValue();
        switch (state) {
            case OPEN: {
                if (!Boolean.FALSE.equals(value)) break;
                OioServerSocketPipelineSink.close(channel, future);
                break;
            }
            case BOUND: {
                if (value != null) {
                    this.bind(channel, future, (SocketAddress)value);
                    break;
                }
                OioServerSocketPipelineSink.close(channel, future);
            }
        }
    }

    private static void handleAcceptedSocket(ChannelEvent e) {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            OioAcceptedSocketChannel channel = (OioAcceptedSocketChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    AbstractOioWorker.close(channel, future);
                    break;
                }
                case BOUND: 
                case CONNECTED: {
                    if (value != null) break;
                    AbstractOioWorker.close(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    AbstractOioWorker.setInterestOps(channel, future, (Integer)value);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            OioSocketChannel channel = (OioSocketChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            Object message = event.getMessage();
            OioWorker.write(channel, future, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void bind(OioServerSocketChannel channel, ChannelFuture future, SocketAddress localAddress) {
        boolean bound = false;
        boolean bossStarted = false;
        try {
            try {
                channel.socket.bind(localAddress, channel.getConfig().getBacklog());
                bound = true;
                future.setSuccess();
                localAddress = channel.getLocalAddress();
                Channels.fireChannelBound(channel, localAddress);
                Executor bossExecutor = ((OioServerSocketChannelFactory)channel.getFactory()).bossExecutor;
                DeadLockProofWorker.start(bossExecutor, new ThreadRenamingRunnable(new Boss(channel), "Old I/O server boss (" + channel + ')', this.determiner));
                return;
            }
            catch (Throwable t) {
                future.setFailure(t);
                Channels.fireExceptionCaught(channel, t);
                Object var8_9 = null;
                if (bossStarted) return;
                if (!bound) return;
                OioServerSocketPipelineSink.close(channel, future);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (bossStarted || !bound) throw throwable;
            OioServerSocketPipelineSink.close(channel, future);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(OioServerSocketChannel channel, ChannelFuture future) {
        boolean bound = channel.isBound();
        try {
            channel.socket.close();
            channel.shutdownLock.lock();
            try {
                if (channel.setClosed()) {
                    future.setSuccess();
                    if (bound) {
                        Channels.fireChannelUnbound(channel);
                    }
                    Channels.fireChannelClosed(channel);
                } else {
                    future.setSuccess();
                }
                Object var4_3 = null;
                channel.shutdownLock.unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                channel.shutdownLock.unlock();
                throw throwable;
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    private final class Boss
    implements Runnable {
        private final OioServerSocketChannel channel;

        Boss(OioServerSocketChannel channel) {
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            this.channel.shutdownLock.lock();
            try {
                while (this.channel.isBound()) {
                    try {
                        Socket acceptedSocket = this.channel.socket.accept();
                        try {
                            ChannelPipeline pipeline = this.channel.getConfig().getPipelineFactory().getPipeline();
                            OioAcceptedSocketChannel acceptedChannel = new OioAcceptedSocketChannel(this.channel, this.channel.getFactory(), pipeline, OioServerSocketPipelineSink.this, acceptedSocket);
                            DeadLockProofWorker.start(OioServerSocketPipelineSink.this.workerExecutor, new ThreadRenamingRunnable(new OioWorker(acceptedChannel), "Old I/O server worker (parentId: " + this.channel.getId() + ", " + this.channel + ')', OioServerSocketPipelineSink.this.determiner));
                        }
                        catch (Exception e) {
                            if (logger.isWarnEnabled()) {
                                logger.warn("Failed to initialize an accepted socket.", e);
                            }
                            try {
                                acceptedSocket.close();
                            }
                            catch (IOException e2) {
                                if (!logger.isWarnEnabled()) continue;
                                logger.warn("Failed to close a partially accepted socket.", e2);
                            }
                        }
                    }
                    catch (SocketTimeoutException e) {
                    }
                    catch (Throwable e) {
                        if (!this.channel.socket.isBound() || this.channel.socket.isClosed()) break;
                        if (logger.isWarnEnabled()) {
                            logger.warn("Failed to accept a connection.", e);
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                Object var5_9 = null;
                this.channel.shutdownLock.unlock();
                return;
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                this.channel.shutdownLock.unlock();
                throw throwable;
            }
        }
    }
}

