/*
 * Decompiled with CFR 0.152.
 */
package shaded.netty.handler.codec.base64;

import shaded.netty.buffer.ChannelBuffer;
import shaded.netty.buffer.ChannelBuffers;
import shaded.netty.channel.Channel;
import shaded.netty.channel.ChannelHandler;
import shaded.netty.channel.ChannelHandlerContext;
import shaded.netty.handler.codec.base64.Base64;
import shaded.netty.handler.codec.base64.Base64Dialect;
import shaded.netty.handler.codec.oneone.OneToOneDecoder;
import shaded.netty.util.CharsetUtil;

@ChannelHandler.Sharable
public class Base64Decoder
extends OneToOneDecoder {
    private final Base64Dialect dialect;

    public Base64Decoder() {
        this(Base64Dialect.STANDARD);
    }

    public Base64Decoder(Base64Dialect dialect) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        this.dialect = dialect;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof String) {
            msg = ChannelBuffers.copiedBuffer((String)msg, CharsetUtil.US_ASCII);
        } else if (!(msg instanceof ChannelBuffer)) {
            return msg;
        }
        ChannelBuffer src = (ChannelBuffer)msg;
        return Base64.decode(src, src.readerIndex(), src.readableBytes(), this.dialect);
    }
}

