/*
 * Decompiled with CFR 0.152.
 */
package shaded.netty.handler.codec.http.websocketx;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import shaded.netty.buffer.ChannelBuffer;
import shaded.netty.buffer.ChannelBuffers;
import shaded.netty.channel.Channel;
import shaded.netty.channel.ChannelFuture;
import shaded.netty.channel.ChannelFutureListener;
import shaded.netty.channel.ChannelHandler;
import shaded.netty.channel.ChannelPipeline;
import shaded.netty.channel.DefaultChannelFuture;
import shaded.netty.handler.codec.http.DefaultHttpRequest;
import shaded.netty.handler.codec.http.HttpMethod;
import shaded.netty.handler.codec.http.HttpRequestEncoder;
import shaded.netty.handler.codec.http.HttpResponse;
import shaded.netty.handler.codec.http.HttpResponseStatus;
import shaded.netty.handler.codec.http.HttpVersion;
import shaded.netty.handler.codec.http.websocketx.WebSocket00FrameDecoder;
import shaded.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder;
import shaded.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import shaded.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import shaded.netty.handler.codec.http.websocketx.WebSocketUtil;
import shaded.netty.handler.codec.http.websocketx.WebSocketVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketClientHandshaker00
extends WebSocketClientHandshaker {
    private ChannelBuffer expectedChallengeResponseBytes;

    public WebSocketClientHandshaker00(URI webSocketURL, WebSocketVersion version, String subprotocol, Map<String, String> customHeaders) {
        this(webSocketURL, version, subprotocol, customHeaders, Long.MAX_VALUE);
    }

    public WebSocketClientHandshaker00(URI webSocketURL, WebSocketVersion version, String subprotocol, Map<String, String> customHeaders, long maxFramePayloadLength) {
        super(webSocketURL, version, subprotocol, customHeaders, maxFramePayloadLength);
    }

    @Override
    public ChannelFuture handshake(Channel channel) {
        int spaces1 = WebSocketUtil.randomNumber(1, 12);
        int spaces2 = WebSocketUtil.randomNumber(1, 12);
        int max1 = Integer.MAX_VALUE / spaces1;
        int max2 = Integer.MAX_VALUE / spaces2;
        int number1 = WebSocketUtil.randomNumber(0, max1);
        int number2 = WebSocketUtil.randomNumber(0, max2);
        int product1 = number1 * spaces1;
        int product2 = number2 * spaces2;
        String key1 = Integer.toString(product1);
        String key2 = Integer.toString(product2);
        key1 = WebSocketClientHandshaker00.insertRandomCharacters(key1);
        key2 = WebSocketClientHandshaker00.insertRandomCharacters(key2);
        key1 = WebSocketClientHandshaker00.insertSpaces(key1, spaces1);
        key2 = WebSocketClientHandshaker00.insertSpaces(key2, spaces2);
        byte[] key3 = WebSocketUtil.randomBytes(8);
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(number1);
        byte[] number1Array = buffer.array();
        buffer = ByteBuffer.allocate(4);
        buffer.putInt(number2);
        byte[] number2Array = buffer.array();
        byte[] challenge = new byte[16];
        System.arraycopy(number1Array, 0, challenge, 0, 4);
        System.arraycopy(number2Array, 0, challenge, 4, 4);
        System.arraycopy(key3, 0, challenge, 8, 8);
        this.expectedChallengeResponseBytes = WebSocketUtil.md5(ChannelBuffers.wrappedBuffer(challenge));
        URI wsURL = this.getWebSocketUrl();
        String path = wsURL.getPath();
        if (wsURL.getQuery() != null && wsURL.getQuery().length() > 0) {
            path = wsURL.getPath() + '?' + wsURL.getQuery();
        }
        if (path == null || path.length() == 0) {
            path = "/";
        }
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, path);
        request.headers().add("Upgrade", "WebSocket");
        request.headers().add("Connection", "Upgrade");
        request.headers().add("Host", wsURL.getHost());
        int wsPort = wsURL.getPort();
        String originValue = "http://" + wsURL.getHost();
        if (wsPort != 80 && wsPort != 443) {
            originValue = originValue + ':' + wsPort;
        }
        request.headers().add("Origin", originValue);
        request.headers().add("Sec-WebSocket-Key1", key1);
        request.headers().add("Sec-WebSocket-Key2", key2);
        String expectedSubprotocol = this.getExpectedSubprotocol();
        if (expectedSubprotocol != null && expectedSubprotocol.length() != 0) {
            request.headers().add("Sec-WebSocket-Protocol", expectedSubprotocol);
        }
        if (this.customHeaders != null) {
            for (Map.Entry e : this.customHeaders.entrySet()) {
                request.headers().add((String)e.getKey(), e.getValue());
            }
        }
        request.headers().set("Content-Length", key3.length);
        request.setContent(ChannelBuffers.copiedBuffer(key3));
        final DefaultChannelFuture handshakeFuture = new DefaultChannelFuture(channel, false);
        ChannelFuture future = channel.write(request);
        future.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                ChannelPipeline p = future.getChannel().getPipeline();
                p.replace(HttpRequestEncoder.class, "ws-encoder", (ChannelHandler)new WebSocket00FrameEncoder());
                if (future.isSuccess()) {
                    handshakeFuture.setSuccess();
                } else {
                    handshakeFuture.setFailure(future.getCause());
                }
            }
        });
        return handshakeFuture;
    }

    @Override
    public void finishHandshake(Channel channel, HttpResponse response) {
        HttpResponseStatus status = new HttpResponseStatus(101, "WebSocket Protocol Handshake");
        if (!response.getStatus().equals(status)) {
            throw new WebSocketHandshakeException("Invalid handshake response status: " + response.getStatus());
        }
        String upgrade = response.headers().get("Upgrade");
        if (!"WebSocket".equals(upgrade)) {
            throw new WebSocketHandshakeException("Invalid handshake response upgrade: " + upgrade);
        }
        String connection = response.headers().get("Connection");
        if (!"Upgrade".equals(connection)) {
            throw new WebSocketHandshakeException("Invalid handshake response connection: " + connection);
        }
        ChannelBuffer challenge = response.getContent();
        if (!challenge.equals(this.expectedChallengeResponseBytes)) {
            throw new WebSocketHandshakeException("Invalid challenge");
        }
        String subprotocol = response.headers().get("Sec-WebSocket-Protocol");
        this.setActualSubprotocol(subprotocol);
        this.setHandshakeComplete();
        WebSocketClientHandshaker00.replaceDecoder(channel, new WebSocket00FrameDecoder(this.getMaxFramePayloadLength()));
    }

    private static String insertRandomCharacters(String key) {
        int count = WebSocketUtil.randomNumber(1, 12);
        char[] randomChars = new char[count];
        int randCount = 0;
        while (randCount < count) {
            int rand = (int)(Math.random() * 126.0 + 33.0);
            if ((33 >= rand || rand >= 47) && (58 >= rand || rand >= 126)) continue;
            randomChars[randCount] = (char)rand;
            ++randCount;
        }
        for (int i = 0; i < count; ++i) {
            int split = WebSocketUtil.randomNumber(0, key.length());
            String part1 = key.substring(0, split);
            String part2 = key.substring(split);
            key = part1 + randomChars[i] + part2;
        }
        return key;
    }

    private static String insertSpaces(String key, int spaces) {
        for (int i = 0; i < spaces; ++i) {
            int split = WebSocketUtil.randomNumber(1, key.length() - 1);
            String part1 = key.substring(0, split);
            String part2 = key.substring(split);
            key = part1 + ' ' + part2;
        }
        return key;
    }
}

