/*
 * Decompiled with CFR 0.152.
 */
package shaded.netty.handler.codec.marshalling;

import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import shaded.netty.buffer.ChannelBuffer;
import shaded.netty.channel.Channel;
import shaded.netty.channel.ChannelHandler;
import shaded.netty.channel.ChannelHandlerContext;
import shaded.netty.handler.codec.marshalling.ChannelBufferByteOutput;
import shaded.netty.handler.codec.marshalling.MarshallerProvider;
import shaded.netty.handler.codec.oneone.OneToOneEncoder;

@ChannelHandler.Sharable
public class MarshallingEncoder
extends OneToOneEncoder {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];
    private final MarshallerProvider provider;
    private final int estimatedLength;

    public MarshallingEncoder(MarshallerProvider provider) {
        this(provider, 512);
    }

    public MarshallingEncoder(MarshallerProvider provider, int estimatedLength) {
        if (estimatedLength < 0) {
            throw new IllegalArgumentException("estimatedLength: " + estimatedLength);
        }
        this.estimatedLength = estimatedLength;
        this.provider = provider;
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        Marshaller marshaller = this.provider.getMarshaller(ctx);
        ChannelBufferByteOutput output = new ChannelBufferByteOutput(ctx.getChannel().getConfig().getBufferFactory(), this.estimatedLength);
        output.getBuffer().writeBytes(LENGTH_PLACEHOLDER);
        marshaller.start((ByteOutput)output);
        marshaller.writeObject(msg);
        marshaller.finish();
        marshaller.close();
        ChannelBuffer encoded = output.getBuffer();
        encoded.setInt(0, encoded.writerIndex() - 4);
        return encoded;
    }
}

