/*
 * Decompiled with CFR 0.152.
 */
package shaded.netty.handler.codec.protobuf;

import java.io.OutputStream;
import shaded.google.protobuf.CodedOutputStream;
import shaded.netty.buffer.ChannelBuffer;
import shaded.netty.buffer.ChannelBufferOutputStream;
import shaded.netty.buffer.ChannelBuffers;
import shaded.netty.channel.Channel;
import shaded.netty.channel.ChannelHandler;
import shaded.netty.channel.ChannelHandlerContext;
import shaded.netty.handler.codec.oneone.OneToOneEncoder;

@ChannelHandler.Sharable
public class ProtobufVarint32LengthFieldPrepender
extends OneToOneEncoder {
    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof ChannelBuffer)) {
            return msg;
        }
        ChannelBuffer body = (ChannelBuffer)msg;
        int length = body.readableBytes();
        ChannelBuffer header = channel.getConfig().getBufferFactory().getBuffer(body.order(), CodedOutputStream.computeRawVarint32Size((int)length));
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance((OutputStream)new ChannelBufferOutputStream(header));
        codedOutputStream.writeRawVarint32(length);
        codedOutputStream.flush();
        return ChannelBuffers.wrappedBuffer(header, body);
    }
}

