/*
 * Decompiled with CFR 0.152.
 */
package shaded.netty.handler.codec.rtsp;

import shaded.netty.buffer.ChannelBuffer;
import shaded.netty.channel.Channel;
import shaded.netty.channel.ChannelHandlerContext;
import shaded.netty.handler.codec.embedder.DecoderEmbedder;
import shaded.netty.handler.codec.http.HttpChunkAggregator;
import shaded.netty.handler.codec.http.HttpMessage;
import shaded.netty.handler.codec.http.HttpMessageDecoder;

public abstract class RtspMessageDecoder
extends HttpMessageDecoder {
    private final DecoderEmbedder<HttpMessage> aggregator;

    protected RtspMessageDecoder() {
        this(4096, 8192, 8192);
    }

    protected RtspMessageDecoder(int maxInitialLineLength, int maxHeaderSize, int maxContentLength) {
        super(maxInitialLineLength, maxHeaderSize, maxContentLength * 2);
        this.aggregator = new DecoderEmbedder(new HttpChunkAggregator(maxContentLength));
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, HttpMessageDecoder.State state) throws Exception {
        Object o = super.decode(ctx, channel, buffer, state);
        if (o != null && this.aggregator.offer(o)) {
            return this.aggregator.poll();
        }
        return null;
    }

    protected boolean isContentAlwaysEmpty(HttpMessage msg) {
        boolean empty = super.isContentAlwaysEmpty(msg);
        if (empty) {
            return true;
        }
        if (!msg.headers().contains("Content-Length")) {
            return true;
        }
        return empty;
    }
}

