/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.core.actors;

import akka.actor.ActorRef;
import akka.actor.package$;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import reactivemongo.api.BSONSerializationPack$;
import reactivemongo.api.ReadPreference$;
import reactivemongo.api.commands.Command$;
import reactivemongo.api.commands.LastError;
import reactivemongo.api.commands.bson.BSONGetLastErrorImplicits$LastErrorReader$;
import reactivemongo.api.commands.bson.BSONIsMasterCommand$;
import reactivemongo.api.commands.bson.BSONIsMasterCommandImplicits$IsMasterWriter$;
import reactivemongo.bson.BSONDocument;
import reactivemongo.bson.BSONReader;
import reactivemongo.bson.BSONValue;
import reactivemongo.bson.BSONValue$;
import reactivemongo.core.actors.AwaitingResponse;
import reactivemongo.core.actors.Closed$;
import reactivemongo.core.actors.ConnectAll$;
import reactivemongo.core.actors.Exceptions$ChannelNotFound$;
import reactivemongo.core.actors.Exceptions$ClosedException$;
import reactivemongo.core.actors.Exceptions$PrimaryUnavailableException$;
import reactivemongo.core.actors.MongoDBSystem;
import reactivemongo.core.actors.MongoDBSystem$;
import reactivemongo.core.actors.PrimaryAvailable;
import reactivemongo.core.actors.PrimaryUnavailable$;
import reactivemongo.core.actors.RefreshAllNodes$;
import reactivemongo.core.actors.SetAvailable;
import reactivemongo.core.commands.CommandError;
import reactivemongo.core.commands.SuccessfulAuthentication;
import reactivemongo.core.nodeset.Authenticate;
import reactivemongo.core.nodeset.Authenticated;
import reactivemongo.core.nodeset.Authenticating;
import reactivemongo.core.nodeset.Authenticating$;
import reactivemongo.core.nodeset.ChannelFactory;
import reactivemongo.core.nodeset.Connection;
import reactivemongo.core.nodeset.ConnectionStatus;
import reactivemongo.core.nodeset.ConnectionStatus$Connected$;
import reactivemongo.core.nodeset.ConnectionStatus$Disconnected$;
import reactivemongo.core.nodeset.Node;
import reactivemongo.core.nodeset.NodeSet;
import reactivemongo.core.nodeset.NodeStatus;
import reactivemongo.core.nodeset.NodeStatus$Primary$;
import reactivemongo.core.nodeset.NodeStatus$Unknown$;
import reactivemongo.core.nodeset.PingInfo;
import reactivemongo.core.nodeset.PingInfo$;
import reactivemongo.core.nodeset.ProtocolMetadata;
import reactivemongo.core.nodeset.QueryableNodeStatus;
import reactivemongo.core.protocol.GetMore;
import reactivemongo.core.protocol.KillCursors;
import reactivemongo.core.protocol.Query;
import reactivemongo.core.protocol.QueryFlags$;
import reactivemongo.core.protocol.Request;
import reactivemongo.core.protocol.RequestMaker;
import reactivemongo.core.protocol.RequestOp;
import reactivemongo.core.protocol.Response;
import reactivemongo.core.protocol.Response$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import shaded.netty.channel.Channel;
import shaded.netty.channel.ChannelFuture;
import shaded.netty.channel.group.ChannelGroupFuture;
import shaded.netty.channel.group.ChannelGroupFutureListener;
import shaded.netty.channel.group.DefaultChannelGroup;

public abstract class MongoDBSystem$class {
    public static final Connection authenticateConnection(MongoDBSystem $this, Connection connection2, Seq auths) {
        Connection connection3;
        block4: {
            while (connection2.authenticating().isEmpty()) {
                Connection connection4;
                Option option = auths.headOption();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Authenticate nextAuth = (Authenticate)some.x();
                    if (connection2.isAuthenticated(nextAuth.db(), nextAuth.user())) {
                        auths = (Seq)auths.tail();
                        continue;
                    }
                    connection4 = $this.sendAuthenticate(connection2, nextAuth);
                } else {
                    connection4 = connection2;
                }
                connection3 = connection4;
                break block4;
            }
            connection3 = connection2;
        }
        return connection3;
    }

    public static final Node reactivemongo$core$actors$MongoDBSystem$$authenticateNode(MongoDBSystem $this, Node node, Seq auths) {
        Vector x$27 = (Vector)node.connections().map((Function1)new Serializable($this, auths){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            private final Seq auths$1;

            public final Connection apply(Connection x0$1) {
                Connection connection2 = x0$1;
                ConnectionStatus connectionStatus = connection2.status();
                ConnectionStatus$Connected$ connectionStatus$Connected$ = ConnectionStatus$Connected$.MODULE$;
                Connection connection3 = !(connectionStatus != null ? !connectionStatus.equals(connectionStatus$Connected$) : connectionStatus$Connected$ != null) ? this.$outer.authenticateConnection(connection2, (Seq<Authenticate>)this.auths$1) : connection2;
                return connection3;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.auths$1 = auths$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
        String x$28 = node.copy$default$1();
        NodeStatus x$29 = node.copy$default$2();
        Set<Authenticated> x$30 = node.copy$default$4();
        Option<BSONDocument> x$31 = node.copy$default$5();
        ProtocolMetadata x$32 = node.copy$default$6();
        PingInfo x$33 = node.copy$default$7();
        boolean x$34 = node.copy$default$8();
        return node.copy(x$28, x$29, (Vector<Connection>)x$27, x$30, x$31, x$32, x$33, x$34);
    }

    public static final NodeSet reactivemongo$core$actors$MongoDBSystem$$authenticateNodeSet(MongoDBSystem $this, NodeSet nodeSet) {
        Vector x$35 = (Vector)nodeSet.nodes().map((Function1)new Serializable($this, nodeSet){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            private final NodeSet nodeSet$1;

            public final Node apply(Node x0$2) {
                Node node = x0$2;
                Node node2 = node != null && node.status() instanceof QueryableNodeStatus ? MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$authenticateNode(this.$outer, node, this.nodeSet$1.authenticates().toSeq()) : node;
                return node2;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.nodeSet$1 = nodeSet$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
        Option<String> x$36 = nodeSet.copy$default$1();
        Option<Object> x$37 = nodeSet.copy$default$2();
        Set<Authenticate> x$38 = nodeSet.copy$default$4();
        return nodeSet.copy(x$36, x$37, (Vector<Node>)x$35, x$38);
    }

    public static Node reactivemongo$core$actors$MongoDBSystem$$unauthenticate(MongoDBSystem $this, Node node, Vector connections) {
        NodeStatus$Unknown$ x$39 = NodeStatus$Unknown$.MODULE$;
        Vector x$40 = connections;
        Set x$41 = connections.isEmpty() ? Predef$.MODULE$.Set().empty() : node.authenticated();
        String x$42 = node.copy$default$1();
        Option<BSONDocument> x$43 = node.copy$default$5();
        ProtocolMetadata x$44 = node.copy$default$6();
        PingInfo x$45 = node.copy$default$7();
        boolean x$46 = node.copy$default$8();
        return node.copy(x$42, x$39, (Vector<Connection>)x$40, (Set<Authenticated>)x$41, x$43, x$44, x$45, x$46);
    }

    public static void reactivemongo$core$actors$MongoDBSystem$$stopWhenDisconnected(MongoDBSystem $this, String state, Object msg) {
        int remainingConnections = BoxesRunTime.unboxToInt((Object)$this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().nodes().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(int open, Node node) {
                return open + node.connections().size();
            }
        }));
        if (MongoDBSystem$.MODULE$.logger().isDebugEnabled()) {
            int disconnected = BoxesRunTime.unboxToInt((Object)$this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().nodes().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final int apply(int open, Node node) {
                    return open + node.connections().count((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Connection x$1) {
                            ConnectionStatus connectionStatus = x$1.status();
                            ConnectionStatus$Disconnected$ connectionStatus$Disconnected$ = ConnectionStatus$Disconnected$.MODULE$;
                            return !(connectionStatus != null ? !connectionStatus.equals(connectionStatus$Disconnected$) : connectionStatus$Disconnected$ != null);
                        }
                    });
                }
            }));
            MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable($this, state, msg, remainingConnections, disconnected){
                public static final long serialVersionUID = 0L;
                private final String state$1;
                private final Object msg$1;
                private final int remainingConnections$1;
                private final int disconnected$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(State: ", ") Received ", " remainingConnections = ", ", disconnected = ", ", connected = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.state$1, this.msg$1, BoxesRunTime.boxToInteger((int)this.remainingConnections$1), BoxesRunTime.boxToInteger((int)this.disconnected$1), BoxesRunTime.boxToInteger((int)(this.remainingConnections$1 - this.disconnected$1))}));
                }
                {
                    this.state$1 = state$1;
                    this.msg$1 = msg$1;
                    this.remainingConnections$1 = remainingConnections$1;
                    this.disconnected$1 = disconnected$1;
                }
            });
        }
        if (remainingConnections == 0) {
            $this.reactivemongo$core$actors$MongoDBSystem$$monitors().foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MongoDBSystem $outer;

                public final void apply(ActorRef x$2) {
                    package$.MODULE$.actorRef2Scala(x$2).$bang((Object)Closed$.MODULE$, this.$outer.self());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            MongoDBSystem$.MODULE$.logger().info((Function0<String>)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MongoDBSystem $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is stopping"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.self()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            $this.context().stop($this.self());
        }
    }

    public static NodeSet updateNodeSetOnDisconnect(MongoDBSystem $this, int channelId) {
        return MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet($this, $this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().updateNodeByChannelId(channelId, (Function1<Node, Node>)new Serializable($this, channelId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            public final int channelId$4;

            public final Node apply(Node node) {
                Vector connections = (Vector)node.connections().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MongoDBSystem$.anonfun.updateNodeSetOnDisconnect.1 $outer;

                    public final Connection apply(Connection connection2) {
                        Connection connection3;
                        if (BoxesRunTime.equalsNumObject((Number)connection2.channel().getId(), (Object)BoxesRunTime.boxToInteger((int)this.$outer.channelId$4))) {
                            ConnectionStatus$Disconnected$ x$47 = ConnectionStatus$Disconnected$.MODULE$;
                            Channel x$48 = connection2.copy$default$1();
                            Set<Authenticated> x$49 = connection2.copy$default$3();
                            Option<Authenticating> x$50 = connection2.copy$default$4();
                            connection3 = connection2.copy(x$48, x$47, x$49, x$50);
                        } else {
                            connection3 = connection2;
                        }
                        return connection3;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Vector$.MODULE$.canBuildFrom());
                return MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$unauthenticate(this.$outer, node, connections);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.channelId$4 = channelId$4;
            }
        }));
    }

    public static Either reactivemongo$core$actors$MongoDBSystem$$lastError(MongoDBSystem $this, Response response) {
        Try try_;
        block4: {
            Left left;
            block3: {
                block2: {
                    try_ = BSONValue.ExtendedBSONValue$.MODULE$.asTry$extension(BSONValue$.MODULE$.ExtendedBSONValue((BSONValue)Response$.MODULE$.parse(response).next()), (BSONReader)BSONGetLastErrorImplicits$LastErrorReader$.MODULE$);
                    if (!(try_ instanceof Failure)) break block2;
                    Failure failure = (Failure)try_;
                    Throwable err = failure.exception();
                    left = scala.package$.MODULE$.Left().apply((Object)err);
                    break block3;
                }
                if (!(try_ instanceof Success)) break block4;
                Success success = (Success)try_;
                LastError err = (LastError)success.value();
                left = scala.package$.MODULE$.Right().apply((Object)err);
            }
            return left;
        }
        throw new MatchError((Object)try_);
    }

    public static PartialFunction receive(MongoDBSystem $this) {
        return $this.reactivemongo$core$actors$MongoDBSystem$$processing().orElse($this.authReceive()).orElse($this.reactivemongo$core$actors$MongoDBSystem$$fallback());
    }

    public static void onPrimaryUnavailable(MongoDBSystem $this) {
        package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)RefreshAllNodes$.MODULE$, $this.self());
        MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet($this, $this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().updateAll((Function1<Node, Node>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Node apply(Node node) {
                Node node2;
                NodeStatus nodeStatus = node.status();
                NodeStatus$Primary$ nodeStatus$Primary$ = NodeStatus$Primary$.MODULE$;
                if (!(nodeStatus != null ? !nodeStatus.equals(nodeStatus$Primary$) : nodeStatus$Primary$ != null)) {
                    NodeStatus$Unknown$ x$71 = NodeStatus$Unknown$.MODULE$;
                    String x$72 = node.copy$default$1();
                    Vector<Connection> x$73 = node.copy$default$3();
                    Set<Authenticated> x$74 = node.copy$default$4();
                    Option<BSONDocument> x$75 = node.copy$default$5();
                    ProtocolMetadata x$76 = node.copy$default$6();
                    PingInfo x$77 = node.copy$default$7();
                    boolean x$78 = node.copy$default$8();
                    node2 = node.copy(x$72, x$71, x$73, x$74, x$75, x$76, x$77, x$78);
                } else {
                    node2 = node;
                }
                return node2;
            }
        }));
        MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$broadcastMonitors($this, PrimaryUnavailable$.MODULE$);
    }

    public static NodeSet reactivemongo$core$actors$MongoDBSystem$$updateNodeSet(MongoDBSystem $this, NodeSet nodeSet) {
        $this.reactivemongo$core$actors$MongoDBSystem$$nodeSet_$eq(nodeSet);
        return nodeSet;
    }

    private static NodeSet updateAuthenticate(MongoDBSystem $this, int channelId, Authenticate replyTo, Option auth) {
        NodeSet nodeSet;
        NodeSet ns = $this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().updateByChannelId(channelId, (Function1<Connection, Connection>)new Serializable($this, auth){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            private final Option auth$1;

            public final Connection apply(Connection con) {
                Set authed;
                Set x$79 = authed = (Set)this.auth$1.map((Function1)new Serializable(this, con){
                    public static final long serialVersionUID = 0L;
                    private final Connection con$1;

                    public final Set<Authenticated> apply(Authenticated x$18) {
                        return (Set)this.con$1.authenticated().$plus((Object)x$18);
                    }
                    {
                        this.con$1 = con$1;
                    }
                }).getOrElse((Function0)new Serializable(this, con){
                    public static final long serialVersionUID = 0L;
                    private final Connection con$1;

                    public final Set<Authenticated> apply() {
                        return this.con$1.authenticated();
                    }
                    {
                        this.con$1 = con$1;
                    }
                });
                None$ x$80 = None$.MODULE$;
                Channel x$81 = con.copy$default$1();
                ConnectionStatus x$82 = con.copy$default$2();
                return this.$outer.authenticateConnection(con.copy(x$81, x$82, (Set<Authenticated>)x$79, (Option<Authenticating>)x$80), (Seq<Authenticate>)this.$outer.reactivemongo$core$actors$MongoDBSystem$$nodeSet().authenticates().toSeq());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.auth$1 = auth$1;
            }
        }, (Function1<Node, Node>)new Serializable($this, auth){
            public static final long serialVersionUID = 0L;
            private final Option auth$1;

            public final Node apply(Node node) {
                Set x$83 = (Set)this.auth$1.map((Function1)new Serializable(this, node){
                    public static final long serialVersionUID = 0L;
                    private final Node node$5;

                    public final Set<Authenticated> apply(Authenticated x$19) {
                        return (Set)this.node$5.authenticated().$plus((Object)x$19);
                    }
                    {
                        this.node$5 = node$5;
                    }
                }).getOrElse((Function0)new Serializable(this, node){
                    public static final long serialVersionUID = 0L;
                    private final Node node$5;

                    public final Set<Authenticated> apply() {
                        return this.node$5.authenticated();
                    }
                    {
                        this.node$5 = node$5;
                    }
                });
                String x$84 = node.copy$default$1();
                NodeStatus x$85 = node.copy$default$2();
                Vector<Connection> x$86 = node.copy$default$3();
                Option<BSONDocument> x$87 = node.copy$default$5();
                ProtocolMetadata x$88 = node.copy$default$6();
                PingInfo x$89 = node.copy$default$7();
                boolean x$90 = node.copy$default$8();
                return node.copy(x$84, x$85, x$86, (Set<Authenticated>)x$83, x$87, x$88, x$89, x$90);
            }
            {
                this.auth$1 = auth$1;
            }
        });
        if (auth.isDefined()) {
            nodeSet = ns;
        } else {
            Set x$91 = (Set)ns.authenticates().$minus((Object)replyTo);
            Option<String> x$92 = ns.copy$default$1();
            Option<Object> x$93 = ns.copy$default$2();
            Vector<Node> x$94 = ns.copy$default$3();
            nodeSet = ns.copy(x$92, x$93, x$94, (Set<Authenticate>)x$91);
        }
        return nodeSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NodeSet authenticationResponse(MongoDBSystem $this, Response response, Function1 check) {
        NodeSet nodeSet;
        Some some;
        Authenticating a;
        Option<Tuple3<String, String, String>> option;
        Option auth = $this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().pickByChannelId(response.info().channelId()).flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Option<Authenticating> apply(Tuple2<Node, Connection> x$20) {
                return ((Connection)x$20._2()).authenticating();
            }
        });
        Option option2 = auth;
        if (option2 instanceof Some && !(option = Authenticating$.MODULE$.unapply(a = (Authenticating)(some = (Some)option2).x())).isEmpty()) {
            None$ none$;
            String db = (String)((Tuple3)option.get())._1();
            String user = (String)((Tuple3)option.get())._2();
            String pass = (String)((Tuple3)option.get())._3();
            Authenticate originalAuthenticate = new Authenticate(db, user, pass);
            Either either = (Either)check.apply((Object)response);
            if (either instanceof Right) {
                Right right = (Right)either;
                SuccessfulAuthentication successfulAuthentication = (SuccessfulAuthentication)right.b();
                $this.reactivemongo$core$actors$MongoDBSystem$$AuthRequestsManager().handleAuthResult(originalAuthenticate, successfulAuthentication);
                if ($this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().isReachable()) {
                    MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$broadcastMonitors($this, new SetAvailable($this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().protocolMetadata()));
                    MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "The node set is now authenticated";
                        }
                    });
                }
                if ($this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().primary().isDefined()) {
                    MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$broadcastMonitors($this, new PrimaryAvailable($this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().protocolMetadata()));
                    MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "The primary is now authenticated";
                        }
                    });
                }
                none$ = new Some((Object)new Authenticated(db, user));
            } else {
                if (!(either instanceof Left)) throw new MatchError((Object)either);
                Left left = (Left)either;
                CommandError error = (CommandError)left.a();
                $this.reactivemongo$core$actors$MongoDBSystem$$AuthRequestsManager().handleAuthResult(originalAuthenticate, (Throwable)((Object)error));
                none$ = None$.MODULE$;
            }
            None$ authenticated = none$;
            nodeSet = MongoDBSystem$class.updateAuthenticate($this, response.info().channelId(), originalAuthenticate, (Option)authenticated);
            return MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet($this, nodeSet);
        } else {
            MongoDBSystem$.MODULE$.logger().warn((Function0<String>)new Serializable($this, option2){
                public static final long serialVersionUID = 0L;
                private final Option x1$6;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication result: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$6}));
                }
                {
                    this.x1$6 = x1$6;
                }
            });
            nodeSet = $this.reactivemongo$core$actors$MongoDBSystem$$nodeSet();
        }
        return MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet($this, nodeSet);
    }

    private static boolean secondaryOK(MongoDBSystem $this, Request message2) {
        Query query;
        int flags;
        RequestOp requestOp;
        boolean bl;
        return !message2.op().requiresPrimary() && (bl = (requestOp = message2.op()) instanceof Query ? ((flags = (query = (Query)requestOp).flags()) & QueryFlags$.MODULE$.SlaveOk()) != 0 : (requestOp instanceof KillCursors ? true : requestOp instanceof GetMore));
    }

    public static Try reactivemongo$core$actors$MongoDBSystem$$pickChannel(MongoDBSystem $this, Request request) {
        return request.channelIdHint().isDefined() ? (Try)$this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().pickByChannelId(BoxesRunTime.unboxToInt((Object)request.channelIdHint().get())).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Success<Tuple2<Node, Connection>> apply(Tuple2<Node, Connection> x$21) {
                return new Success(x$21);
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Failure<Nothing$> apply() {
                return new Failure((Throwable)Exceptions$ChannelNotFound$.MODULE$);
            }
        }) : (Try)$this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().pick(request.readPreference()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Success<Tuple2<Node, Connection>> apply(Tuple2<Node, Connection> x$22) {
                return new Success(x$22);
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Failure<Nothing$> apply() {
                return new Failure((Throwable)Exceptions$PrimaryUnavailableException$.MODULE$);
            }
        });
    }

    public static NodeSet whenAuthenticating(MongoDBSystem $this, int channelId, Function1 f) {
        return MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet($this, $this.reactivemongo$core$actors$MongoDBSystem$$nodeSet().updateConnectionByChannelId(channelId, (Function1<Connection, Connection>)new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            public final Function1 f$1;

            public final Connection apply(Connection connection2) {
                return (Connection)connection2.authenticating().fold((Function0)new Serializable(this, connection2){
                    public static final long serialVersionUID = 0L;
                    private final Connection connection$3;

                    public final Connection apply() {
                        return this.connection$3;
                    }
                    {
                        this.connection$3 = connection$3;
                    }
                }, (Function1)new Serializable(this, connection2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MongoDBSystem$.anonfun.whenAuthenticating.1 $outer;
                    private final Connection connection$3;

                    public final Connection apply(Authenticating authenticating) {
                        return (Connection)this.$outer.f$1.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.connection$3), (Object)authenticating));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.connection$3 = connection$3;
                    }
                });
            }
            {
                this.f$1 = f$1;
            }
        }));
    }

    public static void postStop(MongoDBSystem $this) {
        $this.reactivemongo$core$actors$MongoDBSystem$$connectAllJob().cancel();
        $this.reactivemongo$core$actors$MongoDBSystem$$refreshAllJob().cancel();
        ChannelGroupFutureListener listener = new ChannelGroupFutureListener($this){
            private final ChannelFactory factory;
            private final ListBuffer<ActorRef> monitorActors;

            public ChannelFactory factory() {
                return this.factory;
            }

            public ListBuffer<ActorRef> monitorActors() {
                return this.monitorActors;
            }

            public void operationComplete(ChannelGroupFuture future) {
                MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Netty says all channels are closed.";
                    }
                });
                this.factory().channelFactory().releaseExternalResources();
            }
            {
                this.factory = $outer.channelFactory();
                this.monitorActors = $outer.reactivemongo$core$actors$MongoDBSystem$$monitors();
            }
        };
        $this.allChannelGroup($this.reactivemongo$core$actors$MongoDBSystem$$nodeSet()).close().addListener(listener);
        $this.reactivemongo$core$actors$MongoDBSystem$$awaitingResponses().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Tuple2<Object, AwaitingResponse> x0$4) {
                AwaitingResponse r;
                Tuple2<Object, AwaitingResponse> tuple2 = x0$4;
                Object object = tuple2 != null && !(r = (AwaitingResponse)tuple2._2()).promise().isCompleted() ? r.promise().failure((Throwable)Exceptions$ClosedException$.MODULE$) : BoxedUnit.UNIT;
                return object;
            }
        });
        $this.reactivemongo$core$actors$MongoDBSystem$$awaitingResponses().empty();
        MongoDBSystem$.MODULE$.logger().warn((Function0<String>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MongoDBSystem ", " stopped."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.self()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static void reactivemongo$core$actors$MongoDBSystem$$broadcastMonitors(MongoDBSystem $this, Object message2) {
        $this.reactivemongo$core$actors$MongoDBSystem$$monitors().foreach((Function1)new Serializable($this, message2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            private final Object message$1;

            public final void apply(ActorRef x$23) {
                package$.MODULE$.actorRef2Scala(x$23).$bang(this.message$1, this.$outer.self());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.message$1 = message$1;
            }
        });
    }

    public static NodeSet reactivemongo$core$actors$MongoDBSystem$$connectAll(MongoDBSystem $this, NodeSet nodeSet) {
        nodeSet.nodes().flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Vector<ChannelFuture> apply(Node node) {
                return (Vector)node.connections().withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Connection connection2) {
                        return !connection2.channel().isConnected();
                    }
                }).map((Function1)new Serializable(this, node){
                    public static final long serialVersionUID = 0L;
                    private final Node node$6;

                    public final ChannelFuture apply(Connection connection2) {
                        return connection2.channel().connect((SocketAddress)new InetSocketAddress(this.node$6.host(), this.node$6.port()));
                    }
                    {
                        this.node$6 = node$6;
                    }
                }, Vector$.MODULE$.canBuildFrom());
            }
        }, Vector$.MODULE$.canBuildFrom());
        return nodeSet;
    }

    public static Node sendIsMaster(MongoDBSystem $this, Node node, int id) {
        return (Node)node.connected().headOption().map((Function1)new Serializable($this, node, id){
            public static final long serialVersionUID = 0L;
            private final Node node$7;
            private final int id$1;

            public final Node apply(Connection channel) {
                Tuple2<RequestMaker, Object> tuple2 = Command$.MODULE$.buildRequestMaker(BSONSerializationPack$.MODULE$, BSONIsMasterCommand$.MODULE$.IsMaster(), BSONIsMasterCommandImplicits$IsMasterWriter$.MODULE$, ReadPreference$.MODULE$.primaryPreferred(), "admin");
                if (tuple2 != null) {
                    Node node;
                    RequestMaker isMaster;
                    RequestMaker requestMaker;
                    RequestMaker isMaster2 = requestMaker = (isMaster = (RequestMaker)tuple2._1());
                    channel.send(isMaster2.apply(this.id$1));
                    if (this.node$7.pingInfo().lastIsMasterId() == -1) {
                        long x$95 = System.currentTimeMillis();
                        int x$96 = this.id$1;
                        long x$97 = this.node$7.pingInfo().copy$default$1();
                        PingInfo x$98 = this.node$7.pingInfo().copy(x$97, x$95, x$96);
                        String x$99 = this.node$7.copy$default$1();
                        NodeStatus x$100 = this.node$7.copy$default$2();
                        Vector<Connection> x$101 = this.node$7.copy$default$3();
                        Set<Authenticated> x$102 = this.node$7.copy$default$4();
                        Option<BSONDocument> x$103 = this.node$7.copy$default$5();
                        ProtocolMetadata x$104 = this.node$7.copy$default$6();
                        boolean x$105 = this.node$7.copy$default$8();
                        node = this.node$7.copy(x$99, x$100, x$101, x$102, x$103, x$104, x$98, x$105);
                    } else if (this.node$7.pingInfo().lastIsMasterId() >= PingInfo$.MODULE$.pingTimeout()) {
                        long x$106 = System.currentTimeMillis();
                        int x$107 = this.id$1;
                        long x$108 = Long.MAX_VALUE;
                        PingInfo x$109 = this.node$7.pingInfo().copy(x$108, x$106, x$107);
                        String x$110 = this.node$7.copy$default$1();
                        NodeStatus x$111 = this.node$7.copy$default$2();
                        Vector<Connection> x$112 = this.node$7.copy$default$3();
                        Set<Authenticated> x$113 = this.node$7.copy$default$4();
                        Option<BSONDocument> x$114 = this.node$7.copy$default$5();
                        ProtocolMetadata x$115 = this.node$7.copy$default$6();
                        boolean x$116 = this.node$7.copy$default$8();
                        node = this.node$7.copy(x$110, x$111, x$112, x$113, x$114, x$115, x$109, x$116);
                    } else {
                        node = this.node$7;
                    }
                    return node;
                }
                throw new MatchError(tuple2);
            }
            {
                this.node$7 = node$7;
                this.id$1 = id$1;
            }
        }).getOrElse((Function0)new Serializable($this, node){
            public static final long serialVersionUID = 0L;
            private final Node node$7;

            public final Node apply() {
                return this.node$7;
            }
            {
                this.node$7 = node$7;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static DefaultChannelGroup allChannelGroup(MongoDBSystem $this, NodeSet nodeSet) {
        void var2_2;
        DefaultChannelGroup result2 = new DefaultChannelGroup();
        nodeSet.nodes().foreach((Function1)new Serializable($this, result2){
            public static final long serialVersionUID = 0L;
            public final DefaultChannelGroup result$1;

            public final void apply(Node node) {
                node.connections().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MongoDBSystem$.anonfun.allChannelGroup.1 $outer;

                    public final boolean apply(Connection connection2) {
                        return this.$outer.result$1.add(connection2.channel());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.result$1 = result$1;
            }
        });
        return var2_2;
    }

    public static void $init$(MongoDBSystem $this) {
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$cFactory_$eq($this.channelFactory());
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$awaitingResponses_$eq((LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$monitors_$eq((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$ec_$eq($this.context().system().dispatcher());
        int ms = $this.options().monitorRefreshMS() / 5;
        FiniteDuration interval = ms < 100 ? new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).milliseconds() : new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt($this.options().monitorRefreshMS())).milliseconds();
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$connectAllJob_$eq($this.context().system().scheduler().schedule(interval, interval, $this.self(), (Object)ConnectAll$.MODULE$, (ExecutionContext)$this.ec(), $this.self()));
        FiniteDuration interval2 = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt($this.options().monitorRefreshMS())).milliseconds();
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$refreshAllJob_$eq($this.context().system().scheduler().schedule(interval2, interval2, $this.self(), (Object)RefreshAllNodes$.MODULE$, (ExecutionContext)$this.ec(), $this.self()));
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$closing_$eq((PartialFunction)new MongoDBSystem$.anonfun.1($this));
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$processing_$eq((PartialFunction)new MongoDBSystem$.anonfun.2($this));
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$fallback_$eq((PartialFunction)new MongoDBSystem$.anonfun.3($this));
        $this.reactivemongo$core$actors$MongoDBSystem$$nodeSet_$eq(new NodeSet((Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Vector<Node>)((TraversableOnce)$this.seeds().map((Function1)new MongoDBSystem$.anonfun.22($this), Seq$.MODULE$.canBuildFrom())).toVector(), (Set<Authenticate>)$this.initialAuthenticates().toSet()));
        MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$connectAll($this, $this.reactivemongo$core$actors$MongoDBSystem$$nodeSet());
        package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)RefreshAllNodes$.MODULE$, $this.self());
    }
}

