/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.core.actors;

import akka.actor.ActorRef;
import akka.actor.package$;
import external.reactivemongo.ConnectionListener;
import external.reactivemongo.ConnectionListener$;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import reactivemongo.api.BSONSerializationPack$;
import reactivemongo.api.ReadPreference$;
import reactivemongo.api.commands.Command$;
import reactivemongo.api.commands.LastError;
import reactivemongo.api.commands.bson.BSONGetLastErrorImplicits$LastErrorReader$;
import reactivemongo.api.commands.bson.BSONIsMasterCommand$;
import reactivemongo.api.commands.bson.BSONIsMasterCommandImplicits$IsMasterWriter$;
import reactivemongo.bson.BSONDocument;
import reactivemongo.bson.BSONReader;
import reactivemongo.bson.BSONValue;
import reactivemongo.bson.BSONValue$;
import reactivemongo.core.actors.AwaitingResponse;
import reactivemongo.core.actors.Closed$;
import reactivemongo.core.actors.ConnectAll$;
import reactivemongo.core.actors.Exceptions;
import reactivemongo.core.actors.MongoDBSystem;
import reactivemongo.core.actors.MongoDBSystem$;
import reactivemongo.core.actors.MongoDBSystem$$anonfun$16$;
import reactivemongo.core.actors.MongoDBSystem$$anonfun$connectAll$1$;
import reactivemongo.core.actors.MongoDBSystem$$anonfun$reactivemongo$core$actors$MongoDBSystem$;
import reactivemongo.core.actors.MongoDBSystem$$anonfun$updateNodeSetOnDisconnect$1$;
import reactivemongo.core.actors.MongoDBSystem$$anonfun$whenAuthenticating$1$;
import reactivemongo.core.actors.PrimaryAvailable;
import reactivemongo.core.actors.PrimaryUnavailable$;
import reactivemongo.core.actors.RefreshAll$;
import reactivemongo.core.actors.RequestId$;
import reactivemongo.core.actors.SetAvailable;
import reactivemongo.core.commands.CommandError;
import reactivemongo.core.commands.SuccessfulAuthentication;
import reactivemongo.core.errors.GenericDriverException;
import reactivemongo.core.nodeset.Authenticate;
import reactivemongo.core.nodeset.Authenticated;
import reactivemongo.core.nodeset.Authenticating;
import reactivemongo.core.nodeset.Authenticating$;
import reactivemongo.core.nodeset.ChannelFactory;
import reactivemongo.core.nodeset.Connection;
import reactivemongo.core.nodeset.ConnectionStatus;
import reactivemongo.core.nodeset.ConnectionStatus$Connected$;
import reactivemongo.core.nodeset.ConnectionStatus$Disconnected$;
import reactivemongo.core.nodeset.Node;
import reactivemongo.core.nodeset.Node$;
import reactivemongo.core.nodeset.NodeSet;
import reactivemongo.core.nodeset.NodeSetInfo;
import reactivemongo.core.nodeset.NodeStatus;
import reactivemongo.core.nodeset.NodeStatus$Primary$;
import reactivemongo.core.nodeset.NodeStatus$Unknown$;
import reactivemongo.core.nodeset.PingInfo;
import reactivemongo.core.nodeset.PingInfo$;
import reactivemongo.core.nodeset.ProtocolMetadata;
import reactivemongo.core.nodeset.ProtocolMetadata$;
import reactivemongo.core.protocol.GetMore;
import reactivemongo.core.protocol.KillCursors;
import reactivemongo.core.protocol.Query;
import reactivemongo.core.protocol.QueryFlags$;
import reactivemongo.core.protocol.Request;
import reactivemongo.core.protocol.RequestMaker;
import reactivemongo.core.protocol.RequestOp;
import reactivemongo.core.protocol.Response;
import reactivemongo.core.protocol.Response$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Promise;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import shaded.google.common.collect.EvictingQueue;
import shaded.netty.channel.Channel;
import shaded.netty.channel.ChannelFuture;
import shaded.netty.channel.ChannelFutureListener;
import shaded.netty.channel.group.ChannelGroupFuture;
import shaded.netty.channel.group.ChannelGroupFutureListener;
import shaded.netty.channel.group.DefaultChannelGroup;

public abstract class MongoDBSystem$class {
    public static void reactivemongo$core$actors$MongoDBSystem$$updateHistory(MongoDBSystem $this, String event) {
        $this.history().add((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())), (Object)event));
    }

    public static Exceptions.InternalState internalState(MongoDBSystem $this) {
        return new Exceptions.InternalState((StackTraceElement[])Predef$.MODULE$.refArrayOps($this.history().toArray()).foldLeft(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StackTraceElement.class)), (Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final StackTraceElement[] apply(StackTraceElement[] x0$1, Object x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$1, x1$1);
                if (tuple2 != null) {
                    StackTraceElement[] trace = (StackTraceElement[])tuple2._1();
                    Object object = tuple2._2();
                    if (object instanceof Tuple2) {
                        Tuple2 tuple22 = (Tuple2)object;
                        Object time = tuple22._1();
                        Object event = tuple22._2();
                        StackTraceElement stackTraceElement = new StackTraceElement("reactivemongo", (String)event, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<time:", ">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{time})), -1);
                        StackTraceElement[] stackTraceElementArray = (StackTraceElement[])Predef$.MODULE$.refArrayOps((Object[])trace).$plus$colon((Object)stackTraceElement, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StackTraceElement.class)));
                        return stackTraceElementArray;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        }));
    }

    public static NodeSet getNodeSet(MongoDBSystem $this) {
        return $this.reactivemongo$core$actors$MongoDBSystem$$_nodeSet();
    }

    /*
     * WARNING - void declaration
     */
    public static NodeSet reactivemongo$core$actors$MongoDBSystem$$initNodeSet(MongoDBSystem $this) {
        void var1_1;
        NodeSet ns = new NodeSet((Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Vector<Node>)((TraversableOnce)$this.seeds().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;

            public final Node apply(String seed) {
                return new Node(seed, NodeStatus$Unknown$.MODULE$, (Vector<Connection>)scala.package$.MODULE$.Vector().empty(), (Set<Authenticated>)Predef$.MODULE$.Set().empty(), (Option<BSONDocument>)None$.MODULE$, ProtocolMetadata$.MODULE$.Default(), Node$.MODULE$.apply$default$7(), Node$.MODULE$.apply$default$8()).createNeededChannels(this.$outer.reactivemongo$core$actors$MongoDBSystem$$channelFactory(), this.$outer.self(), 1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toVector(), (Set<Authenticate>)$this.initialAuthenticates().toSet());
        $this.reactivemongo$core$actors$MongoDBSystem$$_nodeSet_$eq(ns);
        $this.reactivemongo$core$actors$MongoDBSystem$$_setInfo_$eq(ns.info());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static NodeSet reactivemongo$core$actors$MongoDBSystem$$close(MongoDBSystem $this) {
        void var2_2;
        MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Closing MongoDBSystem"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reactivemongo$core$actors$MongoDBSystem$$lnm()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        $this.reactivemongo$core$actors$MongoDBSystem$$connectAllJob().cancel();
        $this.reactivemongo$core$actors$MongoDBSystem$$refreshAllJob().cancel();
        ChannelGroupFutureListener listener = new ChannelGroupFutureListener($this){
            private final ChannelFactory factory;
            private final /* synthetic */ MongoDBSystem $outer;

            public ChannelFactory factory() {
                return this.factory;
            }

            public void operationComplete(ChannelGroupFuture future) {
                MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MongoDBSystem$.anon.1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Netty says all channels are closed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reactivemongo$core$actors$MongoDBSystem$$anon$$$outer().reactivemongo$core$actors$MongoDBSystem$$lnm()}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                try {
                    this.factory().channelFactory().releaseExternalResources();
                }
                catch (Throwable throwable) {
                    MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ MongoDBSystem$.anon.1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Fails to release channel resources"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reactivemongo$core$actors$MongoDBSystem$$anon$$$outer().reactivemongo$core$actors$MongoDBSystem$$lnm()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable err$1;

                        public final Throwable apply() {
                            return this.err$1;
                        }
                        {
                            this.err$1 = err$1;
                        }
                    });
                }
            }

            public /* synthetic */ MongoDBSystem reactivemongo$core$actors$MongoDBSystem$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.factory = $outer.reactivemongo$core$actors$MongoDBSystem$$channelFactory();
            }
        };
        NodeSet ns = MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet($this, "Close", (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final NodeSet apply(NodeSet x$5) {
                return x$5.updateAll((Function1<Node, Node>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Node apply(Node node) {
                        Vector<Connection> x$46 = node.connected();
                        String x$47 = node._copy$default$1();
                        NodeStatus x$48 = node._copy$default$2();
                        Set<Authenticated> x$49 = node._copy$default$4();
                        Option<BSONDocument> x$50 = node._copy$default$5();
                        ProtocolMetadata x$51 = node._copy$default$6();
                        PingInfo x$52 = node._copy$default$7();
                        boolean x$53 = node._copy$default$8();
                        Set<String> x$54 = node._copy$default$9();
                        return node._copy(x$47, x$48, x$46, x$49, x$50, x$51, x$52, x$53, x$54);
                    }
                });
            }
        });
        $this.allChannelGroup(ns).close().addListener(listener);
        Exceptions.InternalState istate = $this.internalState();
        $this.reactivemongo$core$actors$MongoDBSystem$$awaitingResponses().foreach((Function1)new Serializable($this, istate){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            private final Exceptions.InternalState istate$1;

            public final Object apply(Tuple2<Object, AwaitingResponse> x0$2) {
                AwaitingResponse r;
                Tuple2<Object, AwaitingResponse> tuple2 = x0$2;
                Object object = tuple2 != null && !(r = (AwaitingResponse)tuple2._2()).promise().isCompleted() ? r.promise().failure((Throwable)new Exceptions.ClosedException(this.$outer.supervisor(), this.$outer.name(), this.istate$1)) : BoxedUnit.UNIT;
                return object;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.istate$1 = istate$1;
            }
        });
        $this.reactivemongo$core$actors$MongoDBSystem$$awaitingResponses().clear();
        return var2_2;
    }

    public static void preStart(MongoDBSystem $this) {
        MongoDBSystem$.MODULE$.logger().info((Function0<String>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Starting the MongoDBSystem ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reactivemongo$core$actors$MongoDBSystem$$lnm(), this.$outer.self().path()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        FiniteDuration refreshInterval = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt($this.options().monitorRefreshMS())).milliseconds();
        int ms = $this.options().monitorRefreshMS() / 5;
        FiniteDuration interval = ms < 100 ? new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).milliseconds() : refreshInterval;
        $this.reactivemongo$core$actors$MongoDBSystem$$connectAllJob_$eq($this.context().system().scheduler().schedule(interval, interval, $this.self(), (Object)ConnectAll$.MODULE$, (ExecutionContext)$this.ec(), $this.self()));
        $this.reactivemongo$core$actors$MongoDBSystem$$refreshAllJob_$eq($this.context().system().scheduler().schedule(refreshInterval, refreshInterval, $this.self(), (Object)RefreshAll$.MODULE$, (ExecutionContext)$this.ec(), $this.self()));
        $this.connectAll($this.reactivemongo$core$actors$MongoDBSystem$$_nodeSet(), (Function2<Node, ChannelFuture, ChannelFuture>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;

            public final ChannelFuture apply(Node node, ChannelFuture chan) {
                chan.addListener(new ChannelFutureListener(this, node){
                    private final /* synthetic */ MongoDBSystem$.anonfun.preStart.2 $outer;
                    private final Node node$1;

                    public void operationComplete(ChannelFuture chan) {
                        this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().sendIsMaster(this.node$1, RequestId$.MODULE$.isMaster().next());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.node$1 = node$1;
                    }
                });
                return chan;
            }

            public /* synthetic */ MongoDBSystem reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static void preRestart(MongoDBSystem $this, Throwable reason, Option message2) {
        String details = (String)message2.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object m) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{m}));
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Restarting the MongoDBSystem ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.self().path(), details}));
        MongoDBSystem$.MODULE$.logger().info((Function0<String>)new Serializable($this, msg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            private final String msg$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reactivemongo$core$actors$MongoDBSystem$$lnm(), this.msg$1}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.msg$1 = msg$1;
            }
        }, (Function0<Throwable>)new Serializable($this, reason){
            public static final long serialVersionUID = 0L;
            private final Throwable reason$1;

            public final Throwable apply() {
                return this.reason$1;
            }
            {
                this.reason$1 = reason$1;
            }
        });
        $this.reactivemongo$core$actors$MongoDBSystem$$super$preRestart(reason, (Option<Object>)message2);
    }

    public static void postStop(MongoDBSystem $this) {
        MongoDBSystem$.MODULE$.logger().info((Function0<String>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Stopping the MongoDBSystem ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reactivemongo$core$actors$MongoDBSystem$$lnm(), this.$outer.self().path()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$close($this);
    }

    public static void postRestart(MongoDBSystem $this, Throwable reason) {
        MongoDBSystem$.MODULE$.logger().info((Function0<String>)new Serializable($this, reason){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            private final Throwable reason$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] The MongoDBSystem is restarted ", " (cause: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reactivemongo$core$actors$MongoDBSystem$$lnm(), this.$outer.self().path(), this.reason$2}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.reason$2 = reason$2;
            }
        });
        $this.reactivemongo$core$actors$MongoDBSystem$$channelFactory_$eq($this.newChannelFactory(BoxedUnit.UNIT));
        MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet($this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Restart(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.reactivemongo$core$actors$MongoDBSystem$$_nodeSet()})), (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;

            public final NodeSet apply(NodeSet x$6) {
                return MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$initNodeSet(this.$outer);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        $this.reactivemongo$core$actors$MongoDBSystem$$super$postRestart(reason);
    }

    public static final Connection authenticateConnection(MongoDBSystem $this, Connection connection2, Seq auths) {
        Connection connection3;
        block4: {
            while (connection2.authenticating().isEmpty()) {
                Connection connection4;
                Option option = auths.headOption();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Authenticate nextAuth = (Authenticate)some.x();
                    if (connection2.isAuthenticated(nextAuth.db(), nextAuth.user())) {
                        auths = (Seq)auths.tail();
                        continue;
                    }
                    connection4 = $this.sendAuthenticate(connection2, nextAuth);
                } else {
                    connection4 = connection2;
                }
                connection3 = connection4;
                break block4;
            }
            connection3 = connection2;
        }
        return connection3;
    }

    public static final Node reactivemongo$core$actors$MongoDBSystem$$authenticateNode(MongoDBSystem $this, Node node, Seq auths) {
        Vector x$55 = (Vector)node.connections().map((Function1)new Serializable($this, auths){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            private final Seq auths$1;

            public final Connection apply(Connection x0$3) {
                Connection connection2 = x0$3;
                ConnectionStatus connectionStatus = connection2.status();
                ConnectionStatus$Connected$ connectionStatus$Connected$ = ConnectionStatus$Connected$.MODULE$;
                Connection connection3 = !(connectionStatus != null ? !connectionStatus.equals(connectionStatus$Connected$) : connectionStatus$Connected$ != null) ? this.$outer.authenticateConnection(connection2, (Seq<Authenticate>)this.auths$1) : connection2;
                return connection3;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.auths$1 = auths$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
        String x$56 = node._copy$default$1();
        NodeStatus x$57 = node._copy$default$2();
        Set<Authenticated> x$58 = node._copy$default$4();
        Option<BSONDocument> x$59 = node._copy$default$5();
        ProtocolMetadata x$60 = node._copy$default$6();
        PingInfo x$61 = node._copy$default$7();
        boolean x$62 = node._copy$default$8();
        Set<String> x$63 = node._copy$default$9();
        return node._copy(x$56, x$57, (Vector<Connection>)x$55, x$58, x$59, x$60, x$61, x$62, x$63);
    }

    public static final NodeSet reactivemongo$core$actors$MongoDBSystem$$authenticateNodeSet(MongoDBSystem $this, NodeSet nodeSet) {
        return nodeSet.updateAll((Function1<Node, Node>)new Serializable($this, nodeSet){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            private final NodeSet nodeSet$1;

            public final Node apply(Node x0$4) {
                NodeStatus status2;
                Node node = x0$4;
                Node node2 = node != null && (status2 = node.status()).queryable() ? MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$authenticateNode(this.$outer, node, this.nodeSet$1.authenticates().toSeq()) : node;
                return node2;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.nodeSet$1 = nodeSet$1;
            }
        });
    }

    public static Node reactivemongo$core$actors$MongoDBSystem$$collectConnections(MongoDBSystem $this, Node node, PartialFunction collector) {
        Node node2;
        Vector connections = (Vector)node.connections().collect(collector, Vector$.MODULE$.canBuildFrom());
        if (connections.isEmpty()) {
            MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MongoDBSystem $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] No longer connected node; Fallback to Unknown status"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reactivemongo$core$actors$MongoDBSystem$$lnm()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            NodeStatus$Unknown$ x$64 = NodeStatus$Unknown$.MODULE$;
            Vector x$65 = scala.package$.MODULE$.Vector().empty();
            Set x$66 = Predef$.MODULE$.Set().empty();
            String x$67 = node._copy$default$1();
            Option<BSONDocument> x$68 = node._copy$default$5();
            ProtocolMetadata x$69 = node._copy$default$6();
            PingInfo x$70 = node._copy$default$7();
            boolean x$71 = node._copy$default$8();
            Set<String> x$72 = node._copy$default$9();
            node2 = node._copy(x$67, x$64, (Vector<Connection>)x$65, (Set<Authenticated>)x$66, x$68, x$69, x$70, x$71, x$72);
        } else {
            Vector x$73 = connections;
            String x$74 = node._copy$default$1();
            NodeStatus x$75 = node._copy$default$2();
            Set<Authenticated> x$76 = node._copy$default$4();
            Option<BSONDocument> x$77 = node._copy$default$5();
            ProtocolMetadata x$78 = node._copy$default$6();
            PingInfo x$79 = node._copy$default$7();
            boolean x$80 = node._copy$default$8();
            Set<String> x$81 = node._copy$default$9();
            node2 = node._copy(x$74, x$75, (Vector<Connection>)x$73, x$76, x$77, x$78, x$79, x$80, x$81);
        }
        return node2;
    }

    public static void reactivemongo$core$actors$MongoDBSystem$$stopWhenDisconnected(MongoDBSystem $this, String state, Object msg) {
        int remainingConnections = BoxesRunTime.unboxToInt((Object)$this.reactivemongo$core$actors$MongoDBSystem$$_nodeSet().nodes().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$7, Node x$8) {
                return x$7 + x$8.connected().size();
            }
        }));
        if (MongoDBSystem$.MODULE$.logger().isDebugEnabled()) {
            int disconnected = BoxesRunTime.unboxToInt((Object)$this.reactivemongo$core$actors$MongoDBSystem$$_nodeSet().nodes().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final int apply(int open, Node node) {
                    return open + node.connections().count((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Connection x$9) {
                            ConnectionStatus connectionStatus = x$9.status();
                            ConnectionStatus$Disconnected$ connectionStatus$Disconnected$ = ConnectionStatus$Disconnected$.MODULE$;
                            return !(connectionStatus != null ? !connectionStatus.equals(connectionStatus$Disconnected$) : connectionStatus$Disconnected$ != null);
                        }
                    });
                }
            }));
            MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable($this, state, msg, remainingConnections, disconnected){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MongoDBSystem $outer;
                private final String state$1;
                private final Object msg$2;
                private final int remainingConnections$1;
                private final int disconnected$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "$", "] Received ", " remainingConnections = ", ", disconnected = ", ", connected = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reactivemongo$core$actors$MongoDBSystem$$lnm(), this.state$1, this.msg$2, BoxesRunTime.boxToInteger((int)this.remainingConnections$1), BoxesRunTime.boxToInteger((int)this.disconnected$1), BoxesRunTime.boxToInteger((int)(this.remainingConnections$1 - this.disconnected$1))}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.state$1 = state$1;
                    this.msg$2 = msg$2;
                    this.remainingConnections$1 = remainingConnections$1;
                    this.disconnected$1 = disconnected$1;
                }
            });
        }
        if (remainingConnections == 0) {
            $this.reactivemongo$core$actors$MongoDBSystem$$monitors().foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MongoDBSystem $outer;

                public final void apply(ActorRef x$10) {
                    package$.MODULE$.actorRef2Scala(x$10).$bang((Object)Closed$.MODULE$, this.$outer.self());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MongoDBSystem $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Stopping ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reactivemongo$core$actors$MongoDBSystem$$lnm(), this.$outer.self()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            $this.context().stop($this.self());
        }
    }

    public static NodeSet updateNodeSetOnDisconnect(MongoDBSystem $this, int channelId) {
        return MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet($this, MongoDBSystem$class.event$1($this, channelId), (Function1)new Serializable($this, channelId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            public final int channelId$4;

            public final NodeSet apply(NodeSet x$11) {
                return x$11.updateNodeByChannelId(this.channelId$4, (Function1<Node, Node>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MongoDBSystem$.anonfun.updateNodeSetOnDisconnect.1 $outer;

                    public final Node apply(Node node) {
                        return MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$collectConnections(this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer(), node, (PartialFunction)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ MongoDBSystem$$anonfun$updateNodeSetOnDisconnect$1$.anonfun.apply.10 $outer;

                            public final <A1 extends Connection, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x1;
                                if (BoxesRunTime.equalsNumObject((Number)A1.channel().getId(), (Object)BoxesRunTime.boxToInteger((int)this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$anonfun$$$outer().channelId$4))) {
                                    ConnectionStatus$Disconnected$ x$82 = ConnectionStatus$Disconnected$.MODULE$;
                                    Channel x$83 = A1.copy$default$1();
                                    Set<Authenticated> x$84 = A1.copy$default$3();
                                    Option<Authenticating> x$85 = A1.copy$default$4();
                                    object = A1.copy(x$83, x$82, x$84, x$85);
                                } else {
                                    object = A1;
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Connection x1) {
                                Connection connection2 = x1;
                                boolean bl = BoxesRunTime.equalsNumObject((Number)connection2.channel().getId(), (Object)BoxesRunTime.boxToInteger((int)this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$anonfun$$$outer().channelId$4)) ? true : true;
                                return bl;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ MongoDBSystem$.anonfun.updateNodeSetOnDisconnect.1 reactivemongo$core$actors$MongoDBSystem$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ MongoDBSystem reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.channelId$4 = channelId$4;
            }
        });
    }

    public static Either reactivemongo$core$actors$MongoDBSystem$$lastError(MongoDBSystem $this, Response response) {
        Try try_;
        block4: {
            Left left;
            block3: {
                block2: {
                    try_ = BSONValue.ExtendedBSONValue$.MODULE$.asTry$extension(BSONValue$.MODULE$.ExtendedBSONValue((BSONValue)Response$.MODULE$.parse(response).next()), (BSONReader)BSONGetLastErrorImplicits$LastErrorReader$.MODULE$);
                    if (!(try_ instanceof Failure)) break block2;
                    Failure failure = (Failure)try_;
                    Throwable err = failure.exception();
                    left = scala.package$.MODULE$.Left().apply((Object)err);
                    break block3;
                }
                if (!(try_ instanceof Success)) break block4;
                Success success = (Success)try_;
                LastError err = (LastError)success.value();
                left = scala.package$.MODULE$.Right().apply((Object)err);
            }
            return left;
        }
        throw new MatchError((Object)try_);
    }

    private static int requestRetries(MongoDBSystem $this) {
        return $this.options().failoverStrategy().retries();
    }

    public static void reactivemongo$core$actors$MongoDBSystem$$failureOrLog(MongoDBSystem $this, Promise promise, Throwable cause, Function1 log2) {
        if (promise.isCompleted()) {
            log2.apply((Object)cause);
        } else {
            promise.failure(cause);
        }
    }

    public static Option reactivemongo$core$actors$MongoDBSystem$$retry(MongoDBSystem $this, AwaitingResponse req) {
        Serializable onError = new Serializable($this, req){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            public final AwaitingResponse req$1;

            public final void apply(Throwable x$12) {
                MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$failureOrLog(this.$outer, this.req$1.promise(), x$12, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MongoDBSystem$.anonfun.16 $outer;

                    public final void apply(Throwable cause) {
                        MongoDBSystem$.MODULE$.logger().error((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ MongoDBSystem$$anonfun$16$.anonfun.apply.11 $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Fails to retry '", "' (channel #", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$lnm(), this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$anonfun$$$outer().req$1.request().op(), BoxesRunTime.boxToInteger((int)this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$anonfun$$$outer().req$1.channelID())}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, (Function0<Throwable>)new Serializable(this, cause){
                            public static final long serialVersionUID = 0L;
                            private final Throwable cause$1;

                            public final Throwable apply() {
                                return this.cause$1;
                            }
                            {
                                this.cause$1 = cause$1;
                            }
                        });
                    }

                    public /* synthetic */ MongoDBSystem$.anonfun.16 reactivemongo$core$actors$MongoDBSystem$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ MongoDBSystem reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.req$1 = req$1;
            }
        };
        return req.retriable(MongoDBSystem$class.requestRetries($this)).flatMap((Function1)new Serializable($this, req, (Function1)onError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            public final AwaitingResponse req$1;
            public final Function1 onError$1;

            public final Option<AwaitingResponse> apply(Function1<Object, AwaitingResponse> newReq) {
                return (Option)MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$foldNodeConnection(this.$outer, this.req$1.request(), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MongoDBSystem$$anonfun$reactivemongo$core$actors$MongoDBSystem$.retry.1 $outer;

                    public final None$ apply(Throwable error) {
                        this.$outer.onError$1.apply((Object)error);
                        return None$.MODULE$;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, (Function2)new Serializable(this, newReq){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MongoDBSystem$$anonfun$reactivemongo$core$actors$MongoDBSystem$.retry.1 $outer;
                    private final Function1 newReq$1;

                    public final Some<AwaitingResponse> apply(Node node, Connection con) {
                        int reqId = this.$outer.req$1.requestID();
                        AwaitingResponse awaiting = (AwaitingResponse)this.newReq$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(con.channel().getId())));
                        this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$awaitingResponses().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)reqId)), (Object)awaiting));
                        awaiting.getWriteConcern().fold((Function0)new Serializable(this, con, awaiting){
                            public static final long serialVersionUID = 0L;
                            private final Connection con$1;
                            private final AwaitingResponse awaiting$1;

                            public final ChannelFuture apply() {
                                return this.con$1.send(this.awaiting$1.request());
                            }
                            {
                                this.con$1 = con$1;
                                this.awaiting$1 = awaiting$1;
                            }
                        }, (Function1)new Serializable(this, con, awaiting){
                            public static final long serialVersionUID = 0L;
                            private final Connection con$1;
                            private final AwaitingResponse awaiting$1;

                            public final ChannelFuture apply(Request wc) {
                                return this.con$1.send(this.awaiting$1.request(), wc);
                            }
                            {
                                this.con$1 = con$1;
                                this.awaiting$1 = awaiting$1;
                            }
                        });
                        return new Some((Object)awaiting);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.newReq$1 = newReq$1;
                    }
                });
            }

            public /* synthetic */ MongoDBSystem reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.req$1 = req$1;
                this.onError$1 = onError$1;
            }
        });
    }

    public static PartialFunction receive(MongoDBSystem $this) {
        return $this.reactivemongo$core$actors$MongoDBSystem$$processing().orElse($this.authReceive()).orElse($this.reactivemongo$core$actors$MongoDBSystem$$fallback());
    }

    public static void onPrimaryUnavailable(MongoDBSystem $this) {
        package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)RefreshAll$.MODULE$, $this.self());
        MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet($this, "PrimaryUnavailable", (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final NodeSet apply(NodeSet x$33) {
                return x$33.updateAll((Function1<Node, Node>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Node apply(Node node) {
                        Node node2;
                        NodeStatus nodeStatus = node.status();
                        NodeStatus$Primary$ nodeStatus$Primary$ = NodeStatus$Primary$.MODULE$;
                        if (!(nodeStatus != null ? !nodeStatus.equals(nodeStatus$Primary$) : nodeStatus$Primary$ != null)) {
                            NodeStatus$Unknown$ x$107 = NodeStatus$Unknown$.MODULE$;
                            String x$108 = node._copy$default$1();
                            Vector<Connection> x$109 = node._copy$default$3();
                            Set<Authenticated> x$110 = node._copy$default$4();
                            Option<BSONDocument> x$111 = node._copy$default$5();
                            ProtocolMetadata x$112 = node._copy$default$6();
                            PingInfo x$113 = node._copy$default$7();
                            boolean x$114 = node._copy$default$8();
                            Set<String> x$115 = node._copy$default$9();
                            node2 = node._copy(x$108, x$107, x$109, x$110, x$111, x$112, x$113, x$114, x$115);
                        } else {
                            node2 = node;
                        }
                        return node2;
                    }
                });
            }
        });
        MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$broadcastMonitors($this, PrimaryUnavailable$.MODULE$);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NodeSet reactivemongo$core$actors$MongoDBSystem$$updateNodeSet(MongoDBSystem $this, String event, Function1 f) {
        NodeSetInfo previous = null;
        NodeSet updated = null;
        Object object = $this.reactivemongo$core$actors$MongoDBSystem$$nodeSetLock();
        synchronized (object) {
            previous = $this.reactivemongo$core$actors$MongoDBSystem$$_setInfo();
            updated = (NodeSet)f.apply((Object)$this.reactivemongo$core$actors$MongoDBSystem$$_nodeSet());
            $this.reactivemongo$core$actors$MongoDBSystem$$_nodeSet_$eq(updated);
        }
        $this.reactivemongo$core$actors$MongoDBSystem$$nodeSetUpdated().apply((Object)event, (Object)previous, (Object)updated);
        return updated;
    }

    public static NodeSet reactivemongo$core$actors$MongoDBSystem$$updateAuthenticate(MongoDBSystem $this, NodeSet nodeSet, int channelId, Authenticate replyTo, Option auth) {
        NodeSet nodeSet2;
        NodeSet ns = nodeSet.updateByChannelId(channelId, (Function1<Connection, Connection>)new Serializable($this, nodeSet, auth){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            private final NodeSet nodeSet$3;
            private final Option auth$1;

            public final Connection apply(Connection con) {
                Set authed;
                Set x$116 = authed = (Set)this.auth$1.map((Function1)new Serializable(this, con){
                    public static final long serialVersionUID = 0L;
                    private final Connection con$2;

                    public final Set<Authenticated> apply(Authenticated x$34) {
                        return (Set)this.con$2.authenticated().$plus((Object)x$34);
                    }
                    {
                        this.con$2 = con$2;
                    }
                }).getOrElse((Function0)new Serializable(this, con){
                    public static final long serialVersionUID = 0L;
                    private final Connection con$2;

                    public final Set<Authenticated> apply() {
                        return this.con$2.authenticated();
                    }
                    {
                        this.con$2 = con$2;
                    }
                });
                None$ x$117 = None$.MODULE$;
                Channel x$118 = con.copy$default$1();
                ConnectionStatus x$119 = con.copy$default$2();
                return this.$outer.authenticateConnection(con.copy(x$118, x$119, (Set<Authenticated>)x$116, (Option<Authenticating>)x$117), (Seq<Authenticate>)this.nodeSet$3.authenticates().toSeq());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.nodeSet$3 = nodeSet$3;
                this.auth$1 = auth$1;
            }
        }, (Function1<Node, Node>)new Serializable($this, auth){
            public static final long serialVersionUID = 0L;
            private final Option auth$1;

            public final Node apply(Node node) {
                Set x$120 = (Set)this.auth$1.map((Function1)new Serializable(this, node){
                    public static final long serialVersionUID = 0L;
                    private final Node node$4;

                    public final Set<Authenticated> apply(Authenticated x$35) {
                        return (Set)this.node$4.authenticated().$plus((Object)x$35);
                    }
                    {
                        this.node$4 = node$4;
                    }
                }).getOrElse((Function0)new Serializable(this, node){
                    public static final long serialVersionUID = 0L;
                    private final Node node$4;

                    public final Set<Authenticated> apply() {
                        return this.node$4.authenticated();
                    }
                    {
                        this.node$4 = node$4;
                    }
                });
                String x$121 = node._copy$default$1();
                NodeStatus x$122 = node._copy$default$2();
                Vector<Connection> x$123 = node._copy$default$3();
                Option<BSONDocument> x$124 = node._copy$default$5();
                ProtocolMetadata x$125 = node._copy$default$6();
                PingInfo x$126 = node._copy$default$7();
                boolean x$127 = node._copy$default$8();
                Set<String> x$128 = node._copy$default$9();
                return node._copy(x$121, x$122, x$123, (Set<Authenticated>)x$120, x$124, x$125, x$126, x$127, x$128);
            }
            {
                this.auth$1 = auth$1;
            }
        });
        if (auth.isDefined()) {
            nodeSet2 = ns;
        } else {
            Set x$129 = (Set)ns.authenticates().$minus((Object)replyTo);
            Option<String> x$130 = ns.copy$default$1();
            Option<Object> x$131 = ns.copy$default$2();
            Vector<Node> x$132 = ns.copy$default$3();
            nodeSet2 = ns.copy(x$130, x$131, x$132, (Set<Authenticate>)x$129);
        }
        return nodeSet2;
    }

    public static NodeSet authenticationResponse(MongoDBSystem $this, Response response, Function1 check) {
        return MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet($this, MongoDBSystem$class.event$5($this, response), (Function1)new Serializable($this, response, check){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            private final Response response$2;
            private final Function1 check$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final NodeSet apply(NodeSet nodeSet) {
                Some some;
                Authenticating authenticating;
                Option<Tuple3<String, String, String>> option;
                Option auth = nodeSet.pickByChannelId(this.response$2.info().channelId()).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<Authenticating> apply(Tuple2<Node, Connection> x$36) {
                        return ((Connection)x$36._2()).authenticating();
                    }
                });
                Option option2 = auth;
                if (option2 instanceof Some && !(option = Authenticating$.MODULE$.unapply(authenticating = (Authenticating)(some = (Some)option2).x())).isEmpty()) {
                    None$ none$;
                    String db = (String)((Tuple3)option.get())._1();
                    String user = (String)((Tuple3)option.get())._2();
                    String pass = (String)((Tuple3)option.get())._3();
                    Authenticate originalAuthenticate = new Authenticate(db, user, pass);
                    Either either = (Either)this.check$1.apply((Object)this.response$2);
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        SuccessfulAuthentication successfulAuthentication = (SuccessfulAuthentication)right.b();
                        this.$outer.reactivemongo$core$actors$MongoDBSystem$$AuthRequestsManager().handleAuthResult(originalAuthenticate, successfulAuthentication);
                        if (nodeSet.isReachable()) {
                            MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$broadcastMonitors(this.$outer, new SetAvailable(nodeSet.protocolMetadata()));
                            MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ MongoDBSystem$.anonfun.authenticationResponse.1 $outer;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] The node set is now authenticated"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$lnm()}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        if (nodeSet.primary().isDefined()) {
                            MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$broadcastMonitors(this.$outer, new PrimaryAvailable(nodeSet.protocolMetadata()));
                            MongoDBSystem$.MODULE$.logger().debug((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ MongoDBSystem$.anonfun.authenticationResponse.1 $outer;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] The primary is now authenticated"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$lnm()}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        } else if (nodeSet.isReachable()) {
                            MongoDBSystem$.MODULE$.logger().warn((Function0<String>)new Serializable(this, nodeSet){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ MongoDBSystem$.anonfun.authenticationResponse.1 $outer;
                                private final NodeSet nodeSet$4;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] The node set is authenticated, but the primary is not available: ", " -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$lnm(), this.nodeSet$4.name(), ((TraversableOnce)this.nodeSet$4.nodes().map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Set<String> apply(Node x$37) {
                                            return x$37.names();
                                        }
                                    }, Vector$.MODULE$.canBuildFrom())).mkString(", ")}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.nodeSet$4 = nodeSet$4;
                                }
                            });
                        }
                        none$ = new Some((Object)new Authenticated(db, user));
                    } else {
                        if (!(either instanceof Left)) throw new MatchError((Object)either);
                        Left left = (Left)either;
                        CommandError error = (CommandError)left.a();
                        this.$outer.reactivemongo$core$actors$MongoDBSystem$$AuthRequestsManager().handleAuthResult(originalAuthenticate, (Throwable)((Object)error));
                        none$ = None$.MODULE$;
                    }
                    None$ authenticated = none$;
                    return MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateAuthenticate(this.$outer, nodeSet, this.response$2.info().channelId(), originalAuthenticate, (Option)authenticated);
                }
                MongoDBSystem$.MODULE$.logger().warn((Function0<String>)new Serializable(this, option2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MongoDBSystem$.anonfun.authenticationResponse.1 $outer;
                    private final Option x1$7;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Authentication result: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$lnm(), this.x1$7}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.x1$7 = x1$7;
                    }
                });
                return nodeSet;
            }

            public /* synthetic */ MongoDBSystem reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.response$2 = response$2;
                this.check$1 = check$1;
            }
        });
    }

    public static boolean reactivemongo$core$actors$MongoDBSystem$$secondaryOK(MongoDBSystem $this, Request message2) {
        Query query;
        int flags;
        RequestOp requestOp;
        boolean bl;
        return !message2.op().requiresPrimary() && (bl = (requestOp = message2.op()) instanceof Query ? ((flags = (query = (Query)requestOp).flags()) & QueryFlags$.MODULE$.SlaveOk()) != 0 : (requestOp instanceof KillCursors ? true : requestOp instanceof GetMore));
    }

    public static String reactivemongo$core$actors$MongoDBSystem$$nodeInfo(MongoDBSystem $this, boolean reqAuth, Node node) {
        String info2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connected:", ", channels:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)node.connected().size()), BoxesRunTime.boxToInteger((int)node.connections().size())}));
        return reqAuth ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"authenticated:", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((SeqLike)node.authenticatedConnections().subject()).size()), info2})) : info2;
    }

    public static Try reactivemongo$core$actors$MongoDBSystem$$pickChannel(MongoDBSystem $this, Request request) {
        Try try_;
        NodeSet ns = $this.reactivemongo$core$actors$MongoDBSystem$$_nodeSet();
        Option<Object> option = request.channelIdHint();
        if (option instanceof Some) {
            Some some = (Some)option;
            int chanId = BoxesRunTime.unboxToInt((Object)some.x());
            try_ = (Try)ns.pickByChannelId(chanId).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Success<Tuple2<Node, Connection>> apply(Tuple2<Node, Connection> x$38) {
                    return new Success(x$38);
                }
            }).getOrElse((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MongoDBSystem $outer;

                public final Failure<Nothing$> apply() {
                    return new Failure((Throwable)new Exceptions.ChannelNotFound(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"#chanId"})).s((Seq)Nil$.MODULE$), false, this.$outer.internalState()));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            try_ = (Try)ns.pick(request.readPreference()).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Success<Tuple2<Node, Connection>> apply(Tuple2<Node, Connection> x$39) {
                    return new Success(x$39);
                }
            }).getOrElse((Function0)new Serializable($this, request, ns){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MongoDBSystem $outer;
                private final Request request$2;
                private final NodeSet ns$1;

                public final Failure<Nothing$> apply() {
                    Exception exception;
                    boolean secOk = MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$secondaryOK(this.$outer, this.request$2);
                    boolean reqAuth = this.ns$1.authenticates().nonEmpty();
                    if (secOk) {
                        if (this.ns$1.isReachable()) {
                            String details = ((TraversableOnce)this.ns$1.nodes().map((Function1)new Serializable(this, reqAuth){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ MongoDBSystem$$anonfun$reactivemongo$core$actors$MongoDBSystem$.pickChannel.4 $outer;
                                private final boolean reqAuth$1;

                                public final String apply(Node node) {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' [", "] { ", " }"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.name(), node.status(), MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$nodeInfo(this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer(), this.reqAuth$1, node)}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.reqAuth$1 = reqAuth$1;
                                }
                            }, Vector$.MODULE$.canBuildFrom())).mkString("; ");
                            exception = new Exceptions.ChannelNotFound(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Channel not found from the nodes: ", " (", "/", "); ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{details, this.$outer.supervisor(), this.$outer.name(), this.$outer.history()})), true, this.$outer.internalState());
                        } else {
                            exception = new Exceptions.NodeSetNotReachable(this.$outer.supervisor(), this.$outer.name(), this.$outer.internalState());
                        }
                    } else {
                        Exception exception2;
                        Option<Node> option = this.ns$1.primary();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Node prim = (Node)some.x();
                            exception2 = new Exceptions.ChannelNotFound(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Channel not found from the primary node: '", "' { ", " } (", "/", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prim.name(), MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$nodeInfo(this.$outer, reqAuth, prim), this.$outer.supervisor(), this.$outer.name()})), true, this.$outer.internalState());
                        } else {
                            exception2 = new Exceptions.PrimaryUnavailableException(this.$outer.supervisor(), this.$outer.name(), this.$outer.internalState());
                        }
                        exception = exception2;
                    }
                    Exceptions.NodeSetNotReachable cause = exception;
                    return new Failure((Throwable)cause);
                }

                public /* synthetic */ MongoDBSystem reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.request$2 = request$2;
                    this.ns$1 = ns$1;
                }
            });
        }
        return try_;
    }

    public static Object reactivemongo$core$actors$MongoDBSystem$$foldNodeConnection(MongoDBSystem $this, Request request, Function1 e, Function2 f) {
        Try try_;
        block4: {
            Object object;
            block3: {
                Success success;
                Tuple2 tuple2;
                block2: {
                    try_ = MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$pickChannel($this, request);
                    if (!(try_ instanceof Failure)) break block2;
                    Failure failure = (Failure)try_;
                    Throwable error = failure.exception();
                    MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable($this, request){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ MongoDBSystem $outer;
                        private final Request request$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] No channel for request: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reactivemongo$core$actors$MongoDBSystem$$lnm(), this.request$1}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.request$1 = request$1;
                        }
                    });
                    object = e.apply((Object)error);
                    break block3;
                }
                if (!(try_ instanceof Success) || (tuple2 = (Tuple2)(success = (Success)try_).value()) == null) break block4;
                Node node = (Node)tuple2._1();
                Connection connection2 = (Connection)tuple2._2();
                MongoDBSystem$.MODULE$.logger().trace((Function0<String>)new Serializable($this, request, node, connection2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MongoDBSystem $outer;
                    private final Request request$1;
                    private final Node node$5;
                    private final Connection connection$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Sending request (", ") expecting response by connection ", " of node ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reactivemongo$core$actors$MongoDBSystem$$lnm(), BoxesRunTime.boxToInteger((int)this.request$1.requestID()), this.connection$1, this.node$5.name(), this.request$1}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.request$1 = request$1;
                        this.node$5 = node$5;
                        this.connection$1 = connection$1;
                    }
                });
                object = f.apply((Object)node, (Object)connection2);
            }
            return object;
        }
        throw new MatchError((Object)try_);
    }

    public static NodeSet whenAuthenticating(MongoDBSystem $this, int channelId, Function1 f) {
        return MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$updateNodeSet($this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authenticating(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)channelId)})), (Function1)new Serializable($this, channelId, f){
            public static final long serialVersionUID = 0L;
            private final int channelId$5;
            public final Function1 f$1;

            public final NodeSet apply(NodeSet x$40) {
                return x$40.updateConnectionByChannelId(this.channelId$5, (Function1<Connection, Connection>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MongoDBSystem$.anonfun.whenAuthenticating.1 $outer;

                    public final Connection apply(Connection connection2) {
                        return (Connection)connection2.authenticating().fold((Function0)new Serializable(this, connection2){
                            public static final long serialVersionUID = 0L;
                            private final Connection connection$2;

                            public final Connection apply() {
                                return this.connection$2;
                            }
                            {
                                this.connection$2 = connection$2;
                            }
                        }, (Function1)new Serializable(this, connection2){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ MongoDBSystem$$anonfun$whenAuthenticating$1$.anonfun.apply.51 $outer;
                            private final Connection connection$2;

                            public final Connection apply(Authenticating authenticating) {
                                return (Connection)this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$anonfun$$$outer().f$1.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.connection$2), (Object)authenticating));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.connection$2 = connection$2;
                            }
                        });
                    }

                    public /* synthetic */ MongoDBSystem$.anonfun.whenAuthenticating.1 reactivemongo$core$actors$MongoDBSystem$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.channelId$5 = channelId$5;
                this.f$1 = f$1;
            }
        });
    }

    public static void reactivemongo$core$actors$MongoDBSystem$$broadcastMonitors(MongoDBSystem $this, Object message2) {
        $this.reactivemongo$core$actors$MongoDBSystem$$monitors().foreach((Function1)new Serializable($this, message2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            private final Object message$1;

            public final void apply(ActorRef x$41) {
                package$.MODULE$.actorRef2Scala(x$41).$bang(this.message$1, this.$outer.self());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.message$1 = message$1;
            }
        });
    }

    public static NodeSet connectAll(MongoDBSystem $this, NodeSet nodeSet, Function2 connected) {
        nodeSet.nodes().flatMap((Function1)new Serializable($this, connected){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MongoDBSystem $outer;
            public final Function2 connected$1;

            public final Vector<Object> apply(Node node) {
                return (Vector)node.connections().withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Connection connection2) {
                        return !connection2.channel().isConnected();
                    }
                }).map((Function1)new Serializable(this, node){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MongoDBSystem$.anonfun.connectAll.1 $outer;
                    public final Node node$6;

                    public final Object apply(Connection connection2) {
                        Object object;
                        try {
                            object = this.$outer.connected$1.apply((Object)this.node$6, (Object)connection2.channel().connect((SocketAddress)new InetSocketAddress(this.node$6.host(), this.node$6.port())));
                        }
                        catch (Throwable throwable) {
                            MongoDBSystem$.MODULE$.logger().warn((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ MongoDBSystem$$anonfun$connectAll$1$.anonfun.apply.55 $outer;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Fails to connect node: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reactivemongo$core$actors$MongoDBSystem$$anonfun$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer().reactivemongo$core$actors$MongoDBSystem$$lnm(), this.$outer.node$6.toShortString()}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }

                    public /* synthetic */ MongoDBSystem$.anonfun.connectAll.1 reactivemongo$core$actors$MongoDBSystem$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.node$6 = node$6;
                    }
                }, Vector$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ MongoDBSystem reactivemongo$core$actors$MongoDBSystem$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.connected$1 = connected$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
        return nodeSet;
    }

    public static Function2 connectAll$default$2(MongoDBSystem $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final ChannelFuture apply(Node x$42, ChannelFuture chan) {
                return chan;
            }
        };
    }

    public static Node sendIsMaster(MongoDBSystem $this, Node node, int id) {
        return (Node)node.connected().headOption().map((Function1)new Serializable($this, node, id){
            public static final long serialVersionUID = 0L;
            private final Node node$7;
            private final int id$1;

            public final Node apply(Connection channel) {
                Tuple2<RequestMaker, Object> tuple2 = Command$.MODULE$.buildRequestMaker(BSONSerializationPack$.MODULE$, BSONIsMasterCommand$.MODULE$.IsMaster(), BSONIsMasterCommandImplicits$IsMasterWriter$.MODULE$, ReadPreference$.MODULE$.primaryPreferred(), "admin");
                if (tuple2 != null) {
                    Node node;
                    RequestMaker isMaster;
                    RequestMaker requestMaker;
                    RequestMaker isMaster2 = requestMaker = (isMaster = (RequestMaker)tuple2._1());
                    channel.send(isMaster2.apply(this.id$1));
                    if (this.node$7.pingInfo().lastIsMasterId() == -1) {
                        long x$133 = System.currentTimeMillis();
                        int x$134 = this.id$1;
                        long x$135 = this.node$7.pingInfo().copy$default$1();
                        PingInfo x$136 = this.node$7.pingInfo().copy(x$135, x$133, x$134);
                        String x$137 = this.node$7._copy$default$1();
                        NodeStatus x$138 = this.node$7._copy$default$2();
                        Vector<Connection> x$139 = this.node$7._copy$default$3();
                        Set<Authenticated> x$140 = this.node$7._copy$default$4();
                        Option<BSONDocument> x$141 = this.node$7._copy$default$5();
                        ProtocolMetadata x$142 = this.node$7._copy$default$6();
                        boolean x$143 = this.node$7._copy$default$8();
                        Set<String> x$144 = this.node$7._copy$default$9();
                        node = this.node$7._copy(x$137, x$138, x$139, x$140, x$141, x$142, x$136, x$143, x$144);
                    } else if (this.node$7.pingInfo().lastIsMasterId() >= PingInfo$.MODULE$.pingTimeout()) {
                        long x$145 = System.currentTimeMillis();
                        int x$146 = this.id$1;
                        long x$147 = Long.MAX_VALUE;
                        PingInfo x$148 = this.node$7.pingInfo().copy(x$147, x$145, x$146);
                        String x$149 = this.node$7._copy$default$1();
                        NodeStatus x$150 = this.node$7._copy$default$2();
                        Vector<Connection> x$151 = this.node$7._copy$default$3();
                        Set<Authenticated> x$152 = this.node$7._copy$default$4();
                        Option<BSONDocument> x$153 = this.node$7._copy$default$5();
                        ProtocolMetadata x$154 = this.node$7._copy$default$6();
                        boolean x$155 = this.node$7._copy$default$8();
                        Set<String> x$156 = this.node$7._copy$default$9();
                        node = this.node$7._copy(x$149, x$150, x$151, x$152, x$153, x$154, x$148, x$155, x$156);
                    } else {
                        node = this.node$7;
                    }
                    return node;
                }
                throw new MatchError(tuple2);
            }
            {
                this.node$7 = node$7;
                this.id$1 = id$1;
            }
        }).getOrElse((Function0)new Serializable($this, node){
            public static final long serialVersionUID = 0L;
            private final Node node$7;

            public final Node apply() {
                return this.node$7;
            }
            {
                this.node$7 = node$7;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static DefaultChannelGroup allChannelGroup(MongoDBSystem $this, NodeSet nodeSet) {
        void var2_2;
        DefaultChannelGroup result2 = new DefaultChannelGroup();
        nodeSet.nodes().foreach((Function1)new Serializable($this, result2){
            public static final long serialVersionUID = 0L;
            public final DefaultChannelGroup result$3;

            public final void apply(Node node) {
                node.connections().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MongoDBSystem$.anonfun.allChannelGroup.1 $outer;

                    public final boolean apply(Connection connection2) {
                        return this.$outer.result$3.add(connection2.channel());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.result$3 = result$3;
            }
        });
        return var2_2;
    }

    private static final String event$1(MongoDBSystem $this, int channelId$4) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ChannelDisconnected(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)channelId$4), $this.reactivemongo$core$actors$MongoDBSystem$$_nodeSet().toShortString()}));
    }

    private static final String event$5(MongoDBSystem $this, Response response$2) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)response$2.info().channelId()), $this.reactivemongo$core$actors$MongoDBSystem$$_nodeSet().toShortString()}));
    }

    /*
     * WARNING - void declaration
     */
    public static void $init$(MongoDBSystem $this) {
        void var1_1;
        $this.reactivemongo$core$actors$MongoDBSystem$$channelFactory_$eq($this.newChannelFactory(BoxedUnit.UNIT));
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$lnm_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.supervisor(), $this.name()})));
        Option<ConnectionListener> cl = ConnectionListener$.MODULE$.apply();
        cl.foreach((Function1)new MongoDBSystem$.anonfun.6($this));
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$listener_$eq((Option)var1_1);
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$awaitingResponses_$eq((LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$monitors_$eq((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$ec_$eq($this.context().system().dispatcher());
        $this.reactivemongo$core$actors$MongoDBSystem$$connectAllJob_$eq($this.reactivemongo$core$actors$MongoDBSystem$$NoJob());
        $this.reactivemongo$core$actors$MongoDBSystem$$refreshAllJob_$eq($this.reactivemongo$core$actors$MongoDBSystem$$NoJob());
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$historyMax_$eq(25);
        $this.history_$eq((EvictingQueue<Tuple2<Object, String>>)EvictingQueue.create((int)$this.reactivemongo$core$actors$MongoDBSystem$$historyMax()));
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$nodeSetUpdated_$eq((Function3)$this.reactivemongo$core$actors$MongoDBSystem$$listener().fold((Function0)new MongoDBSystem$.anonfun.7($this), (Function1)new MongoDBSystem$.anonfun.8($this)));
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$nodeSetLock_$eq(new MongoDBSystem$.anon.3($this));
        $this.reactivemongo$core$actors$MongoDBSystem$$_nodeSet_$eq(null);
        $this.reactivemongo$core$actors$MongoDBSystem$$_setInfo_$eq(null);
        MongoDBSystem$class.reactivemongo$core$actors$MongoDBSystem$$initNodeSet($this);
        $this.reactivemongo$core$actors$MongoDBSystem$$nodeSetUpdated().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Init(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.reactivemongo$core$actors$MongoDBSystem$$_nodeSet().toShortString()})), null, (Object)$this.reactivemongo$core$actors$MongoDBSystem$$_nodeSet());
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$SocketDisconnected_$eq(new GenericDriverException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Socket disconnected (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.reactivemongo$core$actors$MongoDBSystem$$lnm()}))));
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$processing_$eq((PartialFunction)new MongoDBSystem$.anonfun.1($this));
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$closing_$eq((PartialFunction)new MongoDBSystem$.anonfun.2($this));
        $this.reactivemongo$core$actors$MongoDBSystem$_setter_$reactivemongo$core$actors$MongoDBSystem$$fallback_$eq((PartialFunction)new MongoDBSystem$.anonfun.3($this));
    }
}

