/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api;

import akka.actor.ActorRef;
import akka.actor.ActorSystem$;
import akka.actor.Props$;
import akka.pattern.AskableActorRef$;
import akka.pattern.package$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import reactivemongo.api.AuthenticationMode;
import reactivemongo.api.CrAuthentication$;
import reactivemongo.api.Driver;
import reactivemongo.api.Driver$;
import reactivemongo.api.MongoConnection;
import reactivemongo.api.MongoConnectionOptions;
import reactivemongo.api.ScramSha256Authentication$;
import reactivemongo.api.X509Authentication$;
import reactivemongo.core.AsyncSystemControl;
import reactivemongo.core.SystemControl;
import reactivemongo.core.SystemControl$;
import reactivemongo.core.TimedSystemControl;
import reactivemongo.core.actors.Close;
import reactivemongo.core.actors.Close$;
import reactivemongo.core.actors.Exceptions;
import reactivemongo.core.actors.LegacyDBSystem;
import reactivemongo.core.actors.MongoDBSystem;
import reactivemongo.core.actors.StandardDBSystem;
import reactivemongo.core.actors.StandardDBSystemWithScramSha256;
import reactivemongo.core.actors.StandardDBSystemWithX509;
import reactivemongo.core.errors.ConnectionException;
import reactivemongo.core.nodeset.Authenticate;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.AbstractFunction1;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public abstract class Driver$class {
    public static int numConnections(Driver $this) {
        return $this.connectionMonitors().size();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Future askClose(Driver $this, FiniteDuration timeout, ExecutionContext ec) {
        Future future;
        Boolean bl;
        Driver$.MODULE$.reactivemongo$api$Driver$$logger().info((Function0<String>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Driver $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Closing instance of ReactiveMongo driver"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.supervisorName()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        StackTraceElement[] callerSTE = (StackTraceElement[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace()).drop(3)).take(3);
        Function1<Option<FiniteDuration>, Future<BoxedUnit>> function1 = $this.reactivemongo$api$Driver$$systemClose();
        synchronized (function1) {
            Boolean bl2;
            if (Predef$.MODULE$.refArrayOps((Object[])$this.reactivemongo$api$Driver$$closedBy()).isEmpty()) {
                $this.reactivemongo$api$Driver$$closedBy_$eq(callerSTE);
                bl2 = BoxesRunTime.boxToBoolean((boolean)false);
            } else {
                bl2 = BoxesRunTime.boxToBoolean((boolean)true);
            }
            bl = bl2;
        }
        boolean alreadyClosing = BoxesRunTime.unboxToBoolean((Object)bl);
        if (alreadyClosing) {
            Driver$.MODULE$.reactivemongo$api$Driver$$logger().info((Function0<String>)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Driver $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"System already closed: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.supervisorName()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            return future;
        }
        future = AskableActorRef$.MODULE$.$qmark$extension(package$.MODULE$.ask($this.supervisorActor()), (Object)Driver$class.msg$1($this, timeout), new Timeout(timeout)).recover((PartialFunction)new Serializable($this, callerSTE){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Driver $outer;
            private final StackTraceElement[] callerSTE$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                A1.setStackTrace(this.callerSTE$1);
                Driver$.MODULE$.reactivemongo$api$Driver$$logger().warn((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Driver$.anonfun.askClose.1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Fails to close connections within timeout. Continuing closing of ReactiveMongo driver anyway."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reactivemongo$api$Driver$$anonfun$$$outer().supervisorName()}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, (Function0<Throwable>)new Serializable(this, A1){
                    public static final long serialVersionUID = 0L;
                    private final Throwable x1$1;

                    public final Throwable apply() {
                        return this.x1$1;
                    }
                    {
                        this.x1$1 = x1$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }

            public /* synthetic */ Driver reactivemongo$api$Driver$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.callerSTE$1 = callerSTE$1;
            }
        }, ec).flatMap((Function1)new Serializable($this, timeout){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Driver $outer;
            private final FiniteDuration timeout$3;

            public final Future<BoxedUnit> apply(Object x$3) {
                return (Future)this.$outer.reactivemongo$api$Driver$$systemClose().apply((Object)new Some((Object)this.timeout$3));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.timeout$3 = timeout$3;
            }
        }, ec);
        return future;
    }

    public static final Future askConnection(Driver $this, Seq nodes, MongoConnectionOptions options2, Option name) {
        Future future;
        VolatileByteRef bitmap$0 = new VolatileByteRef(0);
        if (nodes.isEmpty()) {
            future = Future$.MODULE$.failed((Throwable)new ConnectionException("No node specified"));
        } else {
            ObjectRef dbsystem$lzy = new ObjectRef(null);
            String nm = (String)name.getOrElse((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Driver $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connection-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.reactivemongo$api$Driver$$connectionCounter().incrementAndGet())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            Seq authentications = ((TraversableOnce)options2.credentials().map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Authenticate apply(Tuple2<String, MongoConnectionOptions.Credential> x0$1) {
                    Tuple2<String, MongoConnectionOptions.Credential> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String db = (String)tuple2._1();
                        MongoConnectionOptions.Credential c = (MongoConnectionOptions.Credential)tuple2._2();
                        Authenticate authenticate2 = new Authenticate(db, c.user(), c.password());
                        return authenticate2;
                    }
                    throw new MatchError(tuple2);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            Option<String> option = options2.appName();
            MongoConnectionOptions mongoConnectionOptions = option instanceof Some ? options2 : options2.withAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.supervisorName(), nm})));
            MongoConnectionOptions opts = mongoConnectionOptions;
            ActorRef mongosystem = $this.system().actorOf(Props$.MODULE$.apply((Function0)new Serializable($this, nm, authentications, opts, dbsystem$lzy, nodes, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Driver $outer;
                private final String nm$1;
                private final Seq authentications$1;
                private final MongoConnectionOptions opts$1;
                private final ObjectRef dbsystem$lzy$1;
                private final Seq nodes$1;
                private final VolatileByteRef bitmap$0$1;

                public final MongoDBSystem apply() {
                    return Driver$class.dbsystem$1(this.$outer, this.nm$1, this.authentications$1, this.opts$1, this.dbsystem$lzy$1, this.nodes$1, this.bitmap$0$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.nm$1 = nm$1;
                    this.authentications$1 = authentications$1;
                    this.opts$1 = opts$1;
                    this.dbsystem$lzy$1 = dbsystem$lzy$1;
                    this.nodes$1 = nodes$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            }, ClassTag$.MODULE$.apply(MongoDBSystem.class)), nm);
            Driver$.MODULE$.reactivemongo$api$Driver$$logger().info((Function0<String>)new Serializable($this, nm){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Driver $outer;
                private final String nm$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Creating connection: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.supervisorName(), this.nm$1}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.nm$1 = nm$1;
                }
            });
            future = Driver$class.connection$1($this, nm, opts, mongosystem, nodes).mapTo(ClassTag$.MODULE$.apply(MongoConnection.class)).map((Function1)new Serializable($this, nm, authentications, opts, dbsystem$lzy, nodes, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Driver $outer;
                public final String nm$1;
                public final Seq authentications$1;
                public final MongoConnectionOptions opts$1;
                public final ObjectRef dbsystem$lzy$1;
                public final Seq nodes$1;
                public final VolatileByteRef bitmap$0$1;

                public final MongoConnection apply(MongoConnection c) {
                    c.history_$eq((Function0<Exceptions.InternalState>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Driver$.anonfun.askConnection.2 $outer;

                        public final Exceptions.InternalState apply() {
                            return Driver$class.dbsystem$1(this.$outer.reactivemongo$api$Driver$$anonfun$$$outer(), this.$outer.nm$1, this.$outer.authentications$1, this.$outer.opts$1, this.$outer.dbsystem$lzy$1, this.$outer.nodes$1, this.$outer.bitmap$0$1).internalState();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    return c;
                }

                public /* synthetic */ Driver reactivemongo$api$Driver$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.nm$1 = nm$1;
                    this.authentications$1 = authentications$1;
                    this.opts$1 = opts$1;
                    this.dbsystem$lzy$1 = dbsystem$lzy$1;
                    this.nodes$1 = nodes$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            }, (ExecutionContext)$this.system().dispatcher());
        }
        return future;
    }

    public static Object addConnectionMsg(Driver $this, String name, Seq nodes, MongoConnectionOptions options2, ActorRef mongosystem) {
        return new Driver.AddConnection($this, name, (Seq<String>)nodes, options2, mongosystem);
    }

    private static final Close msg$1(Driver $this, FiniteDuration timeout$3) {
        return Close$.MODULE$.apply("Driver.askClose", timeout$3);
    }

    private static final MongoDBSystem dbsystem$lzycompute$1(Driver $this, String nm$1, Seq authentications$1, MongoConnectionOptions opts$1, ObjectRef dbsystem$lzy$1, Seq nodes$1, VolatileByteRef bitmap$0$1) {
        Driver driver = $this;
        synchronized (driver) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                MongoDBSystem mongoDBSystem;
                AuthenticationMode authenticationMode = opts$1.authMode();
                CrAuthentication$ crAuthentication$ = CrAuthentication$.MODULE$;
                AuthenticationMode authenticationMode2 = authenticationMode;
                if (!(crAuthentication$ != null ? !crAuthentication$.equals(authenticationMode2) : authenticationMode2 != null)) {
                    mongoDBSystem = new LegacyDBSystem($this.supervisorName(), nm$1, (Seq<String>)nodes$1, (Seq<Authenticate>)authentications$1, opts$1);
                } else {
                    X509Authentication$ x509Authentication$ = X509Authentication$.MODULE$;
                    AuthenticationMode authenticationMode3 = authenticationMode;
                    if (!(x509Authentication$ != null ? !x509Authentication$.equals(authenticationMode3) : authenticationMode3 != null)) {
                        mongoDBSystem = new StandardDBSystemWithX509($this.supervisorName(), nm$1, (Seq<String>)nodes$1, (Seq<Authenticate>)authentications$1, opts$1);
                    } else {
                        ScramSha256Authentication$ scramSha256Authentication$ = ScramSha256Authentication$.MODULE$;
                        AuthenticationMode authenticationMode4 = authenticationMode;
                        mongoDBSystem = !(scramSha256Authentication$ != null ? !scramSha256Authentication$.equals(authenticationMode4) : authenticationMode4 != null) ? new StandardDBSystemWithScramSha256($this.supervisorName(), nm$1, (Seq<String>)nodes$1, (Seq<Authenticate>)authentications$1, opts$1) : new StandardDBSystem($this.supervisorName(), nm$1, (Seq<String>)nodes$1, (Seq<Authenticate>)authentications$1, opts$1);
                    }
                }
                dbsystem$lzy$1.elem = mongoDBSystem;
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (MongoDBSystem)dbsystem$lzy$1.elem;
        }
    }

    public static final MongoDBSystem dbsystem$1(Driver $this, String nm$1, Seq authentications$1, MongoConnectionOptions opts$1, ObjectRef dbsystem$lzy$1, Seq nodes$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? Driver$class.dbsystem$lzycompute$1($this, nm$1, authentications$1, opts$1, dbsystem$lzy$1, nodes$1, bitmap$0$1) : (MongoDBSystem)dbsystem$lzy$1.elem;
    }

    private static final Timeout timeout$1(Driver $this, MongoConnectionOptions opts$1) {
        return opts$1.connectTimeoutMS() > 0 ? Timeout$.MODULE$.apply((long)opts$1.connectTimeoutMS(), TimeUnit.MILLISECONDS) : Timeout$.MODULE$.apply(10000L, TimeUnit.MILLISECONDS);
    }

    private static final Future connection$1(Driver $this, String nm$1, MongoConnectionOptions opts$1, ActorRef mongosystem$1, Seq nodes$1) {
        return AskableActorRef$.MODULE$.$qmark$extension(package$.MODULE$.ask($this.supervisorActor()), (Object)new Driver.AddConnection($this, nm$1, (Seq<String>)nodes$1, opts$1, mongosystem$1), Driver$class.timeout$1($this, opts$1));
    }

    public static void $init$(Driver $this) {
        Try<SystemControl> try_;
        block8: {
            AbstractFunction1 abstractFunction1;
            block6: {
                block7: {
                    SystemControl systemControl;
                    Success success;
                    boolean bl;
                    block5: {
                        Config config;
                        Config reference = (Config)$this.config().getOrElse((Function0)new Driver$.anonfun.2($this));
                        if (reference.hasPath("mongo-async-driver")) {
                            config = reference.getConfig("mongo-async-driver");
                        } else {
                            Driver$.MODULE$.reactivemongo$api$Driver$$logger().info((Function0<String>)new Driver$.anonfun.3($this));
                            config = ConfigFactory.empty();
                        }
                        Config cfg = config;
                        $this.reactivemongo$api$Driver$_setter_$system_$eq(ActorSystem$.MODULE$.apply("reactivemongo", (Option)new Some((Object)cfg), $this.classLoader(), ActorSystem$.MODULE$.apply$default$4()));
                        bl = false;
                        success = null;
                        try_ = SystemControl$.MODULE$.apply($this.system());
                        if (!(try_ instanceof Success)) break block5;
                        bl = true;
                        success = (Success)try_;
                        SystemControl systemControl2 = (SystemControl)success.value();
                        if (!(systemControl2 instanceof TimedSystemControl)) break block5;
                        TimedSystemControl timedSystemControl = (TimedSystemControl)systemControl2;
                        Function1<Option<FiniteDuration>, Try<BoxedUnit>> close2 = timedSystemControl.close();
                        abstractFunction1 = new Driver$.anonfun.4($this, close2);
                        break block6;
                    }
                    if (!bl || !((systemControl = (SystemControl)success.value()) instanceof AsyncSystemControl)) break block7;
                    AsyncSystemControl asyncSystemControl = (AsyncSystemControl)systemControl;
                    Function0<Future<BoxedUnit>> close3 = asyncSystemControl.close();
                    abstractFunction1 = new Driver$.anonfun.5($this, close3);
                    break block6;
                }
                if (!(try_ instanceof Failure)) break block8;
                Failure failure = (Failure)try_;
                Throwable cause = failure.exception();
                abstractFunction1 = new Driver$.anonfun.6($this, cause);
            }
            $this.reactivemongo$api$Driver$_setter_$reactivemongo$api$Driver$$systemClose_$eq((Function1)abstractFunction1);
            $this.reactivemongo$api$Driver$$closedBy_$eq((StackTraceElement[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StackTraceElement.class)));
            $this.reactivemongo$api$Driver$_setter_$supervisorName_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Supervisor-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Driver$.MODULE$.counter().incrementAndGet())})));
            $this.reactivemongo$api$Driver$_setter_$supervisorActor_$eq($this.system().actorOf(Props$.MODULE$.apply((Function0)new Driver$.anonfun.7($this), ClassTag$.MODULE$.apply(Driver.SupervisorActor.class)), $this.supervisorName()));
            $this.reactivemongo$api$Driver$_setter_$connectionMonitors_$eq(Map$.MODULE$.empty());
            $this.reactivemongo$api$Driver$_setter_$reactivemongo$api$Driver$$connectionCounter_$eq(new AtomicLong(0L));
            return;
        }
        throw new MatchError(try_);
    }
}

