/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api;

import akka.actor.ActorRef;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import reactivemongo.api.Failover2$;
import reactivemongo.api.FailoverStrategy;
import reactivemongo.api.MongoConnection;
import reactivemongo.core.actors.Exceptions;
import reactivemongo.core.actors.ExpectingResponse;
import reactivemongo.core.errors.ConnectionException;
import reactivemongo.core.errors.ConnectionNotInitialized;
import reactivemongo.core.errors.DatabaseException;
import reactivemongo.core.protocol.Response;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0007\u000f\u0001MA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003a\u0011!Y\u0007A!A!\u0002\u0017a\u0007\"\u0002:\u0001\t\u0003\u0019\b\"CA\u0003\u0001\t\u0007I\u0011BA\u0004\u0011!\tY\u0002\u0001Q\u0001\n\u0005%\u0001\"CA\u000f\u0001\t\u0007I\u0011AA\u0010\u0011!\t9\u0003\u0001Q\u0001\n\u0005\u0005\u0002bBA\u0015\u0001\u0011%\u00111\u0006\u0005\b\u0003{\u0001A\u0011BA \u0005!1\u0015-\u001b7pm\u0016\u0014(BA\b\u0011\u0003\r\t\u0007/\u001b\u0006\u0002#\u0005i!/Z1di&4X-\\8oO>\u001c\u0001!\u0006\u0002\u0015=M\u0011\u0001!\u0006\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\u000f5,7o]1hKB\u0011QD\b\u0007\u0001\t\u0015y\u0002A1\u0001!\u0005\u0005!\u0016CA\u0011%!\t1\"%\u0003\u0002$/\t9aj\u001c;iS:<\u0007C\u0001\f&\u0013\t1sCA\u0002B]f\f!bY8o]\u0016\u001cG/[8o!\tI#&D\u0001\u000f\u0013\tYcBA\bN_:<wnQ8o]\u0016\u001cG/[8o\u0003A1\u0017-\u001b7pm\u0016\u00148\u000b\u001e:bi\u0016<\u0017\u0010\u0005\u0002*]%\u0011qF\u0004\u0002\u0011\r\u0006LGn\u001c<feN#(/\u0019;fOfDCaA\u00195+B\u0011aCM\u0005\u0003g]\u0011a\u0002Z3qe\u0016\u001c\u0017\r^3e\u001d\u0006lW-\r\u0003 ka\n\u0006C\u0001\f7\u0013\t9tC\u0001\u0004Ts6\u0014w\u000e\\\u0019\u0006Geb4*\u0010\u000b\u0003kiBQa\u000f\nA\u0002\u0001\u000bAA\\1nK&\u0011QHP\u0001\u0006CB\u0004H.\u001f\u0006\u0003\u007f]\taaU=nE>d\u0007CA!I\u001d\t\u0011e\t\u0005\u0002D/5\tAI\u0003\u0002F%\u00051AH]8pizJ!aR\f\u0002\rA\u0013X\rZ3g\u0013\tI%J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000f^\tTa\t'P!~r!!T(\u000f\u0005\rs\u0015\"\u0001\r\n\u0005}:\u0012\u0007\u0002\u0013N\u001db\t4!\n*T\u001f\u0005\u0019\u0016%\u0001+\u0002\u0011M$(/\u0019;fOf\fTa\t!W5^K!a\u0016-\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0015\tIv#\u0001\beKB\u0014XmY1uK\u0012t\u0015-\\32\u000b\rZF,X-\u000f\u0005Ya\u0016BA-\u0018c\u0011\u0011cc\u00060\u0003\u000bM\u001c\u0017\r\\1\u0002-\u0015D\b/Z2uS:<'+Z:q_:\u001cX-T1lKJ\u0004BAF1\u001dG&\u0011!m\u0006\u0002\n\rVt7\r^5p]F\u0002\"\u0001Z5\u000e\u0003\u0015T!AZ4\u0002\r\u0005\u001cGo\u001c:t\u0015\tA\u0007#\u0001\u0003d_J,\u0017B\u00016f\u0005E)\u0005\u0010]3di&twMU3ta>t7/Z\u0001\u0003K\u000e\u0004\"!\u001c9\u000e\u00039T!a\\\f\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002r]\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\tQL(p\u001f\u000b\u0003kb$\"A^<\u0011\u0007%\u0002A\u0004C\u0003l\r\u0001\u000fA\u000eC\u0003`\r\u0001\u0007\u0001\rC\u0003\u001c\r\u0001\u0007A\u0004C\u0003(\r\u0001\u0007\u0001\u0006C\u0003-\r\u0001\u0007Q\u0006\u000b\u0003|cu|\u0018\u0007B\u00106}F\u000bTaI\u001d=\u0017v\nda\t!W\u0003\u00039\u0016GB\u0012\\9\u0006\r\u0011,\r\u0003#-]q\u0016a\u00029s_6L7/Z\u000b\u0003\u0003\u0013\u0001R!\\A\u0006\u0003\u001fI1!!\u0004o\u0005\u001d\u0001&o\\7jg\u0016\u0004B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+9\u0017\u0001\u00039s_R|7m\u001c7\n\t\u0005e\u00111\u0003\u0002\t%\u0016\u001c\bo\u001c8tK\u0006A\u0001O]8nSN,\u0007%\u0001\u0004gkR,(/Z\u000b\u0003\u0003C\u0001R!\\A\u0012\u0003\u001fI1!!\no\u0005\u00191U\u000f^;sK\u00069a-\u001e;ve\u0016\u0004\u0013\u0001B:f]\u0012$B!!\f\u00024A\u0019a#a\f\n\u0007\u0005ErC\u0001\u0003V]&$\bbBA\u001b\u0017\u0001\u0007\u0011qG\u0001\u0002]B\u0019a#!\u000f\n\u0007\u0005mrCA\u0002J]R\f1\"[:SKR\u0014\u00180\u00192mKR!\u0011\u0011IA$!\r1\u00121I\u0005\u0004\u0003\u000b:\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0013b\u0001\u0019AA&\u0003%!\bN]8xC\ndW\r\u0005\u0003\u0002N\u0005McbA'\u0002P%\u0019\u0011\u0011K\f\u0002\u000fA\f7m[1hK&!\u0011QKA,\u0005%!\u0006N]8xC\ndWMC\u0002\u0002R]As\u0001AA.\u0003C\n)\u0007E\u0002\u0017\u0003;J1!a\u0018\u0018\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0003G\nq#\u00168vg\u0016$G\u0006I<jY2\u0004#-\u001a\u0011sK6|g/\u001a3\"\u0005\u0005\u001d\u0014A\u0002\u0019/c]r\u0003\u0007")
public class Failover<T> {
    private final T message;
    private final MongoConnection connection;
    private final FailoverStrategy failoverStrategy;
    private final Function1<T, ExpectingResponse> expectingResponseMaker;
    private final ExecutionContext ec;
    private final Promise<Response> promise;
    private final Future<Response> future;

    private Promise<Response> promise() {
        return this.promise;
    }

    public Future<Response> future() {
        return this.future;
    }

    private void send(int n) {
        ExpectingResponse expectingResponse = (ExpectingResponse)this.expectingResponseMaker.apply(this.message);
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.connection.mongosystem());
        ExpectingResponse x$1 = expectingResponse;
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
        expectingResponse.future().onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            Failure failure = null;
            Try try_ = x0$1;
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable e = failure.exception();
                if (this.isRetryable(e)) {
                    Promise promise;
                    if (n < $this.failoverStrategy.retries()) {
                        int n = n + 1;
                        double delayFactor = $this.failoverStrategy.delayFactor().apply$mcDI$sp(n);
                        FiniteDuration delay = (FiniteDuration)Duration$.MODULE$.unapply($this.failoverStrategy.initialDelay().$times(delayFactor)).fold((Function0 & Serializable & scala.Serializable)() -> $this.failoverStrategy.initialDelay(), (Function1 & Serializable & scala.Serializable)t -> FiniteDuration$.MODULE$.apply(t._1$mcJ$sp(), (TimeUnit)((Object)((Object)((Object)t._2())))));
                        Failover2$.MODULE$.logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Got an error, retrying... (try #").append(n).append(" is scheduled in ").append(delay.toMillis()).append(" ms)").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        promise = $this.connection.actorSystem().scheduler().scheduleOnce(delay, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.send(n), $this.ec);
                        return promise;
                    } else {
                        Failover2$.MODULE$.logger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Got an error, no more attempts to do. Completing with a failure...", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        promise = this.promise().failure(e);
                    }
                    return promise;
                }
            }
            if (bl) {
                Throwable e = failure.exception();
                Failover2$.MODULE$.logger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Got an non retryable error, completing with a failure...", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return this.promise().failure(e);
            }
            if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
            Success success = (Success)try_;
            Response response = (Response)success.value();
            Failover2$.MODULE$.logger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Got a successful result, completing...");
            return this.promise().success((Object)response);
        }, this.ec);
    }

    private boolean isRetryable(Throwable throwable) {
        boolean bl;
        Throwable throwable2 = throwable;
        if (throwable2 instanceof Exceptions.ChannelNotFound) {
            Exceptions.ChannelNotFound channelNotFound = (Exceptions.ChannelNotFound)throwable2;
            bl = channelNotFound.retriable();
        } else {
            DatabaseException databaseException;
            bl = throwable2 instanceof Exceptions.NotAuthenticatedException ? true : (throwable2 instanceof Exceptions.PrimaryUnavailableException ? true : (throwable2 instanceof Exceptions.NodeSetNotReachable ? true : (throwable2 instanceof ConnectionException ? true : (throwable2 instanceof ConnectionNotInitialized ? true : (throwable2 instanceof DatabaseException ? (databaseException = (DatabaseException)((Object)throwable2)).isNotAPrimaryError() || databaseException.isUnauthorized() : false)))));
        }
        return bl;
    }

    public Failover(T message, MongoConnection connection, FailoverStrategy failoverStrategy, Function1<T, ExpectingResponse> expectingResponseMaker, ExecutionContext ec) {
        this.message = message;
        this.connection = connection;
        this.failoverStrategy = failoverStrategy;
        this.expectingResponseMaker = expectingResponseMaker;
        this.ec = ec;
        this.promise = Promise$.MODULE$.apply();
        this.future = this.promise().future();
        this.send(0);
    }
}

