/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.xbill.DNS.Record;
import reactivemongo.api.AuthenticationMode;
import reactivemongo.api.CrAuthentication$;
import reactivemongo.api.FailoverStrategy;
import reactivemongo.api.FailoverStrategy$;
import reactivemongo.api.MongoConnection;
import reactivemongo.api.MongoConnectionOptions;
import reactivemongo.api.MongoConnectionOptions$;
import reactivemongo.api.ReadConcern;
import reactivemongo.api.ReadPreference;
import reactivemongo.api.ReadPreference$;
import reactivemongo.api.ScramSha1Authentication$;
import reactivemongo.api.X509Authentication$;
import reactivemongo.api.commands.GetLastError;
import reactivemongo.api.commands.GetLastError$Majority$;
import reactivemongo.api.commands.package$;
import reactivemongo.core.nodeset.Authenticate;
import reactivemongo.util.LazyLogger;
import reactivemongo.util.LazyLogger$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class MongoConnection$ {
    public static MongoConnection$ MODULE$;
    private final String DefaultHost;
    private final int DefaultPort;
    private final LazyLogger.LazyLogger logger;
    private final Regex IntRe;
    private final Regex FailoverRe;

    static {
        new MongoConnection$();
    }

    public String DefaultHost() {
        return this.DefaultHost;
    }

    public int DefaultPort() {
        return this.DefaultPort;
    }

    public LazyLogger.LazyLogger logger() {
        return this.logger;
    }

    public Try<MongoConnection.ParsedURI> parseURI(String uri) {
        return this.parseURI(uri, reactivemongo.util.package$.MODULE$.dnsResolve(reactivemongo.util.package$.MODULE$.dnsResolve$default$1(), reactivemongo.util.package$.MODULE$.dnsResolve$default$2()), reactivemongo.util.package$.MODULE$.txtRecords(reactivemongo.util.package$.MODULE$.txtRecords$default$1(), ExecutionContext.Implicits$.MODULE$.global()));
    }

    public Try<MongoConnection.ParsedURI> parseURI(String uri, Function1<ExecutionContext, Function1<String, Future<Record[]>>> srvRecResolver, Function1<String, Future<ListSet<String>>> txtResolver) {
        boolean seedList = uri.startsWith("mongodb+srv://");
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            MongoConnection.ParsedURI parsedURI;
            String string;
            if (uri.startsWith("mongodb://")) {
                string = (String)new StringOps(Predef$.MODULE$.augmentString(uri)).drop(10);
            } else if (seedList) {
                string = (String)new StringOps(Predef$.MODULE$.augmentString(uri)).drop(14);
            } else {
                throw new MongoConnection.URIParsingException(new StringBuilder(16).append("Invalid scheme: ").append(uri).toString());
            }
            String useful = string;
            String setSpec = (String)new StringOps(Predef$.MODULE$.augmentString(useful)).takeWhile((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parseURI$2(BoxesRunTime.unboxToChar((Object)x$5))));
            int credentialEnd = setSpec.indexOf("@");
            if (((MongoConnectionOptions)MongoConnection$.opts$1(seedList, setSpec, credentialEnd, txtResolver, useful)._2()).maxIdleTimeMS() != 0 && ((MongoConnectionOptions)MongoConnection$.opts$1(seedList, setSpec, credentialEnd, txtResolver, useful)._2()).maxIdleTimeMS() < ((MongoConnectionOptions)MongoConnection$.opts$1(seedList, setSpec, credentialEnd, txtResolver, useful)._2()).heartbeatFrequencyMS()) {
                throw new MongoConnection.URIParsingException(new StringBuilder(61).append("Invalid URI options: maxIdleTimeMS(").append(((MongoConnectionOptions)MongoConnection$.opts$1(seedList, setSpec, credentialEnd, txtResolver, useful)._2()).maxIdleTimeMS()).append(") < heartbeatFrequencyMS(").append(((MongoConnectionOptions)MongoConnection$.opts$1(seedList, setSpec, credentialEnd, txtResolver, useful)._2()).heartbeatFrequencyMS()).append(")").toString());
            }
            Tuple2 tuple2 = MongoConnection$.opts$1(seedList, setSpec, credentialEnd, txtResolver, useful);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List unsupportedKeys = (List)tuple2._1();
            MongoConnectionOptions options = (MongoConnectionOptions)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)unsupportedKeys, (Object)options);
            Tuple2 tuple23 = tuple22;
            List unsupportedKeys2 = (List)tuple23._1();
            MongoConnectionOptions options2 = (MongoConnectionOptions)tuple23._2();
            if (credentialEnd == -1) {
                MongoConnection.ParsedURI parsedURI2;
                Tuple2<Option<String>, List<Tuple2<String, Object>>> tuple24 = MODULE$.parseHostsAndDbName(seedList, setSpec, srvRecResolver);
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                Option db = (Option)tuple24._1();
                List hosts = (List)tuple24._2();
                Tuple2 tuple25 = new Tuple2((Object)db, (Object)hosts);
                Tuple2 tuple26 = tuple25;
                Option db2 = (Option)tuple26._1();
                List hosts2 = (List)tuple26._2();
                AuthenticationMode authenticationMode = options2.authenticationMechanism();
                if (X509Authentication$.MODULE$.equals(authenticationMode)) {
                    String dbName = (String)db2.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        throw new MongoConnection.URIParsingException(new StringBuilder(84).append("Could not parse URI '").append(uri).append("': authentication information found but no database name in URI").toString());
                    });
                    Map x$1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)dbName), (Object)new MongoConnectionOptions.Credential("", (Option<String>)None$.MODULE$))}));
                    int x$2 = options2.copy$default$1();
                    Option<String> x$3 = options2.copy$default$2();
                    boolean x$4 = options2.copy$default$3();
                    boolean x$52 = options2.copy$default$4();
                    AuthenticationMode x$6 = options2.copy$default$5();
                    boolean x$7 = options2.copy$default$6();
                    boolean x$8 = options2.copy$default$7();
                    int x$9 = options2.copy$default$8();
                    int x$10 = options2.copy$default$9();
                    GetLastError x$11 = options2.copy$default$10();
                    ReadPreference x$12 = options2.copy$default$11();
                    FailoverStrategy x$13 = options2.copy$default$12();
                    int x$14 = options2.copy$default$13();
                    int x$15 = options2.copy$default$14();
                    int x$16 = options2.copy$default$15();
                    Option<MongoConnectionOptions.KeyStore> x$17 = options2.copy$default$17();
                    ReadConcern x$18 = options2.copy$default$18();
                    MongoConnectionOptions optsWithX509 = options2.copy(x$2, x$3, x$4, x$52, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, (Map<String, MongoConnectionOptions.Credential>)x$1, x$17, x$18);
                    parsedURI2 = new MongoConnection.ParsedURI((List<Tuple2<String, Object>>)hosts2.toList(), optsWithX509, (List<String>)unsupportedKeys2, (Option<String>)db2, (Option<Authenticate>)new Some((Object)new Authenticate(dbName, "", (Option<String>)None$.MODULE$)));
                } else {
                    parsedURI2 = new MongoConnection.ParsedURI((List<Tuple2<String, Object>>)hosts2.toList(), options2, (List<String>)unsupportedKeys2, (Option<String>)db2, (Option<Authenticate>)None$.MODULE$);
                }
                parsedURI = parsedURI2;
            } else {
                Tuple2 tuple27;
                String pass;
                String user;
                String string2;
                Regex WithAuth = new StringOps(Predef$.MODULE$.augmentString("([^:]+)(|:[^@]*)@(.+)")).r();
                Option option = WithAuth.unapplySeq((CharSequence)(string2 = setSpec));
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
                    user = (String)((LinearSeqOptimized)option.get()).apply(0);
                    String p = (String)((LinearSeqOptimized)option.get()).apply(1);
                    String hostsPortsAndDbName = (String)((LinearSeqOptimized)option.get()).apply(2);
                    pass = new StringOps(Predef$.MODULE$.augmentString(p)).stripPrefix(":");
                    Tuple2<Option<String>, List<Tuple2<String, Object>>> tuple28 = MODULE$.parseHostsAndDbName(seedList, hostsPortsAndDbName, srvRecResolver);
                    if (tuple28 == null) {
                        throw new MatchError(tuple28);
                    }
                    Option db = (Option)tuple28._1();
                    List hosts = (List)tuple28._2();
                    tuple27 = new Tuple2((Object)db, (Object)hosts);
                } else {
                    throw new MongoConnection.URIParsingException(new StringBuilder(22).append("Could not parse URI '").append(uri).append("'").toString());
                }
                Tuple2 tuple29 = tuple27;
                Option db = (Option)tuple29._1();
                List hosts = (List)tuple29._2();
                MongoConnection.ParsedURI parsedURI3 = (MongoConnection.ParsedURI)db.fold((Function0 & Serializable & scala.Serializable)() -> {
                    throw new MongoConnection.URIParsingException(new StringBuilder(84).append("Could not parse URI '").append(uri).append("': authentication information found but no database name in URI").toString());
                }, (Function1 & Serializable & scala.Serializable)database -> {
                    AuthenticationMode authenticationMode = options2.authenticationMechanism();
                    X509Authentication$ x509Authentication$ = X509Authentication$.MODULE$;
                    if (!(authenticationMode != null ? !authenticationMode.equals(x509Authentication$) : x509Authentication$ != null) && new StringOps(Predef$.MODULE$.augmentString(pass)).nonEmpty()) {
                        throw new MongoConnection.URIParsingException("You should not provide a password when authenticating with X509 authentication");
                    }
                    AuthenticationMode authenticationMode2 = options2.authenticationMechanism();
                    X509Authentication$ x509Authentication$2 = X509Authentication$.MODULE$;
                    Option password = (authenticationMode2 == null ? x509Authentication$2 != null : !authenticationMode2.equals(x509Authentication$2)) ? Option$.MODULE$.apply((Object)pass) : Option$.MODULE$.empty();
                    String authDb = (String)options2.authenticationDatabase().getOrElse((Function0 & Serializable & scala.Serializable)() -> database);
                    Map x$19 = options2.credentials().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)authDb), (Object)new MongoConnectionOptions.Credential(user, (Option<String>)password)));
                    int x$20 = options2.copy$default$1();
                    Option<String> x$21 = options2.copy$default$2();
                    boolean x$22 = options2.copy$default$3();
                    boolean x$23 = options2.copy$default$4();
                    AuthenticationMode x$24 = options2.copy$default$5();
                    boolean x$25 = options2.copy$default$6();
                    boolean x$26 = options2.copy$default$7();
                    int x$27 = options2.copy$default$8();
                    int x$28 = options2.copy$default$9();
                    GetLastError x$29 = options2.copy$default$10();
                    ReadPreference x$30 = options2.copy$default$11();
                    FailoverStrategy x$31 = options2.copy$default$12();
                    int x$32 = options2.copy$default$13();
                    int x$33 = options2.copy$default$14();
                    int x$34 = options2.copy$default$15();
                    Option<MongoConnectionOptions.KeyStore> x$35 = options2.copy$default$17();
                    ReadConcern x$36 = options2.copy$default$18();
                    MongoConnectionOptions optsWithCred = options2.copy(x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, (Map<String, MongoConnectionOptions.Credential>)x$19, x$35, x$36);
                    return new MongoConnection.ParsedURI((List<Tuple2<String, Object>>)hosts.toList(), optsWithCred, (List<String>)unsupportedKeys2, (Option<String>)new Some(database), (Option<Authenticate>)new Some((Object)new Authenticate(authDb, user, (Option<String>)password)));
                });
                parsedURI = parsedURI3;
            }
            return parsedURI;
        });
    }

    private List<Tuple2<String, Object>> parseHosts(boolean seedList, String hosts, Function1<ExecutionContext, Function1<String, Future<Record[]>>> srvRecResolver) {
        return seedList ? ((List)Await$.MODULE$.result(reactivemongo.util.package$.MODULE$.srvRecords(hosts, srvRecResolver, ExecutionContext.Implicits$.MODULE$.global()), (Duration)reactivemongo.util.package$.MODULE$.dnsTimeout())).toList() : (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hosts.split(","))).map((Function1 & Serializable & scala.Serializable)h -> {
            String string;
            Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(h)).span((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parseHosts$2(BoxesRunTime.unboxToChar((Object)x$10))));
            if (tuple2 != null && "".equals(string = (String)tuple2._1())) {
                throw new MongoConnection.URIParsingException(new StringBuilder(28).append("No valid host in the URI: '").append((String)h).append("'").toString());
            }
            if (tuple2 != null) {
                String host = (String)tuple2._1();
                String string2 = (String)tuple2._2();
                if ("".equals(string2)) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)host), (Object)BoxesRunTime.boxToInteger((int)MODULE$.DefaultPort()));
                }
            }
            if (tuple2 == null) throw new MongoConnection.URIParsingException(new StringBuilder(52).append("Could not parse host from URI: invalid definition '").append((String)h).append("'").toString());
            String host = (String)tuple2._1();
            String port = (String)tuple2._2();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)host), (Object)BoxesRunTime.boxToInteger((int)MongoConnection$.liftedTree1$1(port, h)));
        }, scala.collection.package$.MODULE$.breakOut(List$.MODULE$.canBuildFrom()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2<Option<String>, List<Tuple2<String, Object>>> parseHostsAndDbName(boolean seedList, String input, Function1<ExecutionContext, Function1<String, Future<Record[]>>> srvRecResolver) {
        Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(input)).span((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parseHostsAndDbName$1(BoxesRunTime.unboxToChar((Object)x$11))));
        if (tuple2 != null) {
            String hosts = (String)tuple2._1();
            String string = (String)tuple2._2();
            if ("".equals(string)) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), this.parseHosts(seedList, hosts, srvRecResolver));
            }
        }
        if (tuple2 == null) throw new MongoConnection.URIParsingException(new StringBuilder(47).append("Could not parse hosts and database from URI: '").append(input).append("'").toString());
        String hosts = (String)tuple2._1();
        String dbName = (String)tuple2._2();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some(new StringOps(Predef$.MODULE$.augmentString(dbName)).drop(1))), this.parseHosts(seedList, hosts, srvRecResolver));
    }

    private Map<String, String> parseOptions(String options) {
        return options.isEmpty() ? Predef$.MODULE$.Map().empty() : (Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])options.split("&"))).map((Function1 & Serializable & scala.Serializable)option -> {
            String value;
            String key;
            block3: {
                block2: {
                    List list2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])option.split("="))).toList();
                    if (!(list2 instanceof .colon.colon)) break block2;
                    .colon.colon colon2 = (.colon.colon)list2;
                    key = (String)colon2.head();
                    List list3 = colon2.tl$access$1();
                    if (!(list3 instanceof .colon.colon)) break block2;
                    .colon.colon colon3 = (.colon.colon)list3;
                    value = (String)colon3.head();
                    List list4 = colon3.tl$access$1();
                    if (Nil$.MODULE$.equals(list4)) break block3;
                }
                throw new MongoConnection.URIParsingException(new StringBuilder(34).append("Could not parse invalid options '").append(options).append("'").toString());
            }
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
            return tuple2;
        }, scala.collection.package$.MODULE$.breakOut(Map$.MODULE$.canBuildFrom()));
    }

    public Regex IntRe() {
        return this.IntRe;
    }

    public Regex FailoverRe() {
        return this.FailoverRe;
    }

    private Tuple2<List<String>, MongoConnectionOptions> makeOptions(Map<String, String> opts, MongoConnectionOptions initial) {
        Tuple2 tuple2 = (Tuple2)opts.iterator().foldLeft((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Map().empty()), (Object)initial), MongoConnection$::$anonfun$makeOptions$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Map remOpts = (Map)tuple2._1();
        MongoConnectionOptions step1 = (MongoConnectionOptions)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)remOpts, (Object)step1);
        Tuple2 tuple23 = tuple22;
        Map remOpts2 = (Map)tuple23._1();
        MongoConnectionOptions step12 = (MongoConnectionOptions)tuple23._2();
        MongoConnectionOptions step2 = (MongoConnectionOptions)remOpts2.get((Object)"keyStore").fold((Function0 & Serializable & scala.Serializable)() -> step12, (Function1 & Serializable & scala.Serializable)uri -> {
            MongoConnectionOptions.KeyStore keyStore = new MongoConnectionOptions.KeyStore(new URI((String)uri), (Option<char[]>)remOpts2.get((Object)"keyStorePassword").map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.toCharArray()), (String)remOpts2.get((Object)"keyStoreType").getOrElse((Function0 & Serializable & scala.Serializable)() -> "PKCS12"));
            Some x$541 = new Some((Object)keyStore);
            int x$542 = step12.copy$default$1();
            Option<String> x$543 = step12.copy$default$2();
            boolean x$544 = step12.copy$default$3();
            boolean x$545 = step12.copy$default$4();
            AuthenticationMode x$546 = step12.copy$default$5();
            boolean x$547 = step12.copy$default$6();
            boolean x$548 = step12.copy$default$7();
            int x$549 = step12.copy$default$8();
            int x$550 = step12.copy$default$9();
            GetLastError x$551 = step12.copy$default$10();
            ReadPreference x$552 = step12.copy$default$11();
            FailoverStrategy x$553 = step12.copy$default$12();
            int x$554 = step12.copy$default$13();
            int x$555 = step12.copy$default$14();
            int x$556 = step12.copy$default$15();
            Map<String, MongoConnectionOptions.Credential> x$557 = step12.copy$default$16();
            ReadConcern x$558 = step12.copy$default$18();
            return step12.copy(x$542, x$543, x$544, x$545, x$546, x$547, x$548, x$549, x$550, x$551, x$552, x$553, x$554, x$555, x$556, x$557, (Option<MongoConnectionOptions.KeyStore>)x$541, x$558);
        });
        Map remOpts22 = (Map)remOpts2.$minus((Object)"keyStore").$minus((Object)"keyStorePassword").$minus((Object)"keyStoreType");
        return (Tuple2)remOpts22.iterator().foldLeft((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)List$.MODULE$.empty()), (Object)step2), MongoConnection$::$anonfun$makeOptions$29);
    }

    public static final /* synthetic */ boolean $anonfun$parseURI$2(char x$5) {
        return x$5 != '?';
    }

    public static final /* synthetic */ boolean $anonfun$parseURI$3(char x$6) {
        return x$6 != '/';
    }

    private static final Map txtOptions$1(boolean seedList$1, String setSpec$1, int credentialEnd$1, Function1 txtResolver$1) {
        Map map;
        if (!seedList$1) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            String serviceName = (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(setSpec$1)).drop(credentialEnd$1 + 1))).takeWhile((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parseURI$3(BoxesRunTime.unboxToChar((Object)x$6))));
            ListSet records = (ListSet)Await$.MODULE$.result((Awaitable)txtResolver$1.apply((Object)serviceName), (Duration)reactivemongo.util.package$.MODULE$.dnsTimeout());
            map = (Map)records.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(o, r) -> o.$plus$plus(MODULE$.parseOptions((String)r)));
        }
        return map;
    }

    private static final Tuple2 opts$1(boolean seedList$1, String setSpec$1, int credentialEnd$1, Function1 txtResolver$1, String useful$1) {
        MongoConnectionOptions mongoConnectionOptions;
        MongoConnectionOptions empty = new MongoConnectionOptions(MongoConnectionOptions$.MODULE$.apply$default$1(), MongoConnectionOptions$.MODULE$.apply$default$2(), MongoConnectionOptions$.MODULE$.apply$default$3(), MongoConnectionOptions$.MODULE$.apply$default$4(), MongoConnectionOptions$.MODULE$.apply$default$5(), MongoConnectionOptions$.MODULE$.apply$default$6(), MongoConnectionOptions$.MODULE$.apply$default$7(), MongoConnectionOptions$.MODULE$.apply$default$8(), MongoConnectionOptions$.MODULE$.apply$default$9(), MongoConnectionOptions$.MODULE$.apply$default$10(), MongoConnectionOptions$.MODULE$.apply$default$11(), MongoConnectionOptions$.MODULE$.apply$default$12(), MongoConnectionOptions$.MODULE$.apply$default$13(), MongoConnectionOptions$.MODULE$.apply$default$14(), MongoConnectionOptions$.MODULE$.apply$default$15(), MongoConnectionOptions$.MODULE$.apply$default$16(), MongoConnectionOptions$.MODULE$.apply$default$17(), MongoConnectionOptions$.MODULE$.apply$default$18());
        if (!seedList$1) {
            mongoConnectionOptions = empty;
        } else {
            boolean x$1 = true;
            int x$2 = empty.copy$default$1();
            Option<String> x$3 = empty.copy$default$2();
            boolean x$4 = empty.copy$default$4();
            AuthenticationMode x$5 = empty.copy$default$5();
            boolean x$6 = empty.copy$default$6();
            boolean x$7 = empty.copy$default$7();
            int x$8 = empty.copy$default$8();
            int x$9 = empty.copy$default$9();
            GetLastError x$10 = empty.copy$default$10();
            ReadPreference x$11 = empty.copy$default$11();
            FailoverStrategy x$12 = empty.copy$default$12();
            int x$13 = empty.copy$default$13();
            int x$14 = empty.copy$default$14();
            int x$15 = empty.copy$default$15();
            Map<String, MongoConnectionOptions.Credential> x$16 = empty.copy$default$16();
            Option<MongoConnectionOptions.KeyStore> x$17 = empty.copy$default$17();
            ReadConcern x$18 = empty.copy$default$18();
            mongoConnectionOptions = empty.copy(x$2, x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18);
        }
        MongoConnectionOptions initial = mongoConnectionOptions;
        String optionStr = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(useful$1)).drop(new StringOps(Predef$.MODULE$.augmentString(setSpec$1)).size()))).stripPrefix("?");
        return MODULE$.makeOptions((Map<String, String>)MongoConnection$.txtOptions$1(seedList$1, setSpec$1, credentialEnd$1, txtResolver$1).$plus$plus(MODULE$.parseOptions(optionStr)), initial);
    }

    public static final /* synthetic */ boolean $anonfun$parseHosts$2(char x$10) {
        return x$10 != ':';
    }

    private static final int liftedTree1$1(String port$1, String h$1) {
        int n;
        try {
            int p = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(port$1)).drop(1))).toInt();
            if (p <= 0 || p >= 65536) {
                throw new MongoConnection.URIParsingException(new StringBuilder(49).append("Could not parse host '").append(h$1).append("' from URI: invalid port '").append(port$1).append("'").toString());
            }
            n = p;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof NumberFormatException) {
                throw new MongoConnection.URIParsingException(new StringBuilder(49).append("Could not parse host '").append(h$1).append("' from URI: invalid port '").append(port$1).append("'").toString());
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw e;
            }
            throw throwable;
        }
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$parseHostsAndDbName$1(char x$11) {
        return x$11 != '/';
    }

    public static final /* synthetic */ String $anonfun$makeOptions$2() {
        return "Connection option 'authSource' deprecated: use option 'authenticationDatabase'";
    }

    public static final /* synthetic */ String $anonfun$makeOptions$3() {
        return "Connection option 'authMode' is deprecated; Use option 'authenticationMechanism'";
    }

    public static final /* synthetic */ String $anonfun$makeOptions$4() {
        return "Connection option 'authMode' is deprecated; Use option 'authenticationMechanism'";
    }

    public static final /* synthetic */ String $anonfun$makeOptions$5() {
        return "Connection option 'authMode' is deprecated; Use option 'authenticationMechanism'";
    }

    public static final /* synthetic */ String $anonfun$makeOptions$6() {
        return "Connection option 'sslEnabled' is deprecated; Use option 'ssl'";
    }

    public static final /* synthetic */ String $anonfun$makeOptions$7() {
        return "Connection option 'rm.reconnectDelayMS' deprecated: use option 'heartbeatFrequencyMS'";
    }

    public static final /* synthetic */ int $anonfun$makeOptions$8(String ms$1) {
        return new StringOps(Predef$.MODULE$.augmentString(ms$1)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$makeOptions$9(int x$12) {
        return x$12 >= 500;
    }

    public static final /* synthetic */ Duration $anonfun$makeOptions$10(String d$1) {
        return Duration$.MODULE$.apply(d$1);
    }

    public static final /* synthetic */ Option $anonfun$makeOptions$11(Duration d) {
        return Duration$.MODULE$.unapply(d);
    }

    public static final /* synthetic */ boolean $anonfun$makeOptions$12(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ FailoverStrategy $anonfun$makeOptions$18(FiniteDuration delay$1, int retry$1, double factor) {
        return new FailoverStrategy(delay$1, retry$1, (Function1<Object, Object>)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$13 -> (double)x$13 * factor);
    }

    public static final /* synthetic */ Option $anonfun$makeOptions$16(String f$1, FiniteDuration delay$1, int retry) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(f$1)).toDouble()).toOption().map((Function1 & Serializable & scala.Serializable)factor -> MongoConnection$.$anonfun$makeOptions$18(delay$1, retry, BoxesRunTime.unboxToDouble((Object)factor)));
    }

    public static final /* synthetic */ Option $anonfun$makeOptions$13(String r$1, String f$1, Tuple2 x$14) {
        Tuple2 tuple2 = x$14;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long time = tuple2._1$mcJ$sp();
        TimeUnit unit = (TimeUnit)((Object)tuple2._2());
        Option option = new Some((Object)FiniteDuration$.MODULE$.apply(time, unit)).flatMap((Function1 & Serializable & scala.Serializable)delay -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(r$1)).toInt()).toOption().flatMap((Function1 & Serializable & scala.Serializable)retry -> MongoConnection$.$anonfun$makeOptions$16(f$1, delay, BoxesRunTime.unboxToInt((Object)retry))));
        return option;
    }

    public static final /* synthetic */ String $anonfun$makeOptions$20() {
        return "Connection option 'rm.monitorRefreshMS' deprecated: use option 'heartbeatFrequencyMS'";
    }

    public static final /* synthetic */ int $anonfun$makeOptions$21(String ms$2) {
        return new StringOps(Predef$.MODULE$.augmentString(ms$2)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$makeOptions$22(int x$15) {
        return x$15 >= 500;
    }

    public static final /* synthetic */ int $anonfun$makeOptions$23(String ms$3) {
        return new StringOps(Predef$.MODULE$.augmentString(ms$3)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$makeOptions$24(int x$16) {
        return x$16 >= 500;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple2 $anonfun$makeOptions$1(Tuple2 x0$1, Tuple2 x1$1) {
        block12: {
            block10: {
                block42: {
                    block41: {
                        block40: {
                            block39: {
                                block38: {
                                    block37: {
                                        block36: {
                                            block35: {
                                                block34: {
                                                    block33: {
                                                        block32: {
                                                            block31: {
                                                                block30: {
                                                                    block29: {
                                                                        block28: {
                                                                            block27: {
                                                                                block26: {
                                                                                    block25: {
                                                                                        block24: {
                                                                                            block23: {
                                                                                                block22: {
                                                                                                    block21: {
                                                                                                        block20: {
                                                                                                            block19: {
                                                                                                                block18: {
                                                                                                                    block17: {
                                                                                                                        block16: {
                                                                                                                            block15: {
                                                                                                                                block14: {
                                                                                                                                    block13: {
                                                                                                                                        block11: {
                                                                                                                                            var8_2 = new Tuple2((Object)x0$1, (Object)x1$1);
                                                                                                                                            if (var8_2 == null) break block10;
                                                                                                                                            var9_3 = (Tuple2)var8_2._1();
                                                                                                                                            kv = (Tuple2)var8_2._2();
                                                                                                                                            if (var9_3 == null) break block10;
                                                                                                                                            unsupported = (Map)var9_3._1();
                                                                                                                                            result = (MongoConnectionOptions)var9_3._2();
                                                                                                                                            var13_7 = kv;
                                                                                                                                            if (var13_7 == null) break block11;
                                                                                                                                            var14_8 = (String)var13_7._1();
                                                                                                                                            v = (String)var13_7._2();
                                                                                                                                            if (!"authSource".equals(var14_8)) break block11;
                                                                                                                                            MongoConnection$.MODULE$.logger().warn((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$makeOptions$2(), ()Ljava/lang/String;)());
                                                                                                                                            x$1 = new Some((Object)v);
                                                                                                                                            x$2 = result.copy$default$1();
                                                                                                                                            x$3 = result.copy$default$3();
                                                                                                                                            x$4 = result.copy$default$4();
                                                                                                                                            x$5 = result.copy$default$5();
                                                                                                                                            x$6 = result.copy$default$6();
                                                                                                                                            x$7 = result.copy$default$7();
                                                                                                                                            x$8 = result.copy$default$8();
                                                                                                                                            x$9 = result.copy$default$9();
                                                                                                                                            x$10 = result.copy$default$10();
                                                                                                                                            x$11 = result.copy$default$11();
                                                                                                                                            x$12 = result.copy$default$12();
                                                                                                                                            x$13 = result.copy$default$13();
                                                                                                                                            x$14 = result.copy$default$14();
                                                                                                                                            x$15 = result.copy$default$15();
                                                                                                                                            x$16 = result.copy$default$16();
                                                                                                                                            x$17 = result.copy$default$17();
                                                                                                                                            x$18 = result.copy$default$18();
                                                                                                                                            var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$2, (Option<String>)x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18));
                                                                                                                                            break block12;
                                                                                                                                        }
                                                                                                                                        if (var13_7 == null) break block13;
                                                                                                                                        var34_29 = (String)var13_7._1();
                                                                                                                                        var35_30 = (String)var13_7._2();
                                                                                                                                        if (!"authenticationMechanism".equals(var34_29) || !"x509".equals(var35_30)) break block13;
                                                                                                                                        x$19 = X509Authentication$.MODULE$;
                                                                                                                                        x$20 = result.copy$default$1();
                                                                                                                                        x$21 = result.copy$default$2();
                                                                                                                                        x$22 = result.copy$default$3();
                                                                                                                                        x$23 = result.copy$default$4();
                                                                                                                                        x$24 = result.copy$default$6();
                                                                                                                                        x$25 = result.copy$default$7();
                                                                                                                                        x$26 = result.copy$default$8();
                                                                                                                                        x$27 = result.copy$default$9();
                                                                                                                                        x$28 = result.copy$default$10();
                                                                                                                                        x$29 = result.copy$default$11();
                                                                                                                                        x$30 = result.copy$default$12();
                                                                                                                                        x$31 = result.copy$default$13();
                                                                                                                                        x$32 = result.copy$default$14();
                                                                                                                                        x$33 = result.copy$default$15();
                                                                                                                                        x$34 = result.copy$default$16();
                                                                                                                                        x$35 = result.copy$default$17();
                                                                                                                                        x$36 = result.copy$default$18();
                                                                                                                                        var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$20, x$21, x$22, x$23, x$19, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36));
                                                                                                                                        break block12;
                                                                                                                                    }
                                                                                                                                    if (var13_7 == null) break block14;
                                                                                                                                    var54_49 = (String)var13_7._1();
                                                                                                                                    var55_50 = (String)var13_7._2();
                                                                                                                                    if (!"authenticationMechanism".equals(var54_49) || !"mongocr".equals(var55_50)) break block14;
                                                                                                                                    x$37 = CrAuthentication$.MODULE$;
                                                                                                                                    x$38 = result.copy$default$1();
                                                                                                                                    x$39 = result.copy$default$2();
                                                                                                                                    x$40 = result.copy$default$3();
                                                                                                                                    x$41 = result.copy$default$4();
                                                                                                                                    x$42 = result.copy$default$6();
                                                                                                                                    x$43 = result.copy$default$7();
                                                                                                                                    x$44 = result.copy$default$8();
                                                                                                                                    x$45 = result.copy$default$9();
                                                                                                                                    x$46 = result.copy$default$10();
                                                                                                                                    x$47 = result.copy$default$11();
                                                                                                                                    x$48 = result.copy$default$12();
                                                                                                                                    x$49 = result.copy$default$13();
                                                                                                                                    x$50 = result.copy$default$14();
                                                                                                                                    x$51 = result.copy$default$15();
                                                                                                                                    x$52 = result.copy$default$16();
                                                                                                                                    x$53 = result.copy$default$17();
                                                                                                                                    x$54 = result.copy$default$18();
                                                                                                                                    var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$38, x$39, x$40, x$41, x$37, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54));
                                                                                                                                    break block12;
                                                                                                                                }
                                                                                                                                if (var13_7 == null || !"authenticationMechanism".equals(var74_69 = (String)var13_7._1())) break block15;
                                                                                                                                x$55 = ScramSha1Authentication$.MODULE$;
                                                                                                                                x$56 = result.copy$default$1();
                                                                                                                                x$57 = result.copy$default$2();
                                                                                                                                x$58 = result.copy$default$3();
                                                                                                                                x$59 = result.copy$default$4();
                                                                                                                                x$60 = result.copy$default$6();
                                                                                                                                x$61 = result.copy$default$7();
                                                                                                                                x$62 = result.copy$default$8();
                                                                                                                                x$63 = result.copy$default$9();
                                                                                                                                x$64 = result.copy$default$10();
                                                                                                                                x$65 = result.copy$default$11();
                                                                                                                                x$66 = result.copy$default$12();
                                                                                                                                x$67 = result.copy$default$13();
                                                                                                                                x$68 = result.copy$default$14();
                                                                                                                                x$69 = result.copy$default$15();
                                                                                                                                x$70 = result.copy$default$16();
                                                                                                                                x$71 = result.copy$default$17();
                                                                                                                                x$72 = result.copy$default$18();
                                                                                                                                var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$56, x$57, x$58, x$59, x$55, x$60, x$61, x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$69, x$70, x$71, x$72));
                                                                                                                                break block12;
                                                                                                                            }
                                                                                                                            if (var13_7 == null) break block16;
                                                                                                                            var93_88 = (String)var13_7._1();
                                                                                                                            var94_89 = (String)var13_7._2();
                                                                                                                            if (!"authMode".equals(var93_88) || !"x509".equals(var94_89)) break block16;
                                                                                                                            MongoConnection$.MODULE$.logger().warn((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$makeOptions$3(), ()Ljava/lang/String;)());
                                                                                                                            x$73 = X509Authentication$.MODULE$;
                                                                                                                            x$74 = result.copy$default$1();
                                                                                                                            x$75 = result.copy$default$2();
                                                                                                                            x$76 = result.copy$default$3();
                                                                                                                            x$77 = result.copy$default$4();
                                                                                                                            x$78 = result.copy$default$6();
                                                                                                                            x$79 = result.copy$default$7();
                                                                                                                            x$80 = result.copy$default$8();
                                                                                                                            x$81 = result.copy$default$9();
                                                                                                                            x$82 = result.copy$default$10();
                                                                                                                            x$83 = result.copy$default$11();
                                                                                                                            x$84 = result.copy$default$12();
                                                                                                                            x$85 = result.copy$default$13();
                                                                                                                            x$86 = result.copy$default$14();
                                                                                                                            x$87 = result.copy$default$15();
                                                                                                                            x$88 = result.copy$default$16();
                                                                                                                            x$89 = result.copy$default$17();
                                                                                                                            x$90 = result.copy$default$18();
                                                                                                                            var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$74, x$75, x$76, x$77, x$73, x$78, x$79, x$80, x$81, x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90));
                                                                                                                            break block12;
                                                                                                                        }
                                                                                                                        if (var13_7 == null) break block17;
                                                                                                                        var113_108 = (String)var13_7._1();
                                                                                                                        var114_109 = (String)var13_7._2();
                                                                                                                        if (!"authMode".equals(var113_108) || !"mongocr".equals(var114_109)) break block17;
                                                                                                                        MongoConnection$.MODULE$.logger().warn((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$makeOptions$4(), ()Ljava/lang/String;)());
                                                                                                                        x$91 = CrAuthentication$.MODULE$;
                                                                                                                        x$92 = result.copy$default$1();
                                                                                                                        x$93 = result.copy$default$2();
                                                                                                                        x$94 = result.copy$default$3();
                                                                                                                        x$95 = result.copy$default$4();
                                                                                                                        x$96 = result.copy$default$6();
                                                                                                                        x$97 = result.copy$default$7();
                                                                                                                        x$98 = result.copy$default$8();
                                                                                                                        x$99 = result.copy$default$9();
                                                                                                                        x$100 = result.copy$default$10();
                                                                                                                        x$101 = result.copy$default$11();
                                                                                                                        x$102 = result.copy$default$12();
                                                                                                                        x$103 = result.copy$default$13();
                                                                                                                        x$104 = result.copy$default$14();
                                                                                                                        x$105 = result.copy$default$15();
                                                                                                                        x$106 = result.copy$default$16();
                                                                                                                        x$107 = result.copy$default$17();
                                                                                                                        x$108 = result.copy$default$18();
                                                                                                                        var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$92, x$93, x$94, x$95, x$91, x$96, x$97, x$98, x$99, x$100, x$101, x$102, x$103, x$104, x$105, x$106, x$107, x$108));
                                                                                                                        break block12;
                                                                                                                    }
                                                                                                                    if (var13_7 == null || !"authMode".equals(var133_128 = (String)var13_7._1())) break block18;
                                                                                                                    MongoConnection$.MODULE$.logger().warn((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$makeOptions$5(), ()Ljava/lang/String;)());
                                                                                                                    x$109 = ScramSha1Authentication$.MODULE$;
                                                                                                                    x$110 = result.copy$default$1();
                                                                                                                    x$111 = result.copy$default$2();
                                                                                                                    x$112 = result.copy$default$3();
                                                                                                                    x$113 = result.copy$default$4();
                                                                                                                    x$114 = result.copy$default$6();
                                                                                                                    x$115 = result.copy$default$7();
                                                                                                                    x$116 = result.copy$default$8();
                                                                                                                    x$117 = result.copy$default$9();
                                                                                                                    x$118 = result.copy$default$10();
                                                                                                                    x$119 = result.copy$default$11();
                                                                                                                    x$120 = result.copy$default$12();
                                                                                                                    x$121 = result.copy$default$13();
                                                                                                                    x$122 = result.copy$default$14();
                                                                                                                    x$123 = result.copy$default$15();
                                                                                                                    x$124 = result.copy$default$16();
                                                                                                                    x$125 = result.copy$default$17();
                                                                                                                    x$126 = result.copy$default$18();
                                                                                                                    var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$110, x$111, x$112, x$113, x$109, x$114, x$115, x$116, x$117, x$118, x$119, x$120, x$121, x$122, x$123, x$124, x$125, x$126));
                                                                                                                    break block12;
                                                                                                                }
                                                                                                                if (var13_7 == null) break block19;
                                                                                                                var152_147 = (String)var13_7._1();
                                                                                                                v = (String)var13_7._2();
                                                                                                                if (!"authenticationDatabase".equals(var152_147)) break block19;
                                                                                                                x$127 = new Some((Object)v);
                                                                                                                x$128 = result.copy$default$1();
                                                                                                                x$129 = result.copy$default$3();
                                                                                                                x$130 = result.copy$default$4();
                                                                                                                x$131 = result.copy$default$5();
                                                                                                                x$132 = result.copy$default$6();
                                                                                                                x$133 = result.copy$default$7();
                                                                                                                x$134 = result.copy$default$8();
                                                                                                                x$135 = result.copy$default$9();
                                                                                                                x$136 = result.copy$default$10();
                                                                                                                x$137 = result.copy$default$11();
                                                                                                                x$138 = result.copy$default$12();
                                                                                                                x$139 = result.copy$default$13();
                                                                                                                x$140 = result.copy$default$14();
                                                                                                                x$141 = result.copy$default$15();
                                                                                                                x$142 = result.copy$default$16();
                                                                                                                x$143 = result.copy$default$17();
                                                                                                                x$144 = result.copy$default$18();
                                                                                                                var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$128, (Option<String>)x$127, x$129, x$130, x$131, x$132, x$133, x$134, x$135, x$136, x$137, x$138, x$139, x$140, x$141, x$142, x$143, x$144));
                                                                                                                break block12;
                                                                                                            }
                                                                                                            if (var13_7 == null) break block20;
                                                                                                            var172_167 = (String)var13_7._1();
                                                                                                            v = (String)var13_7._2();
                                                                                                            if (!"connectTimeoutMS".equals(var172_167)) break block20;
                                                                                                            var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(new StringOps(Predef$.MODULE$.augmentString(v)).toInt(), result.copy$default$2(), result.copy$default$3(), result.copy$default$4(), result.copy$default$5(), result.copy$default$6(), result.copy$default$7(), result.copy$default$8(), result.copy$default$9(), result.copy$default$10(), result.copy$default$11(), result.copy$default$12(), result.copy$default$13(), result.copy$default$14(), result.copy$default$15(), result.copy$default$16(), result.copy$default$17(), result.copy$default$18()));
                                                                                                            break block12;
                                                                                                        }
                                                                                                        if (var13_7 == null) break block21;
                                                                                                        var174_169 = (String)var13_7._1();
                                                                                                        v = (String)var13_7._2();
                                                                                                        if (!"maxIdleTimeMS".equals(var174_169)) break block21;
                                                                                                        x$145 = new StringOps(Predef$.MODULE$.augmentString(v)).toInt();
                                                                                                        x$146 = result.copy$default$1();
                                                                                                        x$147 = result.copy$default$2();
                                                                                                        x$148 = result.copy$default$3();
                                                                                                        x$149 = result.copy$default$4();
                                                                                                        x$150 = result.copy$default$5();
                                                                                                        x$151 = result.copy$default$6();
                                                                                                        x$152 = result.copy$default$7();
                                                                                                        x$153 = result.copy$default$8();
                                                                                                        x$154 = result.copy$default$9();
                                                                                                        x$155 = result.copy$default$10();
                                                                                                        x$156 = result.copy$default$11();
                                                                                                        x$157 = result.copy$default$12();
                                                                                                        x$158 = result.copy$default$13();
                                                                                                        x$159 = result.copy$default$15();
                                                                                                        x$160 = result.copy$default$16();
                                                                                                        x$161 = result.copy$default$17();
                                                                                                        x$162 = result.copy$default$18();
                                                                                                        var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$146, x$147, x$148, x$149, x$150, x$151, x$152, x$153, x$154, x$155, x$156, x$157, x$158, x$145, x$159, x$160, x$161, x$162));
                                                                                                        break block12;
                                                                                                    }
                                                                                                    if (var13_7 == null) break block22;
                                                                                                    var194_189 = (String)var13_7._1();
                                                                                                    v = (String)var13_7._2();
                                                                                                    if (!"sslEnabled".equals(var194_189)) break block22;
                                                                                                    MongoConnection$.MODULE$.logger().warn((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$makeOptions$6(), ()Ljava/lang/String;)());
                                                                                                    x$163 = new StringOps(Predef$.MODULE$.augmentString(v)).toBoolean();
                                                                                                    x$164 = result.copy$default$1();
                                                                                                    x$165 = result.copy$default$2();
                                                                                                    x$166 = result.copy$default$4();
                                                                                                    x$167 = result.copy$default$5();
                                                                                                    x$168 = result.copy$default$6();
                                                                                                    x$169 = result.copy$default$7();
                                                                                                    x$170 = result.copy$default$8();
                                                                                                    x$171 = result.copy$default$9();
                                                                                                    x$172 = result.copy$default$10();
                                                                                                    x$173 = result.copy$default$11();
                                                                                                    x$174 = result.copy$default$12();
                                                                                                    x$175 = result.copy$default$13();
                                                                                                    x$176 = result.copy$default$14();
                                                                                                    x$177 = result.copy$default$15();
                                                                                                    x$178 = result.copy$default$16();
                                                                                                    x$179 = result.copy$default$17();
                                                                                                    x$180 = result.copy$default$18();
                                                                                                    var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$164, x$165, x$163, x$166, x$167, x$168, x$169, x$170, x$171, x$172, x$173, x$174, x$175, x$176, x$177, x$178, x$179, x$180));
                                                                                                    break block12;
                                                                                                }
                                                                                                if (var13_7 == null) break block23;
                                                                                                var214_209 = (String)var13_7._1();
                                                                                                v = (String)var13_7._2();
                                                                                                if (!"ssl".equals(var214_209)) break block23;
                                                                                                x$181 = new StringOps(Predef$.MODULE$.augmentString(v)).toBoolean();
                                                                                                x$182 = result.copy$default$1();
                                                                                                x$183 = result.copy$default$2();
                                                                                                x$184 = result.copy$default$4();
                                                                                                x$185 = result.copy$default$5();
                                                                                                x$186 = result.copy$default$6();
                                                                                                x$187 = result.copy$default$7();
                                                                                                x$188 = result.copy$default$8();
                                                                                                x$189 = result.copy$default$9();
                                                                                                x$190 = result.copy$default$10();
                                                                                                x$191 = result.copy$default$11();
                                                                                                x$192 = result.copy$default$12();
                                                                                                x$193 = result.copy$default$13();
                                                                                                x$194 = result.copy$default$14();
                                                                                                x$195 = result.copy$default$15();
                                                                                                x$196 = result.copy$default$16();
                                                                                                x$197 = result.copy$default$17();
                                                                                                x$198 = result.copy$default$18();
                                                                                                var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$182, x$183, x$181, x$184, x$185, x$186, x$187, x$188, x$189, x$190, x$191, x$192, x$193, x$194, x$195, x$196, x$197, x$198));
                                                                                                break block12;
                                                                                            }
                                                                                            if (var13_7 == null) break block24;
                                                                                            var234_229 = (String)var13_7._1();
                                                                                            v = (String)var13_7._2();
                                                                                            if (!"sslAllowsInvalidCert".equals(var234_229)) break block24;
                                                                                            x$199 = new StringOps(Predef$.MODULE$.augmentString(v)).toBoolean();
                                                                                            x$200 = result.copy$default$1();
                                                                                            x$201 = result.copy$default$2();
                                                                                            x$202 = result.copy$default$3();
                                                                                            x$203 = result.copy$default$5();
                                                                                            x$204 = result.copy$default$6();
                                                                                            x$205 = result.copy$default$7();
                                                                                            x$206 = result.copy$default$8();
                                                                                            x$207 = result.copy$default$9();
                                                                                            x$208 = result.copy$default$10();
                                                                                            x$209 = result.copy$default$11();
                                                                                            x$210 = result.copy$default$12();
                                                                                            x$211 = result.copy$default$13();
                                                                                            x$212 = result.copy$default$14();
                                                                                            x$213 = result.copy$default$15();
                                                                                            x$214 = result.copy$default$16();
                                                                                            x$215 = result.copy$default$17();
                                                                                            x$216 = result.copy$default$18();
                                                                                            var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$200, x$201, x$202, x$199, x$203, x$204, x$205, x$206, x$207, x$208, x$209, x$210, x$211, x$212, x$213, x$214, x$215, x$216));
                                                                                            break block12;
                                                                                        }
                                                                                        if (var13_7 == null) break block25;
                                                                                        var254_249 = (String)var13_7._1();
                                                                                        v = (String)var13_7._2();
                                                                                        if (!"rm.tcpNoDelay".equals(var254_249)) break block25;
                                                                                        x$217 = new StringOps(Predef$.MODULE$.augmentString(v)).toBoolean();
                                                                                        x$218 = result.copy$default$1();
                                                                                        x$219 = result.copy$default$2();
                                                                                        x$220 = result.copy$default$3();
                                                                                        x$221 = result.copy$default$4();
                                                                                        x$222 = result.copy$default$5();
                                                                                        x$223 = result.copy$default$7();
                                                                                        x$224 = result.copy$default$8();
                                                                                        x$225 = result.copy$default$9();
                                                                                        x$226 = result.copy$default$10();
                                                                                        x$227 = result.copy$default$11();
                                                                                        x$228 = result.copy$default$12();
                                                                                        x$229 = result.copy$default$13();
                                                                                        x$230 = result.copy$default$14();
                                                                                        x$231 = result.copy$default$15();
                                                                                        x$232 = result.copy$default$16();
                                                                                        x$233 = result.copy$default$17();
                                                                                        x$234 = result.copy$default$18();
                                                                                        var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$218, x$219, x$220, x$221, x$222, x$217, x$223, x$224, x$225, x$226, x$227, x$228, x$229, x$230, x$231, x$232, x$233, x$234));
                                                                                        break block12;
                                                                                    }
                                                                                    if (var13_7 == null) break block26;
                                                                                    var274_269 = (String)var13_7._1();
                                                                                    v = (String)var13_7._2();
                                                                                    if (!"rm.keepAlive".equals(var274_269)) break block26;
                                                                                    x$235 = new StringOps(Predef$.MODULE$.augmentString(v)).toBoolean();
                                                                                    x$236 = result.copy$default$1();
                                                                                    x$237 = result.copy$default$2();
                                                                                    x$238 = result.copy$default$3();
                                                                                    x$239 = result.copy$default$4();
                                                                                    x$240 = result.copy$default$5();
                                                                                    x$241 = result.copy$default$6();
                                                                                    x$242 = result.copy$default$8();
                                                                                    x$243 = result.copy$default$9();
                                                                                    x$244 = result.copy$default$10();
                                                                                    x$245 = result.copy$default$11();
                                                                                    x$246 = result.copy$default$12();
                                                                                    x$247 = result.copy$default$13();
                                                                                    x$248 = result.copy$default$14();
                                                                                    x$249 = result.copy$default$15();
                                                                                    x$250 = result.copy$default$16();
                                                                                    x$251 = result.copy$default$17();
                                                                                    x$252 = result.copy$default$18();
                                                                                    var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$236, x$237, x$238, x$239, x$240, x$241, x$235, x$242, x$243, x$244, x$245, x$246, x$247, x$248, x$249, x$250, x$251, x$252));
                                                                                    break block12;
                                                                                }
                                                                                if (var13_7 == null) break block27;
                                                                                var294_289 = (String)var13_7._1();
                                                                                v = (String)var13_7._2();
                                                                                if (!"rm.nbChannelsPerNode".equals(var294_289)) break block27;
                                                                                x$253 = new StringOps(Predef$.MODULE$.augmentString(v)).toInt();
                                                                                x$254 = result.copy$default$1();
                                                                                x$255 = result.copy$default$2();
                                                                                x$256 = result.copy$default$3();
                                                                                x$257 = result.copy$default$4();
                                                                                x$258 = result.copy$default$5();
                                                                                x$259 = result.copy$default$6();
                                                                                x$260 = result.copy$default$7();
                                                                                x$261 = result.copy$default$9();
                                                                                x$262 = result.copy$default$10();
                                                                                x$263 = result.copy$default$11();
                                                                                x$264 = result.copy$default$12();
                                                                                x$265 = result.copy$default$13();
                                                                                x$266 = result.copy$default$14();
                                                                                x$267 = result.copy$default$15();
                                                                                x$268 = result.copy$default$16();
                                                                                x$269 = result.copy$default$17();
                                                                                x$270 = result.copy$default$18();
                                                                                var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$254, x$255, x$256, x$257, x$258, x$259, x$260, x$253, x$261, x$262, x$263, x$264, x$265, x$266, x$267, x$268, x$269, x$270));
                                                                                break block12;
                                                                            }
                                                                            if (var13_7 == null) break block28;
                                                                            var314_309 = (String)var13_7._1();
                                                                            opt = (String)var13_7._2();
                                                                            if (!"rm.reconnectDelayMS".equals(var314_309) || (var316_311 = MongoConnection$.MODULE$.IntRe().unapplySeq((CharSequence)opt)).isEmpty() || var316_311.get() == null || ((LinearSeqOptimized)var316_311.get()).lengthCompare(1) != 0) break block28;
                                                                            ms = (String)((LinearSeqOptimized)var316_311.get()).apply(0);
                                                                            MongoConnection$.MODULE$.logger().warn((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$makeOptions$7(), ()Ljava/lang/String;)());
                                                                            var318_313 = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()I, $anonfun$makeOptions$8(java.lang.String ), ()I)((String)ms)).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (I)Z, $anonfun$makeOptions$9(int ), (I)Z)()).toOption();
                                                                            if (var318_313 instanceof Some) {
                                                                                var319_314 = (Some)var318_313;
                                                                                x$271 = interval = BoxesRunTime.unboxToInt((Object)var319_314.value());
                                                                                x$272 = result.copy$default$1();
                                                                                x$273 = result.copy$default$2();
                                                                                x$274 = result.copy$default$3();
                                                                                x$275 = result.copy$default$4();
                                                                                x$276 = result.copy$default$5();
                                                                                x$277 = result.copy$default$6();
                                                                                x$278 = result.copy$default$7();
                                                                                x$279 = result.copy$default$8();
                                                                                x$280 = result.copy$default$9();
                                                                                x$281 = result.copy$default$10();
                                                                                x$282 = result.copy$default$11();
                                                                                x$283 = result.copy$default$12();
                                                                                x$284 = result.copy$default$14();
                                                                                x$285 = result.copy$default$15();
                                                                                x$286 = result.copy$default$16();
                                                                                x$287 = result.copy$default$17();
                                                                                x$288 = result.copy$default$18();
                                                                                var7_334 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$272, x$273, x$274, x$275, x$276, x$277, x$278, x$279, x$280, x$281, x$282, x$283, x$271, x$284, x$285, x$286, x$287, x$288));
                                                                            } else {
                                                                                var7_334 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rm.reconnectDelayMS"), (Object)opt))), (Object)result);
                                                                            }
                                                                            var3_28 = var7_334;
                                                                            break block12;
                                                                        }
                                                                        if (var13_7 == null) break block29;
                                                                        var339_335 = (String)var13_7._1();
                                                                        var340_336 = (String)var13_7._2();
                                                                        if (!"writeConcern".equals(var339_335) || !"unacknowledged".equals(var340_336)) break block29;
                                                                        x$289 = package$.MODULE$.WriteConcern().Unacknowledged();
                                                                        x$290 = result.copy$default$1();
                                                                        x$291 = result.copy$default$2();
                                                                        x$292 = result.copy$default$3();
                                                                        x$293 = result.copy$default$4();
                                                                        x$294 = result.copy$default$5();
                                                                        x$295 = result.copy$default$6();
                                                                        x$296 = result.copy$default$7();
                                                                        x$297 = result.copy$default$8();
                                                                        x$298 = result.copy$default$9();
                                                                        x$299 = result.copy$default$11();
                                                                        x$300 = result.copy$default$12();
                                                                        x$301 = result.copy$default$13();
                                                                        x$302 = result.copy$default$14();
                                                                        x$303 = result.copy$default$15();
                                                                        x$304 = result.copy$default$16();
                                                                        x$305 = result.copy$default$17();
                                                                        x$306 = result.copy$default$18();
                                                                        var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$290, x$291, x$292, x$293, x$294, x$295, x$296, x$297, x$298, x$289, x$299, x$300, x$301, x$302, x$303, x$304, x$305, x$306));
                                                                        break block12;
                                                                    }
                                                                    if (var13_7 == null) break block30;
                                                                    var359_355 = (String)var13_7._1();
                                                                    var360_356 = (String)var13_7._2();
                                                                    if (!"writeConcern".equals(var359_355) || !"acknowledged".equals(var360_356)) break block30;
                                                                    x$307 = package$.MODULE$.WriteConcern().Acknowledged();
                                                                    x$308 = result.copy$default$1();
                                                                    x$309 = result.copy$default$2();
                                                                    x$310 = result.copy$default$3();
                                                                    x$311 = result.copy$default$4();
                                                                    x$312 = result.copy$default$5();
                                                                    x$313 = result.copy$default$6();
                                                                    x$314 = result.copy$default$7();
                                                                    x$315 = result.copy$default$8();
                                                                    x$316 = result.copy$default$9();
                                                                    x$317 = result.copy$default$11();
                                                                    x$318 = result.copy$default$12();
                                                                    x$319 = result.copy$default$13();
                                                                    x$320 = result.copy$default$14();
                                                                    x$321 = result.copy$default$15();
                                                                    x$322 = result.copy$default$16();
                                                                    x$323 = result.copy$default$17();
                                                                    x$324 = result.copy$default$18();
                                                                    var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$308, x$309, x$310, x$311, x$312, x$313, x$314, x$315, x$316, x$307, x$317, x$318, x$319, x$320, x$321, x$322, x$323, x$324));
                                                                    break block12;
                                                                }
                                                                if (var13_7 == null) break block31;
                                                                var379_375 = (String)var13_7._1();
                                                                var380_376 = (String)var13_7._2();
                                                                if (!"writeConcern".equals(var379_375) || !"journaled".equals(var380_376)) break block31;
                                                                x$325 = package$.MODULE$.WriteConcern().Journaled();
                                                                x$326 = result.copy$default$1();
                                                                x$327 = result.copy$default$2();
                                                                x$328 = result.copy$default$3();
                                                                x$329 = result.copy$default$4();
                                                                x$330 = result.copy$default$5();
                                                                x$331 = result.copy$default$6();
                                                                x$332 = result.copy$default$7();
                                                                x$333 = result.copy$default$8();
                                                                x$334 = result.copy$default$9();
                                                                x$335 = result.copy$default$11();
                                                                x$336 = result.copy$default$12();
                                                                x$337 = result.copy$default$13();
                                                                x$338 = result.copy$default$14();
                                                                x$339 = result.copy$default$15();
                                                                x$340 = result.copy$default$16();
                                                                x$341 = result.copy$default$17();
                                                                x$342 = result.copy$default$18();
                                                                var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$326, x$327, x$328, x$329, x$330, x$331, x$332, x$333, x$334, x$325, x$335, x$336, x$337, x$338, x$339, x$340, x$341, x$342));
                                                                break block12;
                                                            }
                                                            if (var13_7 == null) break block32;
                                                            var399_395 = (String)var13_7._1();
                                                            var400_396 = (String)var13_7._2();
                                                            if (!"writeConcern".equals(var399_395) || !"default".equals(var400_396)) break block32;
                                                            x$343 = package$.MODULE$.WriteConcern().Default();
                                                            x$344 = result.copy$default$1();
                                                            x$345 = result.copy$default$2();
                                                            x$346 = result.copy$default$3();
                                                            x$347 = result.copy$default$4();
                                                            x$348 = result.copy$default$5();
                                                            x$349 = result.copy$default$6();
                                                            x$350 = result.copy$default$7();
                                                            x$351 = result.copy$default$8();
                                                            x$352 = result.copy$default$9();
                                                            x$353 = result.copy$default$11();
                                                            x$354 = result.copy$default$12();
                                                            x$355 = result.copy$default$13();
                                                            x$356 = result.copy$default$14();
                                                            x$357 = result.copy$default$15();
                                                            x$358 = result.copy$default$16();
                                                            x$359 = result.copy$default$17();
                                                            x$360 = result.copy$default$18();
                                                            var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$344, x$345, x$346, x$347, x$348, x$349, x$350, x$351, x$352, x$343, x$353, x$354, x$355, x$356, x$357, x$358, x$359, x$360));
                                                            break block12;
                                                        }
                                                        if (var13_7 == null) break block33;
                                                        var419_415 = (String)var13_7._1();
                                                        var420_416 = (String)var13_7._2();
                                                        if (!"readPreference".equals(var419_415) || !"primary".equals(var420_416)) break block33;
                                                        x$361 = ReadPreference$.MODULE$.primary();
                                                        x$362 = result.copy$default$1();
                                                        x$363 = result.copy$default$2();
                                                        x$364 = result.copy$default$3();
                                                        x$365 = result.copy$default$4();
                                                        x$366 = result.copy$default$5();
                                                        x$367 = result.copy$default$6();
                                                        x$368 = result.copy$default$7();
                                                        x$369 = result.copy$default$8();
                                                        x$370 = result.copy$default$9();
                                                        x$371 = result.copy$default$10();
                                                        x$372 = result.copy$default$12();
                                                        x$373 = result.copy$default$13();
                                                        x$374 = result.copy$default$14();
                                                        x$375 = result.copy$default$15();
                                                        x$376 = result.copy$default$16();
                                                        x$377 = result.copy$default$17();
                                                        x$378 = result.copy$default$18();
                                                        var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$362, x$363, x$364, x$365, x$366, x$367, x$368, x$369, x$370, x$371, x$361, x$372, x$373, x$374, x$375, x$376, x$377, x$378));
                                                        break block12;
                                                    }
                                                    if (var13_7 == null) break block34;
                                                    var439_435 = (String)var13_7._1();
                                                    var440_436 = (String)var13_7._2();
                                                    if (!"readPreference".equals(var439_435) || !"primaryPreferred".equals(var440_436)) break block34;
                                                    x$379 = ReadPreference$.MODULE$.primaryPreferred();
                                                    x$380 = result.copy$default$1();
                                                    x$381 = result.copy$default$2();
                                                    x$382 = result.copy$default$3();
                                                    x$383 = result.copy$default$4();
                                                    x$384 = result.copy$default$5();
                                                    x$385 = result.copy$default$6();
                                                    x$386 = result.copy$default$7();
                                                    x$387 = result.copy$default$8();
                                                    x$388 = result.copy$default$9();
                                                    x$389 = result.copy$default$10();
                                                    x$390 = result.copy$default$12();
                                                    x$391 = result.copy$default$13();
                                                    x$392 = result.copy$default$14();
                                                    x$393 = result.copy$default$15();
                                                    x$394 = result.copy$default$16();
                                                    x$395 = result.copy$default$17();
                                                    x$396 = result.copy$default$18();
                                                    var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$380, x$381, x$382, x$383, x$384, x$385, x$386, x$387, x$388, x$389, x$379, x$390, x$391, x$392, x$393, x$394, x$395, x$396));
                                                    break block12;
                                                }
                                                if (var13_7 == null) break block35;
                                                var459_455 = (String)var13_7._1();
                                                var460_456 = (String)var13_7._2();
                                                if (!"readPreference".equals(var459_455) || !"secondary".equals(var460_456)) break block35;
                                                x$397 = ReadPreference$.MODULE$.secondary();
                                                x$398 = result.copy$default$1();
                                                x$399 = result.copy$default$2();
                                                x$400 = result.copy$default$3();
                                                x$401 = result.copy$default$4();
                                                x$402 = result.copy$default$5();
                                                x$403 = result.copy$default$6();
                                                x$404 = result.copy$default$7();
                                                x$405 = result.copy$default$8();
                                                x$406 = result.copy$default$9();
                                                x$407 = result.copy$default$10();
                                                x$408 = result.copy$default$12();
                                                x$409 = result.copy$default$13();
                                                x$410 = result.copy$default$14();
                                                x$411 = result.copy$default$15();
                                                x$412 = result.copy$default$16();
                                                x$413 = result.copy$default$17();
                                                x$414 = result.copy$default$18();
                                                var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$398, x$399, x$400, x$401, x$402, x$403, x$404, x$405, x$406, x$407, x$397, x$408, x$409, x$410, x$411, x$412, x$413, x$414));
                                                break block12;
                                            }
                                            if (var13_7 == null) break block36;
                                            var479_475 = (String)var13_7._1();
                                            var480_476 = (String)var13_7._2();
                                            if (!"readPreference".equals(var479_475) || !"secondaryPreferred".equals(var480_476)) break block36;
                                            x$415 = ReadPreference$.MODULE$.secondaryPreferred();
                                            x$416 = result.copy$default$1();
                                            x$417 = result.copy$default$2();
                                            x$418 = result.copy$default$3();
                                            x$419 = result.copy$default$4();
                                            x$420 = result.copy$default$5();
                                            x$421 = result.copy$default$6();
                                            x$422 = result.copy$default$7();
                                            x$423 = result.copy$default$8();
                                            x$424 = result.copy$default$9();
                                            x$425 = result.copy$default$10();
                                            x$426 = result.copy$default$12();
                                            x$427 = result.copy$default$13();
                                            x$428 = result.copy$default$14();
                                            x$429 = result.copy$default$15();
                                            x$430 = result.copy$default$16();
                                            x$431 = result.copy$default$17();
                                            x$432 = result.copy$default$18();
                                            var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$416, x$417, x$418, x$419, x$420, x$421, x$422, x$423, x$424, x$425, x$415, x$426, x$427, x$428, x$429, x$430, x$431, x$432));
                                            break block12;
                                        }
                                        if (var13_7 == null) break block37;
                                        var499_495 = (String)var13_7._1();
                                        var500_496 = (String)var13_7._2();
                                        if (!"readPreference".equals(var499_495) || !"nearest".equals(var500_496)) break block37;
                                        x$433 = ReadPreference$.MODULE$.nearest();
                                        x$434 = result.copy$default$1();
                                        x$435 = result.copy$default$2();
                                        x$436 = result.copy$default$3();
                                        x$437 = result.copy$default$4();
                                        x$438 = result.copy$default$5();
                                        x$439 = result.copy$default$6();
                                        x$440 = result.copy$default$7();
                                        x$441 = result.copy$default$8();
                                        x$442 = result.copy$default$9();
                                        x$443 = result.copy$default$10();
                                        x$444 = result.copy$default$12();
                                        x$445 = result.copy$default$13();
                                        x$446 = result.copy$default$14();
                                        x$447 = result.copy$default$15();
                                        x$448 = result.copy$default$16();
                                        x$449 = result.copy$default$17();
                                        x$450 = result.copy$default$18();
                                        var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$434, x$435, x$436, x$437, x$438, x$439, x$440, x$441, x$442, x$443, x$433, x$444, x$445, x$446, x$447, x$448, x$449, x$450));
                                        break block12;
                                    }
                                    if (var13_7 == null) break block38;
                                    var519_515 = (String)var13_7._1();
                                    var520_516 = (String)var13_7._2();
                                    if (!"rm.failover".equals(var519_515) || !"default".equals(var520_516)) break block38;
                                    var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result);
                                    break block12;
                                }
                                if (var13_7 == null) break block39;
                                var521_517 = (String)var13_7._1();
                                var522_518 = (String)var13_7._2();
                                if (!"rm.failover".equals(var521_517) || !"remote".equals(var522_518)) break block39;
                                x$451 = FailoverStrategy$.MODULE$.remote();
                                x$452 = result.copy$default$1();
                                x$453 = result.copy$default$2();
                                x$454 = result.copy$default$3();
                                x$455 = result.copy$default$4();
                                x$456 = result.copy$default$5();
                                x$457 = result.copy$default$6();
                                x$458 = result.copy$default$7();
                                x$459 = result.copy$default$8();
                                x$460 = result.copy$default$9();
                                x$461 = result.copy$default$10();
                                x$462 = result.copy$default$11();
                                x$463 = result.copy$default$13();
                                x$464 = result.copy$default$14();
                                x$465 = result.copy$default$15();
                                x$466 = result.copy$default$16();
                                x$467 = result.copy$default$17();
                                x$468 = result.copy$default$18();
                                var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$452, x$453, x$454, x$455, x$456, x$457, x$458, x$459, x$460, x$461, x$462, x$451, x$463, x$464, x$465, x$466, x$467, x$468));
                                break block12;
                            }
                            if (var13_7 == null) break block40;
                            var541_537 = (String)var13_7._1();
                            var542_538 = (String)var13_7._2();
                            if (!"rm.failover".equals(var541_537) || !"strict".equals(var542_538)) break block40;
                            x$469 = FailoverStrategy$.MODULE$.strict();
                            x$470 = result.copy$default$1();
                            x$471 = result.copy$default$2();
                            x$472 = result.copy$default$3();
                            x$473 = result.copy$default$4();
                            x$474 = result.copy$default$5();
                            x$475 = result.copy$default$6();
                            x$476 = result.copy$default$7();
                            x$477 = result.copy$default$8();
                            x$478 = result.copy$default$9();
                            x$479 = result.copy$default$10();
                            x$480 = result.copy$default$11();
                            x$481 = result.copy$default$13();
                            x$482 = result.copy$default$14();
                            x$483 = result.copy$default$15();
                            x$484 = result.copy$default$16();
                            x$485 = result.copy$default$17();
                            x$486 = result.copy$default$18();
                            var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$470, x$471, x$472, x$473, x$474, x$475, x$476, x$477, x$478, x$479, x$480, x$469, x$481, x$482, x$483, x$484, x$485, x$486));
                            break block12;
                        }
                        if (var13_7 == null) break block41;
                        var561_557 = (String)var13_7._1();
                        opt = (String)var13_7._2();
                        if (!"rm.failover".equals(var561_557) || (var563_559 = MongoConnection$.MODULE$.FailoverRe().unapplySeq((CharSequence)opt)).isEmpty() || var563_559.get() == null || ((LinearSeqOptimized)var563_559.get()).lengthCompare(3) != 0) break block41;
                        d = (String)((LinearSeqOptimized)var563_559.get()).apply(0);
                        r = (String)((LinearSeqOptimized)var563_559.get()).apply(1);
                        f = (String)((LinearSeqOptimized)var563_559.get()).apply(2);
                        var567_563 = Try$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$makeOptions$10(java.lang.String ), ()Lscala/concurrent/duration/Duration;)((String)d)).toOption().flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$makeOptions$11(scala.concurrent.duration.Duration ), (Lscala/concurrent/duration/Duration;)Lscala/Option;)()).withFilter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$makeOptions$12$adapted(scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)()).flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$makeOptions$13(java.lang.String java.lang.String scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Option;)((String)r, (String)f));
                        if (var567_563 instanceof Some) {
                            var568_564 = (Some)var567_563;
                            x$487 = strategy = (FailoverStrategy)var568_564.value();
                            x$488 = result.copy$default$1();
                            x$489 = result.copy$default$2();
                            x$490 = result.copy$default$3();
                            x$491 = result.copy$default$4();
                            x$492 = result.copy$default$5();
                            x$493 = result.copy$default$6();
                            x$494 = result.copy$default$7();
                            x$495 = result.copy$default$8();
                            x$496 = result.copy$default$9();
                            x$497 = result.copy$default$10();
                            x$498 = result.copy$default$11();
                            x$499 = result.copy$default$13();
                            x$500 = result.copy$default$14();
                            x$501 = result.copy$default$15();
                            x$502 = result.copy$default$16();
                            x$503 = result.copy$default$17();
                            x$504 = result.copy$default$18();
                            var6_584 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$488, x$489, x$490, x$491, x$492, x$493, x$494, x$495, x$496, x$497, x$498, x$487, x$499, x$500, x$501, x$502, x$503, x$504));
                        } else {
                            var6_584 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rm.failover"), (Object)opt))), (Object)result);
                        }
                        var3_28 = var6_584;
                        break block12;
                    }
                    if (var13_7 == null) break block42;
                    var588_585 = (String)var13_7._1();
                    opt = (String)var13_7._2();
                    if (!"rm.monitorRefreshMS".equals(var588_585) || (var590_587 = MongoConnection$.MODULE$.IntRe().unapplySeq((CharSequence)opt)).isEmpty() || var590_587.get() == null || ((LinearSeqOptimized)var590_587.get()).lengthCompare(1) != 0) break block42;
                    ms = (String)((LinearSeqOptimized)var590_587.get()).apply(0);
                    MongoConnection$.MODULE$.logger().warn((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$makeOptions$20(), ()Ljava/lang/String;)());
                    var592_589 = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()I, $anonfun$makeOptions$21(java.lang.String ), ()I)((String)ms)).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (I)Z, $anonfun$makeOptions$22(int ), (I)Z)()).toOption();
                    if (var592_589 instanceof Some) {
                        var593_590 = (Some)var592_589;
                        x$505 = interval = BoxesRunTime.unboxToInt((Object)var593_590.value());
                        x$506 = result.copy$default$1();
                        x$507 = result.copy$default$2();
                        x$508 = result.copy$default$3();
                        x$509 = result.copy$default$4();
                        x$510 = result.copy$default$5();
                        x$511 = result.copy$default$6();
                        x$512 = result.copy$default$7();
                        x$513 = result.copy$default$8();
                        x$514 = result.copy$default$9();
                        x$515 = result.copy$default$10();
                        x$516 = result.copy$default$11();
                        x$517 = result.copy$default$12();
                        x$518 = result.copy$default$14();
                        x$519 = result.copy$default$15();
                        x$520 = result.copy$default$16();
                        x$521 = result.copy$default$17();
                        x$522 = result.copy$default$18();
                        var5_610 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$506, x$507, x$508, x$509, x$510, x$511, x$512, x$513, x$514, x$515, x$516, x$517, x$505, x$518, x$519, x$520, x$521, x$522));
                    } else {
                        var5_610 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rm.monitorRefreshMS"), (Object)opt))), (Object)result);
                    }
                    var3_28 = var5_610;
                    break block12;
                }
                if (var13_7 == null) ** GOTO lbl-1000
                var613_611 = (String)var13_7._1();
                opt = (String)var13_7._2();
                if ("heartbeatFrequencyMS".equals(var613_611) && !(var615_613 = MongoConnection$.MODULE$.IntRe().unapplySeq((CharSequence)opt)).isEmpty() && var615_613.get() != null && ((LinearSeqOptimized)var615_613.get()).lengthCompare(1) == 0) {
                    ms = (String)((LinearSeqOptimized)var615_613.get()).apply(0);
                    var617_615 = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()I, $anonfun$makeOptions$23(java.lang.String ), ()I)((String)ms)).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (I)Z, $anonfun$makeOptions$24(int ), (I)Z)()).toOption();
                    if (var617_615 instanceof Some) {
                        var618_616 = (Some)var617_615;
                        x$523 = interval = BoxesRunTime.unboxToInt((Object)var618_616.value());
                        x$524 = result.copy$default$1();
                        x$525 = result.copy$default$2();
                        x$526 = result.copy$default$3();
                        x$527 = result.copy$default$4();
                        x$528 = result.copy$default$5();
                        x$529 = result.copy$default$6();
                        x$530 = result.copy$default$7();
                        x$531 = result.copy$default$8();
                        x$532 = result.copy$default$9();
                        x$533 = result.copy$default$10();
                        x$534 = result.copy$default$11();
                        x$535 = result.copy$default$12();
                        x$536 = result.copy$default$14();
                        x$537 = result.copy$default$15();
                        x$538 = result.copy$default$16();
                        x$539 = result.copy$default$17();
                        x$540 = result.copy$default$18();
                        var4_636 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$524, x$525, x$526, x$527, x$528, x$529, x$530, x$531, x$532, x$533, x$534, x$535, x$523, x$536, x$537, x$538, x$539, x$540));
                    } else {
                        var4_636 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"heartbeatFrequencyMS"), (Object)opt))), (Object)result);
                    }
                    var3_28 = var4_636;
                } else lbl-1000:
                // 2 sources

                {
                    var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported.$plus(var13_7)), (Object)result);
                }
                break block12;
            }
            throw new MatchError((Object)var8_2);
        }
        var2_637 = var3_28;
        return var2_637;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple2 $anonfun$makeOptions$29(Tuple2 x0$2, Tuple2 x1$2) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        block4: {
                            var4_2 = new Tuple2((Object)x0$2, (Object)x1$2);
                            if (var4_2 == null) ** GOTO lbl148
                            var5_3 = (Tuple2)var4_2._1();
                            kv = (Tuple2)var4_2._2();
                            if (var5_3 == null) ** GOTO lbl148
                            unsupported = (List)var5_3._1();
                            result = (MongoConnectionOptions)var5_3._2();
                            var9_7 = kv;
                            if (var9_7 == null) break block4;
                            var10_8 = (String)var9_7._1();
                            var11_9 = (String)var9_7._2();
                            if (!"writeConcernW".equals(var10_8) || !"majority".equals(var11_9)) break block4;
                            x$559 = result.writeConcern().copy(GetLastError$Majority$.MODULE$, result.writeConcern().copy$default$2(), result.writeConcern().copy$default$3(), result.writeConcern().copy$default$4());
                            x$560 = result.copy$default$1();
                            x$561 = result.copy$default$2();
                            x$562 = result.copy$default$3();
                            x$563 = result.copy$default$4();
                            x$564 = result.copy$default$5();
                            x$565 = result.copy$default$6();
                            x$566 = result.copy$default$7();
                            x$567 = result.copy$default$8();
                            x$568 = result.copy$default$9();
                            x$569 = result.copy$default$11();
                            x$570 = result.copy$default$12();
                            x$571 = result.copy$default$13();
                            x$572 = result.copy$default$14();
                            x$573 = result.copy$default$15();
                            x$574 = result.copy$default$16();
                            x$575 = result.copy$default$17();
                            x$576 = result.copy$default$18();
                            var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$560, x$561, x$562, x$563, x$564, x$565, x$566, x$567, x$568, x$559, x$569, x$570, x$571, x$572, x$573, x$574, x$575, x$576));
                            break block5;
                        }
                        if (var9_7 == null) break block6;
                        var30_29 = (String)var9_7._1();
                        var31_30 = (String)var9_7._2();
                        if (!"writeConcernW".equals(var30_29) || (var32_31 = MongoConnection$.MODULE$.IntRe().unapplySeq((CharSequence)var31_30)).isEmpty() || var32_31.get() == null || ((LinearSeqOptimized)var32_31.get()).lengthCompare(1) != 0) break block6;
                        str = (String)((LinearSeqOptimized)var32_31.get()).apply(0);
                        x$577 = result.writeConcern().copy(new GetLastError.WaitForAcknowledgments(new StringOps(Predef$.MODULE$.augmentString(str)).toInt()), result.writeConcern().copy$default$2(), result.writeConcern().copy$default$3(), result.writeConcern().copy$default$4());
                        x$578 = result.copy$default$1();
                        x$579 = result.copy$default$2();
                        x$580 = result.copy$default$3();
                        x$581 = result.copy$default$4();
                        x$582 = result.copy$default$5();
                        x$583 = result.copy$default$6();
                        x$584 = result.copy$default$7();
                        x$585 = result.copy$default$8();
                        x$586 = result.copy$default$9();
                        x$587 = result.copy$default$11();
                        x$588 = result.copy$default$12();
                        x$589 = result.copy$default$13();
                        x$590 = result.copy$default$14();
                        x$591 = result.copy$default$15();
                        x$592 = result.copy$default$16();
                        x$593 = result.copy$default$17();
                        x$594 = result.copy$default$18();
                        var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$578, x$579, x$580, x$581, x$582, x$583, x$584, x$585, x$586, x$577, x$587, x$588, x$589, x$590, x$591, x$592, x$593, x$594));
                        break block5;
                    }
                    if (var9_7 == null) break block7;
                    var52_51 = (String)var9_7._1();
                    tag = (String)var9_7._2();
                    if (!"writeConcernW".equals(var52_51)) break block7;
                    x$595 = result.writeConcern().copy(new GetLastError.TagSet(tag), result.writeConcern().copy$default$2(), result.writeConcern().copy$default$3(), result.writeConcern().copy$default$4());
                    x$596 = result.copy$default$1();
                    x$597 = result.copy$default$2();
                    x$598 = result.copy$default$3();
                    x$599 = result.copy$default$4();
                    x$600 = result.copy$default$5();
                    x$601 = result.copy$default$6();
                    x$602 = result.copy$default$7();
                    x$603 = result.copy$default$8();
                    x$604 = result.copy$default$9();
                    x$605 = result.copy$default$11();
                    x$606 = result.copy$default$12();
                    x$607 = result.copy$default$13();
                    x$608 = result.copy$default$14();
                    x$609 = result.copy$default$15();
                    x$610 = result.copy$default$16();
                    x$611 = result.copy$default$17();
                    x$612 = result.copy$default$18();
                    var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$596, x$597, x$598, x$599, x$600, x$601, x$602, x$603, x$604, x$595, x$605, x$606, x$607, x$608, x$609, x$610, x$611, x$612));
                    break block5;
                }
                if (var9_7 == null) break block8;
                var72_71 = (String)var9_7._1();
                journaled = (String)var9_7._2();
                if (!"writeConcernJ".equals(var72_71)) break block8;
                x$613 = new StringOps(Predef$.MODULE$.augmentString(journaled)).toBoolean();
                x$614 = result.writeConcern().copy$default$1();
                x$615 = result.writeConcern().copy$default$3();
                x$616 = result.writeConcern().copy$default$4();
                x$617 = result.writeConcern().copy(x$614, x$613, x$615, x$616);
                x$618 = result.copy$default$1();
                x$619 = result.copy$default$2();
                x$620 = result.copy$default$3();
                x$621 = result.copy$default$4();
                x$622 = result.copy$default$5();
                x$623 = result.copy$default$6();
                x$624 = result.copy$default$7();
                x$625 = result.copy$default$8();
                x$626 = result.copy$default$9();
                x$627 = result.copy$default$11();
                x$628 = result.copy$default$12();
                x$629 = result.copy$default$13();
                x$630 = result.copy$default$14();
                x$631 = result.copy$default$15();
                x$632 = result.copy$default$16();
                x$633 = result.copy$default$17();
                x$634 = result.copy$default$18();
                var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$618, x$619, x$620, x$621, x$622, x$623, x$624, x$625, x$626, x$617, x$627, x$628, x$629, x$630, x$631, x$632, x$633, x$634));
                break block5;
            }
            if (var9_7 == null) ** GOTO lbl-1000
            var96_95 = (String)var9_7._1();
            var97_96 = (String)var9_7._2();
            if ("writeConcernTimeout".equals(var96_95) && !(var98_97 = MongoConnection$.MODULE$.IntRe().unapplySeq((CharSequence)var97_96)).isEmpty() && var98_97.get() != null && ((LinearSeqOptimized)var98_97.get()).lengthCompare(1) == 0) {
                ms = (String)((LinearSeqOptimized)var98_97.get()).apply(0);
                x$635 = new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(ms)).toInt()));
                x$636 = result.writeConcern().copy$default$1();
                x$637 = result.writeConcern().copy$default$2();
                x$638 = result.writeConcern().copy$default$3();
                x$639 = result.writeConcern().copy(x$636, x$637, x$638, (Option<Object>)x$635);
                x$640 = result.copy$default$1();
                x$641 = result.copy$default$2();
                x$642 = result.copy$default$3();
                x$643 = result.copy$default$4();
                x$644 = result.copy$default$5();
                x$645 = result.copy$default$6();
                x$646 = result.copy$default$7();
                x$647 = result.copy$default$8();
                x$648 = result.copy$default$9();
                x$649 = result.copy$default$11();
                x$650 = result.copy$default$12();
                x$651 = result.copy$default$13();
                x$652 = result.copy$default$14();
                x$653 = result.copy$default$15();
                x$654 = result.copy$default$16();
                x$655 = result.copy$default$17();
                x$656 = result.copy$default$18();
                var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$640, x$641, x$642, x$643, x$644, x$645, x$646, x$647, x$648, x$639, x$649, x$650, x$651, x$652, x$653, x$654, x$655, x$656));
            } else if (var9_7 != null) {
                var123_122 = k = (String)var9_7._1();
                var3_28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported.$colon$colon((Object)var123_122)), (Object)result);
            } else {
                throw new MatchError((Object)var9_7);
lbl148:
                // 2 sources

                throw new MatchError((Object)var4_2);
            }
        }
        var2_123 = var3_28;
        return var2_123;
    }

    private MongoConnection$() {
        MODULE$ = this;
        this.DefaultHost = "localhost";
        this.DefaultPort = 27017;
        this.logger = LazyLogger$.MODULE$.apply("reactivemongo.api.MongoConnection");
        this.IntRe = new StringOps(Predef$.MODULE$.augmentString("^([0-9]+)$")).r();
        this.FailoverRe = new StringOps(Predef$.MODULE$.augmentString("^([^:]+):([0-9]+)x([0-9.]+)$")).r();
    }

    public static final /* synthetic */ Object $anonfun$makeOptions$12$adapted(Tuple2 check$ifrefutable$1) {
        return BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$makeOptions$12(check$ifrefutable$1));
    }
}

