/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.Props$;
import akka.actor.SupervisorStrategy;
import akka.actor.Terminated;
import akka.annotation.InternalApi;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import reactivemongo.api.AsyncDriver$;
import reactivemongo.api.AsyncDriver$AddConnection$;
import reactivemongo.api.AsyncDriver$SupervisorActor$;
import reactivemongo.api.AuthenticationMode;
import reactivemongo.api.FailoverStrategy;
import reactivemongo.api.MongoConnection;
import reactivemongo.api.MongoConnection$;
import reactivemongo.api.MongoConnectionOptions;
import reactivemongo.api.MongoConnectionOptions$;
import reactivemongo.api.ReadConcern;
import reactivemongo.api.ReadPreference;
import reactivemongo.api.ScramSha256Authentication$;
import reactivemongo.api.WriteConcern;
import reactivemongo.api.X509Authentication$;
import reactivemongo.core.AsyncSystemControl;
import reactivemongo.core.SystemControl;
import reactivemongo.core.SystemControl$;
import reactivemongo.core.TimedSystemControl;
import reactivemongo.core.actors.Close;
import reactivemongo.core.actors.Close$;
import reactivemongo.core.actors.Closed$;
import reactivemongo.core.actors.Exceptions;
import reactivemongo.core.actors.MongoDBSystem;
import reactivemongo.core.actors.StandardDBSystem;
import reactivemongo.core.actors.StandardDBSystemWithScramSha256;
import reactivemongo.core.actors.StandardDBSystemWithX509;
import reactivemongo.core.errors.ConnectionException;
import reactivemongo.core.nodeset.Authenticate;
import reactivemongo.util.package$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.ListSet$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\rEg\u0001B*U\u0005eC\u0001\u0002\u0019\u0001\u0003\u0006\u0004%\t\"\u0019\u0005\t]\u0002\u0011\t\u0011)A\u0005E\"Aq\u000e\u0001BC\u0002\u0013E\u0001\u000f\u0003\u0005{\u0001\t\u0005\t\u0015!\u0003r\u0011\u0015Y\b\u0001\"\u0001}\u0011)\t\u0019\u0001\u0001b\u0001\n\u00031\u0016Q\u0001\u0005\t\u0003/\u0001\u0001\u0015!\u0003\u0002\b!A\u0011\u0011\u0004\u0001\u0005\u0002Y\u000bY\u0002C\u0004\u0002$\u0001!\t!!\n\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002f!9\u00111\u0005\u0001\u0005\u0002\u0005M\u0004bBA\u0012\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003G\u0001A\u0011AAB\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003\u0017Cq!a\t\u0001\t\u0003\tI\fC\u0004\u0002$\u0001!\t!!5\t\u0013\u0005u\u0007\u00011A\u0005\n\u0005}\u0007\"CAw\u0001\u0001\u0007I\u0011BAx\u0011!\tY\u0010\u0001Q!\n\u0005\u0005\bbBA\u007f\u0001\u0011\u0005\u0011q \u0005\n\u0005?\u0001\u0011\u0013!C\u0001\u0005CA\u0011Ba\u000e\u0001\u0005\u0004%IA!\u000f\t\u0011\t\r\u0003\u0001)A\u0005\u0005wA\u0011B!\u0012\u0001\u0005\u0004%)Ba\u0012\t\u0011\t%\u0003\u0001)A\u0007\u0003+B!Ba\u0013\u0001\u0005\u0004%)A\u0016B'\u0011!\u0011)\u0006\u0001Q\u0001\u000e\t=\u0003\"\u0003B,\u0001\t\u0007IQ\u0003B-\u0011!\u0011Y\u0007\u0001Q\u0001\u000e\tm\u0003\"\u0003B7\u0001\t\u0007I\u0011\u0002B8\u0011!\u0011\u0019\t\u0001Q\u0001\n\tE\u0004b\u0002BC\u0001\u0011E!q\u0011\u0004\u0007\u0005\u001f\u0003AI!%\t\u0015\u0005m\u0014E!f\u0001\n\u0003\u00119\u0005\u0003\u0006\u0003 \u0006\u0012\t\u0012)A\u0005\u0003+B!\"a\u000f\"\u0005+\u0007I\u0011\u0001BQ\u0011)\u0011\u0019+\tB\tB\u0003%\u0011Q\b\u0005\u000b\u0003W\n#Q3A\u0005\u0002\t\u0015\u0006B\u0003BTC\tE\t\u0015!\u0003\u0002n!Q!\u0011V\u0011\u0003\u0016\u0004%\tA!\u0014\t\u0015\t-\u0016E!E!\u0002\u0013\u0011y\u0005\u0003\u0004|C\u0011\u0005!Q\u0016\u0005\n\u0005w\u000b\u0013\u0011!C\u0001\u0005{C\u0011Ba2\"#\u0003%\tA!3\t\u0013\t5\u0017%%A\u0005\u0002\t=\u0007\"\u0003BjCE\u0005I\u0011\u0001Bk\u0011%\u0011I.II\u0001\n\u0003\u0011Y\u000eC\u0005\u0003`\u0006\n\t\u0011\"\u0011\u0003b\"I!q]\u0011\u0002\u0002\u0013\u0005\u00111\u0004\u0005\n\u0005S\f\u0013\u0011!C\u0001\u0005WD\u0011Ba<\"\u0003\u0003%\tE!=\t\u0013\tm\u0018%!A\u0005\u0002\tu\b\"CB\u0001C\u0005\u0005I\u0011IB\u0002\u0011%\u0019)!IA\u0001\n\u0003\u001a9\u0001C\u0005\u0004\n\u0005\n\t\u0011\"\u0011\u0004\f\u001dI1q\u0002\u0001\u0002\u0002#%1\u0011\u0003\u0004\n\u0005\u001f\u0003\u0011\u0011!E\u0005\u0007'Aaa_\u001d\u0005\u0002\r\u0005\u0002\"CB\u0003s\u0005\u0005IQIB\u0004\u0011%\u0019\u0019#OA\u0001\n\u0003\u001b)\u0003C\u0005\u00040e\n\t\u0011\"!\u00042!A1q\b\u0001\u0005\u0002Q\u001b\tE\u0002\u0004\u0004\\\u000111Q\f\u0005\u000e\u0007KzD\u0011!A\u0003\u0006\u0003\u0005\u000b\u0011B?\t\rm|D\u0011AB4\u0011\u001d\u0019yg\u0010C\u0001\u0007cB\u0011ba\u001f@\u0005\u0004%\ta! \t\u0011\r\u001du\b)A\u0005\u0007\u007fBqa!#@\t\u0003\u0019i\bC\u0004\u0004\f~\"\te!$\b\u000f\r=E\u000b#\u0001\u0004\u0012\u001a11\u000b\u0016E\u0001\u0007'Caa\u001f%\u0005\u0002\rU\u0005bBB\u0012\u0011\u0012\u00051q\u0013\u0005\b\u0007GAE\u0011ABM\u0011\u001d\u0019\u0019\u0003\u0013C\u0001\u0007;C\u0011ba)I\u0005\u0004%Ia!*\t\u0011\r}\u0006\n)A\u0005\u0007OC!b!1I\u0005\u0004%\t\u0001\u0016B8\u0011!\u0019\u0019\r\u0013Q\u0001\n\tE\u0004\"CBc\u0011F\u0005I\u0011ABd\u0011%\u0019Y\rSI\u0001\n\u0003\u0019iMA\u0006Bgft7\r\u0012:jm\u0016\u0014(BA+W\u0003\r\t\u0007/\u001b\u0006\u0002/\u0006i!/Z1di&4X-\\8oO>\u001c\u0001a\u0005\u0002\u00015B\u00111LX\u0007\u00029*\tQ,A\u0003tG\u0006d\u0017-\u0003\u0002`9\n1\u0011I\\=SK\u001a\faaY8oM&<W#\u00012\u0011\u0007m\u001bW-\u0003\u0002e9\n1q\n\u001d;j_:\u0004\"A\u001a7\u000e\u0003\u001dT!\u0001\u00195\u000b\u0005%T\u0017\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003-\f1aY8n\u0013\tiwM\u0001\u0004D_:4\u0017nZ\u0001\bG>tg-[4!\u0003-\u0019G.Y:t\u0019>\fG-\u001a:\u0016\u0003E\u00042aW2s!\t\u0019\b0D\u0001u\u0015\t)h/\u0001\u0003mC:<'\"A<\u0002\t)\fg/Y\u0005\u0003sR\u00141b\u00117bgNdu.\u00193fe\u0006a1\r\\1tg2{\u0017\rZ3sA\u00051A(\u001b8jiz\"B!`@\u0002\u0002A\u0011a\u0010A\u0007\u0002)\"9\u0001-\u0002I\u0001\u0002\u0004\u0011\u0007bB8\u0006!\u0003\u0005\r!]\u0001\u0007gf\u001cH/Z7\u0016\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003'i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u0006C\u000e$xN\u001d\u0006\u0003\u0003#\tA!Y6lC&!\u0011QCA\u0006\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u000fML8\u000f^3nA\u0005qa.^7D_:tWm\u0019;j_:\u001cXCAA\u000f!\rY\u0016qD\u0005\u0004\u0003Ca&aA%oi\u000691m\u001c8oK\u000e$H\u0003BA\u0014\u0003s\u0001b!!\u000b\u00020\u0005MRBAA\u0016\u0015\r\ti\u0003X\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\u0019\u0003W\u0011aAR;ukJ,\u0007c\u0001@\u00026%\u0019\u0011q\u0007+\u0003\u001f5{gnZ8D_:tWm\u0019;j_:Dq!a\u000f\n\u0001\u0004\ti$A\u0003o_\u0012,7\u000f\u0005\u0004\u0002@\u0005=\u0013Q\u000b\b\u0005\u0003\u0003\nYE\u0004\u0003\u0002D\u0005%SBAA#\u0015\r\t9\u0005W\u0001\u0007yI|w\u000e\u001e \n\u0003uK1!!\u0014]\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0015\u0002T\t\u00191+Z9\u000b\u0007\u00055C\f\u0005\u0003\u0002X\u0005}c\u0002BA-\u00037\u00022!a\u0011]\u0013\r\ti\u0006X\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00141\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005uC\f\u0006\u0004\u0002(\u0005\u001d\u0014\u0011\u000e\u0005\b\u0003wQ\u0001\u0019AA\u001f\u0011\u001d\tYG\u0003a\u0001\u0003[\nqa\u001c9uS>t7\u000fE\u0002\u007f\u0003_J1!!\u001dU\u0005YiuN\\4p\u0007>tg.Z2uS>tw\n\u001d;j_:\u001cH\u0003CA\u0014\u0003k\n9(!\u001f\t\u000f\u0005m2\u00021\u0001\u0002>!9\u00111N\u0006A\u0002\u00055\u0004bBA>\u0017\u0001\u0007\u0011QK\u0001\u0005]\u0006lW\r\u0006\u0003\u0002(\u0005}\u0004bBAA\u0019\u0001\u0007\u0011QK\u0001\nkJL7\u000b\u001e:jGR$b!a\n\u0002\u0006\u0006\u001d\u0005bBAA\u001b\u0001\u0007\u0011Q\u000b\u0005\b\u0003wj\u0001\u0019AAE!\u0011Y6-!\u0016\u0016\t\u00055\u0015Q\u0015\u000b\u0007\u0003O\ty)a.\t\u000f\u0005Ee\u00021\u0001\u0002\u0014\u0006I\u0001/\u0019:tK\u0012,&+\u0013\t\u0007\u0003+\u000bY*!)\u000f\u0007y\f9*C\u0002\u0002\u001aR\u000bq\"T8oO>\u001cuN\u001c8fGRLwN\\\u0005\u0005\u0003;\u000byJA\u0002V%&S1!!'U!\u0011\t\u0019+!*\r\u0001\u00119\u0011q\u0015\bC\u0002\u0005%&!\u0001+\u0012\t\u0005-\u0016\u0011\u0017\t\u00047\u00065\u0016bAAX9\n9aj\u001c;iS:<\u0007cA.\u00024&\u0019\u0011Q\u0017/\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002|9\u0001\r!!#\u0016\t\u0005m\u00161\u0019\u000b\t\u0003O\ti,!2\u0002H\"9\u0011\u0011S\bA\u0002\u0005}\u0006CBAK\u00037\u000b\t\r\u0005\u0003\u0002$\u0006\rGaBAT\u001f\t\u0007\u0011\u0011\u0016\u0005\b\u0003wz\u0001\u0019AAE\u0011\u001d\tIm\u0004a\u0001\u0003\u0017\f!b\u001d;sS\u000e$Xj\u001c3f!\rY\u0016QZ\u0005\u0004\u0003\u001fd&a\u0002\"p_2,\u0017M\\\u000b\u0005\u0003'\fY\u000e\u0006\u0003\u0002(\u0005U\u0007bBAI!\u0001\u0007\u0011q\u001b\t\u0007\u0003+\u000bY*!7\u0011\t\u0005\r\u00161\u001c\u0003\b\u0003O\u0003\"\u0019AAU\u0003!\u0019Gn\\:fI\nKXCAAq!\u0015Y\u00161]At\u0013\r\t)\u000f\u0018\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004g\u0006%\u0018bAAvi\n\t2\u000b^1dWR\u0013\u0018mY3FY\u0016lWM\u001c;\u0002\u0019\rdwn]3e\u0005f|F%Z9\u0015\t\u0005E\u0018q\u001f\t\u00047\u0006M\u0018bAA{9\n!QK\\5u\u0011%\tIPEA\u0001\u0002\u0004\t\t/A\u0002yIE\n\u0011b\u00197pg\u0016$')\u001f\u0011\u0002\u000b\rdwn]3\u0015\t\t\u0005!q\u0002\u000b\u0005\u0005\u0007\u0011)\u0001\u0005\u0004\u0002*\u0005=\u0012\u0011\u001f\u0005\b\u0005\u000f!\u00029\u0001B\u0005\u0003\t)7\r\u0005\u0003\u0002*\t-\u0011\u0002\u0002B\u0007\u0003W\u0011\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\u0013\tEA\u0003%AA\u0002\tM\u0011a\u0002;j[\u0016|W\u000f\u001e\t\u0005\u0005+\u0011Y\"\u0004\u0002\u0003\u0018)!!\u0011DA\u0016\u0003!!WO]1uS>t\u0017\u0002\u0002B\u000f\u0005/\u0011aBR5oSR,G)\u001e:bi&|g.A\bdY>\u001cX\r\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\u0019C\u000b\u0003\u0003\u0014\t\u00152F\u0001B\u0014!\u0011\u0011ICa\r\u000e\u0005\t-\"\u0002\u0002B\u0017\u0005_\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tEB,\u0001\u0006b]:|G/\u0019;j_:LAA!\u000e\u0003,\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0017ML8\u000f^3n\u00072|7/Z\u000b\u0003\u0005w\u0001ra\u0017B\u001f\u0005\u0003\u0012\u0019!C\u0002\u0003@q\u0013\u0011BR;oGRLwN\\\u0019\u0011\tm\u001b'1C\u0001\rgf\u001cH/Z7DY>\u001cX\rI\u0001\u000fgV\u0004XM\u001d<jg>\u0014h*Y7f+\t\t)&A\btkB,'O^5t_Jt\u0015-\\3!\u0003=\u0019X\u000f]3sm&\u001cxN]!di>\u0014XC\u0001B(!\u0011\tIA!\u0015\n\t\tM\u00131\u0002\u0002\t\u0003\u000e$xN\u001d*fM\u0006\u00012/\u001e9feZL7o\u001c:BGR|'\u000fI\u0001\u0013G>tg.Z2uS>tWj\u001c8ji>\u00148/\u0006\u0002\u0003\\AA!Q\fB4\u0005\u001f\n\u0019$\u0004\u0002\u0003`)!!\u0011\rB2\u0003\u001diW\u000f^1cY\u0016T1A!\u001a]\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005S\u0012yFA\u0002NCB\f1cY8o]\u0016\u001cG/[8o\u001b>t\u0017\u000e^8sg\u0002\n\u0011cY8o]\u0016\u001cG/[8o\u0007>,h\u000e^3s+\t\u0011\t\b\u0005\u0003\u0003t\t}TB\u0001B;\u0015\u0011\u00119H!\u001f\u0002\r\u0005$x.\\5d\u0015\u0011\tiCa\u001f\u000b\u0007\tud/\u0001\u0003vi&d\u0017\u0002\u0002BA\u0005k\u0012!\"\u0011;p[&\u001cGj\u001c8h\u0003I\u0019wN\u001c8fGRLwN\\\"pk:$XM\u001d\u0011\u0002\u001b\u0005\u001c8nQ8o]\u0016\u001cG/[8o)!\t9C!#\u0003\f\n5\u0005bBA\u001eA\u0001\u0007\u0011Q\b\u0005\b\u0003W\u0002\u0003\u0019AA7\u0011\u001d\tY\b\ta\u0001\u0003\u0013\u0013Q\"\u00113e\u0007>tg.Z2uS>t7CB\u0011[\u0005'\u0013I\nE\u0002\\\u0005+K1Aa&]\u0005\u001d\u0001&o\u001c3vGR\u00042a\u0017BN\u0013\r\u0011i\n\u0018\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006]\u0006lW\rI\u000b\u0003\u0003{\taA\\8eKN\u0004SCAA7\u0003!y\u0007\u000f^5p]N\u0004\u0013aC7p]\u001e|7/_:uK6\fA\"\\8oO>\u001c\u0018p\u001d;f[\u0002\"\"Ba,\u00034\nU&q\u0017B]!\r\u0011\t,I\u0007\u0002\u0001!9\u00111\u0010\u0016A\u0002\u0005U\u0003bBA\u001eU\u0001\u0007\u0011Q\b\u0005\b\u0003WR\u0003\u0019AA7\u0011\u001d\u0011IK\u000ba\u0001\u0005\u001f\nAaY8qsRQ!q\u0016B`\u0005\u0003\u0014\u0019M!2\t\u0013\u0005m4\u0006%AA\u0002\u0005U\u0003\"CA\u001eWA\u0005\t\u0019AA\u001f\u0011%\tYg\u000bI\u0001\u0002\u0004\ti\u0007C\u0005\u0003*.\u0002\n\u00111\u0001\u0003P\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BfU\u0011\t)F!\n\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u001b\u0016\u0005\u0003{\u0011)#\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t]'\u0006BA7\u0005K\tabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0003^*\"!q\nB\u0013\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!1\u001d\t\u0004g\n\u0015\u0018bAA1i\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAY\u0005[D\u0011\"!?3\u0003\u0003\u0005\r!!\b\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa=\u0011\r\tU(q_AY\u001b\t\u0011\u0019'\u0003\u0003\u0003z\n\r$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a3\u0003\u0000\"I\u0011\u0011 \u001b\u0002\u0002\u0003\u0007\u0011\u0011W\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011QD\u0001\ti>\u001cFO]5oOR\u0011!1]\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005-7Q\u0002\u0005\n\u0003s<\u0014\u0011!a\u0001\u0003c\u000bQ\"\u00113e\u0007>tg.Z2uS>t\u0007c\u0001BYsM)\u0011h!\u0006\u0003\u001aBq1qCB\u000f\u0003+\ni$!\u001c\u0003P\t=VBAB\r\u0015\r\u0019Y\u0002X\u0001\beVtG/[7f\u0013\u0011\u0019yb!\u0007\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0006\u0002\u0004\u0012\u0005)\u0011\r\u001d9msRQ!qVB\u0014\u0007S\u0019Yc!\f\t\u000f\u0005mD\b1\u0001\u0002V!9\u00111\b\u001fA\u0002\u0005u\u0002bBA6y\u0001\u0007\u0011Q\u000e\u0005\b\u0005Sc\u0004\u0019\u0001B(\u0003\u001d)h.\u00199qYf$Baa\r\u0004<A!1lYB\u001b!-Y6qGA+\u0003{\tiGa\u0014\n\u0007\reBL\u0001\u0004UkBdW\r\u000e\u0005\n\u0007{i\u0014\u0011!a\u0001\u0005_\u000b1\u0001\u001f\u00131\u0003A\tG\rZ\"p]:,7\r^5p]6\u001bx\r\u0006\u0006\u00022\u000e\r3QIB$\u0007\u0013Bq!a\u001f?\u0001\u0004\t)\u0006C\u0004\u0002<y\u0002\r!!\u0010\t\u000f\u0005-d\b1\u0001\u0002n!9!\u0011\u0016 A\u0002\t=\u0003f\u0002 \u0004N\rM3Q\u000b\t\u0004g\u000e=\u0013bAB)i\n\u00012+\u001e9qe\u0016\u001c8oV1s]&twm]\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0007/\n#a!\u0017\u0002%5+G\u000f[8e%\u0016$XO\u001d8j]\u001e\fe.\u001f\u0002\u0010'V\u0004XM\u001d<jg>\u0014\u0018i\u0019;peN!qHWB0!\u0011\tIa!\u0019\n\t\r\r\u00141\u0002\u0002\u0006\u0003\u000e$xN]\u00016e\u0016\f7\r^5wK6|gnZ8%CBLG%Q:z]\u000e$%/\u001b<fe\u0012\u001aV\u000f]3sm&\u001cxN]!di>\u0014H\u0005\n3sSZ,'\u000f\u0006\u0003\u0004j\r-\u0004c\u0001BY\u007f!11QN!A\u0002u\fa\u0001\u001a:jm\u0016\u0014\u0018aB5t\u000b6\u0004H/_\u000b\u0003\u0003\u0017D3AQB;!\rY6qO\u0005\u0004\u0007sb&AB5oY&tW-A\u0004sK\u000e,\u0017N^3\u0016\u0005\r}\u0004\u0003BBA\u0007\u0007k\u0011aP\u0005\u0005\u0007\u000b\u001b\tGA\u0004SK\u000e,\u0017N^3\u0002\u0011I,7-Z5wK\u0002\nqa\u00197pg&tw-\u0001\u0005q_N$8\u000b^8q)\t\t\t0A\u0006Bgft7\r\u0012:jm\u0016\u0014\bC\u0001@I'\tA%\f\u0006\u0002\u0004\u0012R\tQ\u0010F\u0002~\u00077CQ\u0001Y&A\u0002\u0015$R!`BP\u0007CCQ\u0001\u0019'A\u0002\u0015DQa\u001c'A\u0002I\fa\u0001\\8hO\u0016\u0014XCABT!\u0011\u0019Ik!/\u000f\t\r-61\u0017\b\u0005\u0007[\u001b\tL\u0004\u0003\u0002D\r=\u0016\"A,\n\u0007\tud+\u0003\u0003\u00046\u000e]\u0016A\u0003'bufdunZ4fe*\u0019!Q\u0010,\n\t\rm6Q\u0018\u0002\u000b\u0019\u0006T\u0018\u0010T8hO\u0016\u0014(\u0002BB[\u0007o\u000bq\u0001\\8hO\u0016\u0014\b%A\u0004d_VtG/\u001a:\u0002\u0011\r|WO\u001c;fe\u0002\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nTCABeU\r\u0011'QE\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r='fA9\u0003&\u0001")
public final class AsyncDriver {
    private volatile AsyncDriver$AddConnection$ AddConnection$module;
    private final Option<Config> config;
    private final Option<ClassLoader> classLoader;
    private final ActorSystem system;
    private StackTraceElement[] closedBy;
    private final Function1<Option<FiniteDuration>, Future<BoxedUnit>> systemClose;
    private final String supervisorName;
    private final ActorRef supervisorActor;
    private final Map<ActorRef, MongoConnection> connectionMonitors;
    private final AtomicLong connectionCounter;

    public static Option<ClassLoader> $lessinit$greater$default$2() {
        return AsyncDriver$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Config> $lessinit$greater$default$1() {
        return AsyncDriver$.MODULE$.$lessinit$greater$default$1();
    }

    public static AsyncDriver apply(Config config, ClassLoader classLoader) {
        return AsyncDriver$.MODULE$.apply(config, classLoader);
    }

    public static AsyncDriver apply(Config config) {
        return AsyncDriver$.MODULE$.apply(config);
    }

    public static AsyncDriver apply() {
        return AsyncDriver$.MODULE$.apply();
    }

    private AsyncDriver$AddConnection$ AddConnection() {
        if (this.AddConnection$module == null) {
            this.AddConnection$lzycompute$1();
        }
        return this.AddConnection$module;
    }

    public Option<Config> config() {
        return this.config;
    }

    public Option<ClassLoader> classLoader() {
        return this.classLoader;
    }

    public ActorSystem system() {
        return this.system;
    }

    public int numConnections() {
        return this.connectionMonitors().size();
    }

    public Future<MongoConnection> connect(Seq<String> nodes) {
        return this.askConnection(nodes, MongoConnectionOptions$.MODULE$.default(), (Option<String>)Option$.MODULE$.empty());
    }

    public Future<MongoConnection> connect(Seq<String> nodes, MongoConnectionOptions options) {
        return this.askConnection(nodes, options, (Option<String>)Option$.MODULE$.empty());
    }

    public Future<MongoConnection> connect(Seq<String> nodes, MongoConnectionOptions options, String name) {
        return this.askConnection(nodes, options, (Option<String>)new Some((Object)name));
    }

    public Future<MongoConnection> connect(String uriStrict) {
        return this.connect(uriStrict, (Option<String>)None$.MODULE$);
    }

    public Future<MongoConnection> connect(String uriStrict, Option<String> name) {
        return MongoConnection$.MODULE$.fromString(uriStrict, AsyncDriver.ec$1()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> this.connect((MongoConnection.URI)x$1, name), AsyncDriver.ec$1());
    }

    public <T> Future<MongoConnection> connect(MongoConnection.URI<T> parsedURI, Option<String> name) {
        return this.connect(parsedURI, name, true);
    }

    public <T> Future<MongoConnection> connect(MongoConnection.URI<T> parsedURI, Option<String> name, boolean strictMode) {
        Future<MongoConnection> future;
        if (strictMode && parsedURI.ignoredOptions().nonEmpty()) {
            future = Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(49).append("The connection URI contains unsupported options: ").append(parsedURI.ignoredOptions().mkString(", ")).toString()));
        } else {
            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$1 = parsedURI.options().credentials();
            int x$2 = parsedURI.options().copy$default$1();
            Option<String> x$3 = parsedURI.options().copy$default$2();
            boolean x$4 = parsedURI.options().copy$default$3();
            boolean x$5 = parsedURI.options().copy$default$4();
            AuthenticationMode x$6 = parsedURI.options().copy$default$5();
            boolean x$7 = parsedURI.options().copy$default$6();
            boolean x$8 = parsedURI.options().copy$default$7();
            int x$9 = parsedURI.options().copy$default$8();
            Option<Object> x$10 = parsedURI.options().copy$default$9();
            int x$11 = parsedURI.options().copy$default$10();
            WriteConcern x$12 = parsedURI.options().copy$default$11();
            ReadPreference x$13 = parsedURI.options().copy$default$12();
            FailoverStrategy x$14 = parsedURI.options().copy$default$13();
            int x$15 = parsedURI.options().copy$default$14();
            int x$16 = parsedURI.options().copy$default$15();
            int x$17 = parsedURI.options().copy$default$16();
            Option<MongoConnectionOptions.KeyStore> x$18 = parsedURI.options().copy$default$18();
            ReadConcern x$19 = parsedURI.options().copy$default$19();
            Option<String> x$20 = parsedURI.options().copy$default$20();
            future = this.askConnection((Seq<String>)((SetLike)parsedURI.hosts().map((Function1 & Serializable & scala.Serializable)h -> new StringBuilder(0).append((String)h._1()).append(':').append(h._2$mcI$sp()).toString(), ListSet$.MODULE$.canBuildFrom())).toSeq(), parsedURI.options().copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$1, x$18, x$19, x$20), name);
        }
        return future;
    }

    public <T> Future<MongoConnection> connect(MongoConnection.URI<T> parsedURI) {
        return this.connect(parsedURI, (Option<String>)None$.MODULE$);
    }

    private StackTraceElement[] closedBy() {
        return this.closedBy;
    }

    private void closedBy_$eq(StackTraceElement[] x$1) {
        this.closedBy = x$1;
    }

    public Future<BoxedUnit> close(FiniteDuration timeout, ExecutionContext ec) {
        Future future;
        boolean bl;
        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("[").append(this.supervisorName()).append("] Closing instance of ReactiveMongo driver").toString());
        StackTraceElement[] callerSTE = (StackTraceElement[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace())).drop(3))).take(3);
        Function1<Option<FiniteDuration>, Future<BoxedUnit>> function1 = this.systemClose();
        synchronized (function1) {
            boolean bl2;
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.closedBy())).isEmpty()) {
                this.closedBy_$eq(callerSTE);
                bl2 = false;
            } else {
                bl2 = true;
            }
            bl = bl2;
        }
        boolean alreadyClosing = bl;
        if (alreadyClosing) {
            AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("System already closed: ").append(this.supervisorName()).toString());
            future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        } else {
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.supervisorActor());
            Close x$1 = AsyncDriver.msg$1(timeout);
            Timeout x$22 = new Timeout(timeout);
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            future = AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$22, x$3).recover((PartialFunction)new scala.Serializable(this, callerSTE){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AsyncDriver $outer;
                private final StackTraceElement[] callerSTE$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    A1.setStackTrace(this.callerSTE$1);
                    AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("[").append($this.$outer.supervisorName()).append("] Fails to close connections within timeout. Continuing closing of ReactiveMongo driver anyway.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> A1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return (B1)boxedUnit;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = true;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.callerSTE$1 = callerSTE$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(reactivemongo.api.AsyncDriver$$anonfun$close$3 ), $anonfun$applyOrElse$2(java.lang.Throwable )}, serializedLambda);
                }
            }, ec).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> (Future)this.systemClose().apply((Object)new Some((Object)timeout)), ec);
        }
        return future;
    }

    public FiniteDuration close$default$1() {
        return FiniteDuration$.MODULE$.apply(2L, TimeUnit.SECONDS);
    }

    private Function1<Option<FiniteDuration>, Future<BoxedUnit>> systemClose() {
        return this.systemClose;
    }

    public final String supervisorName() {
        return this.supervisorName;
    }

    public final ActorRef supervisorActor() {
        return this.supervisorActor;
    }

    public final Map<ActorRef, MongoConnection> connectionMonitors() {
        return this.connectionMonitors;
    }

    private AtomicLong connectionCounter() {
        return this.connectionCounter;
    }

    public Future<MongoConnection> askConnection(Seq<String> nodes, MongoConnectionOptions options, Option<String> name) {
        Future future;
        if (nodes.isEmpty()) {
            future = Future$.MODULE$.failed((Throwable)new ConnectionException("No node specified"));
        } else {
            MongoConnectionOptions mongoConnectionOptions;
            LazyRef dbsystem$lzy = new LazyRef();
            String nm = (String)name.getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Connection-").append(this.connectionCounter().incrementAndGet()).toString());
            Seq authentications = ((TraversableOnce)options.credentials().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String db = (String)tuple2._1();
                MongoConnectionOptions.Credential c = (MongoConnectionOptions.Credential)tuple2._2();
                Authenticate authenticate = new Authenticate(db, c.user(), c.password());
                return authenticate;
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            Option<String> option = options.appName();
            if (option instanceof Some) {
                mongoConnectionOptions = options;
            } else {
                Some x$1 = new Some((Object)new StringBuilder(1).append(this.supervisorName()).append("/").append(nm).toString());
                int x$2 = options.copy$default$1();
                Option<String> x$3 = options.copy$default$2();
                boolean x$4 = options.copy$default$3();
                boolean x$5 = options.copy$default$4();
                AuthenticationMode x$6 = options.copy$default$5();
                boolean x$7 = options.copy$default$6();
                boolean x$8 = options.copy$default$7();
                int x$9 = options.copy$default$8();
                Option<Object> x$10 = options.copy$default$9();
                int x$11 = options.copy$default$10();
                WriteConcern x$12 = options.copy$default$11();
                ReadPreference x$13 = options.copy$default$12();
                FailoverStrategy x$14 = options.copy$default$13();
                int x$15 = options.copy$default$14();
                int x$16 = options.copy$default$15();
                int x$17 = options.copy$default$16();
                scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$18 = options.copy$default$17();
                Option<MongoConnectionOptions.KeyStore> x$19 = options.copy$default$18();
                ReadConcern x$20 = options.copy$default$19();
                mongoConnectionOptions = options.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, (Option<String>)x$1);
            }
            MongoConnectionOptions opts = mongoConnectionOptions;
            ActorRef mongosystem = this.system().actorOf(Props$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.dbsystem$1(dbsystem$lzy, opts, nm, nodes, authentications), ClassTag$.MODULE$.apply(MongoDBSystem.class)), nm);
            AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("[").append(this.supervisorName()).append("] Creating connection: ").append(nm).toString());
            future = this.connection$1(nm, nodes, opts, mongosystem).mapTo(ClassTag$.MODULE$.apply(MongoConnection.class)).map((Function1 & Serializable & scala.Serializable)c -> {
                c.history_$eq((Function0<Exceptions.InternalState>)(Function0 & Serializable & scala.Serializable)() -> this.dbsystem$1(dbsystem$lzy, opts, nm, nodes, authentications).internalState());
                return c;
            }, (ExecutionContext)this.system().dispatcher());
        }
        return future;
    }

    public Object addConnectionMsg(String name, Seq<String> nodes, MongoConnectionOptions options, ActorRef mongosystem) {
        return new AddConnection(this, name, nodes, options, mongosystem);
    }

    private final void AddConnection$lzycompute$1() {
        AsyncDriver asyncDriver = this;
        synchronized (asyncDriver) {
            if (this.AddConnection$module == null) {
                this.AddConnection$module = new AsyncDriver$AddConnection$(this);
            }
        }
    }

    public static final /* synthetic */ Config $anonfun$system$1() {
        return ConfigFactory.load();
    }

    public static final /* synthetic */ String $anonfun$system$2() {
        return "No mongo-async-driver configuration found";
    }

    private static final ExecutionContext ec$1() {
        return package$.MODULE$.sameThreadExecutionContext();
    }

    private static final Close msg$1(FiniteDuration timeout$1) {
        return Close$.MODULE$.apply("AsyncDriver.close", timeout$1);
    }

    public static final /* synthetic */ Future $anonfun$systemClose$1(Function1 close$1, Option timeout) {
        Future future;
        Try try_ = (Try)close$1.apply((Object)timeout);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable cause = failure.exception();
            future = Future$.MODULE$.failed(cause);
        } else {
            future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        return future;
    }

    public static final /* synthetic */ Future $anonfun$systemClose$2(Function0 close$2, Option x$3) {
        return (Future)close$2.apply();
    }

    public static final /* synthetic */ Future $anonfun$systemClose$3(Throwable cause$1, Option x$4) {
        return Future$.MODULE$.failed(cause$1);
    }

    public static final /* synthetic */ SupervisorActor $anonfun$supervisorActor$1(AsyncDriver $this) {
        return new SupervisorActor($this, $this);
    }

    private final /* synthetic */ MongoDBSystem dbsystem$lzycompute$1(LazyRef dbsystem$lzy$1, MongoConnectionOptions opts$1, String nm$1, Seq nodes$1, Seq authentications$1) {
        MongoDBSystem mongoDBSystem;
        LazyRef lazyRef = dbsystem$lzy$1;
        synchronized (lazyRef) {
            MongoDBSystem mongoDBSystem2;
            if (dbsystem$lzy$1.initialized()) {
                mongoDBSystem2 = (MongoDBSystem)dbsystem$lzy$1.value();
            } else {
                AuthenticationMode authenticationMode = opts$1.authenticationMechanism();
                MongoDBSystem mongoDBSystem3 = X509Authentication$.MODULE$.equals(authenticationMode) ? new StandardDBSystemWithX509(this.supervisorName(), nm$1, (Seq<String>)nodes$1, (Seq<Authenticate>)authentications$1, opts$1) : (ScramSha256Authentication$.MODULE$.equals(authenticationMode) ? new StandardDBSystemWithScramSha256(this.supervisorName(), nm$1, (Seq<String>)nodes$1, (Seq<Authenticate>)authentications$1, opts$1) : new StandardDBSystem(this.supervisorName(), nm$1, (Seq<String>)nodes$1, (Seq<Authenticate>)authentications$1, opts$1));
                mongoDBSystem2 = (MongoDBSystem)dbsystem$lzy$1.initialize((Object)mongoDBSystem3);
            }
            mongoDBSystem = mongoDBSystem2;
        }
        return mongoDBSystem;
    }

    private final MongoDBSystem dbsystem$1(LazyRef dbsystem$lzy$1, MongoConnectionOptions opts$1, String nm$1, Seq nodes$1, Seq authentications$1) {
        return dbsystem$lzy$1.initialized() ? (MongoDBSystem)dbsystem$lzy$1.value() : this.dbsystem$lzycompute$1(dbsystem$lzy$1, opts$1, nm$1, nodes$1, authentications$1);
    }

    private static final Timeout timeout$2(MongoConnectionOptions opts$1) {
        return opts$1.connectTimeoutMS() > 0 ? Timeout$.MODULE$.apply((long)opts$1.connectTimeoutMS(), TimeUnit.MILLISECONDS) : Timeout$.MODULE$.apply(10000L, TimeUnit.MILLISECONDS);
    }

    private final Future connection$1(String nm$1, Seq nodes$1, MongoConnectionOptions opts$1, ActorRef mongosystem$1) {
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.supervisorActor());
        AddConnection x$1 = new AddConnection(this, nm$1, (Seq<String>)nodes$1, opts$1, mongosystem$1);
        Timeout x$2 = AsyncDriver.timeout$2(opts$1);
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        return AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$2, x$3);
    }

    /*
     * Unable to fully structure code
     */
    public AsyncDriver(Option<Config> config, Option<ClassLoader> classLoader) {
        this.config = config;
        this.classLoader = classLoader;
        super();
        reference = (Config)config.getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$system$1(), ()Lcom/typesafe/config/Config;)());
        if (!reference.hasPath("mongo-async-driver")) {
            AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$system$2(), ()Ljava/lang/String;)());
            v0 = ConfigFactory.empty();
        } else {
            v0 = reference.getConfig("mongo-async-driver");
        }
        cfg = v0;
        this.system = ActorSystem$.MODULE$.apply("reactivemongo", (Option)new Some((Object)cfg), classLoader, ActorSystem$.MODULE$.apply$default$4());
        this.closedBy = (StackTraceElement[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StackTraceElement.class));
        var6_5 = false;
        var7_6 = null;
        var8_7 = SystemControl$.MODULE$.apply(this.system());
        if (!(var8_7 instanceof Success)) ** GOTO lbl-1000
        var6_5 = true;
        var7_6 = (Success)var8_7;
        var9_8 = (SystemControl)var7_6.value();
        if (var9_8 instanceof TimedSystemControl) {
            var10_9 = (TimedSystemControl)var9_8;
            close = var10_9.close();
            var3_11 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$systemClose$1(scala.Function1 scala.Option ), (Lscala/Option;)Lscala/concurrent/Future;)(close);
        } else if (var6_5 && (var12_12 = (SystemControl)var7_6.value()) instanceof AsyncSystemControl) {
            var13_13 = (AsyncSystemControl)var12_12;
            close = var13_13.close();
            var3_11 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$systemClose$2(scala.Function0 scala.Option ), (Lscala/Option;)Lscala/concurrent/Future;)(close);
        } else if (var8_7 instanceof Failure) {
            var15_15 = (Failure)var8_7;
            cause = var15_15.exception();
            var3_11 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$systemClose$3(java.lang.Throwable scala.Option ), (Lscala/Option;)Lscala/concurrent/Future;)((Throwable)cause);
        } else {
            throw new MatchError(var8_7);
        }
        this.systemClose = var3_11;
        this.supervisorName = new StringBuilder(11).append("Supervisor-").append(AsyncDriver$.MODULE$.counter().incrementAndGet()).toString();
        this.supervisorActor = this.system().actorOf(Props$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$supervisorActor$1(reactivemongo.api.AsyncDriver ), ()Lreactivemongo/api/AsyncDriver$SupervisorActor;)((AsyncDriver)this), ClassTag$.MODULE$.apply(SupervisorActor.class)), this.supervisorName());
        this.connectionMonitors = Map$.MODULE$.empty();
        this.connectionCounter = new AtomicLong(0L);
    }

    public class AddConnection
    implements Product,
    scala.Serializable {
        private final String name;
        private final Seq<String> nodes;
        private final MongoConnectionOptions options;
        private final ActorRef mongosystem;
        public final /* synthetic */ AsyncDriver $outer;

        public String name() {
            return this.name;
        }

        public Seq<String> nodes() {
            return this.nodes;
        }

        public MongoConnectionOptions options() {
            return this.options;
        }

        public ActorRef mongosystem() {
            return this.mongosystem;
        }

        public AddConnection copy(String name, Seq<String> nodes, MongoConnectionOptions options, ActorRef mongosystem) {
            return new AddConnection(this.reactivemongo$api$AsyncDriver$AddConnection$$$outer(), name, nodes, options, mongosystem);
        }

        public String copy$default$1() {
            return this.name();
        }

        public Seq<String> copy$default$2() {
            return this.nodes();
        }

        public MongoConnectionOptions copy$default$3() {
            return this.options();
        }

        public ActorRef copy$default$4() {
            return this.mongosystem();
        }

        public String productPrefix() {
            return "AddConnection";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.name();
                    break;
                }
                case 1: {
                    object = this.nodes();
                    break;
                }
                case 2: {
                    object = this.options();
                    break;
                }
                case 3: {
                    object = this.mongosystem();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof AddConnection;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof AddConnection)) return false;
            if (((AddConnection)object).reactivemongo$api$AsyncDriver$AddConnection$$$outer() != this.reactivemongo$api$AsyncDriver$AddConnection$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            AddConnection addConnection = (AddConnection)x$1;
            String string = this.name();
            String string2 = addConnection.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Seq<String> seq = this.nodes();
            Seq<String> seq2 = addConnection.nodes();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            MongoConnectionOptions mongoConnectionOptions = this.options();
            MongoConnectionOptions mongoConnectionOptions2 = addConnection.options();
            if (mongoConnectionOptions == null) {
                if (mongoConnectionOptions2 != null) {
                    return false;
                }
            } else if (!((Object)mongoConnectionOptions).equals(mongoConnectionOptions2)) return false;
            ActorRef actorRef = this.mongosystem();
            ActorRef actorRef2 = addConnection.mongosystem();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            if (!addConnection.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ AsyncDriver reactivemongo$api$AsyncDriver$AddConnection$$$outer() {
            return this.$outer;
        }

        public AddConnection(AsyncDriver $outer, String name, Seq<String> nodes, MongoConnectionOptions options, ActorRef mongosystem) {
            this.name = name;
            this.nodes = nodes;
            this.options = options;
            this.mongosystem = mongosystem;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public final class SupervisorActor
    implements Actor {
        public final AsyncDriver reactivemongo$api$AsyncDriver$SupervisorActor$$driver;
        private final PartialFunction<Object, BoxedUnit> receive;
        private final ActorContext context;
        private final ActorRef self;
        private final /* synthetic */ AsyncDriver $outer;

        public final ActorRef sender() {
            return Actor.sender$((Actor)this);
        }

        @InternalApi
        public void aroundReceive(PartialFunction<Object, BoxedUnit> receive, Object msg) {
            Actor.aroundReceive$((Actor)this, receive, (Object)msg);
        }

        @InternalApi
        public void aroundPreStart() {
            Actor.aroundPreStart$((Actor)this);
        }

        @InternalApi
        public void aroundPostStop() {
            Actor.aroundPostStop$((Actor)this);
        }

        @InternalApi
        public void aroundPreRestart(Throwable reason, Option<Object> message) {
            Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
        }

        @InternalApi
        public void aroundPostRestart(Throwable reason) {
            Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
        }

        public SupervisorStrategy supervisorStrategy() {
            return Actor.supervisorStrategy$((Actor)this);
        }

        public void preStart() throws Exception {
            Actor.preStart$((Actor)this);
        }

        public void preRestart(Throwable reason, Option<Object> message) throws Exception {
            Actor.preRestart$((Actor)this, (Throwable)reason, message);
        }

        public void postRestart(Throwable reason) throws Exception {
            Actor.postRestart$((Actor)this, (Throwable)reason);
        }

        public void unhandled(Object message) {
            Actor.unhandled$((Actor)this, (Object)message);
        }

        public ActorContext context() {
            return this.context;
        }

        public final ActorRef self() {
            return this.self;
        }

        public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
            this.context = x$1;
        }

        public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
            this.self = x$1;
        }

        public boolean isEmpty() {
            return this.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.connectionMonitors().isEmpty();
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return this.receive;
        }

        public PartialFunction<Object, BoxedUnit> closing() {
            Queue waitingForClose = (Queue)Queue$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ActorRef[]{this.sender()}));
            return new scala.Serializable(this, waitingForClose){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SupervisorActor $outer;
                private final Queue waitingForClose$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Option<String> option;
                    Object object;
                    boolean bl = false;
                    Close close2 = null;
                    A1 A1 = x1;
                    if (A1 instanceof AddConnection && ((AddConnection)A1).reactivemongo$api$AsyncDriver$AddConnection$$$outer() == this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer()) {
                        AddConnection addConnection = (AddConnection)A1;
                        String name = addConnection.name();
                        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Refusing to add connection while the driver is closing: ").append(name).toString());
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    if (A1 instanceof Terminated) {
                        Terminated terminated = (Terminated)A1;
                        ActorRef actor = terminated.actor();
                        this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.connectionMonitors().remove((Object)actor).foreach((Function1 & Serializable & scala.Serializable)con -> {
                            SupervisorActor$$anonfun$closing$1.$anonfun$applyOrElse$8(this, con);
                            return BoxedUnit.UNIT;
                        });
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    if (A1 instanceof Close) {
                        bl = true;
                        close2 = (Close)A1;
                        Option<String> option2 = Close$.MODULE$.unapply(close2);
                        if (!option2.isEmpty()) {
                            String src = (String)option2.get();
                            if (this.$outer.isEmpty()) {
                                AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Close the supervisor for ").append(src).toString());
                                akka.actor.package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)Closed$.MODULE$, this.$outer.self());
                                object = BoxedUnit.UNIT;
                                return (B1)object;
                            }
                        }
                    }
                    if (bl && !(option = Close$.MODULE$.unapply(close2)).isEmpty()) {
                        String src = (String)option.get();
                        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Close request received from ").append(src).append(", but already closing.").toString());
                        this.waitingForClose$1.$plus$eq((Object)this.$outer.sender());
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(Object x1) {
                    boolean bl = false;
                    Close close2 = null;
                    Object object = x1;
                    if (object instanceof AddConnection && ((AddConnection)object).reactivemongo$api$AsyncDriver$AddConnection$$$outer() == this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer()) {
                        return true;
                    }
                    if (object instanceof Terminated) {
                        return true;
                    }
                    if (object instanceof Close) {
                        bl = true;
                        close2 = (Close)object;
                        Option<String> option = Close$.MODULE$.unapply(close2);
                        if (!option.isEmpty() && this.$outer.isEmpty()) {
                            return true;
                        }
                    }
                    if (!bl) return false;
                    Option<String> option = Close$.MODULE$.unapply(close2);
                    if (option.isEmpty()) return false;
                    return true;
                }

                public static final /* synthetic */ boolean $anonfun$applyOrElse$10(ActorRef x$6) {
                    return true;
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$11(SupervisorActor$$anonfun$closing$1 $this, ActorRef x$7) {
                    akka.actor.package$.MODULE$.actorRef2Scala(x$7).$bang((Object)Closed$.MODULE$, $this.$outer.self());
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$8(SupervisorActor$$anonfun$closing$1 $this, MongoConnection con) {
                    block0: {
                        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Connection is terminated: ").append(con.name()).toString());
                        if (!$this.$outer.isEmpty()) break block0;
                        $this.$outer.context().stop($this.$outer.self());
                        $this.waitingForClose$1.dequeueAll((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SupervisorActor$$anonfun$closing$1.$anonfun$applyOrElse$10(x$6))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                            SupervisorActor$$anonfun$closing$1.$anonfun$applyOrElse$11($this, x$7);
                            return BoxedUnit.UNIT;
                        });
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.waitingForClose$1 = waitingForClose$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$7(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$closing$1 java.lang.String ), $anonfun$applyOrElse$8$adapted(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$closing$1 reactivemongo.api.MongoConnection ), $anonfun$applyOrElse$12(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$closing$1 java.lang.String ), $anonfun$applyOrElse$13(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$closing$1 java.lang.String ), $anonfun$applyOrElse$9(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$closing$1 reactivemongo.api.MongoConnection ), $anonfun$applyOrElse$10$adapted(akka.actor.ActorRef ), $anonfun$applyOrElse$11$adapted(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$closing$1 akka.actor.ActorRef )}, serializedLambda);
                }
            };
        }

        public void postStop() {
            AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("[").append($this.$outer.supervisorName()).append("] Stopping the monitor...").toString());
        }

        public /* synthetic */ AsyncDriver reactivemongo$api$AsyncDriver$SupervisorActor$$$outer() {
            return this.$outer;
        }

        public SupervisorActor(AsyncDriver $outer, AsyncDriver driver) {
            this.reactivemongo$api$AsyncDriver$SupervisorActor$$driver = driver;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Actor.$init$((Actor)this);
            this.receive = new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SupervisorActor $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Close close2;
                    Option<String> option;
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof AddConnection && ((AddConnection)A1).reactivemongo$api$AsyncDriver$AddConnection$$$outer() == this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer()) {
                        AddConnection addConnection = (AddConnection)A1;
                        String name = addConnection.name();
                        MongoConnectionOptions opts = addConnection.options();
                        ActorRef sys = addConnection.mongosystem();
                        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Add connection to the supervisor: ").append(name).toString());
                        MongoConnection connection = new MongoConnection(this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName(), name, this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.system(), sys, opts);
                        this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.connectionMonitors().put((Object)connection.monitor(), (Object)connection);
                        this.$outer.context().watch(connection.monitor());
                        akka.actor.package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)connection, this.$outer.self());
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof Terminated) {
                        Terminated terminated = (Terminated)A1;
                        ActorRef actor = terminated.actor();
                        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Connection is terminated: ").append(actor.path()).toString());
                        this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.connectionMonitors().remove((Object)actor);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof Close && !(option = Close$.MODULE$.unapply(close2 = (Close)A1)).isEmpty()) {
                        BoxedUnit boxedUnit;
                        String src = (String)option.get();
                        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Close the supervisor for ").append(src).toString());
                        if (this.$outer.isEmpty()) {
                            this.$outer.context().stop(this.$outer.self());
                            akka.actor.package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)Closed$.MODULE$, this.$outer.self());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.$outer.context().become(this.$outer.closing());
                            Future$.MODULE$.sequence((TraversableOnce)this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.connectionMonitors().values().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.close(SupervisorActor$$anonfun$1.timeout$3(close2)), scala.collection.Iterable$.MODULE$.canBuildFrom()), scala.collection.Iterable$.MODULE$.canBuildFrom(), this.ec$2());
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        object = boxedUnit;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Close close2;
                    Option<String> option;
                    Object object = x1;
                    boolean bl = object instanceof AddConnection && ((AddConnection)object).reactivemongo$api$AsyncDriver$AddConnection$$$outer() == this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer() ? true : (object instanceof Terminated ? true : object instanceof Close && !(option = Close$.MODULE$.unapply(close2 = (Close)object)).isEmpty());
                    return bl;
                }

                private static final FiniteDuration timeout$3(Close x5$1) {
                    return x5$1.timeout();
                }

                private final ExecutionContext ec$2() {
                    return this.$outer.context().dispatcher();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$1 java.lang.String ), $anonfun$applyOrElse$4(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$1 akka.actor.ActorRef ), $anonfun$applyOrElse$5(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$1 java.lang.String ), $anonfun$applyOrElse$6(reactivemongo.core.actors.Close reactivemongo.api.MongoConnection )}, serializedLambda);
                }
            };
        }
    }
}

