/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.xbill.DNS.Record;
import reactivemongo.api.AuthenticationMode;
import reactivemongo.api.FailoverStrategy;
import reactivemongo.api.FailoverStrategy$;
import reactivemongo.api.MongoConnection;
import reactivemongo.api.MongoConnection$URIBuilder$;
import reactivemongo.api.MongoConnectionOptions;
import reactivemongo.api.MongoConnectionOptions$;
import reactivemongo.api.MongoConnectionOptions$Credential$;
import reactivemongo.api.MongoConnectionOptions$KeyStore$;
import reactivemongo.api.ReadConcern;
import reactivemongo.api.ReadConcern$;
import reactivemongo.api.ReadPreference;
import reactivemongo.api.ReadPreference$;
import reactivemongo.api.ScramSha1Authentication$;
import reactivemongo.api.ScramSha256Authentication$;
import reactivemongo.api.WriteConcern;
import reactivemongo.api.WriteConcern$;
import reactivemongo.api.WriteConcern$Majority$;
import reactivemongo.api.WriteConcern$TagSet$;
import reactivemongo.api.WriteConcern$WaitForAcknowledgments$;
import reactivemongo.api.X509Authentication$;
import reactivemongo.util.LazyLogger;
import reactivemongo.util.LazyLogger$;
import reactivemongo.util.package$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class MongoConnection$ {
    public static MongoConnection$ MODULE$;
    private final String DefaultHost;
    private final int DefaultPort;
    private final LazyLogger.LazyLogger logger;
    private final Regex IntRe;
    private final Regex FailoverRe;

    static {
        new MongoConnection$();
    }

    public String DefaultHost() {
        return this.DefaultHost;
    }

    public int DefaultPort() {
        return this.DefaultPort;
    }

    public LazyLogger.LazyLogger logger() {
        return this.logger;
    }

    public Future<MongoConnection.URI<Option<String>>> fromString(String uri, ExecutionContext ec) {
        return this.parse(uri, package$.MODULE$.dnsResolve(package$.MODULE$.dnsResolve$default$1(), package$.MODULE$.dnsResolve$default$2()), package$.MODULE$.txtRecords(package$.MODULE$.txtRecords$default$1(), ec), ec, MongoConnection$URIBuilder$.MODULE$.default());
    }

    public Future<MongoConnection.URI<String>> fromStringWithDB(String uri, ExecutionContext ec) {
        return this.parse(uri, package$.MODULE$.dnsResolve(package$.MODULE$.dnsResolve$default$1(), package$.MODULE$.dnsResolve$default$2()), package$.MODULE$.txtRecords(package$.MODULE$.txtRecords$default$1(), ec), ec, MongoConnection$URIBuilder$.MODULE$.requiredDB());
    }

    public <T> Future<MongoConnection.URI<T>> parse(String uri, Function1<ExecutionContext, Function1<String, Future<Record[]>>> srvRecResolver, Function1<String, Future<ListSet<String>>> txtResolver, ExecutionContext ec, MongoConnection.URIBuilder<T> uriBuilder) {
        boolean seedList = uri.startsWith("mongodb+srv://");
        Function4 & Serializable & scala.Serializable createUri = (Function4 & Serializable & scala.Serializable)(hosts, options, ignoredOptions, db) -> uriBuilder.apply((ListSet<Tuple2<String, Object>>)hosts, (MongoConnectionOptions)options, (List<String>)ignoredOptions, (Option<String>)db).recoverWith((PartialFunction)new scala.Serializable(uri){
            public static final long serialVersionUID = 0L;
            private final String uri$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof IllegalArgumentException) {
                    IllegalArgumentException illegalArgumentException = (IllegalArgumentException)A1;
                    object = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(2).append(illegalArgumentException.getMessage()).append(": ").append(this.uri$1).toString()));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof IllegalArgumentException;
                return bl;
            }
            {
                this.uri$1 = uri$1;
            }
        }, ec);
        return (uri.startsWith("mongodb://") ? Future$.MODULE$.successful(new StringOps(Predef$.MODULE$.augmentString(uri)).drop(10)) : (seedList ? Future$.MODULE$.successful(new StringOps(Predef$.MODULE$.augmentString(uri)).drop(14)) : Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(16).append("Invalid scheme: ").append(uri).toString())))).map((Function1 & Serializable & scala.Serializable)useful -> {
            String setSpec = (String)new StringOps(Predef$.MODULE$.augmentString(useful)).takeWhile((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parse$3(BoxesRunTime.unboxToChar((Object)x$5))));
            int credentialEnd = setSpec.indexOf("@");
            return new Tuple3(useful, (Object)setSpec, (Object)BoxesRunTime.boxToInteger((int)credentialEnd));
        }, ec).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
            MongoConnectionOptions mongoConnectionOptions;
            int credentialEnd;
            String setSpec;
            String useful;
            Tuple3 tuple3 = x$9;
            if (tuple3 != null) {
                useful = (String)tuple3._1();
                setSpec = (String)tuple3._2();
                credentialEnd = BoxesRunTime.unboxToInt((Object)tuple3._3());
                MongoConnectionOptions empty = MongoConnectionOptions$.MODULE$.default();
                if (!seedList) {
                    mongoConnectionOptions = empty;
                } else {
                    boolean x$1 = true;
                    int x$2 = empty.copy$default$1();
                    Option<String> x$3 = empty.copy$default$2();
                    boolean x$4 = empty.copy$default$4();
                    AuthenticationMode x$5 = empty.copy$default$5();
                    boolean x$6 = empty.copy$default$6();
                    boolean x$7 = empty.copy$default$7();
                    int x$82 = empty.copy$default$8();
                    Option<Object> x$92 = empty.copy$default$9();
                    int x$10 = empty.copy$default$10();
                    WriteConcern x$11 = empty.copy$default$11();
                    ReadPreference x$12 = empty.copy$default$12();
                    FailoverStrategy x$13 = empty.copy$default$13();
                    int x$14 = empty.copy$default$14();
                    int x$15 = empty.copy$default$15();
                    int x$16 = empty.copy$default$16();
                    Map<String, MongoConnectionOptions.Credential> x$17 = empty.copy$default$17();
                    Option<MongoConnectionOptions.KeyStore> x$18 = empty.copy$default$18();
                    ReadConcern x$19 = empty.copy$default$19();
                    Option<String> x$20 = empty.copy$default$20();
                    mongoConnectionOptions = empty.copy(x$2, x$3, x$1, x$4, x$5, x$6, x$7, x$82, x$92, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
                }
            } else {
                throw new MatchError((Object)tuple3);
            }
            MongoConnectionOptions initial = mongoConnectionOptions;
            Future future = MongoConnection$.txtOptions$1(seedList, setSpec, credentialEnd, txtResolver, ec).flatMap((Function1 & Serializable & scala.Serializable)txt -> MODULE$.parseOptions(MongoConnection$.optionStr$1(useful, setSpec)).map((Function1 & Serializable & scala.Serializable)os -> {
                Tuple2<List<String>, MongoConnectionOptions> opts = MODULE$.makeOptions((Map<String, String>)txt.$plus$plus((GenTraversableOnce)os), initial);
                return new Tuple2(os, opts);
            }, ec).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> {
                Tuple2 tuple2 = x$7;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2 opts = (Tuple2)tuple2._2();
                Future future = (((MongoConnectionOptions)opts._2()).maxIdleTimeMS() != 0 && ((MongoConnectionOptions)opts._2()).maxIdleTimeMS() < ((MongoConnectionOptions)opts._2()).heartbeatFrequencyMS() ? Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(61).append("Invalid URI options: maxIdleTimeMS(").append(((MongoConnectionOptions)opts._2()).maxIdleTimeMS()).append(") < heartbeatFrequencyMS(").append(((MongoConnectionOptions)opts._2()).heartbeatFrequencyMS()).append(")").toString())) : Future$.MODULE$.successful((Object)opts)).map((Function1 & Serializable & scala.Serializable)res -> res, ec);
                return future;
            }, ec), ec).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parse$15(check$ifrefutable$1)), ec).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> {
                Future future;
                Tuple2 tuple2 = x$8;
                if (tuple2 != null) {
                    List unsupportedKeys = (List)tuple2._1();
                    MongoConnectionOptions options = (MongoConnectionOptions)tuple2._2();
                    if (credentialEnd == -1) {
                        future = MODULE$.parseHostsAndDB(seedList, setSpec, srvRecResolver, ec).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                            Future future;
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 != null) {
                                Option db = (Option)tuple2._1();
                                ListSet hosts = (ListSet)tuple2._2();
                                AuthenticationMode authenticationMode = options.authenticationMechanism();
                                if (X509Authentication$.MODULE$.equals(authenticationMode)) {
                                    Future future2;
                                    Option option = db;
                                    if (option instanceof Some) {
                                        Some some = (Some)option;
                                        String dbName = (String)some.value();
                                        Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)dbName), (Object)MongoConnectionOptions$Credential$.MODULE$.apply("", (Option<String>)None$.MODULE$))}));
                                        int x$22 = options.copy$default$1();
                                        Option<String> x$23 = options.copy$default$2();
                                        boolean x$24 = options.copy$default$3();
                                        boolean x$25 = options.copy$default$4();
                                        AuthenticationMode x$26 = options.copy$default$5();
                                        boolean x$27 = options.copy$default$6();
                                        boolean x$28 = options.copy$default$7();
                                        int x$29 = options.copy$default$8();
                                        Option<Object> x$30 = options.copy$default$9();
                                        int x$31 = options.copy$default$10();
                                        WriteConcern x$32 = options.copy$default$11();
                                        ReadPreference x$33 = options.copy$default$12();
                                        FailoverStrategy x$34 = options.copy$default$13();
                                        int x$35 = options.copy$default$14();
                                        int x$36 = options.copy$default$15();
                                        int x$37 = options.copy$default$16();
                                        Option<MongoConnectionOptions.KeyStore> x$38 = options.copy$default$18();
                                        ReadConcern x$39 = options.copy$default$19();
                                        Option<String> x$40 = options.copy$default$20();
                                        MongoConnectionOptions optsWithX509 = options.copy(x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, (Map<String, MongoConnectionOptions.Credential>)x$21, x$38, x$39, x$40);
                                        future2 = (Future)createUri.apply((Object)hosts, (Object)optsWithX509, (Object)unsupportedKeys, (Object)db);
                                    } else {
                                        future2 = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(84).append("Could not parse URI '").append(uri).append("': authentication information found but no database name in URI").toString()));
                                    }
                                    future = future2;
                                } else {
                                    future = (Future)createUri.apply((Object)hosts, (Object)options, (Object)unsupportedKeys, (Object)db);
                                }
                            } else {
                                throw new MatchError((Object)tuple2);
                            }
                            Future future3 = future;
                            return future3;
                        }, ec);
                    } else {
                        Future future2;
                        String string;
                        Regex WithAuth = new StringOps(Predef$.MODULE$.augmentString("([^:]+)(|:[^@]*)@(.+)")).r();
                        Option option = WithAuth.unapplySeq((CharSequence)(string = setSpec));
                        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
                            String user = (String)((LinearSeqOptimized)option.get()).apply(0);
                            String p = (String)((LinearSeqOptimized)option.get()).apply(1);
                            String hostsPortsAndDB = (String)((LinearSeqOptimized)option.get()).apply(2);
                            String pass = new StringOps(Predef$.MODULE$.augmentString(p)).stripPrefix(":");
                            future2 = MODULE$.parseHostsAndDB(seedList, hostsPortsAndDB, srvRecResolver, ec).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                Future future;
                                Tuple2 tuple2 = x0$2;
                                if (tuple2 == null) return Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(84).append("Could not parse URI '").append(uri).append("': authentication information found but no database name in URI").toString()));
                                Option option = (Option)tuple2._1();
                                ListSet hosts = (ListSet)tuple2._2();
                                if (!(option instanceof Some)) return Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(84).append("Could not parse URI '").append(uri).append("': authentication information found but no database name in URI").toString()));
                                Some some = (Some)option;
                                String database = (String)some.value();
                                AuthenticationMode authenticationMode = options.authenticationMechanism();
                                X509Authentication$ x509Authentication$ = X509Authentication$.MODULE$;
                                if (!(authenticationMode != null ? !authenticationMode.equals(x509Authentication$) : x509Authentication$ != null) && new StringOps(Predef$.MODULE$.augmentString(pass)).nonEmpty()) {
                                    future = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException("You should not provide a password when authenticating with X509 authentication"));
                                    return future;
                                } else {
                                    AuthenticationMode authenticationMode2 = options.authenticationMechanism();
                                    X509Authentication$ x509Authentication$2 = X509Authentication$.MODULE$;
                                    Option password = (authenticationMode2 == null ? x509Authentication$2 != null : !authenticationMode2.equals(x509Authentication$2)) ? Option$.MODULE$.apply((Object)pass) : Option$.MODULE$.empty();
                                    String authDb = (String)options.authenticationDatabase().getOrElse((Function0 & Serializable & scala.Serializable)() -> database);
                                    Map x$41 = options.credentials().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)authDb), (Object)MongoConnectionOptions$Credential$.MODULE$.apply(user, (Option<String>)password)));
                                    int x$42 = options.copy$default$1();
                                    Option<String> x$43 = options.copy$default$2();
                                    boolean x$44 = options.copy$default$3();
                                    boolean x$45 = options.copy$default$4();
                                    AuthenticationMode x$46 = options.copy$default$5();
                                    boolean x$47 = options.copy$default$6();
                                    boolean x$48 = options.copy$default$7();
                                    int x$49 = options.copy$default$8();
                                    Option<Object> x$50 = options.copy$default$9();
                                    int x$51 = options.copy$default$10();
                                    WriteConcern x$52 = options.copy$default$11();
                                    ReadPreference x$53 = options.copy$default$12();
                                    FailoverStrategy x$54 = options.copy$default$13();
                                    int x$55 = options.copy$default$14();
                                    int x$56 = options.copy$default$15();
                                    int x$57 = options.copy$default$16();
                                    Option<MongoConnectionOptions.KeyStore> x$58 = options.copy$default$18();
                                    ReadConcern x$59 = options.copy$default$19();
                                    Option<String> x$60 = options.copy$default$20();
                                    MongoConnectionOptions optsWithCred = options.copy(x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, (Map<String, MongoConnectionOptions.Credential>)x$41, x$58, x$59, x$60);
                                    future = (Future)createUri.apply((Object)hosts, (Object)optsWithCred, (Object)unsupportedKeys, (Object)new Some((Object)database));
                                }
                                return future;
                            }, ec);
                        } else {
                            future2 = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(22).append("Could not parse URI '").append(uri).append("'").toString()));
                        }
                        future = future2;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Future future3 = future.map((Function1 & Serializable & scala.Serializable)parsedUri -> parsedUri, ec);
                return future3;
            }, ec);
            return future;
        }, ec);
    }

    private Future<ListSet<Tuple2<String, Object>>> parseHosts(boolean seedList, String hosts, Function1<ExecutionContext, Function1<String, Future<Record[]>>> srvRecResolver, ExecutionContext ec) {
        Future future;
        if (seedList) {
            future = ((Future)Await$.MODULE$.ready(package$.MODULE$.srvRecords(hosts, srvRecResolver, ec), (Duration)package$.MODULE$.dnsTimeout())).map((Function1 & Serializable & scala.Serializable)x$10 -> ((ListSet)ListSet$.MODULE$.empty()).$plus$plus((GenTraversableOnce)x$10), ec);
        } else {
            Builder buf = ListSet$.MODULE$.newBuilder();
            future = this.parse$1((Iterable)Predef$.MODULE$.wrapRefArray((Object[])hosts.split(",")), buf);
        }
        return future;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Future<Tuple2<Option<String>, ListSet<Tuple2<String, Object>>>> parseHostsAndDB(boolean seedList, String input, Function1<ExecutionContext, Function1<String, Future<Record[]>>> srvRecResolver, ExecutionContext ec) {
        Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(input)).span((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parseHostsAndDB$1(BoxesRunTime.unboxToChar((Object)x$12))));
        if (tuple2 != null) {
            String hosts = (String)tuple2._1();
            String string = (String)tuple2._2();
            if ("".equals(string)) {
                return this.parseHosts(seedList, hosts, srvRecResolver, ec).map((Function1 & Serializable & scala.Serializable)x$13 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), x$13), ec);
            }
        }
        if (tuple2 == null) return Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(47).append("Could not parse hosts and database from URI: '").append(input).append("'").toString()));
        String hosts = (String)tuple2._1();
        String dbName = (String)tuple2._2();
        return this.parseHosts(seedList, hosts, srvRecResolver, ec).map((Function1 & Serializable & scala.Serializable)x$14 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some(new StringOps(Predef$.MODULE$.augmentString(dbName)).drop(1))), x$14), ec);
    }

    private Future<Map<String, String>> parseOptions(String options) {
        Future future;
        if (options.isEmpty()) {
            future = Future$.MODULE$.successful((Object)Predef$.MODULE$.Map().empty());
        } else {
            scala.collection.mutable.Map buf = Map$.MODULE$.empty();
            future = this.parse$2((Iterable)Predef$.MODULE$.wrapRefArray((Object[])options.split("&")), options, buf);
        }
        return future;
    }

    private Regex IntRe() {
        return this.IntRe;
    }

    private Regex FailoverRe() {
        return this.FailoverRe;
    }

    private Tuple2<List<String>, MongoConnectionOptions> makeOptions(Map<String, String> opts, MongoConnectionOptions initial) {
        Tuple2 tuple2 = (Tuple2)opts.iterator().foldLeft((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Map().empty()), (Object)initial), (arg_0, arg_1) -> MongoConnection$.$anonfun$makeOptions$4(this, arg_0, arg_1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Map remOpts = (Map)tuple2._1();
        MongoConnectionOptions step1 = (MongoConnectionOptions)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)remOpts, (Object)step1);
        Tuple2 tuple23 = tuple22;
        Map remOpts2 = (Map)tuple23._1();
        MongoConnectionOptions step12 = (MongoConnectionOptions)tuple23._2();
        MongoConnectionOptions step2 = (MongoConnectionOptions)remOpts2.get((Object)"keyStore").fold((Function0 & Serializable & scala.Serializable)() -> step12, (Function1 & Serializable & scala.Serializable)uri -> {
            MongoConnectionOptions.KeyStore keyStore = MongoConnectionOptions$KeyStore$.MODULE$.apply(new URI((String)uri), (Option<char[]>)remOpts2.get((Object)"keyStorePassword").map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.toCharArray()), (String)remOpts2.getOrElse((Object)"keyStoreType", (Function0 & Serializable & scala.Serializable)() -> "PKCS12"), true);
            Some x$561 = new Some((Object)keyStore);
            int x$562 = step12.copy$default$1();
            Option<String> x$563 = step12.copy$default$2();
            boolean x$564 = step12.copy$default$3();
            boolean x$565 = step12.copy$default$4();
            AuthenticationMode x$566 = step12.copy$default$5();
            boolean x$567 = step12.copy$default$6();
            boolean x$568 = step12.copy$default$7();
            int x$569 = step12.copy$default$8();
            Option<Object> x$570 = step12.copy$default$9();
            int x$571 = step12.copy$default$10();
            WriteConcern x$572 = step12.copy$default$11();
            ReadPreference x$573 = step12.copy$default$12();
            FailoverStrategy x$574 = step12.copy$default$13();
            int x$575 = step12.copy$default$14();
            int x$576 = step12.copy$default$15();
            int x$577 = step12.copy$default$16();
            Map<String, MongoConnectionOptions.Credential> x$578 = step12.copy$default$17();
            ReadConcern x$579 = step12.copy$default$19();
            Option<String> x$580 = step12.copy$default$20();
            return step12.copy(x$562, x$563, x$564, x$565, x$566, x$567, x$568, x$569, x$570, x$571, x$572, x$573, x$574, x$575, x$576, x$577, x$578, (Option<MongoConnectionOptions.KeyStore>)x$561, x$579, x$580);
        });
        Map remOpts22 = (Map)remOpts2.$minus((Object)"keyStore").$minus((Object)"keyStorePassword").$minus((Object)"keyStoreType");
        return (Tuple2)remOpts22.iterator().foldLeft((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)List$.MODULE$.empty()), (Object)step2), (arg_0, arg_1) -> MongoConnection$.$anonfun$makeOptions$17(this, arg_0, arg_1));
    }

    public static final /* synthetic */ boolean $anonfun$parse$3(char x$5) {
        return x$5 != '?';
    }

    public static final /* synthetic */ boolean $anonfun$parse$5(char x$6) {
        return x$6 != '/';
    }

    private static final Future txtOptions$1(boolean seedList$1, String setSpec$1, int credentialEnd$1, Function1 txtResolver$1, ExecutionContext ec$1) {
        Future future;
        if (!seedList$1) {
            future = Future$.MODULE$.successful((Object)Predef$.MODULE$.Map().empty());
        } else {
            String serviceName = (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(setSpec$1)).drop(credentialEnd$1 + 1))).takeWhile((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parse$5(BoxesRunTime.unboxToChar((Object)x$6))));
            future = ((Future)Await$.MODULE$.ready((Awaitable)txtResolver$1.apply((Object)serviceName), (Duration)package$.MODULE$.dnsTimeout())).flatMap((Function1 & Serializable & scala.Serializable)records -> ((Future)records.foldLeft((Object)Future$.MODULE$.successful((Object)Predef$.MODULE$.Map().empty()), (Function2 & Serializable & scala.Serializable)(o, r) -> o.flatMap((Function1 & Serializable & scala.Serializable)prev -> MODULE$.parseOptions((String)r).map((Function1 & Serializable & scala.Serializable)cur -> prev.$plus$plus((GenTraversableOnce)cur), ec$1), ec$1))).map((Function1 & Serializable & scala.Serializable)res -> res, ec$1), ec$1);
        }
        return future;
    }

    private static final String optionStr$1(String useful$1, String setSpec$1) {
        return new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(useful$1)).drop(new StringOps(Predef$.MODULE$.augmentString(setSpec$1)).size()))).stripPrefix("?");
    }

    public static final /* synthetic */ boolean $anonfun$parse$15(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$parseHosts$2(char x$11) {
        return x$11 != ':';
    }

    private final Future parse$1(Iterable input, Builder buf$1) {
        Future future;
        block15: {
            Option option;
            while ((option = input.headOption()) instanceof Some) {
                Future future2;
                String string;
                Some some = (Some)option;
                String h = (String)some.value();
                Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(h)).span((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parseHosts$2(BoxesRunTime.unboxToChar((Object)x$11))));
                if (tuple2 != null && "".equals(string = (String)tuple2._1())) {
                    future2 = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(28).append("No valid host in the URI: '").append(h).append("'").toString()));
                } else {
                    if (tuple2 != null) {
                        String host = (String)tuple2._1();
                        String string2 = (String)tuple2._2();
                        if ("".equals(string2)) {
                            buf$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)host), (Object)BoxesRunTime.boxToInteger((int)this.DefaultPort())));
                            input = (Iterable)input.drop(1);
                            continue;
                        }
                    }
                    if (tuple2 != null) {
                        Left res;
                        Object object;
                        String host = (String)tuple2._1();
                        String port = (String)tuple2._2();
                        try {
                            int p = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(port)).drop(1))).toInt();
                            object = p <= 0 || p >= 65536 ? scala.package$.MODULE$.Left().apply((Object)new MongoConnection.URIParsingException(new StringBuilder(49).append("Could not parse host '").append(h).append("' from URI: invalid port '").append(port).append("'").toString())) : scala.package$.MODULE$.Right().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)host), (Object)BoxesRunTime.boxToInteger((int)p)));
                        }
                        catch (Throwable throwable) {
                            Left left;
                            Throwable throwable2 = throwable;
                            if (throwable2 instanceof NumberFormatException) {
                                left = scala.package$.MODULE$.Left().apply((Object)new MongoConnection.URIParsingException(new StringBuilder(49).append("Could not parse host '").append(h).append("' from URI: invalid port '").append(port).append("'").toString()));
                            } else {
                                Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                                if (!option2.isEmpty()) {
                                    Throwable cause = (Throwable)option2.get();
                                    left = scala.package$.MODULE$.Left().apply((Object)cause);
                                } else {
                                    throw throwable;
                                }
                            }
                            object = left;
                        }
                        Left left = res = object;
                        if (!(left instanceof Left)) {
                            if (left instanceof Right) {
                                Right right = (Right)left;
                                Tuple2 node = (Tuple2)right.value();
                                buf$1.$plus$eq((Object)node);
                                input = (Iterable)input.drop(1);
                                continue;
                            }
                            throw new MatchError((Object)left);
                        }
                        Left left2 = left;
                        Throwable cause = (Throwable)left2.value();
                        Future future3 = Future$.MODULE$.failed(cause);
                        future2 = future3;
                    } else {
                        future2 = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(52).append("Could not parse host from URI: invalid definition '").append(h).append("'").toString()));
                    }
                }
                future = future2;
                break block15;
            }
            future = Future$.MODULE$.successful(buf$1.result());
        }
        return future;
    }

    public static final /* synthetic */ boolean $anonfun$parseHostsAndDB$1(char x$12) {
        return x$12 != '/';
    }

    public static final /* synthetic */ boolean $anonfun$parseOptions$1(char x$15) {
        return x$15 != '=';
    }

    private final Future parse$2(Iterable input, String options$2, scala.collection.mutable.Map buf$2) {
        Future future;
        block3: {
            Option option;
            while ((option = input.headOption()) instanceof Some) {
                String string;
                Some some = (Some)option;
                String option2 = (String)some.value();
                Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(option2)).span((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parseOptions$1(BoxesRunTime.unboxToChar((Object)x$15))));
                if (tuple2 == null || !"".equals(string = (String)tuple2._2())) {
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        buf$2.put((Object)key, new StringOps(Predef$.MODULE$.augmentString(v)).drop(1));
                        input = (Iterable)input.drop(1);
                        continue;
                    }
                    throw new MatchError((Object)tuple2);
                }
                Future future2 = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(34).append("Could not parse invalid options '").append(options$2).append("'").toString()));
                future = future2;
                break block3;
            }
            future = Future$.MODULE$.successful((Object)buf$2.toMap(Predef$.MODULE$.$conforms()));
        }
        return future;
    }

    private final Tuple2 make$1(String name, String input, Map unsupported, MongoConnectionOptions parsed, Function0 f) {
        Tuple2 tuple2;
        try {
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), f.apply());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable cause = (Throwable)option.get();
            this.logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Invalid option '").append(name).append("': ").append(input).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> cause);
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)input))), (Object)parsed);
            tuple2 = tuple22;
        }
        return tuple2;
    }

    private final void deprecated$1(String expected, String actual) {
        block0: {
            String string = actual;
            String string2 = expected;
            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
            this.logger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Connection option '").append(actual).append("' is deprecated in favor of '").append(expected).append("'").toString());
        }
    }

    public static final /* synthetic */ String $anonfun$makeOptions$5() {
        return "Connection option 'replicaSet' is ignored: determined from servers response";
    }

    public static final /* synthetic */ MongoConnectionOptions $anonfun$makeOptions$6(String d$1, String opt$1, String r$2, String f$1, MongoConnectionOptions result$1) {
        FailoverStrategy strategy;
        Tuple2 dur;
        Option option = Duration$.MODULE$.unapply(Duration$.MODULE$.apply(d$1));
        if (!(option instanceof Some)) {
            throw new MongoConnection.URIParsingException(new StringBuilder(32).append("Invalid duration 'rm.failover': ").append(opt$1).toString());
        }
        Some some = (Some)option;
        Tuple2 tuple2 = dur = (Tuple2)some.value();
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        long time = tuple22._1$mcJ$sp();
        TimeUnit unit = (TimeUnit)((Object)tuple22._2());
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToLong((long)time), (Object)unit);
        Tuple2 tuple24 = tuple23;
        long time2 = tuple24._1$mcJ$sp();
        TimeUnit unit2 = (TimeUnit)((Object)tuple24._2());
        FiniteDuration delay = FiniteDuration$.MODULE$.apply(time2, unit2);
        int retry = new StringOps(Predef$.MODULE$.augmentString(r$2)).toInt();
        double factor = new StringOps(Predef$.MODULE$.augmentString(f$1)).toDouble();
        FailoverStrategy x$481 = strategy = FailoverStrategy$.MODULE$.apply(delay, retry, (Function1<Object, Object>)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$17 -> (double)x$17 * factor);
        int x$482 = result$1.copy$default$1();
        Option<String> x$483 = result$1.copy$default$2();
        boolean x$484 = result$1.copy$default$3();
        boolean x$485 = result$1.copy$default$4();
        AuthenticationMode x$486 = result$1.copy$default$5();
        boolean x$487 = result$1.copy$default$6();
        boolean x$488 = result$1.copy$default$7();
        int x$489 = result$1.copy$default$8();
        Option<Object> x$490 = result$1.copy$default$9();
        int x$491 = result$1.copy$default$10();
        WriteConcern x$492 = result$1.copy$default$11();
        ReadPreference x$493 = result$1.copy$default$12();
        int x$494 = result$1.copy$default$14();
        int x$495 = result$1.copy$default$15();
        int x$496 = result$1.copy$default$16();
        Map<String, MongoConnectionOptions.Credential> x$497 = result$1.copy$default$17();
        Option<MongoConnectionOptions.KeyStore> x$498 = result$1.copy$default$18();
        ReadConcern x$499 = result$1.copy$default$19();
        Option<String> x$500 = result$1.copy$default$20();
        return result$1.copy(x$482, x$483, x$484, x$485, x$486, x$487, x$488, x$489, x$490, x$491, x$492, x$493, x$481, x$494, x$495, x$496, x$497, x$498, x$499, x$500);
    }

    public static final /* synthetic */ String $anonfun$makeOptions$8() {
        return "Connection option 'rm.failover' should be preferred to 'retryWrites'";
    }

    public static final /* synthetic */ String $anonfun$makeOptions$9() {
        return "Connection option 'rm.failover' should be preferred to 'retryWrites'";
    }

    public static final /* synthetic */ MongoConnectionOptions $anonfun$makeOptions$10(String ms$1, MongoConnectionOptions result$1) {
        int millis = new StringOps(Predef$.MODULE$.augmentString(ms$1)).toInt();
        if (millis < 500) {
            throw new MongoConnection.URIParsingException("'heartbeatFrequencyMS' must be >= 500 milliseconds");
        }
        int x$521 = millis;
        int x$522 = result$1.copy$default$1();
        Option<String> x$523 = result$1.copy$default$2();
        boolean x$524 = result$1.copy$default$3();
        boolean x$525 = result$1.copy$default$4();
        AuthenticationMode x$526 = result$1.copy$default$5();
        boolean x$527 = result$1.copy$default$6();
        boolean x$528 = result$1.copy$default$7();
        int x$529 = result$1.copy$default$8();
        Option<Object> x$530 = result$1.copy$default$9();
        int x$531 = result$1.copy$default$10();
        WriteConcern x$532 = result$1.copy$default$11();
        ReadPreference x$533 = result$1.copy$default$12();
        FailoverStrategy x$534 = result$1.copy$default$13();
        int x$535 = result$1.copy$default$15();
        int x$536 = result$1.copy$default$16();
        Map<String, MongoConnectionOptions.Credential> x$537 = result$1.copy$default$17();
        Option<MongoConnectionOptions.KeyStore> x$538 = result$1.copy$default$18();
        ReadConcern x$539 = result$1.copy$default$19();
        Option<String> x$540 = result$1.copy$default$20();
        return result$1.copy(x$522, x$523, x$524, x$525, x$526, x$527, x$528, x$529, x$530, x$531, x$532, x$533, x$534, x$521, x$535, x$536, x$537, x$538, x$539, x$540);
    }

    public static final /* synthetic */ String $anonfun$makeOptions$11(String x$18) {
        return x$18.trim();
    }

    public static final /* synthetic */ boolean $anonfun$makeOptions$12(String v) {
        return new StringOps(Predef$.MODULE$.augmentString(v)).nonEmpty() && new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(v.getBytes("UTF-8"))).size() < 128;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple2 $anonfun$makeOptions$4(MongoConnection$ $this, Tuple2 x0$1, Tuple2 x1$1) {
        block6: {
            block4: {
                block36: {
                    block35: {
                        block34: {
                            block33: {
                                block32: {
                                    block31: {
                                        block30: {
                                            block29: {
                                                block28: {
                                                    block27: {
                                                        block26: {
                                                            block25: {
                                                                block24: {
                                                                    block23: {
                                                                        block22: {
                                                                            block21: {
                                                                                block20: {
                                                                                    block19: {
                                                                                        block18: {
                                                                                            block17: {
                                                                                                block16: {
                                                                                                    block15: {
                                                                                                        block14: {
                                                                                                            block13: {
                                                                                                                block12: {
                                                                                                                    block11: {
                                                                                                                        block10: {
                                                                                                                            block9: {
                                                                                                                                block8: {
                                                                                                                                    block7: {
                                                                                                                                        block5: {
                                                                                                                                            var7_3 = new Tuple2((Object)x0$1, (Object)x1$1);
                                                                                                                                            if (var7_3 == null) break block4;
                                                                                                                                            var8_4 = (Tuple2)var7_3._1();
                                                                                                                                            kv = (Tuple2)var7_3._2();
                                                                                                                                            if (var8_4 == null) break block4;
                                                                                                                                            unsupported = (Map)var8_4._1();
                                                                                                                                            result = (MongoConnectionOptions)var8_4._2();
                                                                                                                                            var12_8 = kv;
                                                                                                                                            if (var12_8 == null || !"replicaSet".equals(var13_9 = (String)var12_8._1())) break block5;
                                                                                                                                            MongoConnection$.MODULE$.logger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$makeOptions$5(), ()Ljava/lang/String;)());
                                                                                                                                            var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result);
                                                                                                                                            break block6;
                                                                                                                                        }
                                                                                                                                        if (var12_8 == null) break block7;
                                                                                                                                        var14_11 = (String)var12_8._1();
                                                                                                                                        var15_12 = (String)var12_8._2();
                                                                                                                                        if (!"authenticationMechanism".equals(var14_11) || !"x509".equals(var15_12)) break block7;
                                                                                                                                        x$1 = X509Authentication$.MODULE$;
                                                                                                                                        x$2 = result.copy$default$1();
                                                                                                                                        x$3 = result.copy$default$2();
                                                                                                                                        x$4 = result.copy$default$3();
                                                                                                                                        x$5 = result.copy$default$4();
                                                                                                                                        x$6 = result.copy$default$6();
                                                                                                                                        x$7 = result.copy$default$7();
                                                                                                                                        x$8 = result.copy$default$8();
                                                                                                                                        x$9 = result.copy$default$9();
                                                                                                                                        x$10 = result.copy$default$10();
                                                                                                                                        x$11 = result.copy$default$11();
                                                                                                                                        x$12 = result.copy$default$12();
                                                                                                                                        x$13 = result.copy$default$13();
                                                                                                                                        x$14 = result.copy$default$14();
                                                                                                                                        x$15 = result.copy$default$15();
                                                                                                                                        x$16 = result.copy$default$16();
                                                                                                                                        x$17 = result.copy$default$17();
                                                                                                                                        x$18 = result.copy$default$18();
                                                                                                                                        x$19 = result.copy$default$19();
                                                                                                                                        x$20 = result.copy$default$20();
                                                                                                                                        var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
                                                                                                                                        break block6;
                                                                                                                                    }
                                                                                                                                    if (var12_8 == null) break block8;
                                                                                                                                    var36_33 = (String)var12_8._1();
                                                                                                                                    var37_34 = (String)var12_8._2();
                                                                                                                                    if (!"authenticationMechanism".equals(var36_33) || !"scram-sha256".equals(var37_34)) break block8;
                                                                                                                                    x$21 = ScramSha256Authentication$.MODULE$;
                                                                                                                                    x$22 = result.copy$default$1();
                                                                                                                                    x$23 = result.copy$default$2();
                                                                                                                                    x$24 = result.copy$default$3();
                                                                                                                                    x$25 = result.copy$default$4();
                                                                                                                                    x$26 = result.copy$default$6();
                                                                                                                                    x$27 = result.copy$default$7();
                                                                                                                                    x$28 = result.copy$default$8();
                                                                                                                                    x$29 = result.copy$default$9();
                                                                                                                                    x$30 = result.copy$default$10();
                                                                                                                                    x$31 = result.copy$default$11();
                                                                                                                                    x$32 = result.copy$default$12();
                                                                                                                                    x$33 = result.copy$default$13();
                                                                                                                                    x$34 = result.copy$default$14();
                                                                                                                                    x$35 = result.copy$default$15();
                                                                                                                                    x$36 = result.copy$default$16();
                                                                                                                                    x$37 = result.copy$default$17();
                                                                                                                                    x$38 = result.copy$default$18();
                                                                                                                                    x$39 = result.copy$default$19();
                                                                                                                                    x$40 = result.copy$default$20();
                                                                                                                                    var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$22, x$23, x$24, x$25, x$21, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40));
                                                                                                                                    break block6;
                                                                                                                                }
                                                                                                                                if (var12_8 == null || !"authenticationMechanism".equals(var58_55 = (String)var12_8._1())) break block9;
                                                                                                                                x$41 = ScramSha1Authentication$.MODULE$;
                                                                                                                                x$42 = result.copy$default$1();
                                                                                                                                x$43 = result.copy$default$2();
                                                                                                                                x$44 = result.copy$default$3();
                                                                                                                                x$45 = result.copy$default$4();
                                                                                                                                x$46 = result.copy$default$6();
                                                                                                                                x$47 = result.copy$default$7();
                                                                                                                                x$48 = result.copy$default$8();
                                                                                                                                x$49 = result.copy$default$9();
                                                                                                                                x$50 = result.copy$default$10();
                                                                                                                                x$51 = result.copy$default$11();
                                                                                                                                x$52 = result.copy$default$12();
                                                                                                                                x$53 = result.copy$default$13();
                                                                                                                                x$54 = result.copy$default$14();
                                                                                                                                x$55 = result.copy$default$15();
                                                                                                                                x$56 = result.copy$default$16();
                                                                                                                                x$57 = result.copy$default$17();
                                                                                                                                x$58 = result.copy$default$18();
                                                                                                                                x$59 = result.copy$default$19();
                                                                                                                                x$60 = result.copy$default$20();
                                                                                                                                var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$42, x$43, x$44, x$45, x$41, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60));
                                                                                                                                break block6;
                                                                                                                            }
                                                                                                                            if (var12_8 == null) break block10;
                                                                                                                            n = (String)var12_8._1();
                                                                                                                            v = (String)var12_8._2();
                                                                                                                            var6_78 = "authenticationDatabase".equals(n) != false ? true : "authSource".equals(n) != false;
                                                                                                                            if (!var6_78) break block10;
                                                                                                                            $this.deprecated$1(n, "authenticationDatabase");
                                                                                                                            x$61 = new Some((Object)v);
                                                                                                                            x$62 = result.copy$default$1();
                                                                                                                            x$63 = result.copy$default$3();
                                                                                                                            x$64 = result.copy$default$4();
                                                                                                                            x$65 = result.copy$default$5();
                                                                                                                            x$66 = result.copy$default$6();
                                                                                                                            x$67 = result.copy$default$7();
                                                                                                                            x$68 = result.copy$default$8();
                                                                                                                            x$69 = result.copy$default$9();
                                                                                                                            x$70 = result.copy$default$10();
                                                                                                                            x$71 = result.copy$default$11();
                                                                                                                            x$72 = result.copy$default$12();
                                                                                                                            x$73 = result.copy$default$13();
                                                                                                                            x$74 = result.copy$default$14();
                                                                                                                            x$75 = result.copy$default$15();
                                                                                                                            x$76 = result.copy$default$16();
                                                                                                                            x$77 = result.copy$default$17();
                                                                                                                            x$78 = result.copy$default$18();
                                                                                                                            x$79 = result.copy$default$19();
                                                                                                                            x$80 = result.copy$default$20();
                                                                                                                            var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$62, (Option<String>)x$61, x$63, x$64, x$65, x$66, x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79, x$80));
                                                                                                                            break block6;
                                                                                                                        }
                                                                                                                        if (var12_8 == null) break block11;
                                                                                                                        var101_99 = (String)var12_8._1();
                                                                                                                        v = (String)var12_8._2();
                                                                                                                        if (!"connectTimeoutMS".equals(var101_99)) break block11;
                                                                                                                        var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(new StringOps(Predef$.MODULE$.augmentString(v)).toInt(), result.copy$default$2(), result.copy$default$3(), result.copy$default$4(), result.copy$default$5(), result.copy$default$6(), result.copy$default$7(), result.copy$default$8(), result.copy$default$9(), result.copy$default$10(), result.copy$default$11(), result.copy$default$12(), result.copy$default$13(), result.copy$default$14(), result.copy$default$15(), result.copy$default$16(), result.copy$default$17(), result.copy$default$18(), result.copy$default$19(), result.copy$default$20()));
                                                                                                                        break block6;
                                                                                                                    }
                                                                                                                    if (var12_8 == null) break block12;
                                                                                                                    var103_101 = (String)var12_8._1();
                                                                                                                    v = (String)var12_8._2();
                                                                                                                    if (!"maxIdleTimeMS".equals(var103_101)) break block12;
                                                                                                                    x$81 = new StringOps(Predef$.MODULE$.augmentString(v)).toInt();
                                                                                                                    x$82 = result.copy$default$1();
                                                                                                                    x$83 = result.copy$default$2();
                                                                                                                    x$84 = result.copy$default$3();
                                                                                                                    x$85 = result.copy$default$4();
                                                                                                                    x$86 = result.copy$default$5();
                                                                                                                    x$87 = result.copy$default$6();
                                                                                                                    x$88 = result.copy$default$7();
                                                                                                                    x$89 = result.copy$default$8();
                                                                                                                    x$90 = result.copy$default$9();
                                                                                                                    x$91 = result.copy$default$10();
                                                                                                                    x$92 = result.copy$default$11();
                                                                                                                    x$93 = result.copy$default$12();
                                                                                                                    x$94 = result.copy$default$13();
                                                                                                                    x$95 = result.copy$default$14();
                                                                                                                    x$96 = result.copy$default$16();
                                                                                                                    x$97 = result.copy$default$17();
                                                                                                                    x$98 = result.copy$default$18();
                                                                                                                    x$99 = result.copy$default$19();
                                                                                                                    x$100 = result.copy$default$20();
                                                                                                                    var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$95, x$81, x$96, x$97, x$98, x$99, x$100));
                                                                                                                    break block6;
                                                                                                                }
                                                                                                                if (var12_8 == null) break block13;
                                                                                                                var125_123 = (String)var12_8._1();
                                                                                                                v = (String)var12_8._2();
                                                                                                                if (!"ssl".equals(var125_123)) break block13;
                                                                                                                x$101 = new StringOps(Predef$.MODULE$.augmentString(v)).toBoolean();
                                                                                                                x$102 = result.copy$default$1();
                                                                                                                x$103 = result.copy$default$2();
                                                                                                                x$104 = result.copy$default$4();
                                                                                                                x$105 = result.copy$default$5();
                                                                                                                x$106 = result.copy$default$6();
                                                                                                                x$107 = result.copy$default$7();
                                                                                                                x$108 = result.copy$default$8();
                                                                                                                x$109 = result.copy$default$9();
                                                                                                                x$110 = result.copy$default$10();
                                                                                                                x$111 = result.copy$default$11();
                                                                                                                x$112 = result.copy$default$12();
                                                                                                                x$113 = result.copy$default$13();
                                                                                                                x$114 = result.copy$default$14();
                                                                                                                x$115 = result.copy$default$15();
                                                                                                                x$116 = result.copy$default$16();
                                                                                                                x$117 = result.copy$default$17();
                                                                                                                x$118 = result.copy$default$18();
                                                                                                                x$119 = result.copy$default$19();
                                                                                                                x$120 = result.copy$default$20();
                                                                                                                var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$102, x$103, x$101, x$104, x$105, x$106, x$107, x$108, x$109, x$110, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118, x$119, x$120));
                                                                                                                break block6;
                                                                                                            }
                                                                                                            if (var12_8 == null) break block14;
                                                                                                            var147_145 = (String)var12_8._1();
                                                                                                            v = (String)var12_8._2();
                                                                                                            if (!"sslAllowsInvalidCert".equals(var147_145)) break block14;
                                                                                                            x$121 = new StringOps(Predef$.MODULE$.augmentString(v)).toBoolean();
                                                                                                            x$122 = result.copy$default$1();
                                                                                                            x$123 = result.copy$default$2();
                                                                                                            x$124 = result.copy$default$3();
                                                                                                            x$125 = result.copy$default$5();
                                                                                                            x$126 = result.copy$default$6();
                                                                                                            x$127 = result.copy$default$7();
                                                                                                            x$128 = result.copy$default$8();
                                                                                                            x$129 = result.copy$default$9();
                                                                                                            x$130 = result.copy$default$10();
                                                                                                            x$131 = result.copy$default$11();
                                                                                                            x$132 = result.copy$default$12();
                                                                                                            x$133 = result.copy$default$13();
                                                                                                            x$134 = result.copy$default$14();
                                                                                                            x$135 = result.copy$default$15();
                                                                                                            x$136 = result.copy$default$16();
                                                                                                            x$137 = result.copy$default$17();
                                                                                                            x$138 = result.copy$default$18();
                                                                                                            x$139 = result.copy$default$19();
                                                                                                            x$140 = result.copy$default$20();
                                                                                                            var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$122, x$123, x$124, x$121, x$125, x$126, x$127, x$128, x$129, x$130, x$131, x$132, x$133, x$134, x$135, x$136, x$137, x$138, x$139, x$140));
                                                                                                            break block6;
                                                                                                        }
                                                                                                        if (var12_8 == null) break block15;
                                                                                                        var169_167 = (String)var12_8._1();
                                                                                                        v = (String)var12_8._2();
                                                                                                        if (!"rm.tcpNoDelay".equals(var169_167)) break block15;
                                                                                                        x$141 = new StringOps(Predef$.MODULE$.augmentString(v)).toBoolean();
                                                                                                        x$142 = result.copy$default$1();
                                                                                                        x$143 = result.copy$default$2();
                                                                                                        x$144 = result.copy$default$3();
                                                                                                        x$145 = result.copy$default$4();
                                                                                                        x$146 = result.copy$default$5();
                                                                                                        x$147 = result.copy$default$7();
                                                                                                        x$148 = result.copy$default$8();
                                                                                                        x$149 = result.copy$default$9();
                                                                                                        x$150 = result.copy$default$10();
                                                                                                        x$151 = result.copy$default$11();
                                                                                                        x$152 = result.copy$default$12();
                                                                                                        x$153 = result.copy$default$13();
                                                                                                        x$154 = result.copy$default$14();
                                                                                                        x$155 = result.copy$default$15();
                                                                                                        x$156 = result.copy$default$16();
                                                                                                        x$157 = result.copy$default$17();
                                                                                                        x$158 = result.copy$default$18();
                                                                                                        x$159 = result.copy$default$19();
                                                                                                        x$160 = result.copy$default$20();
                                                                                                        var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$142, x$143, x$144, x$145, x$146, x$141, x$147, x$148, x$149, x$150, x$151, x$152, x$153, x$154, x$155, x$156, x$157, x$158, x$159, x$160));
                                                                                                        break block6;
                                                                                                    }
                                                                                                    if (var12_8 == null) break block16;
                                                                                                    var191_189 = (String)var12_8._1();
                                                                                                    v = (String)var12_8._2();
                                                                                                    if (!"rm.keepAlive".equals(var191_189)) break block16;
                                                                                                    x$161 = new StringOps(Predef$.MODULE$.augmentString(v)).toBoolean();
                                                                                                    x$162 = result.copy$default$1();
                                                                                                    x$163 = result.copy$default$2();
                                                                                                    x$164 = result.copy$default$3();
                                                                                                    x$165 = result.copy$default$4();
                                                                                                    x$166 = result.copy$default$5();
                                                                                                    x$167 = result.copy$default$6();
                                                                                                    x$168 = result.copy$default$8();
                                                                                                    x$169 = result.copy$default$9();
                                                                                                    x$170 = result.copy$default$10();
                                                                                                    x$171 = result.copy$default$11();
                                                                                                    x$172 = result.copy$default$12();
                                                                                                    x$173 = result.copy$default$13();
                                                                                                    x$174 = result.copy$default$14();
                                                                                                    x$175 = result.copy$default$15();
                                                                                                    x$176 = result.copy$default$16();
                                                                                                    x$177 = result.copy$default$17();
                                                                                                    x$178 = result.copy$default$18();
                                                                                                    x$179 = result.copy$default$19();
                                                                                                    x$180 = result.copy$default$20();
                                                                                                    var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$162, x$163, x$164, x$165, x$166, x$167, x$161, x$168, x$169, x$170, x$171, x$172, x$173, x$174, x$175, x$176, x$177, x$178, x$179, x$180));
                                                                                                    break block6;
                                                                                                }
                                                                                                if (var12_8 == null) break block17;
                                                                                                var213_211 = (String)var12_8._1();
                                                                                                v = (String)var12_8._2();
                                                                                                if (!"rm.nbChannelsPerNode".equals(var213_211)) break block17;
                                                                                                x$181 = new StringOps(Predef$.MODULE$.augmentString(v)).toInt();
                                                                                                x$182 = result.copy$default$1();
                                                                                                x$183 = result.copy$default$2();
                                                                                                x$184 = result.copy$default$3();
                                                                                                x$185 = result.copy$default$4();
                                                                                                x$186 = result.copy$default$5();
                                                                                                x$187 = result.copy$default$6();
                                                                                                x$188 = result.copy$default$7();
                                                                                                x$189 = result.copy$default$9();
                                                                                                x$190 = result.copy$default$10();
                                                                                                x$191 = result.copy$default$11();
                                                                                                x$192 = result.copy$default$12();
                                                                                                x$193 = result.copy$default$13();
                                                                                                x$194 = result.copy$default$14();
                                                                                                x$195 = result.copy$default$15();
                                                                                                x$196 = result.copy$default$16();
                                                                                                x$197 = result.copy$default$17();
                                                                                                x$198 = result.copy$default$18();
                                                                                                x$199 = result.copy$default$19();
                                                                                                x$200 = result.copy$default$20();
                                                                                                var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$182, x$183, x$184, x$185, x$186, x$187, x$188, x$181, x$189, x$190, x$191, x$192, x$193, x$194, x$195, x$196, x$197, x$198, x$199, x$200));
                                                                                                break block6;
                                                                                            }
                                                                                            if (var12_8 == null) break block18;
                                                                                            var235_233 = (String)var12_8._1();
                                                                                            var236_234 = (String)var12_8._2();
                                                                                            if (!"rm.maxInFlightRequestsPerChannel".equals(var235_233) || (var237_235 = MongoConnection$.MODULE$.IntRe().unapplySeq((CharSequence)var236_234)).isEmpty() || var237_235.get() == null || ((LinearSeqOptimized)var237_235.get()).lengthCompare(1) != 0) break block18;
                                                                                            max = (String)((LinearSeqOptimized)var237_235.get()).apply(0);
                                                                                            x$201 = new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(max)).toInt()));
                                                                                            x$202 = result.copy$default$1();
                                                                                            x$203 = result.copy$default$2();
                                                                                            x$204 = result.copy$default$3();
                                                                                            x$205 = result.copy$default$4();
                                                                                            x$206 = result.copy$default$5();
                                                                                            x$207 = result.copy$default$6();
                                                                                            x$208 = result.copy$default$7();
                                                                                            x$209 = result.copy$default$8();
                                                                                            x$210 = result.copy$default$10();
                                                                                            x$211 = result.copy$default$11();
                                                                                            x$212 = result.copy$default$12();
                                                                                            x$213 = result.copy$default$13();
                                                                                            x$214 = result.copy$default$14();
                                                                                            x$215 = result.copy$default$15();
                                                                                            x$216 = result.copy$default$16();
                                                                                            x$217 = result.copy$default$17();
                                                                                            x$218 = result.copy$default$18();
                                                                                            x$219 = result.copy$default$19();
                                                                                            x$220 = result.copy$default$20();
                                                                                            var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$202, x$203, x$204, x$205, x$206, x$207, x$208, x$209, (Option<Object>)x$201, x$210, x$211, x$212, x$213, x$214, x$215, x$216, x$217, x$218, x$219, x$220));
                                                                                            break block6;
                                                                                        }
                                                                                        if (var12_8 == null) break block19;
                                                                                        var259_257 = (String)var12_8._1();
                                                                                        var260_258 = (String)var12_8._2();
                                                                                        if (!"rm.minIdleChannelsPerNode".equals(var259_257) || (var261_259 = MongoConnection$.MODULE$.IntRe().unapplySeq((CharSequence)var260_258)).isEmpty() || var261_259.get() == null || ((LinearSeqOptimized)var261_259.get()).lengthCompare(1) != 0) break block19;
                                                                                        min = (String)((LinearSeqOptimized)var261_259.get()).apply(0);
                                                                                        x$221 = new StringOps(Predef$.MODULE$.augmentString(min)).toInt();
                                                                                        x$222 = result.copy$default$1();
                                                                                        x$223 = result.copy$default$2();
                                                                                        x$224 = result.copy$default$3();
                                                                                        x$225 = result.copy$default$4();
                                                                                        x$226 = result.copy$default$5();
                                                                                        x$227 = result.copy$default$6();
                                                                                        x$228 = result.copy$default$7();
                                                                                        x$229 = result.copy$default$8();
                                                                                        x$230 = result.copy$default$9();
                                                                                        x$231 = result.copy$default$11();
                                                                                        x$232 = result.copy$default$12();
                                                                                        x$233 = result.copy$default$13();
                                                                                        x$234 = result.copy$default$14();
                                                                                        x$235 = result.copy$default$15();
                                                                                        x$236 = result.copy$default$16();
                                                                                        x$237 = result.copy$default$17();
                                                                                        x$238 = result.copy$default$18();
                                                                                        x$239 = result.copy$default$19();
                                                                                        x$240 = result.copy$default$20();
                                                                                        var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$222, x$223, x$224, x$225, x$226, x$227, x$228, x$229, x$230, x$221, x$231, x$232, x$233, x$234, x$235, x$236, x$237, x$238, x$239, x$240));
                                                                                        break block6;
                                                                                    }
                                                                                    if (var12_8 == null) break block20;
                                                                                    var283_281 = (String)var12_8._1();
                                                                                    var284_282 = (String)var12_8._2();
                                                                                    if (!"writeConcern".equals(var283_281) || !"unacknowledged".equals(var284_282)) break block20;
                                                                                    x$241 = WriteConcern$.MODULE$.Unacknowledged();
                                                                                    x$242 = result.copy$default$1();
                                                                                    x$243 = result.copy$default$2();
                                                                                    x$244 = result.copy$default$3();
                                                                                    x$245 = result.copy$default$4();
                                                                                    x$246 = result.copy$default$5();
                                                                                    x$247 = result.copy$default$6();
                                                                                    x$248 = result.copy$default$7();
                                                                                    x$249 = result.copy$default$8();
                                                                                    x$250 = result.copy$default$9();
                                                                                    x$251 = result.copy$default$10();
                                                                                    x$252 = result.copy$default$12();
                                                                                    x$253 = result.copy$default$13();
                                                                                    x$254 = result.copy$default$14();
                                                                                    x$255 = result.copy$default$15();
                                                                                    x$256 = result.copy$default$16();
                                                                                    x$257 = result.copy$default$17();
                                                                                    x$258 = result.copy$default$18();
                                                                                    x$259 = result.copy$default$19();
                                                                                    x$260 = result.copy$default$20();
                                                                                    var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$242, x$243, x$244, x$245, x$246, x$247, x$248, x$249, x$250, x$251, x$241, x$252, x$253, x$254, x$255, x$256, x$257, x$258, x$259, x$260));
                                                                                    break block6;
                                                                                }
                                                                                if (var12_8 == null) break block21;
                                                                                var305_303 = (String)var12_8._1();
                                                                                var306_304 = (String)var12_8._2();
                                                                                if (!"writeConcern".equals(var305_303) || !"acknowledged".equals(var306_304)) break block21;
                                                                                x$261 = WriteConcern$.MODULE$.Acknowledged();
                                                                                x$262 = result.copy$default$1();
                                                                                x$263 = result.copy$default$2();
                                                                                x$264 = result.copy$default$3();
                                                                                x$265 = result.copy$default$4();
                                                                                x$266 = result.copy$default$5();
                                                                                x$267 = result.copy$default$6();
                                                                                x$268 = result.copy$default$7();
                                                                                x$269 = result.copy$default$8();
                                                                                x$270 = result.copy$default$9();
                                                                                x$271 = result.copy$default$10();
                                                                                x$272 = result.copy$default$12();
                                                                                x$273 = result.copy$default$13();
                                                                                x$274 = result.copy$default$14();
                                                                                x$275 = result.copy$default$15();
                                                                                x$276 = result.copy$default$16();
                                                                                x$277 = result.copy$default$17();
                                                                                x$278 = result.copy$default$18();
                                                                                x$279 = result.copy$default$19();
                                                                                x$280 = result.copy$default$20();
                                                                                var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$262, x$263, x$264, x$265, x$266, x$267, x$268, x$269, x$270, x$271, x$261, x$272, x$273, x$274, x$275, x$276, x$277, x$278, x$279, x$280));
                                                                                break block6;
                                                                            }
                                                                            if (var12_8 == null) break block22;
                                                                            var327_325 = (String)var12_8._1();
                                                                            var328_326 = (String)var12_8._2();
                                                                            if (!"writeConcern".equals(var327_325) || !"journaled".equals(var328_326)) break block22;
                                                                            x$281 = WriteConcern$.MODULE$.Journaled();
                                                                            x$282 = result.copy$default$1();
                                                                            x$283 = result.copy$default$2();
                                                                            x$284 = result.copy$default$3();
                                                                            x$285 = result.copy$default$4();
                                                                            x$286 = result.copy$default$5();
                                                                            x$287 = result.copy$default$6();
                                                                            x$288 = result.copy$default$7();
                                                                            x$289 = result.copy$default$8();
                                                                            x$290 = result.copy$default$9();
                                                                            x$291 = result.copy$default$10();
                                                                            x$292 = result.copy$default$12();
                                                                            x$293 = result.copy$default$13();
                                                                            x$294 = result.copy$default$14();
                                                                            x$295 = result.copy$default$15();
                                                                            x$296 = result.copy$default$16();
                                                                            x$297 = result.copy$default$17();
                                                                            x$298 = result.copy$default$18();
                                                                            x$299 = result.copy$default$19();
                                                                            x$300 = result.copy$default$20();
                                                                            var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$282, x$283, x$284, x$285, x$286, x$287, x$288, x$289, x$290, x$291, x$281, x$292, x$293, x$294, x$295, x$296, x$297, x$298, x$299, x$300));
                                                                            break block6;
                                                                        }
                                                                        if (var12_8 == null) break block23;
                                                                        var349_347 = (String)var12_8._1();
                                                                        var350_348 = (String)var12_8._2();
                                                                        if (!"writeConcern".equals(var349_347) || !"default".equals(var350_348)) break block23;
                                                                        x$301 = WriteConcern$.MODULE$.Default();
                                                                        x$302 = result.copy$default$1();
                                                                        x$303 = result.copy$default$2();
                                                                        x$304 = result.copy$default$3();
                                                                        x$305 = result.copy$default$4();
                                                                        x$306 = result.copy$default$5();
                                                                        x$307 = result.copy$default$6();
                                                                        x$308 = result.copy$default$7();
                                                                        x$309 = result.copy$default$8();
                                                                        x$310 = result.copy$default$9();
                                                                        x$311 = result.copy$default$10();
                                                                        x$312 = result.copy$default$12();
                                                                        x$313 = result.copy$default$13();
                                                                        x$314 = result.copy$default$14();
                                                                        x$315 = result.copy$default$15();
                                                                        x$316 = result.copy$default$16();
                                                                        x$317 = result.copy$default$17();
                                                                        x$318 = result.copy$default$18();
                                                                        x$319 = result.copy$default$19();
                                                                        x$320 = result.copy$default$20();
                                                                        var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$302, x$303, x$304, x$305, x$306, x$307, x$308, x$309, x$310, x$311, x$301, x$312, x$313, x$314, x$315, x$316, x$317, x$318, x$319, x$320));
                                                                        break block6;
                                                                    }
                                                                    if (var12_8 == null) break block24;
                                                                    var371_369 = (String)var12_8._1();
                                                                    var372_370 = (String)var12_8._2();
                                                                    if (!"readPreference".equals(var371_369) || !"primary".equals(var372_370)) break block24;
                                                                    x$321 = ReadPreference$.MODULE$.primary();
                                                                    x$322 = result.copy$default$1();
                                                                    x$323 = result.copy$default$2();
                                                                    x$324 = result.copy$default$3();
                                                                    x$325 = result.copy$default$4();
                                                                    x$326 = result.copy$default$5();
                                                                    x$327 = result.copy$default$6();
                                                                    x$328 = result.copy$default$7();
                                                                    x$329 = result.copy$default$8();
                                                                    x$330 = result.copy$default$9();
                                                                    x$331 = result.copy$default$10();
                                                                    x$332 = result.copy$default$11();
                                                                    x$333 = result.copy$default$13();
                                                                    x$334 = result.copy$default$14();
                                                                    x$335 = result.copy$default$15();
                                                                    x$336 = result.copy$default$16();
                                                                    x$337 = result.copy$default$17();
                                                                    x$338 = result.copy$default$18();
                                                                    x$339 = result.copy$default$19();
                                                                    x$340 = result.copy$default$20();
                                                                    var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$322, x$323, x$324, x$325, x$326, x$327, x$328, x$329, x$330, x$331, x$332, x$321, x$333, x$334, x$335, x$336, x$337, x$338, x$339, x$340));
                                                                    break block6;
                                                                }
                                                                if (var12_8 == null) break block25;
                                                                var393_391 = (String)var12_8._1();
                                                                var394_392 = (String)var12_8._2();
                                                                if (!"readPreference".equals(var393_391) || !"primaryPreferred".equals(var394_392)) break block25;
                                                                x$341 = ReadPreference$.MODULE$.primaryPreferred();
                                                                x$342 = result.copy$default$1();
                                                                x$343 = result.copy$default$2();
                                                                x$344 = result.copy$default$3();
                                                                x$345 = result.copy$default$4();
                                                                x$346 = result.copy$default$5();
                                                                x$347 = result.copy$default$6();
                                                                x$348 = result.copy$default$7();
                                                                x$349 = result.copy$default$8();
                                                                x$350 = result.copy$default$9();
                                                                x$351 = result.copy$default$10();
                                                                x$352 = result.copy$default$11();
                                                                x$353 = result.copy$default$13();
                                                                x$354 = result.copy$default$14();
                                                                x$355 = result.copy$default$15();
                                                                x$356 = result.copy$default$16();
                                                                x$357 = result.copy$default$17();
                                                                x$358 = result.copy$default$18();
                                                                x$359 = result.copy$default$19();
                                                                x$360 = result.copy$default$20();
                                                                var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$342, x$343, x$344, x$345, x$346, x$347, x$348, x$349, x$350, x$351, x$352, x$341, x$353, x$354, x$355, x$356, x$357, x$358, x$359, x$360));
                                                                break block6;
                                                            }
                                                            if (var12_8 == null) break block26;
                                                            var415_413 = (String)var12_8._1();
                                                            var416_414 = (String)var12_8._2();
                                                            if (!"readPreference".equals(var415_413) || !"secondary".equals(var416_414)) break block26;
                                                            x$361 = ReadPreference$.MODULE$.secondary();
                                                            x$362 = result.copy$default$1();
                                                            x$363 = result.copy$default$2();
                                                            x$364 = result.copy$default$3();
                                                            x$365 = result.copy$default$4();
                                                            x$366 = result.copy$default$5();
                                                            x$367 = result.copy$default$6();
                                                            x$368 = result.copy$default$7();
                                                            x$369 = result.copy$default$8();
                                                            x$370 = result.copy$default$9();
                                                            x$371 = result.copy$default$10();
                                                            x$372 = result.copy$default$11();
                                                            x$373 = result.copy$default$13();
                                                            x$374 = result.copy$default$14();
                                                            x$375 = result.copy$default$15();
                                                            x$376 = result.copy$default$16();
                                                            x$377 = result.copy$default$17();
                                                            x$378 = result.copy$default$18();
                                                            x$379 = result.copy$default$19();
                                                            x$380 = result.copy$default$20();
                                                            var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$362, x$363, x$364, x$365, x$366, x$367, x$368, x$369, x$370, x$371, x$372, x$361, x$373, x$374, x$375, x$376, x$377, x$378, x$379, x$380));
                                                            break block6;
                                                        }
                                                        if (var12_8 == null) break block27;
                                                        var437_435 = (String)var12_8._1();
                                                        var438_436 = (String)var12_8._2();
                                                        if (!"readPreference".equals(var437_435) || !"secondaryPreferred".equals(var438_436)) break block27;
                                                        x$381 = ReadPreference$.MODULE$.secondaryPreferred();
                                                        x$382 = result.copy$default$1();
                                                        x$383 = result.copy$default$2();
                                                        x$384 = result.copy$default$3();
                                                        x$385 = result.copy$default$4();
                                                        x$386 = result.copy$default$5();
                                                        x$387 = result.copy$default$6();
                                                        x$388 = result.copy$default$7();
                                                        x$389 = result.copy$default$8();
                                                        x$390 = result.copy$default$9();
                                                        x$391 = result.copy$default$10();
                                                        x$392 = result.copy$default$11();
                                                        x$393 = result.copy$default$13();
                                                        x$394 = result.copy$default$14();
                                                        x$395 = result.copy$default$15();
                                                        x$396 = result.copy$default$16();
                                                        x$397 = result.copy$default$17();
                                                        x$398 = result.copy$default$18();
                                                        x$399 = result.copy$default$19();
                                                        x$400 = result.copy$default$20();
                                                        var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$382, x$383, x$384, x$385, x$386, x$387, x$388, x$389, x$390, x$391, x$392, x$381, x$393, x$394, x$395, x$396, x$397, x$398, x$399, x$400));
                                                        break block6;
                                                    }
                                                    if (var12_8 == null) break block28;
                                                    var459_457 = (String)var12_8._1();
                                                    var460_458 = (String)var12_8._2();
                                                    if (!"readPreference".equals(var459_457) || !"nearest".equals(var460_458)) break block28;
                                                    x$401 = ReadPreference$.MODULE$.nearest();
                                                    x$402 = result.copy$default$1();
                                                    x$403 = result.copy$default$2();
                                                    x$404 = result.copy$default$3();
                                                    x$405 = result.copy$default$4();
                                                    x$406 = result.copy$default$5();
                                                    x$407 = result.copy$default$6();
                                                    x$408 = result.copy$default$7();
                                                    x$409 = result.copy$default$8();
                                                    x$410 = result.copy$default$9();
                                                    x$411 = result.copy$default$10();
                                                    x$412 = result.copy$default$11();
                                                    x$413 = result.copy$default$13();
                                                    x$414 = result.copy$default$14();
                                                    x$415 = result.copy$default$15();
                                                    x$416 = result.copy$default$16();
                                                    x$417 = result.copy$default$17();
                                                    x$418 = result.copy$default$18();
                                                    x$419 = result.copy$default$19();
                                                    x$420 = result.copy$default$20();
                                                    var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$402, x$403, x$404, x$405, x$406, x$407, x$408, x$409, x$410, x$411, x$412, x$401, x$413, x$414, x$415, x$416, x$417, x$418, x$419, x$420));
                                                    break block6;
                                                }
                                                if (var12_8 == null) break block29;
                                                var481_479 = (String)var12_8._1();
                                                var482_480 = (String)var12_8._2();
                                                if (!"readConcernLevel".equals(var481_479) || (var483_481 = ReadConcern$.MODULE$.unapply(var482_480)).isEmpty()) break block29;
                                                x$421 = c = (ReadConcern)var483_481.get();
                                                x$422 = result.copy$default$1();
                                                x$423 = result.copy$default$2();
                                                x$424 = result.copy$default$3();
                                                x$425 = result.copy$default$4();
                                                x$426 = result.copy$default$5();
                                                x$427 = result.copy$default$6();
                                                x$428 = result.copy$default$7();
                                                x$429 = result.copy$default$8();
                                                x$430 = result.copy$default$9();
                                                x$431 = result.copy$default$10();
                                                x$432 = result.copy$default$11();
                                                x$433 = result.copy$default$12();
                                                x$434 = result.copy$default$13();
                                                x$435 = result.copy$default$14();
                                                x$436 = result.copy$default$15();
                                                x$437 = result.copy$default$16();
                                                x$438 = result.copy$default$17();
                                                x$439 = result.copy$default$18();
                                                x$440 = result.copy$default$20();
                                                var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$422, x$423, x$424, x$425, x$426, x$427, x$428, x$429, x$430, x$431, x$432, x$433, x$434, x$435, x$436, x$437, x$438, x$439, x$421, x$440));
                                                break block6;
                                            }
                                            if (var12_8 == null) break block30;
                                            var505_503 = (String)var12_8._1();
                                            var506_504 = (String)var12_8._2();
                                            if (!"rm.failover".equals(var505_503) || !"default".equals(var506_504)) break block30;
                                            var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result);
                                            break block6;
                                        }
                                        if (var12_8 == null) break block31;
                                        var507_505 = (String)var12_8._1();
                                        var508_506 = (String)var12_8._2();
                                        if (!"rm.failover".equals(var507_505) || !"remote".equals(var508_506)) break block31;
                                        x$441 = FailoverStrategy$.MODULE$.remote();
                                        x$442 = result.copy$default$1();
                                        x$443 = result.copy$default$2();
                                        x$444 = result.copy$default$3();
                                        x$445 = result.copy$default$4();
                                        x$446 = result.copy$default$5();
                                        x$447 = result.copy$default$6();
                                        x$448 = result.copy$default$7();
                                        x$449 = result.copy$default$8();
                                        x$450 = result.copy$default$9();
                                        x$451 = result.copy$default$10();
                                        x$452 = result.copy$default$11();
                                        x$453 = result.copy$default$12();
                                        x$454 = result.copy$default$14();
                                        x$455 = result.copy$default$15();
                                        x$456 = result.copy$default$16();
                                        x$457 = result.copy$default$17();
                                        x$458 = result.copy$default$18();
                                        x$459 = result.copy$default$19();
                                        x$460 = result.copy$default$20();
                                        var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$442, x$443, x$444, x$445, x$446, x$447, x$448, x$449, x$450, x$451, x$452, x$453, x$441, x$454, x$455, x$456, x$457, x$458, x$459, x$460));
                                        break block6;
                                    }
                                    if (var12_8 == null) break block32;
                                    var529_527 = (String)var12_8._1();
                                    var530_528 = (String)var12_8._2();
                                    if (!"rm.failover".equals(var529_527) || !"strict".equals(var530_528)) break block32;
                                    x$461 = FailoverStrategy$.MODULE$.strict();
                                    x$462 = result.copy$default$1();
                                    x$463 = result.copy$default$2();
                                    x$464 = result.copy$default$3();
                                    x$465 = result.copy$default$4();
                                    x$466 = result.copy$default$5();
                                    x$467 = result.copy$default$6();
                                    x$468 = result.copy$default$7();
                                    x$469 = result.copy$default$8();
                                    x$470 = result.copy$default$9();
                                    x$471 = result.copy$default$10();
                                    x$472 = result.copy$default$11();
                                    x$473 = result.copy$default$12();
                                    x$474 = result.copy$default$14();
                                    x$475 = result.copy$default$15();
                                    x$476 = result.copy$default$16();
                                    x$477 = result.copy$default$17();
                                    x$478 = result.copy$default$18();
                                    x$479 = result.copy$default$19();
                                    x$480 = result.copy$default$20();
                                    var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$462, x$463, x$464, x$465, x$466, x$467, x$468, x$469, x$470, x$471, x$472, x$473, x$461, x$474, x$475, x$476, x$477, x$478, x$479, x$480));
                                    break block6;
                                }
                                if (var12_8 == null) break block33;
                                var551_549 = (String)var12_8._1();
                                opt = (String)var12_8._2();
                                if (!"rm.failover".equals(var551_549) || (var553_551 = MongoConnection$.MODULE$.FailoverRe().unapplySeq((CharSequence)opt)).isEmpty() || var553_551.get() == null || ((LinearSeqOptimized)var553_551.get()).lengthCompare(3) != 0) break block33;
                                d = (String)((LinearSeqOptimized)var553_551.get()).apply(0);
                                r = (String)((LinearSeqOptimized)var553_551.get()).apply(1);
                                f = (String)((LinearSeqOptimized)var553_551.get()).apply(2);
                                var4_10 = $this.make$1("rm.failover", opt, unsupported, result, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$makeOptions$6(java.lang.String java.lang.String java.lang.String java.lang.String reactivemongo.api.MongoConnectionOptions ), ()Lreactivemongo/api/MongoConnectionOptions;)((String)d, (String)opt, (String)r, (String)f, (MongoConnectionOptions)result));
                                break block6;
                            }
                            if (var12_8 == null) break block34;
                            var557_555 = (String)var12_8._1();
                            var558_556 = (String)var12_8._2();
                            if (!"retryWrites".equals(var557_555) || !"true".equals(var558_556)) break block34;
                            MongoConnection$.MODULE$.logger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$makeOptions$8(), ()Ljava/lang/String;)());
                            var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result);
                            break block6;
                        }
                        if (var12_8 == null || !"retryWrites".equals(var559_557 = (String)var12_8._1())) break block35;
                        MongoConnection$.MODULE$.logger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$makeOptions$9(), ()Ljava/lang/String;)());
                        x$501 = FailoverStrategy$.MODULE$.strict();
                        x$502 = result.copy$default$1();
                        x$503 = result.copy$default$2();
                        x$504 = result.copy$default$3();
                        x$505 = result.copy$default$4();
                        x$506 = result.copy$default$5();
                        x$507 = result.copy$default$6();
                        x$508 = result.copy$default$7();
                        x$509 = result.copy$default$8();
                        x$510 = result.copy$default$9();
                        x$511 = result.copy$default$10();
                        x$512 = result.copy$default$11();
                        x$513 = result.copy$default$12();
                        x$514 = result.copy$default$14();
                        x$515 = result.copy$default$15();
                        x$516 = result.copy$default$16();
                        x$517 = result.copy$default$17();
                        x$518 = result.copy$default$18();
                        x$519 = result.copy$default$19();
                        x$520 = result.copy$default$20();
                        var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$502, x$503, x$504, x$505, x$506, x$507, x$508, x$509, x$510, x$511, x$512, x$513, x$501, x$514, x$515, x$516, x$517, x$518, x$519, x$520));
                        break block6;
                    }
                    if (var12_8 == null) break block36;
                    var580_578 = (String)var12_8._1();
                    var581_579 = (String)var12_8._2();
                    if (!"heartbeatFrequencyMS".equals(var580_578) || (var582_580 = MongoConnection$.MODULE$.IntRe().unapplySeq((CharSequence)var581_579)).isEmpty() || var582_580.get() == null || ((LinearSeqOptimized)var582_580.get()).lengthCompare(1) != 0) break block36;
                    ms = (String)((LinearSeqOptimized)var582_580.get()).apply(0);
                    var4_10 = $this.make$1("heartbeatFrequencyMS", ms, unsupported, result, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$makeOptions$10(java.lang.String reactivemongo.api.MongoConnectionOptions ), ()Lreactivemongo/api/MongoConnectionOptions;)((String)ms, (MongoConnectionOptions)result));
                    break block6;
                }
                if (var12_8 == null) ** GOTO lbl-1000
                var584_582 = (String)var12_8._1();
                nme = (String)var12_8._2();
                if ("appName".equals(var584_582)) {
                    var586_584 = Option$.MODULE$.apply((Object)nme).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$makeOptions$11(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$makeOptions$12$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)());
                    if (var586_584 instanceof Some) {
                        var587_585 = (Some)var586_584;
                        appName = (String)var587_585.value();
                        x$541 = new Some((Object)appName);
                        x$542 = result.copy$default$1();
                        x$543 = result.copy$default$2();
                        x$544 = result.copy$default$3();
                        x$545 = result.copy$default$4();
                        x$546 = result.copy$default$5();
                        x$547 = result.copy$default$6();
                        x$548 = result.copy$default$7();
                        x$549 = result.copy$default$8();
                        x$550 = result.copy$default$9();
                        x$551 = result.copy$default$10();
                        x$552 = result.copy$default$11();
                        x$553 = result.copy$default$12();
                        x$554 = result.copy$default$13();
                        x$555 = result.copy$default$14();
                        x$556 = result.copy$default$15();
                        x$557 = result.copy$default$16();
                        x$558 = result.copy$default$17();
                        x$559 = result.copy$default$18();
                        x$560 = result.copy$default$19();
                        var5_607 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$542, x$543, x$544, x$545, x$546, x$547, x$548, x$549, x$550, x$551, x$552, x$553, x$554, x$555, x$556, x$557, x$558, x$559, x$560, (Option<String>)x$541));
                    } else {
                        var5_607 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"appName"), (Object)nme))), (Object)result);
                    }
                    var4_10 = var5_607;
                } else lbl-1000:
                // 2 sources

                {
                    var4_10 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported.$plus(var12_8)), (Object)result);
                }
                break block6;
            }
            throw new MatchError((Object)var7_3);
        }
        var3_608 = var4_10;
        return var3_608;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple2 $anonfun$makeOptions$17(MongoConnection$ $this, Tuple2 x0$2, Tuple2 x1$2) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        block4: {
                            var10_3 = new Tuple2((Object)x0$2, (Object)x1$2);
                            if (var10_3 == null) ** GOTO lbl185
                            var11_4 = (Tuple2)var10_3._1();
                            kv = (Tuple2)var10_3._2();
                            if (var11_4 == null) ** GOTO lbl185
                            unsupported = (List)var11_4._1();
                            result = (MongoConnectionOptions)var11_4._2();
                            var15_8 = kv;
                            if (var15_8 == null) break block4;
                            o = (String)var15_8._1();
                            var17_10 = (String)var15_8._2();
                            var9_11 = "writeConcernW".equals(o) != false ? true : "w".equals(o) != false;
                            if (!var9_11 || !"majority".equals(var17_10)) break block4;
                            $this.deprecated$1(o, "w");
                            qual$1 = result.writeConcern();
                            x$581 = WriteConcern$Majority$.MODULE$;
                            x$582 = qual$1.copy$default$2();
                            x$583 = qual$1.copy$default$3();
                            x$584 = qual$1.copy$default$4();
                            x$585 = qual$1.copy(x$581, x$582, x$583, x$584);
                            x$586 = result.copy$default$1();
                            x$587 = result.copy$default$2();
                            x$588 = result.copy$default$3();
                            x$589 = result.copy$default$4();
                            x$590 = result.copy$default$5();
                            x$591 = result.copy$default$6();
                            x$592 = result.copy$default$7();
                            x$593 = result.copy$default$8();
                            x$594 = result.copy$default$9();
                            x$595 = result.copy$default$10();
                            x$596 = result.copy$default$12();
                            x$597 = result.copy$default$13();
                            x$598 = result.copy$default$14();
                            x$599 = result.copy$default$15();
                            x$600 = result.copy$default$16();
                            x$601 = result.copy$default$17();
                            x$602 = result.copy$default$18();
                            x$603 = result.copy$default$19();
                            x$604 = result.copy$default$20();
                            var4_37 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$586, x$587, x$588, x$589, x$590, x$591, x$592, x$593, x$594, x$595, x$585, x$596, x$597, x$598, x$599, x$600, x$601, x$602, x$603, x$604));
                            break block5;
                        }
                        if (var15_8 == null) break block6;
                        o = (String)var15_8._1();
                        var44_39 = (String)var15_8._2();
                        var8_40 = "writeConcernW".equals(o) != false ? true : "w".equals(o) != false;
                        if (!var8_40 || (var45_41 = MongoConnection$.MODULE$.IntRe().unapplySeq((CharSequence)var44_39)).isEmpty() || var45_41.get() == null || ((LinearSeqOptimized)var45_41.get()).lengthCompare(1) != 0) break block6;
                        str = (String)((LinearSeqOptimized)var45_41.get()).apply(0);
                        $this.deprecated$1(o, "w");
                        qual$2 = result.writeConcern();
                        x$605 = WriteConcern$WaitForAcknowledgments$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString(str)).toInt());
                        x$606 = qual$2.copy$default$2();
                        x$607 = qual$2.copy$default$3();
                        x$608 = qual$2.copy$default$4();
                        x$609 = qual$2.copy(x$605, x$606, x$607, x$608);
                        x$610 = result.copy$default$1();
                        x$611 = result.copy$default$2();
                        x$612 = result.copy$default$3();
                        x$613 = result.copy$default$4();
                        x$614 = result.copy$default$5();
                        x$615 = result.copy$default$6();
                        x$616 = result.copy$default$7();
                        x$617 = result.copy$default$8();
                        x$618 = result.copy$default$9();
                        x$619 = result.copy$default$10();
                        x$620 = result.copy$default$12();
                        x$621 = result.copy$default$13();
                        x$622 = result.copy$default$14();
                        x$623 = result.copy$default$15();
                        x$624 = result.copy$default$16();
                        x$625 = result.copy$default$17();
                        x$626 = result.copy$default$18();
                        x$627 = result.copy$default$19();
                        x$628 = result.copy$default$20();
                        var4_37 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$610, x$611, x$612, x$613, x$614, x$615, x$616, x$617, x$618, x$619, x$609, x$620, x$621, x$622, x$623, x$624, x$625, x$626, x$627, x$628));
                        break block5;
                    }
                    if (var15_8 == null) break block7;
                    o = (String)var15_8._1();
                    tag = (String)var15_8._2();
                    var7_70 = "writeConcernW".equals(o) != false ? true : "w".equals(o) != false;
                    if (!var7_70) break block7;
                    $this.deprecated$1(o, "w");
                    qual$3 = result.writeConcern();
                    x$629 = WriteConcern$TagSet$.MODULE$.apply(tag);
                    x$630 = qual$3.copy$default$2();
                    x$631 = qual$3.copy$default$3();
                    x$632 = qual$3.copy$default$4();
                    x$633 = qual$3.copy(x$629, x$630, x$631, x$632);
                    x$634 = result.copy$default$1();
                    x$635 = result.copy$default$2();
                    x$636 = result.copy$default$3();
                    x$637 = result.copy$default$4();
                    x$638 = result.copy$default$5();
                    x$639 = result.copy$default$6();
                    x$640 = result.copy$default$7();
                    x$641 = result.copy$default$8();
                    x$642 = result.copy$default$9();
                    x$643 = result.copy$default$10();
                    x$644 = result.copy$default$12();
                    x$645 = result.copy$default$13();
                    x$646 = result.copy$default$14();
                    x$647 = result.copy$default$15();
                    x$648 = result.copy$default$16();
                    x$649 = result.copy$default$17();
                    x$650 = result.copy$default$18();
                    x$651 = result.copy$default$19();
                    x$652 = result.copy$default$20();
                    var4_37 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$634, x$635, x$636, x$637, x$638, x$639, x$640, x$641, x$642, x$643, x$633, x$644, x$645, x$646, x$647, x$648, x$649, x$650, x$651, x$652));
                    break block5;
                }
                if (var15_8 == null) break block8;
                o = (String)var15_8._1();
                journaled = (String)var15_8._2();
                var6_98 = "journal".equals(o) != false ? true : "writeConcernJ".equals(o) != false;
                if (!var6_98) break block8;
                $this.deprecated$1(o, "journal");
                qual$4 = result.writeConcern();
                x$653 = new StringOps(Predef$.MODULE$.augmentString(journaled)).toBoolean();
                x$654 = qual$4.copy$default$1();
                x$655 = qual$4.copy$default$3();
                x$656 = qual$4.copy$default$4();
                x$657 = qual$4.copy(x$654, x$653, x$655, x$656);
                x$658 = result.copy$default$1();
                x$659 = result.copy$default$2();
                x$660 = result.copy$default$3();
                x$661 = result.copy$default$4();
                x$662 = result.copy$default$5();
                x$663 = result.copy$default$6();
                x$664 = result.copy$default$7();
                x$665 = result.copy$default$8();
                x$666 = result.copy$default$9();
                x$667 = result.copy$default$10();
                x$668 = result.copy$default$12();
                x$669 = result.copy$default$13();
                x$670 = result.copy$default$14();
                x$671 = result.copy$default$15();
                x$672 = result.copy$default$16();
                x$673 = result.copy$default$17();
                x$674 = result.copy$default$18();
                x$675 = result.copy$default$19();
                x$676 = result.copy$default$20();
                var4_37 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$658, x$659, x$660, x$661, x$662, x$663, x$664, x$665, x$666, x$667, x$657, x$668, x$669, x$670, x$671, x$672, x$673, x$674, x$675, x$676));
                break block5;
            }
            if (var15_8 == null) ** GOTO lbl-1000
            o = (String)var15_8._1();
            var127_125 = (String)var15_8._2();
            var5_126 = "wtimeoutMS".equals(o) != false ? true : "writeConcernTimeout".equals(o) != false;
            if (var5_126 && !(var128_127 = MongoConnection$.MODULE$.IntRe().unapplySeq((CharSequence)var127_125)).isEmpty() && var128_127.get() != null && ((LinearSeqOptimized)var128_127.get()).lengthCompare(1) == 0) {
                ms = (String)((LinearSeqOptimized)var128_127.get()).apply(0);
                $this.deprecated$1(o, "journal");
                qual$5 = result.writeConcern();
                x$677 = new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(ms)).toInt()));
                x$678 = qual$5.copy$default$1();
                x$679 = qual$5.copy$default$2();
                x$680 = qual$5.copy$default$3();
                x$681 = qual$5.copy(x$678, x$679, x$680, (Option<Object>)x$677);
                x$682 = result.copy$default$1();
                x$683 = result.copy$default$2();
                x$684 = result.copy$default$3();
                x$685 = result.copy$default$4();
                x$686 = result.copy$default$5();
                x$687 = result.copy$default$6();
                x$688 = result.copy$default$7();
                x$689 = result.copy$default$8();
                x$690 = result.copy$default$9();
                x$691 = result.copy$default$10();
                x$692 = result.copy$default$12();
                x$693 = result.copy$default$13();
                x$694 = result.copy$default$14();
                x$695 = result.copy$default$15();
                x$696 = result.copy$default$16();
                x$697 = result.copy$default$17();
                x$698 = result.copy$default$18();
                x$699 = result.copy$default$19();
                x$700 = result.copy$default$20();
                var4_37 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported), (Object)result.copy(x$682, x$683, x$684, x$685, x$686, x$687, x$688, x$689, x$690, x$691, x$681, x$692, x$693, x$694, x$695, x$696, x$697, x$698, x$699, x$700));
            } else if (var15_8 != null) {
                var156_155 = k = (String)var15_8._1();
                var4_37 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unsupported.$colon$colon((Object)var156_155)), (Object)result);
            } else {
                throw new MatchError((Object)var15_8);
lbl185:
                // 2 sources

                throw new MatchError((Object)var10_3);
            }
        }
        var3_156 = var4_37;
        return var3_156;
    }

    private MongoConnection$() {
        MODULE$ = this;
        this.DefaultHost = "localhost";
        this.DefaultPort = 27017;
        this.logger = LazyLogger$.MODULE$.apply("reactivemongo.api.MongoConnection");
        this.IntRe = new StringOps(Predef$.MODULE$.augmentString("^([0-9]+)$")).r();
        this.FailoverRe = new StringOps(Predef$.MODULE$.augmentString("^([^:]+):([0-9]+)x([0-9.]+)$")).r();
    }

    public static final /* synthetic */ Object $anonfun$makeOptions$12$adapted(String v) {
        return BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$makeOptions$12(v));
    }
}

