/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api;

import akka.actor.ActorRef;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import reactivemongo.api.Failover2$;
import reactivemongo.api.FailoverStrategy;
import reactivemongo.api.MongoConnection;
import reactivemongo.core.actors.Exceptions;
import reactivemongo.core.actors.ExpectingResponse;
import reactivemongo.core.errors.ConnectionException;
import reactivemongo.core.errors.ConnectionNotInitialized;
import reactivemongo.core.errors.DatabaseException;
import reactivemongo.core.protocol.Response;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005=c\u0001B\u0007\u000f\u0001MA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011!\t\u0007A!A!\u0002\u0017\u0011\u0007\"\u00025\u0001\t\u0003I\u0007bB;\u0001\u0005\u0004%IA\u001e\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003x\u0011%\t\u0019\u0001\u0001b\u0001\n\u0003\t)\u0001\u0003\u0005\u0002\u000e\u0001\u0001\u000b\u0011BA\u0004\u0011\u001d\ty\u0001\u0001C\u0005\u0003#Aq!a\t\u0001\t\u0013\t)C\u0001\u0005GC&dwN^3s\u0015\ty\u0001#A\u0002ba&T\u0011!E\u0001\u000ee\u0016\f7\r^5wK6|gnZ8\u0004\u0001U\u0011ACH\n\u0003\u0001U\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0017aB7fgN\fw-\u001a\t\u0003;ya\u0001\u0001B\u0003 \u0001\t\u0007\u0001EA\u0001U#\t\tC\u0005\u0005\u0002\u0017E%\u00111e\u0006\u0002\b\u001d>$\b.\u001b8h!\t1R%\u0003\u0002'/\t\u0019\u0011I\\=\u0002\u0015\r|gN\\3di&|g\u000e\u0005\u0002*U5\ta\"\u0003\u0002,\u001d\tyQj\u001c8h_\u000e{gN\\3di&|g.\u0001\tgC&dwN^3s'R\u0014\u0018\r^3hsB\u0011\u0011FL\u0005\u0003_9\u0011\u0001CR1jY>4XM]*ue\u0006$XmZ=)\u0007\r\tD\u0007\u0005\u0002\u0017e%\u00111g\u0006\u0002\u000fI\u0016\u0004(/Z2bi\u0016$g*Y7fc\u0011yR\u0007O)\u0011\u0005Y1\u0014BA\u001c\u0018\u0005\u0019\u0019\u00160\u001c2pYF*1%\u000f\u001fL{Q\u0011QG\u000f\u0005\u0006wI\u0001\r\u0001Q\u0001\u0005]\u0006lW-\u0003\u0002>}\u0005)\u0011\r\u001d9ms*\u0011qhF\u0001\u0007'fl'm\u001c7\u0011\u0005\u0005CeB\u0001\"G!\t\u0019u#D\u0001E\u0015\t)%#\u0001\u0004=e>|GOP\u0005\u0003\u000f^\ta\u0001\u0015:fI\u00164\u0017BA%K\u0005\u0019\u0019FO]5oO*\u0011qiF\u0019\u0006G1{\u0005k\u0010\b\u0003\u001b>s!a\u0011(\n\u0003aI!aP\f2\t\u0011je\nG\u0019\u0004KI\u001bv\"A*\"\u0003Q\u000b\u0001b\u001d;sCR,w-_\u0001\u0017Kb\u0004Xm\u0019;j]\u001e\u0014Vm\u001d9p]N,W*Y6feB!ac\u0016\u000fZ\u0013\tAvCA\u0005Gk:\u001cG/[8ocA\u0011!lX\u0007\u00027*\u0011A,X\u0001\u0007C\u000e$xN]:\u000b\u0005y\u0003\u0012\u0001B2pe\u0016L!\u0001Y.\u0003#\u0015C\b/Z2uS:<'+Z:q_:\u001cX-\u0001\u0002fGB\u00111MZ\u0007\u0002I*\u0011QmF\u0001\u000bG>t7-\u001e:sK:$\u0018BA4e\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0005U>\u0004\u0018\u000f\u0006\u0002l]R\u0011A.\u001c\t\u0004S\u0001a\u0002\"B1\u0007\u0001\b\u0011\u0007\"B+\u0007\u0001\u00041\u0006\"B\u000e\u0007\u0001\u0004a\u0002\"B\u0014\u0007\u0001\u0004A\u0003\"\u0002\u0017\u0007\u0001\u0004i\u0003fA92gF\"q$\u000e;Rc\u0015\u0019\u0013\bP&>\u0003\u001d\u0001(o\\7jg\u0016,\u0012a\u001e\t\u0004GbT\u0018BA=e\u0005\u001d\u0001&o\\7jg\u0016\u0004\"a\u001f@\u000e\u0003qT!!`/\u0002\u0011A\u0014x\u000e^8d_2L!a ?\u0003\u0011I+7\u000f]8og\u0016\f\u0001\u0002\u001d:p[&\u001cX\rI\u0001\u0007MV$XO]3\u0016\u0005\u0005\u001d\u0001\u0003B2\u0002\niL1!a\u0003e\u0005\u00191U\u000f^;sK\u00069a-\u001e;ve\u0016\u0004\u0013\u0001B:f]\u0012$B!a\u0005\u0002\u001aA\u0019a#!\u0006\n\u0007\u0005]qC\u0001\u0003V]&$\bbBA\u000e\u0017\u0001\u0007\u0011QD\u0001\u0002]B\u0019a#a\b\n\u0007\u0005\u0005rCA\u0002J]R\f1\"[:SKR\u0014\u00180\u00192mKR!\u0011qEA\u0017!\r1\u0012\u0011F\u0005\u0004\u0003W9\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003_a\u0001\u0019AA\u0019\u0003%!\bN]8xC\ndW\r\u0005\u0003\u00024\u0005ebbA'\u00026%\u0019\u0011qG\f\u0002\u000fA\f7m[1hK&!\u00111HA\u001f\u0005%!\u0006N]8xC\ndWMC\u0002\u00028]As\u0001AA!\u0003\u000f\nY\u0005E\u0002\u0017\u0003\u0007J1!!\u0012\u0018\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0003\u0013\nq#\u00168vg\u0016$G\u0006I<jY2\u0004#-\u001a\u0011sK6|g/\u001a3\"\u0005\u00055\u0013A\u0002\u0019/c]r\u0003\u0007")
public class Failover<T> {
    private final T message;
    private final MongoConnection connection;
    private final FailoverStrategy failoverStrategy;
    private final Function1<T, ExpectingResponse> expectingResponseMaker;
    private final ExecutionContext ec;
    private final Promise<Response> promise;
    private final Future<Response> future;

    private Promise<Response> promise() {
        return this.promise;
    }

    public Future<Response> future() {
        return this.future;
    }

    private void send(int n) {
        ExpectingResponse expectingResponse = (ExpectingResponse)this.expectingResponseMaker.apply(this.message);
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.connection.mongosystem());
        ExpectingResponse x$1 = expectingResponse;
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
        expectingResponse.future().onComplete((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            Failure failure = null;
            Try try_ = x0$1;
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable e = failure.exception();
                if (this.isRetryable(e)) {
                    Promise promise;
                    if (n < $this.failoverStrategy.retries()) {
                        int n = n + 1;
                        double delayFactor = $this.failoverStrategy.delayFactor().apply$mcDI$sp(n);
                        FiniteDuration delay = (FiniteDuration)Duration$.MODULE$.unapply($this.failoverStrategy.initialDelay().$times(delayFactor)).fold((Function0 & Serializable)() -> $this.failoverStrategy.initialDelay(), (Function1 & Serializable)t -> FiniteDuration$.MODULE$.apply(t._1$mcJ$sp(), (TimeUnit)((Object)((Object)((Object)t._2())))));
                        Failover2$.MODULE$.logger().debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Got an error, retrying... (try #").append(n).append(" is scheduled in ").append(delay.toMillis()).append(" ms)").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                        promise = $this.connection.actorSystem().scheduler().scheduleOnce(delay, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.send(n), $this.ec);
                        return promise;
                    } else {
                        Failover2$.MODULE$.logger().error((Function0<String>)(Function0 & Serializable)() -> "Got an error, no more attempts to do. Completing with a failure...", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                        promise = this.promise().failure(e);
                    }
                    return promise;
                }
            }
            if (bl) {
                Throwable e = failure.exception();
                Failover2$.MODULE$.logger().trace((Function0<String>)(Function0 & Serializable)() -> "Got an non retryable error, completing with a failure...", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return this.promise().failure(e);
            }
            if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
            Success success = (Success)try_;
            Response response = (Response)success.value();
            Failover2$.MODULE$.logger().trace((Function0<String>)(Function0 & Serializable)() -> "Got a successful result, completing...");
            return this.promise().success((Object)response);
        }, this.ec);
    }

    private boolean isRetryable(Throwable throwable) {
        boolean bl;
        Throwable throwable2 = throwable;
        if (throwable2 instanceof Exceptions.ChannelNotFound) {
            Exceptions.ChannelNotFound channelNotFound = (Exceptions.ChannelNotFound)throwable2;
            bl = channelNotFound.retriable();
        } else {
            DatabaseException databaseException;
            bl = throwable2 instanceof Exceptions.NotAuthenticatedException ? true : (throwable2 instanceof Exceptions.PrimaryUnavailableException ? true : (throwable2 instanceof Exceptions.NodeSetNotReachable ? true : (throwable2 instanceof ConnectionException ? true : (throwable2 instanceof ConnectionNotInitialized ? true : (throwable2 instanceof DatabaseException ? (databaseException = (DatabaseException)((Object)throwable2)).isNotAPrimaryError() || databaseException.isUnauthorized() : false)))));
        }
        return bl;
    }

    public Failover(T message, MongoConnection connection, FailoverStrategy failoverStrategy, Function1<T, ExpectingResponse> expectingResponseMaker, ExecutionContext ec) {
        this.message = message;
        this.connection = connection;
        this.failoverStrategy = failoverStrategy;
        this.expectingResponseMaker = expectingResponseMaker;
        this.ec = ec;
        this.promise = Promise$.MODULE$.apply();
        this.future = this.promise().future();
        this.send(0);
    }
}

