/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.core.protocol;

import akka.actor.ActorRef;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import reactivemongo.core.actors.ChannelConnected;
import reactivemongo.core.actors.ChannelDisconnected;
import reactivemongo.core.protocol.MongoHandler$;
import reactivemongo.core.protocol.Response;
import reactivemongo.io.netty.channel.Channel;
import reactivemongo.io.netty.channel.ChannelHandlerContext;
import reactivemongo.io.netty.channel.ChannelPromise;
import reactivemongo.io.netty.handler.timeout.IdleStateEvent;
import reactivemongo.io.netty.handler.timeout.IdleStateHandler;
import reactivemongo.util.LazyLogger;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Md!B\f\u0019\u0001qq\u0002\u0002D\u0016\u0001\t\u0003\u0005)Q!A!\u0002\u0013i\u0003\u0002\u0004\u001e\u0001\t\u0003\u0005)Q!A!\u0002\u0013i\u0003\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015CQ!\u0013\u0001\u0005\u0002)Cqa\u0015\u0001A\u0002\u0013%A\u000bC\u0004V\u0001\u0001\u0007I\u0011\u0002,\t\rq\u0003\u0001\u0015)\u0003F\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u00159\u0007\u0001\"\u0011i\u0011\u0015y\u0007\u0001\"\u0011q\u0011\u0015\u0011\b\u0001\"\u0011t\u0011\u0015Q\b\u0001\"\u0011|\u0011\u001d\t9\u0001\u0001C!\u0003\u0013Aq!a\t\u0001\t\u0003\n)\u0003C\u0004\u0002*\u0001!\t!a\u000b\t\u000f\u0005%\u0002\u0001\"\u0001\u0002<\u001dA\u0011Q\t\r\t\u0002q\t9EB\u0004\u00181!\u0005A$!\u0013\t\r%\u001bB\u0011AA)\u0011%\t\u0019f\u0005b\u0001\n\u0003\t)\u0006\u0003\u0005\u0002rM\u0001\u000b\u0011BA,\u00051iuN\\4p\u0011\u0006tG\r\\3s\u0015\tI\"$\u0001\u0005qe>$xnY8m\u0015\tYB$\u0001\u0003d_J,'\"A\u000f\u0002\u001bI,\u0017m\u0019;jm\u0016lwN\\4p'\t\u0001q\u0004\u0005\u0002!S5\t\u0011E\u0003\u0002#G\u00059A/[7f_V$(B\u0001\u0013&\u0003\u001dA\u0017M\u001c3mKJT!AJ\u0014\u0002\u000b9,G\u000f^=\u000b\u0005!b\u0012AA5p\u0013\tQ\u0013E\u0001\tJI2,7\u000b^1uK\"\u000bg\u000e\u001a7fe\u0006!$/Z1di&4X-\\8oO>$3m\u001c:fIA\u0014x\u000e^8d_2$Sj\u001c8h_\"\u000bg\u000e\u001a7fe\u0012\"3/\u001e9feZL7o\u001c:\u0004\u0001A\u0011af\u000e\b\u0003_U\u0002\"\u0001M\u001a\u000e\u0003ER!A\r\u0017\u0002\rq\u0012xn\u001c;?\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001(\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y\u001a\u0014\u0001\u000e:fC\u000e$\u0018N^3n_:<w\u000eJ2pe\u0016$\u0003O]8u_\u000e|G\u000eJ'p]\u001e|\u0007*\u00198eY\u0016\u0014H\u0005J2p]:,7\r^5p]\u0006A!/Z2fSZ,'\u000f\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u0006)\u0011m\u0019;pe*\t\u0011)\u0001\u0003bW.\f\u0017BA\"?\u0005!\t5\r^8s%\u00164\u0017AC5eY\u0016$\u0016.\\3N'B\u0011aiR\u0007\u0002g%\u0011\u0001j\r\u0002\u0005\u0019>tw-\u0001\u0004=S:LGO\u0010\u000b\u0006\u00176{\u0015K\u0015\t\u0003\u0019\u0002i\u0011\u0001\u0007\u0005\u0006\u001d\u0016\u0001\r!L\u0001\u000bgV\u0004XM\u001d<jg>\u0014\b\"\u0002)\u0006\u0001\u0004i\u0013AC2p]:,7\r^5p]\")1(\u0002a\u0001y!)A)\u0002a\u0001\u000b\u0006!A.Y:u+\u0005)\u0015\u0001\u00037bgR|F%Z9\u0015\u0005]S\u0006C\u0001$Y\u0013\tI6G\u0001\u0003V]&$\bbB.\b\u0003\u0003\u0005\r!R\u0001\u0004q\u0012\n\u0014!\u00027bgR\u0004\u0013!D2iC:tW\r\\!di&4X\r\u0006\u0002X?\")\u0001-\u0003a\u0001C\u0006\u00191\r\u001e=\u0011\u0005\t,W\"A2\u000b\u0005\u0011,\u0013aB2iC:tW\r\\\u0005\u0003M\u000e\u0014Qc\u00115b]:,G\u000eS1oI2,'oQ8oi\u0016DH/A\u0006dQ\u0006tg.\u001a7JI2,GcA,jU\")\u0001M\u0003a\u0001C\")1N\u0003a\u0001Y\u0006\tQ\r\u0005\u0002![&\u0011a.\t\u0002\u000f\u0013\u0012dWm\u0015;bi\u0016,e/\u001a8u\u0003=\u0019\u0007.\u00198oK2Le.Y2uSZ,GCA,r\u0011\u0015\u00017\u00021\u0001b\u0003-\u0019\u0007.\u00198oK2\u0014V-\u00193\u0015\u0007]#X\u000fC\u0003a\u0019\u0001\u0007\u0011\rC\u0003w\u0019\u0001\u0007q/A\u0002ng\u001e\u0004\"A\u0012=\n\u0005e\u001c$aA!os\u0006)qO]5uKR!q\u000b`?\u007f\u0011\u0015\u0001W\u00021\u0001b\u0011\u00151X\u00021\u0001x\u0011\u0019yX\u00021\u0001\u0002\u0002\u00059\u0001O]8nSN,\u0007c\u00012\u0002\u0004%\u0019\u0011QA2\u0003\u001d\rC\u0017M\u001c8fYB\u0013x.\\5tK\u0006yQ\r_2faRLwN\\\"bk\u001eDG\u000fF\u0003X\u0003\u0017\ti\u0001C\u0003a\u001d\u0001\u0007\u0011\rC\u0004\u0002\u00109\u0001\r!!\u0005\u0002\u000b\r\fWo]3\u0011\t\u0005M\u0011Q\u0004\b\u0005\u0003+\tIBD\u00021\u0003/I\u0011\u0001N\u0005\u0004\u00037\u0019\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003?\t\tCA\u0005UQJ|w/\u00192mK*\u0019\u00111D\u001a\u0002\u0019!\fg\u000e\u001a7fe\u0006#G-\u001a3\u0015\u0007]\u000b9\u0003C\u0003a\u001f\u0001\u0007\u0011-A\u0002m_\u001e$RaVA\u0017\u0003_AQ\u0001\u0019\tA\u0002\u0005Da!!\r\u0011\u0001\u0004i\u0013!A:)\u0007A\t)\u0004E\u0002G\u0003oI1!!\u000f4\u0005\u0019Ig\u000e\\5oKR9q+!\u0010\u0002@\u0005\u0005\u0003\"\u00021\u0012\u0001\u0004\t\u0007BBA\u0019#\u0001\u0007Q\u0006C\u0004\u0002\u0010E\u0001\r!!\u0005)\u0007E\t)$\u0001\u0007N_:<w\u000eS1oI2,'\u000f\u0005\u0002M'M\u00191#a\u0013\u0011\u0007\u0019\u000bi%C\u0002\u0002PM\u0012a!\u00118z%\u00164GCAA$\u0003\u0019awnZ4feV\u0011\u0011q\u000b\t\u0005\u00033\nYG\u0004\u0003\u0002\\\u0005\u0015d\u0002BA/\u0003Cr1\u0001MA0\u0013\u0005i\u0012bAA29\u0005!Q\u000f^5m\u0013\u0011\t9'!\u001b\u0002\u00151\u000b'0\u001f'pO\u001e,'OC\u0002\u0002dqIA!!\u001c\u0002p\tQA*\u0019>z\u0019><w-\u001a:\u000b\t\u0005\u001d\u0014\u0011N\u0001\bY><w-\u001a:!\u0001")
public class MongoHandler
extends IdleStateHandler {
    public final String reactivemongo$core$protocol$MongoHandler$$supervisor;
    public final String reactivemongo$core$protocol$MongoHandler$$connection;
    private final ActorRef receiver;
    private long last;

    public static LazyLogger.LazyLogger logger() {
        return MongoHandler$.MODULE$.logger();
    }

    private long last() {
        return this.last;
    }

    private void last_$eq(long x$1) {
        this.last = x$1;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.log(ctx, "Channel is active");
        this.last_$eq(System.nanoTime());
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.receiver);
        ChannelConnected x$1 = new ChannelConnected(ctx.channel().id());
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
        super.channelActive(ctx);
    }

    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) {
        if (this.last() != -1L) {
            long now = System.nanoTime();
            this.log(ctx, new StringBuilder(40).append("Channel has been inactive for ").append(now - this.last()).append(" (last = ").append(this.last()).append(")").toString());
        }
        ctx.channel().close();
        super.channelIdle(ctx, e);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        long now = System.nanoTime();
        if (this.last() != -1L) {
            Channel chan = ctx.channel();
            if (chan.remoteAddress() != null) {
                this.log(ctx, new StringBuilder(19).append("Channel is closed: ").append(this.last()).toString());
            }
            this.last_$eq(now);
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.receiver);
            ChannelDisconnected x$1 = new ChannelDisconnected(chan.id());
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
        }
        super.channelInactive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.last_$eq(System.nanoTime());
        Object object = msg;
        if (object instanceof Response) {
            Response response = (Response)object;
            this.log(ctx, new StringBuilder(43).append("Channel received message ").append(response).append("; Will be send to ").append(this.receiver.path()).toString());
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.receiver);
            Response x$1 = response;
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.log(ctx, new StringBuilder(20).append("Unexpected message: ").append(msg).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        this.log(ctx, "Channel is requested to write");
        this.last_$eq(System.nanoTime());
        super.write(ctx, msg, promise);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.log(ctx, new StringBuilder(18).append("Error on channel #").append(ctx.channel().id()).toString(), cause);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (ctx.channel().isActive()) {
            this.channelActive(ctx);
        }
        super.handlerAdded(ctx);
    }

    public void log(ChannelHandlerContext ctx, String s) {
        MongoHandler$.MODULE$.logger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(15).append("[").append($this.reactivemongo$core$protocol$MongoHandler$$supervisor).append("/").append($this.reactivemongo$core$protocol$MongoHandler$$connection).append("] ").append(s).append(" (channel ").append(ctx.channel()).append(")").toString());
    }

    public void log(ChannelHandlerContext ctx, String s, Throwable cause) {
        MongoHandler$.MODULE$.logger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(15).append("[").append($this.reactivemongo$core$protocol$MongoHandler$$supervisor).append("/").append($this.reactivemongo$core$protocol$MongoHandler$$connection).append("] ").append(s).append(" (channel ").append(ctx.channel()).append(")").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> cause);
    }

    public MongoHandler(String supervisor, String connection, ActorRef receiver, long idleTimeMS) {
        this.reactivemongo$core$protocol$MongoHandler$$supervisor = supervisor;
        this.reactivemongo$core$protocol$MongoHandler$$connection = connection;
        this.receiver = receiver;
        super(idleTimeMS, idleTimeMS, idleTimeMS, TimeUnit.MILLISECONDS);
        this.last = -1L;
    }
}

