/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.core.protocol;

import java.io.Serializable;
import reactivemongo.api.BSONSerializationPack$;
import reactivemongo.bson.BSONDocument;
import reactivemongo.bson.DefaultBSONHandlers$;
import reactivemongo.core.errors.DatabaseException;
import reactivemongo.core.errors.ReactiveMongoException$;
import reactivemongo.core.protocol.MessageHeader;
import reactivemongo.core.protocol.Reply;
import reactivemongo.core.protocol.ReplyDocumentIterator$;
import reactivemongo.core.protocol.Response;
import reactivemongo.core.protocol.ResponseDecoder$;
import reactivemongo.core.protocol.ResponseInfo;
import reactivemongo.io.netty.buffer.ByteBuf;
import reactivemongo.io.netty.channel.ChannelId;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class Response$
implements Serializable {
    public static final Response$ MODULE$ = new Response$();

    public Response apply(MessageHeader header, Reply reply, ByteBuf documents, ChannelId info) {
        return new Response.Successful(header, reply, documents, info);
    }

    public Iterator<BSONDocument> parse(Response response) {
        return ReplyDocumentIterator$.MODULE$.parse(BSONSerializationPack$.MODULE$, response, DefaultBSONHandlers$.MODULE$.BSONDocumentIdentity());
    }

    public Option<Tuple4<MessageHeader, Reply, ByteBuf, ChannelId>> unapply(Response response) {
        return new Some((Object)new Tuple4((Object)response.header(), (Object)response.reply(), (Object)response.documents(), (Object)new ResponseInfo(response.info())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Future<Tuple2<Response, BSONDocument>> preload(Response response, ExecutionContext ec) {
        Future future;
        boolean bl = false;
        Response.Successful successful = null;
        Response response2 = response;
        if (response2 instanceof Response.WithCursor) {
            Response.WithCursor withCursor = (Response.WithCursor)response2;
            BSONDocument cursorDoc = withCursor.cursor$access$5();
            return Future$.MODULE$.successful((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)withCursor), (Object)cursorDoc));
        }
        if (response2 instanceof Response.CommandError) {
            Response.CommandError commandError = (Response.CommandError)response2;
            DatabaseException cause = commandError.cause$access$3();
            return Future$.MODULE$.failed((Throwable)((Object)cause));
        }
        if (response2 instanceof Response.Successful) {
            int n;
            bl = true;
            successful = (Response.Successful)response2;
            Reply reply = successful._reply();
            if (reply != null && 0 == (n = reply.numberReturned())) {
                return Future$.MODULE$.failed((Throwable)((Object)ReactiveMongoException$.MODULE$.apply(new StringBuilder(31).append("Cannot preload empty response: ").append(response).toString())));
            }
        }
        if (!bl) throw new MatchError((Object)response2);
        MessageHeader header = successful._header();
        Reply reply = successful._reply();
        ByteBuf docs = successful._documents();
        ChannelId info = successful._info();
        ByteBuf buf = docs.duplicate();
        Try<BSONDocument> try_ = ResponseDecoder$.MODULE$.first(buf);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            BSONDocument first = (BSONDocument)success.value();
            future = Future$.MODULE$.apply((Function0 & Serializable)() -> {
                buf.resetReaderIndex();
                Response.Successful other = new Response.Successful(header, reply, buf, info);
                other.first_$eq((Option<BSONDocument>)Option$.MODULE$.apply((Object)first));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)other), (Object)first);
            }, ec);
            return future;
        } else {
            if (!(try_ instanceof Failure)) throw new MatchError(try_);
            Failure failure = (Failure)try_;
            Throwable cause = failure.exception();
            future = Future$.MODULE$.failed(cause);
        }
        return future;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Response$.class);
    }

    private Response$() {
    }
}

