/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.SupervisorStrategy;
import akka.actor.Terminated;
import akka.annotation.InternalApi;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import reactivemongo.api.AsyncDriver$;
import reactivemongo.api.AsyncDriver$AddConnection$;
import reactivemongo.api.AsyncDriver$SupervisorActor$;
import reactivemongo.api.AuthenticationMode;
import reactivemongo.api.FailoverStrategy;
import reactivemongo.api.MongoConnection;
import reactivemongo.api.MongoConnection$;
import reactivemongo.api.MongoConnectionOptions;
import reactivemongo.api.MongoConnectionOptions$;
import reactivemongo.api.ReadConcern;
import reactivemongo.api.ReadPreference;
import reactivemongo.api.ScramSha256Authentication$;
import reactivemongo.api.WriteConcern;
import reactivemongo.api.X509Authentication$;
import reactivemongo.core.AsyncSystemControl;
import reactivemongo.core.SystemControl;
import reactivemongo.core.SystemControl$;
import reactivemongo.core.TimedSystemControl;
import reactivemongo.core.actors.Close;
import reactivemongo.core.actors.Close$;
import reactivemongo.core.actors.Closed$;
import reactivemongo.core.actors.Exceptions;
import reactivemongo.core.actors.MongoDBSystem;
import reactivemongo.core.actors.StandardDBSystem;
import reactivemongo.core.actors.StandardDBSystemWithScramSha256;
import reactivemongo.core.actors.StandardDBSystemWithX509;
import reactivemongo.core.errors.ConnectionException;
import reactivemongo.core.nodeset.Authenticate;
import reactivemongo.util.package$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\r}h\u0001\u0002+V\u0005iC\u0001\"\u0019\u0001\u0003\u0006\u0004%\tB\u0019\u0005\t_\u0002\u0011\t\u0011)A\u0005G\"A\u0001\u000f\u0001BC\u0002\u0013E\u0011\u000f\u0003\u0005|\u0001\t\u0005\t\u0015!\u0003s\u0011\u0015a\b\u0001\"\u0001~\u0011)\t)\u0001\u0001b\u0001\n\u00039\u0016q\u0001\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\n!A\u00111\u0004\u0001\u0005\u0002]\u000bi\u0002C\u0004\u0002&\u0001!\t!a\n\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002h!9\u0011Q\u0005\u0001\u0005\u0002\u0005U\u0004bBA\u0013\u0001\u0011\u0005\u0011q\u0010\u0005\b\u0003K\u0001A\u0011AAC\u0011\u001d\t)\u0003\u0001C\u0001\u0003\u001bCq!!\n\u0001\t\u0003\tY\fC\u0004\u0002&\u0001!\t!a5\t\u0013\u0005}\u0007\u00011A\u0005\n\u0005\u0005\b\"CAx\u0001\u0001\u0007I\u0011BAy\u0011!\ti\u0010\u0001Q!\n\u0005\r\bbBA\u0000\u0001\u0011\u0005!\u0011\u0001\u0005\n\u0005C\u0001\u0011\u0013!C\u0001\u0005GA\u0011B!\u000f\u0001\u0005\u0004%IAa\u000f\t\u0011\t\u0015\u0003\u0001)A\u0005\u0005{A\u0011Ba\u0012\u0001\u0005\u0004%)B!\u0013\t\u0011\t=\u0003\u0001)A\u0007\u0005\u0017B!B!\u0015\u0001\u0005\u0004%)a\u0016B*\u0011!\u0011Y\u0006\u0001Q\u0001\u000e\tU\u0003\"\u0003B/\u0001\t\u0007IQ\u0003B0\u0011!\u0011i\t\u0001Q\u0001\u000e\t\u0005\u0004\"\u0003BH\u0001\t\u0007I\u0011\u0002BI\u0011!\u0011)\u000b\u0001Q\u0001\n\tM\u0005b\u0002BT\u0001\u0011E!\u0011\u0016\u0004\u0007\u0005c\u0003AIa-\t\u0015\u0005u\u0014E!f\u0001\n\u0003\u0011\t\r\u0003\u0006\u0003D\u0006\u0012\t\u0012)A\u0005\u0003/B!\"!\u0010\"\u0005+\u0007I\u0011\u0001Bc\u0011)\u00119-\tB\tB\u0003%\u0011q\b\u0005\u000b\u0003[\n#Q3A\u0005\u0002\t%\u0007B\u0003BfC\tE\t\u0015!\u0003\u0002p!Q!QZ\u0011\u0003\u0016\u0004%\tAa4\t\u0015\tE\u0017E!E!\u0002\u0013\u0011\t\b\u0003\u0004}C\u0011\u0005!1\u001b\u0005\n\u0005C\f\u0013\u0011!C\u0001\u0005GD\u0011B!<\"#\u0003%\tAa<\t\u0013\tM\u0018%%A\u0005\u0002\tU\b\"\u0003B}CE\u0005I\u0011\u0001B~\u0011%\u0011y0II\u0001\n\u0003\u0019\t\u0001C\u0005\u0004\u0006\u0005\n\t\u0011\"\u0011\u0003J!I1qA\u0011\u0002\u0002\u0013\u0005\u0011Q\u0004\u0005\n\u0007\u0013\t\u0013\u0011!C\u0001\u0007\u0017A\u0011ba\u0004\"\u0003\u0003%\te!\u0005\t\u0013\rm\u0011%!A\u0005\u0002\ru\u0001\"CB\u0011C\u0005\u0005I\u0011IB\u0012\u0011%\u00199#IA\u0001\n\u0003\u001aI\u0003C\u0005\u0004,\u0005\n\t\u0011\"\u0011\u0004.!I1qF\u0011\u0002\u0002\u0013\u00053\u0011G\u0004\n\u0007k\u0001\u0011\u0011!E\u0005\u0007o1\u0011B!-\u0001\u0003\u0003EIa!\u000f\t\rqTD\u0011AB)\u0011%\u0019YCOA\u0001\n\u000b\u001ai\u0003C\u0005\u0004Ti\n\t\u0011\"!\u0004V!I1q\f\u001e\u0002\u0002\u0013\u00055\u0011\r\u0005\t\u0007_\u0002A\u0011A+\u0004r\u0019111\u0012\u0001\u0007\u0007\u001bCQb!&A\t\u0003\u0005)Q!A!\u0002\u0013q\bB\u0002?A\t\u0003\u00199\nC\u0004\u0004 \u0002#\ta!)\t\u0013\r-\u0006I1A\u0005\u0002\r5\u0006\u0002CB]\u0001\u0002\u0006Iaa,\t\u000f\rm\u0006\t\"\u0001\u0004.\"91Q\u0018!\u0005B\r}vaBBa+\"\u000511\u0019\u0004\u0007)VC\ta!2\t\rqLE\u0011ABd\u0011\u001d\u0019\u0019&\u0013C\u0001\u0007\u0013Dqaa\u0015J\t\u0003\u0019Y\rC\u0004\u0004T%#\taa4\t\u0013\rU\u0017J1A\u0005\n\r]\u0007\u0002CBw\u0013\u0002\u0006Ia!7\t\u0015\r=\u0018J1A\u0005\u0002U\u0013\t\n\u0003\u0005\u0004r&\u0003\u000b\u0011\u0002BJ\u0011%\u0019\u00190SI\u0001\n\u0003\u0019)\u0010C\u0005\u0004z&\u000b\n\u0011\"\u0001\u0004|\nY\u0011i]=oG\u0012\u0013\u0018N^3s\u0015\t1v+A\u0002ba&T\u0011\u0001W\u0001\u000ee\u0016\f7\r^5wK6|gnZ8\u0004\u0001M\u0011\u0001a\u0017\t\u00039~k\u0011!\u0018\u0006\u0002=\u0006)1oY1mC&\u0011\u0001-\u0018\u0002\u0007\u0003:L(+\u001a4\u0002\r\r|gNZ5h+\u0005\u0019\u0007c\u0001/eM&\u0011Q-\u0018\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u001dlW\"\u00015\u000b\u0005\u0005L'B\u00016l\u0003!!\u0018\u0010]3tC\u001a,'\"\u00017\u0002\u0007\r|W.\u0003\u0002oQ\n11i\u001c8gS\u001e\fqaY8oM&<\u0007%A\u0006dY\u0006\u001c8\u000fT8bI\u0016\u0014X#\u0001:\u0011\u0007q#7\u000f\u0005\u0002us6\tQO\u0003\u0002wo\u0006!A.\u00198h\u0015\u0005A\u0018\u0001\u00026bm\u0006L!A_;\u0003\u0017\rc\u0017m]:M_\u0006$WM]\u0001\rG2\f7o\u001d'pC\u0012,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000by\f\t!a\u0001\u0011\u0005}\u0004Q\"A+\t\u000f\u0005,\u0001\u0013!a\u0001G\"9\u0001/\u0002I\u0001\u0002\u0004\u0011\u0018AB:zgR,W.\u0006\u0002\u0002\nA!\u00111BA\u000b\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011!B1di>\u0014(BAA\n\u0003\u0011\t7n[1\n\t\u0005]\u0011Q\u0002\u0002\f\u0003\u000e$xN]*zgR,W.A\u0004tsN$X-\u001c\u0011\u0002\u001d9,XnQ8o]\u0016\u001cG/[8ogV\u0011\u0011q\u0004\t\u00049\u0006\u0005\u0012bAA\u0012;\n\u0019\u0011J\u001c;\u0002\u000f\r|gN\\3diR!\u0011\u0011FA\u001e!\u0019\tY#!\r\u000265\u0011\u0011Q\u0006\u0006\u0004\u0003_i\u0016AC2p]\u000e,(O]3oi&!\u00111GA\u0017\u0005\u00191U\u000f^;sKB\u0019q0a\u000e\n\u0007\u0005eRKA\bN_:<wnQ8o]\u0016\u001cG/[8o\u0011\u001d\ti$\u0003a\u0001\u0003\u007f\tQA\\8eKN\u0004b!!\u0011\u0002R\u0005]c\u0002BA\"\u0003\u001brA!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0004\u0003\u0013J\u0016A\u0002\u001fs_>$h(C\u0001_\u0013\r\ty%X\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019&!\u0016\u0003\u0007M+\u0017OC\u0002\u0002Pu\u0003B!!\u0017\u0002b9!\u00111LA/!\r\t)%X\u0005\u0004\u0003?j\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002d\u0005\u0015$AB*ue&twMC\u0002\u0002`u#b!!\u000b\u0002j\u0005-\u0004bBA\u001f\u0015\u0001\u0007\u0011q\b\u0005\b\u0003[R\u0001\u0019AA8\u0003\u001dy\u0007\u000f^5p]N\u00042a`A9\u0013\r\t\u0019(\u0016\u0002\u0017\u001b>twm\\\"p]:,7\r^5p]>\u0003H/[8ogRA\u0011\u0011FA<\u0003s\nY\bC\u0004\u0002>-\u0001\r!a\u0010\t\u000f\u000554\u00021\u0001\u0002p!9\u0011QP\u0006A\u0002\u0005]\u0013\u0001\u00028b[\u0016$B!!\u000b\u0002\u0002\"9\u00111\u0011\u0007A\u0002\u0005]\u0013!C;sSN#(/[2u)\u0019\tI#a\"\u0002\n\"9\u00111Q\u0007A\u0002\u0005]\u0003bBA?\u001b\u0001\u0007\u00111\u0012\t\u00059\u0012\f9&\u0006\u0003\u0002\u0010\u0006\u001dFCBA\u0015\u0003#\u000bI\fC\u0004\u0002\u0014:\u0001\r!!&\u0002\u0013A\f'o]3e+JK\u0005CBAL\u0003;\u000b\u0019KD\u0002\u0000\u00033K1!a'V\u0003=iuN\\4p\u0007>tg.Z2uS>t\u0017\u0002BAP\u0003C\u00131!\u0016*J\u0015\r\tY*\u0016\t\u0005\u0003K\u000b9\u000b\u0004\u0001\u0005\u000f\u0005%fB1\u0001\u0002,\n\tA+\u0005\u0003\u0002.\u0006M\u0006c\u0001/\u00020&\u0019\u0011\u0011W/\u0003\u000f9{G\u000f[5oOB\u0019A,!.\n\u0007\u0005]VLA\u0002B]fDq!! \u000f\u0001\u0004\tY)\u0006\u0003\u0002>\u0006\u0015G\u0003CA\u0015\u0003\u007f\u000b9-!3\t\u000f\u0005Mu\u00021\u0001\u0002BB1\u0011qSAO\u0003\u0007\u0004B!!*\u0002F\u00129\u0011\u0011V\bC\u0002\u0005-\u0006bBA?\u001f\u0001\u0007\u00111\u0012\u0005\b\u0003\u0017|\u0001\u0019AAg\u0003)\u0019HO]5di6{G-\u001a\t\u00049\u0006=\u0017bAAi;\n9!i\\8mK\u0006tW\u0003BAk\u0003;$B!!\u000b\u0002X\"9\u00111\u0013\tA\u0002\u0005e\u0007CBAL\u0003;\u000bY\u000e\u0005\u0003\u0002&\u0006uGaBAU!\t\u0007\u00111V\u0001\tG2|7/\u001a3CsV\u0011\u00111\u001d\t\u00069\u0006\u0015\u0018\u0011^\u0005\u0004\u0003Ol&!B!se\u0006L\bc\u0001;\u0002l&\u0019\u0011Q^;\u0003#M#\u0018mY6Ue\u0006\u001cW-\u00127f[\u0016tG/\u0001\u0007dY>\u001cX\r\u001a\"z?\u0012*\u0017\u000f\u0006\u0003\u0002t\u0006e\bc\u0001/\u0002v&\u0019\u0011q_/\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003w\u0014\u0012\u0011!a\u0001\u0003G\f1\u0001\u001f\u00132\u0003%\u0019Gn\\:fI\nK\b%A\u0003dY>\u001cX\r\u0006\u0003\u0003\u0004\tEA\u0003\u0002B\u0003\u0005\u000f\u0001b!a\u000b\u00022\u0005M\bb\u0002B\u0005)\u0001\u000f!1B\u0001\u0003K\u000e\u0004B!a\u000b\u0003\u000e%!!qBA\u0017\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0005\u0003\u0014Q\u0001\n\u00111\u0001\u0003\u0016\u00059A/[7f_V$\b\u0003\u0002B\f\u0005;i!A!\u0007\u000b\t\tm\u0011QF\u0001\tIV\u0014\u0018\r^5p]&!!q\u0004B\r\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\fqb\u00197pg\u0016$C-\u001a4bk2$H%M\u000b\u0003\u0005KQCA!\u0006\u0003(-\u0012!\u0011\u0006\t\u0005\u0005W\u0011)$\u0004\u0002\u0003.)!!q\u0006B\u0019\u0003%)hn\u00195fG.,GMC\u0002\u00034u\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u00119D!\f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0006tsN$X-\\\"m_N,WC\u0001B\u001f!\u001da&q\bB\"\u0005\u000bI1A!\u0011^\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003]I\nU\u0011\u0001D:zgR,Wn\u00117pg\u0016\u0004\u0013AD:va\u0016\u0014h/[:pe:\u000bW.Z\u000b\u0003\u0005\u0017\u00022\u0001\u001eB'\u0013\r\t\u0019'^\u0001\u0010gV\u0004XM\u001d<jg>\u0014h*Y7fA\u0005y1/\u001e9feZL7o\u001c:BGR|'/\u0006\u0002\u0003VA!\u00111\u0002B,\u0013\u0011\u0011I&!\u0004\u0003\u0011\u0005\u001bGo\u001c:SK\u001a\f\u0001c];qKJ4\u0018n]8s\u0003\u000e$xN\u001d\u0011\u0002%\r|gN\\3di&|g.T8oSR|'o]\u000b\u0003\u0005C\u0002\u0002Ba\u0019\u0003n\tE\u0014QG\u0007\u0003\u0005KRAAa\u001a\u0003j\u00059Q.\u001e;bE2,'b\u0001B6;\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t=$Q\r\u0002\u0004\u001b\u0006\u0004\b\u0003\u0002B:\u0005\u0013sAA!\u001e\u0003\u0006:!!q\u000fBA\u001d\u0011\u0011IH! \u000f\t\u0005\u0015#1P\u0005\u00021&\u0019!qP,\u0002\r\u0005\u001cGo\u001c:t\u0013\u0011\tyAa!\u000b\u0007\t}t+\u0003\u0003\u0002P\t\u001d%\u0002BA\b\u0005\u0007KAA!\u0017\u0003\f*!\u0011q\nBD\u0003M\u0019wN\u001c8fGRLwN\\'p]&$xN]:!\u0003E\u0019wN\u001c8fGRLwN\\\"pk:$XM]\u000b\u0003\u0005'\u0003BA!&\u0003\"6\u0011!q\u0013\u0006\u0005\u00053\u0013Y*\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003_\u0011iJC\u0002\u0003 ^\fA!\u001e;jY&!!1\u0015BL\u0005)\tEo\\7jG2{gnZ\u0001\u0013G>tg.Z2uS>t7i\\;oi\u0016\u0014\b%A\u0007bg.\u001cuN\u001c8fGRLwN\u001c\u000b\t\u0003S\u0011YK!,\u00030\"9\u0011Q\b\u0011A\u0002\u0005}\u0002bBA7A\u0001\u0007\u0011q\u000e\u0005\b\u0003{\u0002\u0003\u0019AAF\u00055\tE\rZ\"p]:,7\r^5p]N1\u0011e\u0017B[\u0005w\u00032\u0001\u0018B\\\u0013\r\u0011I,\u0018\u0002\b!J|G-^2u!\u0011\t\tE!0\n\t\t}\u0016Q\u000b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u000b\u0003\u0003/\nQA\\1nK\u0002*\"!a\u0010\u0002\r9|G-Z:!+\t\ty'\u0001\u0005paRLwN\\:!\u0003-iwN\\4pgf\u001cH/Z7\u0016\u0005\tE\u0014\u0001D7p]\u001e|7/_:uK6\u0004CC\u0003Bk\u00053\u0014YN!8\u0003`B\u0019!q[\u0011\u000e\u0003\u0001Aq!! +\u0001\u0004\t9\u0006C\u0004\u0002>)\u0002\r!a\u0010\t\u000f\u00055$\u00061\u0001\u0002p!9!Q\u001a\u0016A\u0002\tE\u0014\u0001B2paf$\"B!6\u0003f\n\u001d(\u0011\u001eBv\u0011%\tih\u000bI\u0001\u0002\u0004\t9\u0006C\u0005\u0002>-\u0002\n\u00111\u0001\u0002@!I\u0011QN\u0016\u0011\u0002\u0003\u0007\u0011q\u000e\u0005\n\u0005\u001b\\\u0003\u0013!a\u0001\u0005c\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003r*\"\u0011q\u000bB\u0014\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"Aa>+\t\u0005}\"qE\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011iP\u000b\u0003\u0002p\t\u001d\u0012AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007\u0007QCA!\u001d\u0003(\u0005i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00024\u000e5\u0001\"CA~e\u0005\u0005\t\u0019AA\u0010\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB\n!\u0019\u0019)ba\u0006\u000246\u0011!\u0011N\u0005\u0005\u00073\u0011IG\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAg\u0007?A\u0011\"a?5\u0003\u0003\u0005\r!a-\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005\u0017\u001a)\u0003C\u0005\u0002|V\n\t\u00111\u0001\u0002 \u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002 \u0005AAo\\*ue&tw\r\u0006\u0002\u0003L\u00051Q-];bYN$B!!4\u00044!I\u00111 \u001d\u0002\u0002\u0003\u0007\u00111W\u0001\u000e\u0003\u0012$7i\u001c8oK\u000e$\u0018n\u001c8\u0011\u0007\t]'hE\u0003;\u0007w\u00199\u0005\u0005\b\u0004>\r\r\u0013qKA \u0003_\u0012\tH!6\u000e\u0005\r}\"bAB!;\u00069!/\u001e8uS6,\u0017\u0002BB#\u0007\u007f\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85!\u0011\u0019Iea\u0014\u000e\u0005\r-#bAB'o\u0006\u0011\u0011n\\\u0005\u0005\u0005\u007f\u001bY\u0005\u0006\u0002\u00048\u0005)\u0011\r\u001d9msRQ!Q[B,\u00073\u001aYf!\u0018\t\u000f\u0005uT\b1\u0001\u0002X!9\u0011QH\u001fA\u0002\u0005}\u0002bBA7{\u0001\u0007\u0011q\u000e\u0005\b\u0005\u001bl\u0004\u0019\u0001B9\u0003\u001d)h.\u00199qYf$Baa\u0019\u0004lA!A\fZB3!-a6qMA,\u0003\u007f\tyG!\u001d\n\u0007\r%TL\u0001\u0004UkBdW\r\u000e\u0005\n\u0007[r\u0014\u0011!a\u0001\u0005+\f1\u0001\u001f\u00131\u0003A\tG\rZ\"p]:,7\r^5p]6\u001bx\r\u0006\u0006\u00024\u000eM4QOB<\u0007sBq!! @\u0001\u0004\t9\u0006C\u0004\u0002>}\u0002\r!a\u0010\t\u000f\u00055t\b1\u0001\u0002p!9!QZ A\u0002\tE\u0004fB \u0004~\r\r5Q\u0011\t\u0004i\u000e}\u0014bABAk\n\u00012+\u001e9qe\u0016\u001c8oV1s]&twm]\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0007\u000f\u000b#a!#\u0002%5+G\u000f[8e%\u0016$XO\u001d8j]\u001e\fe.\u001f\u0002\u0010'V\u0004XM\u001d<jg>\u0014\u0018i\u0019;peN!\u0001iWBH!\u0011\u0011\u0019h!%\n\t\rM%1\u0012\u0002\u0006\u0003\u000e$xN]\u00016e\u0016\f7\r^5wK6|gnZ8%CBLG%Q:z]\u000e$%/\u001b<fe\u0012\u001aV\u000f]3sm&\u001cxN]!di>\u0014H\u0005\n3sSZ,'\u000f\u0006\u0003\u0004\u001a\u000em\u0005c\u0001Bl\u0001\"11Q\u0014\"A\u0002y\fa\u0001\u001a:jm\u0016\u0014\u0018aB5t\u000b6\u0004H/_\u000b\u0003\u0003\u001bD3aQBS!\ra6qU\u0005\u0004\u0007Sk&AB5oY&tW-A\u0004sK\u000e,\u0017N^3\u0016\u0005\r=\u0006\u0003BBY\u0007gk\u0011\u0001Q\u0005\u0005\u0007k\u001b9LA\u0004SK\u000e,\u0017N^3\n\t\rM\u0015QB\u0001\te\u0016\u001cW-\u001b<fA\u000591\r\\8tS:<\u0017\u0001\u00039pgR\u001cFo\u001c9\u0015\u0005\u0005M\u0018aC!ts:\u001cGI]5wKJ\u0004\"a`%\u0014\u0005%[FCABb)\u0005qHc\u0001@\u0004N\")\u0011\r\u0014a\u0001MR)ap!5\u0004T\")\u0011-\u0014a\u0001M\")\u0001/\u0014a\u0001g\u00061An\\4hKJ,\"a!7\u0011\t\rm7q\u001d\b\u0005\u0007;\u001c\tO\u0004\u0003\u0003z\r}\u0017b\u0001BP/&!11]Bs\u0003)a\u0015M_=M_\u001e<WM\u001d\u0006\u0004\u0005?;\u0016\u0002BBu\u0007W\u0014!\u0002T1{s2{wmZ3s\u0015\u0011\u0019\u0019o!:\u0002\u000f1|wmZ3sA\u000591m\\;oi\u0016\u0014\u0018\u0001C2pk:$XM\u001d\u0011\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u00199PK\u0002d\u0005O\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TCAB\u007fU\r\u0011(q\u0005")
public final class AsyncDriver {
    private volatile AsyncDriver$AddConnection$ AddConnection$module;
    private final Option<Config> config;
    private final Option<ClassLoader> classLoader;
    private final ActorSystem system;
    private StackTraceElement[] closedBy;
    private final Function1<Option<FiniteDuration>, Future<BoxedUnit>> systemClose;
    private final String supervisorName;
    private final ActorRef supervisorActor;
    private final Map<ActorRef, MongoConnection> connectionMonitors;
    private final AtomicLong connectionCounter;

    public static Option<ClassLoader> $lessinit$greater$default$2() {
        return AsyncDriver$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Config> $lessinit$greater$default$1() {
        return AsyncDriver$.MODULE$.$lessinit$greater$default$1();
    }

    public static AsyncDriver apply(Config config, ClassLoader classLoader) {
        return AsyncDriver$.MODULE$.apply(config, classLoader);
    }

    public static AsyncDriver apply(Config config) {
        return AsyncDriver$.MODULE$.apply(config);
    }

    public static AsyncDriver apply() {
        return AsyncDriver$.MODULE$.apply();
    }

    private AsyncDriver$AddConnection$ AddConnection() {
        if (this.AddConnection$module == null) {
            this.AddConnection$lzycompute$1();
        }
        return this.AddConnection$module;
    }

    public Option<Config> config() {
        return this.config;
    }

    public Option<ClassLoader> classLoader() {
        return this.classLoader;
    }

    public ActorSystem system() {
        return this.system;
    }

    public int numConnections() {
        return this.connectionMonitors().size();
    }

    public Future<MongoConnection> connect(Seq<String> nodes) {
        return this.askConnection(nodes, MongoConnectionOptions$.MODULE$.default(), (Option<String>)Option$.MODULE$.empty());
    }

    public Future<MongoConnection> connect(Seq<String> nodes, MongoConnectionOptions options) {
        return this.askConnection(nodes, options, (Option<String>)Option$.MODULE$.empty());
    }

    public Future<MongoConnection> connect(Seq<String> nodes, MongoConnectionOptions options, String name) {
        return this.askConnection(nodes, options, (Option<String>)new Some((Object)name));
    }

    public Future<MongoConnection> connect(String uriStrict) {
        return this.connect(uriStrict, (Option<String>)None$.MODULE$);
    }

    public Future<MongoConnection> connect(String uriStrict, Option<String> name) {
        return MongoConnection$.MODULE$.fromString(uriStrict, AsyncDriver.ec$1()).flatMap((Function1 & Serializable)x$1 -> this.connect((MongoConnection.URI)x$1, name), AsyncDriver.ec$1());
    }

    public <T> Future<MongoConnection> connect(MongoConnection.URI<T> parsedURI, Option<String> name) {
        return this.connect(parsedURI, name, true);
    }

    public <T> Future<MongoConnection> connect(MongoConnection.URI<T> parsedURI, Option<String> name, boolean strictMode) {
        if (strictMode && parsedURI.ignoredOptions().nonEmpty()) {
            return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(49).append("The connection URI contains unsupported options: ").append(parsedURI.ignoredOptions().mkString(", ")).toString()));
        }
        scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$1 = parsedURI.options().credentials();
        int x$2 = parsedURI.options().copy$default$1();
        Option<String> x$3 = parsedURI.options().copy$default$2();
        boolean x$4 = parsedURI.options().copy$default$3();
        boolean x$5 = parsedURI.options().copy$default$4();
        AuthenticationMode x$6 = parsedURI.options().copy$default$5();
        boolean x$7 = parsedURI.options().copy$default$6();
        boolean x$8 = parsedURI.options().copy$default$7();
        int x$9 = parsedURI.options().copy$default$8();
        Option<Object> x$10 = parsedURI.options().copy$default$9();
        int x$11 = parsedURI.options().copy$default$10();
        int x$12 = parsedURI.options().copy$default$11();
        WriteConcern x$13 = parsedURI.options().copy$default$12();
        ReadPreference x$14 = parsedURI.options().copy$default$13();
        FailoverStrategy x$15 = parsedURI.options().copy$default$14();
        int x$16 = parsedURI.options().copy$default$15();
        int x$17 = parsedURI.options().copy$default$16();
        int x$18 = parsedURI.options().copy$default$17();
        Option<MongoConnectionOptions.KeyStore> x$19 = parsedURI.options().copy$default$19();
        ReadConcern x$20 = parsedURI.options().copy$default$20();
        Option<String> x$21 = parsedURI.options().copy$default$21();
        return this.askConnection((Seq<String>)((IterableOnceOps)parsedURI.hosts().map((Function1 & Serializable)h -> new StringBuilder(11).append((String)h._1()).append(':').append(h._2$mcI$sp()).toString())).toSeq(), parsedURI.options().copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$1, x$19, x$20, x$21), name);
    }

    public <T> Future<MongoConnection> connect(MongoConnection.URI<T> parsedURI) {
        return this.connect(parsedURI, (Option<String>)None$.MODULE$);
    }

    private StackTraceElement[] closedBy() {
        return this.closedBy;
    }

    private void closedBy_$eq(StackTraceElement[] x$1) {
        this.closedBy = x$1;
    }

    public Future<BoxedUnit> close(FiniteDuration timeout, ExecutionContext ec) {
        boolean bl;
        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("[").append(this.supervisorName()).append("] Closing instance of ReactiveMongo driver").toString());
        StackTraceElement[] callerSTE = (StackTraceElement[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace()), 3)), 3);
        Function1<Option<FiniteDuration>, Future<BoxedUnit>> function1 = this.systemClose();
        synchronized (function1) {
            boolean bl2;
            if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.closedBy()))) {
                this.closedBy_$eq(callerSTE);
                bl2 = false;
            } else {
                bl2 = true;
            }
            bl = bl2;
        }
        boolean alreadyClosing = bl;
        if (alreadyClosing) {
            AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("System already closed: ").append(this.supervisorName()).toString());
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        ActorRef qual$1 = reactivemongo.actors.pattern.ask.package$.MODULE$.ask(this.supervisorActor());
        Close x$1 = AsyncDriver.msg$1(timeout);
        Timeout x$22 = new Timeout(timeout);
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        return AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$22, x$3).recover((PartialFunction)new Serializable(this, callerSTE){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncDriver $outer;
            private final StackTraceElement[] callerSTE$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                A1.setStackTrace(this.callerSTE$1);
                AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(96).append("[").append($this.$outer.supervisorName()).append("] Fails to close connections within timeout. Continuing closing of ReactiveMongo driver anyway.").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> A1);
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.callerSTE$1 = callerSTE$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(reactivemongo.api.AsyncDriver$$anonfun$close$3 ), $anonfun$applyOrElse$2(java.lang.Throwable )}, serializedLambda);
            }
        }, ec).flatMap((Function1 & Serializable)x$2 -> (Future)this.systemClose().apply((Object)new Some((Object)timeout)), ec);
    }

    public FiniteDuration close$default$1() {
        return FiniteDuration$.MODULE$.apply(2L, TimeUnit.SECONDS);
    }

    private Function1<Option<FiniteDuration>, Future<BoxedUnit>> systemClose() {
        return this.systemClose;
    }

    public final String supervisorName() {
        return this.supervisorName;
    }

    public final ActorRef supervisorActor() {
        return this.supervisorActor;
    }

    public final Map<ActorRef, MongoConnection> connectionMonitors() {
        return this.connectionMonitors;
    }

    private AtomicLong connectionCounter() {
        return this.connectionCounter;
    }

    public Future<MongoConnection> askConnection(Seq<String> nodes, MongoConnectionOptions options, Option<String> name) {
        MongoConnectionOptions mongoConnectionOptions;
        if (nodes.isEmpty()) {
            return Future$.MODULE$.failed((Throwable)new ConnectionException("No node specified"));
        }
        LazyRef dbsystem$lzy = new LazyRef();
        String nm = (String)name.getOrElse((Function0 & Serializable)() -> new StringBuilder(11).append("Connection-").append(this.connectionCounter().incrementAndGet()).toString());
        Seq authentications = ((IterableOnceOps)options.credentials().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String db = (String)tuple2._1();
                MongoConnectionOptions.Credential c = (MongoConnectionOptions.Credential)tuple2._2();
                return new Authenticate(db, c.user(), c.password());
            }
            throw new MatchError((Object)tuple2);
        })).toSeq();
        Option<String> option = options.appName();
        if (option instanceof Some) {
            mongoConnectionOptions = options;
        } else {
            Some x$1 = new Some((Object)new StringBuilder(1).append(this.supervisorName()).append("/").append(nm).toString());
            int x$2 = options.copy$default$1();
            Option<String> x$3 = options.copy$default$2();
            boolean x$4 = options.copy$default$3();
            boolean x$5 = options.copy$default$4();
            AuthenticationMode x$6 = options.copy$default$5();
            boolean x$7 = options.copy$default$6();
            boolean x$8 = options.copy$default$7();
            int x$9 = options.copy$default$8();
            Option<Object> x$10 = options.copy$default$9();
            int x$11 = options.copy$default$10();
            int x$12 = options.copy$default$11();
            WriteConcern x$13 = options.copy$default$12();
            ReadPreference x$14 = options.copy$default$13();
            FailoverStrategy x$15 = options.copy$default$14();
            int x$16 = options.copy$default$15();
            int x$17 = options.copy$default$16();
            int x$18 = options.copy$default$17();
            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$19 = options.copy$default$18();
            Option<MongoConnectionOptions.KeyStore> x$20 = options.copy$default$19();
            ReadConcern x$21 = options.copy$default$20();
            mongoConnectionOptions = options.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, (Option<String>)x$1);
        }
        MongoConnectionOptions opts = mongoConnectionOptions;
        ActorRef mongosystem = this.system().actorOf(reactivemongo.actors.actor.package$.MODULE$.Props().apply((Function0 & Serializable)() -> this.dbsystem$1(dbsystem$lzy, opts, nm, nodes, authentications), ClassTag$.MODULE$.apply(MongoDBSystem.class)), nm);
        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append("[").append(this.supervisorName()).append("] Creating connection: ").append(nm).toString());
        return this.connection$1(nm, nodes, opts, mongosystem).mapTo(ClassTag$.MODULE$.apply(MongoConnection.class)).map((Function1 & Serializable)c -> {
            c.history_$eq((Function0<Exceptions.InternalState>)(Function0 & Serializable)() -> this.dbsystem$1(dbsystem$lzy, opts, nm, nodes, authentications).internalState());
            return c;
        }, (ExecutionContext)this.system().dispatcher());
    }

    public Object addConnectionMsg(String name, Seq<String> nodes, MongoConnectionOptions options, ActorRef mongosystem) {
        return new AddConnection(this, name, nodes, options, mongosystem);
    }

    private final void AddConnection$lzycompute$1() {
        AsyncDriver asyncDriver = this;
        synchronized (asyncDriver) {
            if (this.AddConnection$module == null) {
                this.AddConnection$module = new AsyncDriver$AddConnection$(this);
            }
        }
    }

    public static final /* synthetic */ Config $anonfun$system$1() {
        return ConfigFactory.load();
    }

    public static final /* synthetic */ String $anonfun$system$2() {
        return "No mongo-async-driver configuration found";
    }

    private static final ExecutionContext ec$1() {
        return package$.MODULE$.sameThreadExecutionContext();
    }

    private static final Close msg$1(FiniteDuration timeout$1) {
        return Close$.MODULE$.apply("AsyncDriver.close", timeout$1);
    }

    public static final /* synthetic */ Future $anonfun$systemClose$1(Function1 close$1, Option timeout) {
        Try try_ = (Try)close$1.apply((Object)timeout);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable cause = failure.exception();
            return Future$.MODULE$.failed(cause);
        }
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public static final /* synthetic */ Future $anonfun$systemClose$2(Function0 close$2, Option x$3) {
        return (Future)close$2.apply();
    }

    public static final /* synthetic */ Future $anonfun$systemClose$3(Throwable cause$1, Option x$4) {
        return Future$.MODULE$.failed(cause$1);
    }

    public static final /* synthetic */ SupervisorActor $anonfun$supervisorActor$1(AsyncDriver $this) {
        return new SupervisorActor($this, $this);
    }

    private final /* synthetic */ MongoDBSystem dbsystem$lzycompute$1(LazyRef dbsystem$lzy$1, MongoConnectionOptions opts$1, String nm$1, Seq nodes$1, Seq authentications$1) {
        MongoDBSystem mongoDBSystem;
        LazyRef lazyRef = dbsystem$lzy$1;
        synchronized (lazyRef) {
            AuthenticationMode authenticationMode;
            mongoDBSystem = dbsystem$lzy$1.initialized() ? (MongoDBSystem)dbsystem$lzy$1.value() : (MongoDBSystem)dbsystem$lzy$1.initialize((Object)(X509Authentication$.MODULE$.equals(authenticationMode = opts$1.authenticationMechanism()) ? new StandardDBSystemWithX509(this.supervisorName(), nm$1, (Seq<String>)nodes$1, (Seq<Authenticate>)authentications$1, opts$1) : (ScramSha256Authentication$.MODULE$.equals(authenticationMode) ? new StandardDBSystemWithScramSha256(this.supervisorName(), nm$1, (Seq<String>)nodes$1, (Seq<Authenticate>)authentications$1, opts$1) : new StandardDBSystem(this.supervisorName(), nm$1, (Seq<String>)nodes$1, (Seq<Authenticate>)authentications$1, opts$1))));
        }
        return mongoDBSystem;
    }

    private final MongoDBSystem dbsystem$1(LazyRef dbsystem$lzy$1, MongoConnectionOptions opts$1, String nm$1, Seq nodes$1, Seq authentications$1) {
        if (dbsystem$lzy$1.initialized()) {
            return (MongoDBSystem)dbsystem$lzy$1.value();
        }
        return this.dbsystem$lzycompute$1(dbsystem$lzy$1, opts$1, nm$1, nodes$1, authentications$1);
    }

    private static final Timeout timeout$2(MongoConnectionOptions opts$1) {
        if (opts$1.connectTimeoutMS() > 0) {
            return reactivemongo.actors.util.package$.MODULE$.Timeout().apply((long)opts$1.connectTimeoutMS(), TimeUnit.MILLISECONDS);
        }
        return reactivemongo.actors.util.package$.MODULE$.Timeout().apply(10000L, TimeUnit.MILLISECONDS);
    }

    private final Future connection$1(String nm$1, Seq nodes$1, MongoConnectionOptions opts$1, ActorRef mongosystem$1) {
        ActorRef qual$1 = reactivemongo.actors.pattern.ask.package$.MODULE$.ask(this.supervisorActor());
        AddConnection x$1 = new AddConnection(this, nm$1, (Seq<String>)nodes$1, opts$1, mongosystem$1);
        Timeout x$2 = AsyncDriver.timeout$2(opts$1);
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        return AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3);
    }

    /*
     * Unable to fully structure code
     */
    public AsyncDriver(Option<Config> config, Option<ClassLoader> classLoader) {
        this.config = config;
        this.classLoader = classLoader;
        super();
        reference = (Config)config.getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$system$1(), ()Lcom/typesafe/config/Config;)());
        if (!reference.hasPath("mongo-async-driver")) {
            AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$system$2(), ()Ljava/lang/String;)());
            v0 = ConfigFactory.empty();
        } else {
            v0 = reference.getConfig("mongo-async-driver");
        }
        cfg = v0;
        this.system = reactivemongo.actors.actor.package$.MODULE$.ActorSystem().apply("reactivemongo", (Option)new Some((Object)cfg), classLoader, reactivemongo.actors.actor.package$.MODULE$.ActorSystem().apply$default$4());
        this.closedBy = (StackTraceElement[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StackTraceElement.class));
        var6_5 = false;
        var7_6 = null;
        var8_7 = SystemControl$.MODULE$.apply(this.system());
        if (!(var8_7 instanceof Success)) ** GOTO lbl-1000
        var6_5 = true;
        var7_6 = (Success)var8_7;
        var9_8 = (SystemControl)var7_6.value();
        if (var9_8 instanceof TimedSystemControl) {
            var10_9 = (TimedSystemControl)var9_8;
            close = var10_9.close();
            v1 = (Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$systemClose$1(scala.Function1 scala.Option ), (Lscala/Option;)Lscala/concurrent/Future;)(close);
        } else if (var6_5 && (var12_11 = (SystemControl)var7_6.value()) instanceof AsyncSystemControl) {
            var13_12 = (AsyncSystemControl)var12_11;
            close = var13_12.close();
            v1 = (Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$systemClose$2(scala.Function0 scala.Option ), (Lscala/Option;)Lscala/concurrent/Future;)(close);
        } else if (var8_7 instanceof Failure) {
            var15_14 = (Failure)var8_7;
            cause = var15_14.exception();
            v1 = (Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$systemClose$3(java.lang.Throwable scala.Option ), (Lscala/Option;)Lscala/concurrent/Future;)((Throwable)cause);
        } else {
            throw new MatchError(var8_7);
        }
        this.systemClose = v1;
        this.supervisorName = new StringBuilder(11).append("Supervisor-").append(AsyncDriver$.MODULE$.counter().incrementAndGet()).toString();
        this.supervisorActor = this.system().actorOf(reactivemongo.actors.actor.package$.MODULE$.Props().apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$supervisorActor$1(reactivemongo.api.AsyncDriver ), ()Lreactivemongo/api/AsyncDriver$SupervisorActor;)((AsyncDriver)this), ClassTag$.MODULE$.apply(SupervisorActor.class)), this.supervisorName());
        this.connectionMonitors = (Map)Map$.MODULE$.empty();
        this.connectionCounter = new AtomicLong(0L);
    }

    private class AddConnection
    implements Product,
    Serializable {
        private final String name;
        private final Seq<String> nodes;
        private final MongoConnectionOptions options;
        private final ActorRef mongosystem;
        public final /* synthetic */ AsyncDriver $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String name() {
            return this.name;
        }

        public Seq<String> nodes() {
            return this.nodes;
        }

        public MongoConnectionOptions options() {
            return this.options;
        }

        public ActorRef mongosystem() {
            return this.mongosystem;
        }

        public AddConnection copy(String name, Seq<String> nodes, MongoConnectionOptions options, ActorRef mongosystem) {
            return new AddConnection(this.reactivemongo$api$AsyncDriver$AddConnection$$$outer(), name, nodes, options, mongosystem);
        }

        public String copy$default$1() {
            return this.name();
        }

        public Seq<String> copy$default$2() {
            return this.nodes();
        }

        public MongoConnectionOptions copy$default$3() {
            return this.options();
        }

        public ActorRef copy$default$4() {
            return this.mongosystem();
        }

        public String productPrefix() {
            return "AddConnection";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.name();
                }
                case 1: {
                    return this.nodes();
                }
                case 2: {
                    return this.options();
                }
                case 3: {
                    return this.mongosystem();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof AddConnection;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "nodes";
                }
                case 2: {
                    return "options";
                }
                case 3: {
                    return "mongosystem";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof AddConnection)) return false;
            if (((AddConnection)object).reactivemongo$api$AsyncDriver$AddConnection$$$outer() != this.reactivemongo$api$AsyncDriver$AddConnection$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            AddConnection addConnection = (AddConnection)x$1;
            String string = this.name();
            String string2 = addConnection.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Seq<String> seq = this.nodes();
            Seq<String> seq2 = addConnection.nodes();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            MongoConnectionOptions mongoConnectionOptions = this.options();
            MongoConnectionOptions mongoConnectionOptions2 = addConnection.options();
            if (mongoConnectionOptions == null) {
                if (mongoConnectionOptions2 != null) {
                    return false;
                }
            } else if (!((Object)mongoConnectionOptions).equals(mongoConnectionOptions2)) return false;
            ActorRef actorRef = this.mongosystem();
            ActorRef actorRef2 = addConnection.mongosystem();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            if (!addConnection.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ AsyncDriver reactivemongo$api$AsyncDriver$AddConnection$$$outer() {
            return this.$outer;
        }

        public AddConnection(AsyncDriver $outer, String name, Seq<String> nodes, MongoConnectionOptions options, ActorRef mongosystem) {
            this.name = name;
            this.nodes = nodes;
            this.options = options;
            this.mongosystem = mongosystem;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    private final class SupervisorActor
    implements Actor {
        public final AsyncDriver reactivemongo$api$AsyncDriver$SupervisorActor$$driver;
        private final PartialFunction<Object, BoxedUnit> receive;
        private ActorContext context;
        private ActorRef self;
        private final /* synthetic */ AsyncDriver $outer;

        public final ActorRef sender() {
            return Actor.sender$((Actor)this);
        }

        @InternalApi
        public void aroundReceive(PartialFunction<Object, BoxedUnit> receive, Object msg) {
            Actor.aroundReceive$((Actor)this, receive, (Object)msg);
        }

        @InternalApi
        public void aroundPreStart() {
            Actor.aroundPreStart$((Actor)this);
        }

        @InternalApi
        public void aroundPostStop() {
            Actor.aroundPostStop$((Actor)this);
        }

        @InternalApi
        public void aroundPreRestart(Throwable reason, Option<Object> message) {
            Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
        }

        @InternalApi
        public void aroundPostRestart(Throwable reason) {
            Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
        }

        public SupervisorStrategy supervisorStrategy() {
            return Actor.supervisorStrategy$((Actor)this);
        }

        public void preStart() throws Exception {
            Actor.preStart$((Actor)this);
        }

        public void preRestart(Throwable reason, Option<Object> message) throws Exception {
            Actor.preRestart$((Actor)this, (Throwable)reason, message);
        }

        public void postRestart(Throwable reason) throws Exception {
            Actor.postRestart$((Actor)this, (Throwable)reason);
        }

        public void unhandled(Object message) {
            Actor.unhandled$((Actor)this, (Object)message);
        }

        public ActorContext context() {
            return this.context;
        }

        public final ActorRef self() {
            return this.self;
        }

        public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
            this.context = x$1;
        }

        public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
            this.self = x$1;
        }

        public boolean isEmpty() {
            return this.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.connectionMonitors().isEmpty();
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return this.receive;
        }

        public PartialFunction<Object, BoxedUnit> closing() {
            Queue waitingForClose = (Queue)Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ActorRef[]{this.sender()}));
            return new Serializable(this, waitingForClose){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ SupervisorActor $outer;
                private final Queue waitingForClose$1;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Option<String> option;
                    boolean bl = false;
                    Close close2 = null;
                    A1 A1 = x1;
                    if (A1 instanceof AddConnection && ((AddConnection)A1).reactivemongo$api$AsyncDriver$AddConnection$$$outer() == this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer()) {
                        AddConnection addConnection = (AddConnection)A1;
                        String name = addConnection.name();
                        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Refusing to add connection while the driver is closing: ").append(name).toString());
                        return (B1)BoxedUnit.UNIT;
                    }
                    if (A1 instanceof Terminated) {
                        Terminated terminated = (Terminated)A1;
                        this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.connectionMonitors().remove((Object)terminated.actor()).foreach((Function1 & Serializable)con -> {
                            SupervisorActor$$anonfun$closing$1.$anonfun$applyOrElse$8(this, con);
                            return BoxedUnit.UNIT;
                        });
                        return (B1)BoxedUnit.UNIT;
                    }
                    if (A1 instanceof Close) {
                        bl = true;
                        close2 = (Close)A1;
                        Option<String> option2 = Close$.MODULE$.unapply(close2);
                        if (!option2.isEmpty()) {
                            String src = (String)option2.get();
                            if (this.$outer.isEmpty()) {
                                AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Close the supervisor for ").append(src).toString());
                                akka.actor.package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)Closed$.MODULE$, this.$outer.self());
                                return (B1)BoxedUnit.UNIT;
                            }
                        }
                    }
                    if (bl && !(option = Close$.MODULE$.unapply(close2)).isEmpty()) {
                        String src = (String)option.get();
                        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Close request received from ").append(src).append(", but already closing.").toString());
                        this.waitingForClose$1.$plus$eq((Object)this.$outer.sender());
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Object x1) {
                    Option<String> option;
                    boolean bl = false;
                    Close close2 = null;
                    Object object = x1;
                    if (object instanceof AddConnection && ((AddConnection)object).reactivemongo$api$AsyncDriver$AddConnection$$$outer() == this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer()) {
                        return true;
                    }
                    if (object instanceof Terminated) {
                        return true;
                    }
                    if (object instanceof Close) {
                        bl = true;
                        close2 = (Close)object;
                        Option<String> option2 = Close$.MODULE$.unapply(close2);
                        if (!option2.isEmpty() && this.$outer.isEmpty()) {
                            return true;
                        }
                    }
                    return bl && !(option = Close$.MODULE$.unapply(close2)).isEmpty();
                }

                public static final /* synthetic */ boolean $anonfun$applyOrElse$10(ActorRef x$6) {
                    return true;
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$11(SupervisorActor$$anonfun$closing$1 $this, ActorRef x$7) {
                    akka.actor.package$.MODULE$.actorRef2Scala(x$7).$bang((Object)Closed$.MODULE$, $this.$outer.self());
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$8(SupervisorActor$$anonfun$closing$1 $this, MongoConnection con) {
                    AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Connection is terminated: ").append(con.name()).toString());
                    if ($this.$outer.isEmpty()) {
                        $this.$outer.context().stop($this.$outer.self());
                        $this.waitingForClose$1.dequeueAll((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SupervisorActor$$anonfun$closing$1.$anonfun$applyOrElse$10(x$6))).foreach((Function1 & Serializable)x$7 -> {
                            SupervisorActor$$anonfun$closing$1.$anonfun$applyOrElse$11($this, x$7);
                            return BoxedUnit.UNIT;
                        });
                        return;
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.waitingForClose$1 = waitingForClose$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10$adapted(akka.actor.ActorRef ), $anonfun$applyOrElse$11$adapted(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$closing$1 akka.actor.ActorRef ), $anonfun$applyOrElse$12(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$closing$1 java.lang.String ), $anonfun$applyOrElse$13(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$closing$1 java.lang.String ), $anonfun$applyOrElse$7(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$closing$1 java.lang.String ), $anonfun$applyOrElse$8$adapted(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$closing$1 reactivemongo.api.MongoConnection ), $anonfun$applyOrElse$9(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$closing$1 reactivemongo.api.MongoConnection )}, serializedLambda);
                }
            };
        }

        public void postStop() {
            AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("[").append($this.$outer.supervisorName()).append("] Stopping the monitor...").toString());
        }

        public /* synthetic */ AsyncDriver reactivemongo$api$AsyncDriver$SupervisorActor$$$outer() {
            return this.$outer;
        }

        public SupervisorActor(AsyncDriver $outer, AsyncDriver driver) {
            this.reactivemongo$api$AsyncDriver$SupervisorActor$$driver = driver;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Actor.$init$((Actor)this);
            this.receive = new Serializable(this){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ SupervisorActor $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Close close2;
                    Option<String> option;
                    A1 A1 = x1;
                    if (A1 instanceof AddConnection && ((AddConnection)A1).reactivemongo$api$AsyncDriver$AddConnection$$$outer() == this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer()) {
                        AddConnection addConnection = (AddConnection)A1;
                        String name = addConnection.name();
                        MongoConnectionOptions opts = addConnection.options();
                        ActorRef sys = addConnection.mongosystem();
                        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Add connection to the supervisor: ").append(name).toString());
                        MongoConnection connection = new MongoConnection(this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName(), name, this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.system(), sys, opts);
                        this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.connectionMonitors().put((Object)connection.monitor(), (Object)connection);
                        this.$outer.context().watch(connection.monitor());
                        akka.actor.package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)connection, this.$outer.self());
                        return (B1)BoxedUnit.UNIT;
                    }
                    if (A1 instanceof Terminated) {
                        Terminated terminated = (Terminated)A1;
                        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Connection is terminated: ").append(terminated.actor().path()).toString());
                        this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.connectionMonitors().remove((Object)terminated.actor());
                        return (B1)BoxedUnit.UNIT;
                    }
                    if (A1 instanceof Close && !(option = Close$.MODULE$.unapply(close2 = (Close)A1)).isEmpty()) {
                        String src = (String)option.get();
                        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Close the supervisor for ").append(src).toString());
                        if (this.$outer.isEmpty()) {
                            this.$outer.context().stop(this.$outer.self());
                            akka.actor.package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)Closed$.MODULE$, this.$outer.self());
                            return (B1)BoxedUnit.UNIT;
                        }
                        this.$outer.context().become(this.$outer.closing());
                        Future$.MODULE$.sequence((IterableOnce)this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.connectionMonitors().values().map((Function1 & Serializable)x$5 -> x$5.close(SupervisorActor$$anonfun$1.timeout$3(close2))), BuildFrom$.MODULE$.buildFromIterableOps(), this.ec$2());
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Object x1) {
                    Close close2;
                    Option<String> option;
                    Object object = x1;
                    if (object instanceof AddConnection && ((AddConnection)object).reactivemongo$api$AsyncDriver$AddConnection$$$outer() == this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer()) {
                        return true;
                    }
                    if (object instanceof Terminated) {
                        return true;
                    }
                    return object instanceof Close && !(option = Close$.MODULE$.unapply(close2 = (Close)object)).isEmpty();
                }

                private static final FiniteDuration timeout$3(Close x5$1) {
                    return x5$1.timeout();
                }

                private final ExecutionContext ec$2() {
                    return this.$outer.context().dispatcher();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$1 java.lang.String ), $anonfun$applyOrElse$4(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$1 akka.actor.Terminated ), $anonfun$applyOrElse$5(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$1 java.lang.String ), $anonfun$applyOrElse$6(reactivemongo.core.actors.Close reactivemongo.api.MongoConnection )}, serializedLambda);
                }
            };
            Statics.releaseFence();
        }
    }
}

