/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import reactivemongo.actors.pattern.package$;
import reactivemongo.api.Failover$;
import reactivemongo.api.FailoverStrategy;
import reactivemongo.api.MongoConnection;
import reactivemongo.api.RetryableFailure$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u00055a!\u0002\n\u0014\u0005U9\u0002\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\t\u0011U\u0002!\u0011!Q\u0001\nYB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0006\u007f!)!\t\u0001C\u0001\u0007\"9!\n\u0001b\u0001\n\u0013Y\u0005B\u0002+\u0001A\u0003%A\nC\u0004V\u0001\t\u0007I\u0011\u0001,\t\r]\u0003\u0001\u0015!\u0003%\u0011\u0015A\u0006\u0001\"\u0003Z\u0011\u0015Q\u0006\u0001\"\u0003\\\u000f\u0019\t7\u0003#\u0001\u0016E\u001a1!c\u0005E\u0001+\rDQAQ\u0007\u0005\u0002\u0011D\u0001\"Z\u0007C\u0002\u0013\u00051C\u001a\u0005\u0007o6\u0001\u000b\u0011B4\t\u000balA\u0011A=\u0003\u0011\u0019\u000b\u0017\u000e\\8wKJT!\u0001F\u000b\u0002\u0007\u0005\u0004\u0018NC\u0001\u0017\u00035\u0011X-Y2uSZ,Wn\u001c8h_V\u0011\u0001\u0004L\n\u0003\u0001e\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0017\u0001\u00039s_\u0012,8-\u001a:\u0004\u0001A\u0019!D\t\u0013\n\u0005\rZ\"!\u0003$v]\u000e$\u0018n\u001c81!\r)\u0003FK\u0007\u0002M)\u0011qeG\u0001\u000bG>t7-\u001e:sK:$\u0018BA\u0015'\u0005\u00191U\u000f^;sKB\u00111\u0006\f\u0007\u0001\t\u0015i\u0003A1\u0001/\u0005\u0005\t\u0015CA\u00183!\tQ\u0002'\u0003\u000227\t9aj\u001c;iS:<\u0007C\u0001\u000e4\u0013\t!4DA\u0002B]f\f!bY8o]\u0016\u001cG/[8o!\t9\u0004(D\u0001\u0014\u0013\tI4CA\bN_:<wnQ8o]\u0016\u001cG/[8o\u0003A1\u0017-\u001b7pm\u0016\u00148\u000b\u001e:bi\u0016<\u0017\u0010\u0005\u00028y%\u0011Qh\u0005\u0002\u0011\r\u0006LGn\u001c<feN#(/\u0019;fOf\f!!Z2\u0011\u0005\u0015\u0002\u0015BA!'\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0005\t\u001eC\u0015\n\u0006\u0002F\rB\u0019q\u0007\u0001\u0016\t\u000by*\u00019A \t\u000b})\u0001\u0019A\u0011\t\u000bU*\u0001\u0019\u0001\u001c\t\u000bi*\u0001\u0019A\u001e\u0002\u00071tW.F\u0001M!\ti%+D\u0001O\u0015\ty\u0005+\u0001\u0003mC:<'\"A)\u0002\t)\fg/Y\u0005\u0003':\u0013aa\u0015;sS:<\u0017\u0001\u00027o[\u0002\naAZ;ukJ,W#\u0001\u0013\u0002\u000f\u0019,H/\u001e:fA\u0005!a.\u001a=u)\u0005!\u0013\u0001B:f]\u0012$\"\u0001\n/\t\u000bu[\u0001\u0019\u00010\u0002\u00039\u0004\"AG0\n\u0005\u0001\\\"aA%oi\u0006Aa)Y5m_Z,'\u000f\u0005\u00028\u001bM\u0011Q\"\u0007\u000b\u0002E\u00061An\\4hKJ,\u0012a\u001a\t\u0003QRt!![9\u000f\u0005)|gBA6o\u001b\u0005a'BA7!\u0003\u0019a$o\\8u}%\ta#\u0003\u0002q+\u0005!Q\u000f^5m\u0013\t\u00118/\u0001\u0006MCjLHj\\4hKJT!\u0001]\u000b\n\u0005U4(A\u0003'bufdunZ4fe*\u0011!o]\u0001\bY><w-\u001a:!\u0003\u0015\t\u0007\u000f\u001d7z+\tQx\u0010F\u0003|\u0003\u0013\tY\u0001F\u0002}\u0003\u0007!2!`A\u0001!\r9\u0004A \t\u0003W}$Q!L\tC\u00029BQAP\tA\u0004}BaaH\tA\u0002\u0005\u0015\u0001\u0003\u0002\u000e#\u0003\u000f\u00012!\n\u0015\u007f\u0011\u0015)\u0014\u00031\u00017\u0011\u0015Q\u0014\u00031\u0001<\u0001")
public final class Failover<A> {
    private final Function0<Future<A>> producer;
    private final MongoConnection connection;
    private final FailoverStrategy failoverStrategy;
    private final ExecutionContext ec;
    private final String lnm;
    private final Future<A> future;

    public static <A> Failover<A> apply(MongoConnection connection, FailoverStrategy failoverStrategy, Function0<Future<A>> producer, ExecutionContext ec) {
        return Failover$.MODULE$.apply(connection, failoverStrategy, producer, ec);
    }

    private String lnm() {
        return this.lnm;
    }

    public Future<A> future() {
        return this.future;
    }

    private Future<A> next() {
        Future future;
        try {
            future = (Future)this.producer.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                future = Future$.MODULE$.failed(throwable2);
            }
            throw throwable;
        }
        return future;
    }

    private Future<A> send(int n) {
        return this.next().map((Function1 & Serializable)x$1 -> new Success(x$1), this.ec).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                return (B1)new Failure(A1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
        }, this.ec).flatMap((Function1 & Serializable)x0$1 -> {
            Option<Throwable> option;
            Try try_ = x0$1;
            if (try_ != null && !(option = RetryableFailure$.MODULE$.unapply(try_)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                if (n < $this.failoverStrategy.retries()) {
                    int n = n + 1;
                    double delayFactor = $this.failoverStrategy.delayFactor().apply$mcDI$sp(n);
                    FiniteDuration delay = (FiniteDuration)Duration$.MODULE$.unapply($this.failoverStrategy.initialDelay().$times(delayFactor)).fold((Function0 & Serializable)() -> $this.failoverStrategy.initialDelay(), (Function1 & Serializable)t -> FiniteDuration$.MODULE$.apply(t._1$mcJ$sp(), (TimeUnit)((Object)((Object)((Object)t._2())))));
                    Failover$.MODULE$.logger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("[").append(this.lnm()).append("] Got an error, retrying... (try #").append(n).append(" is scheduled in ").append(delay.toMillis()).append(" ms)").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    return package$.MODULE$.after(delay, $this.connection.actorSystem().scheduler(), (Function0 & Serializable)() -> this.send(n), $this.ec);
                }
                Failover$.MODULE$.logger().error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("[").append(this.lnm()).append("] Got an error, no more attempts to do. Completing with a failure... ").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return Future$.MODULE$.failed(e);
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                Failover$.MODULE$.logger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("[").append(this.lnm()).append("] Got an non retryable error, completing with a failure... ").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return Future$.MODULE$.failed(e);
            }
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object response = success.value();
                Failover$.MODULE$.logger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("[").append(this.lnm()).append("] Got a successful result, completing...").toString());
                return Future$.MODULE$.successful(response);
            }
            throw new MatchError((Object)try_);
        }, this.ec);
    }

    public Failover(Function0<Future<A>> producer, MongoConnection connection, FailoverStrategy failoverStrategy, ExecutionContext ec) {
        this.producer = producer;
        this.connection = connection;
        this.failoverStrategy = failoverStrategy;
        this.ec = ec;
        this.lnm = new StringBuilder(1).append(connection.supervisor()).append("/").append(connection.name()).toString();
        this.future = this.send(0);
    }
}

