/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.core.netty;

import akka.actor.ActorRef;
import akka.actor.ScalaActorRef;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import reactivemongo.api.MongoConnectionOptions;
import reactivemongo.api.MongoConnectionOptions$KeyStore$;
import reactivemongo.core.SSL;
import reactivemongo.core.actors.ChannelDisconnected;
import reactivemongo.core.errors.GenericDriverException;
import reactivemongo.core.errors.GenericDriverException$;
import reactivemongo.core.netty.ChannelFactory$;
import reactivemongo.core.netty.ChannelFactory$TrustAny$;
import reactivemongo.core.netty.Pack;
import reactivemongo.core.netty.Pack$;
import reactivemongo.core.protocol.MongoHandler;
import reactivemongo.core.protocol.RequestEncoder;
import reactivemongo.core.protocol.ResponseDecoder;
import reactivemongo.core.protocol.ResponseFrameDecoder;
import reactivemongo.io.netty.bootstrap.Bootstrap;
import reactivemongo.io.netty.channel.Channel;
import reactivemongo.io.netty.channel.ChannelFuture;
import reactivemongo.io.netty.channel.ChannelFutureListener;
import reactivemongo.io.netty.channel.ChannelHandler;
import reactivemongo.io.netty.channel.ChannelId;
import reactivemongo.io.netty.channel.ChannelInitializer;
import reactivemongo.io.netty.channel.ChannelOption;
import reactivemongo.io.netty.channel.ChannelPipeline;
import reactivemongo.io.netty.channel.EventLoopGroup;
import reactivemongo.io.netty.handler.ssl.SslHandler;
import reactivemongo.io.netty.handler.timeout.IdleStateHandler;
import reactivemongo.io.netty.util.AttributeKey;
import reactivemongo.io.netty.util.concurrent.Future;
import reactivemongo.io.netty.util.concurrent.GenericFutureListener;
import reactivemongo.util.LazyLogger;
import reactivemongo.util.LazyLogger$;
import reactivemongo.util.package$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.concurrent.Promise;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Random;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\t\u0005g!\u0002\u00192\u0005U:\u0004\u0002\u0004#\u0001\t\u0003\u0005)Q!A!\u0002\u00131\u0005\u0002D*\u0001\t\u0003\u0005)Q!A!\u0002\u00131\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u000bm\u0003A\u0011\u0001/\t\u0019\u0011\u0004A\u0011!A\u0003\u0002\u000b\u0007I\u0011B3\t\u0013%\u0004!\u0011!A!\u0002\u00131\u0007\u0002\u00046\u0001\t\u0003\u0005)\u0011!b\u0001\n\u0013Y\u0007\"C8\u0001\u0005\u0003\u0005\t\u0015!\u0003m\u00111\u0001\b\u0001\"A\u0001\u0006\u0003\u0015\r\u0011\"\u0003r\u0011%y\bA!A\u0001B\u0003%!\u000f\u0003\b\u0002\u0002\u0001!\t\u0011!B\u0001\u0006\u0004%I!a\u0001\t\u0017\u0005U\u0001A!A\u0001B\u0003%\u0011Q\u0001\u0005\u000f\u0003/\u0001A\u0011!A\u0003\u0002\u000b\u0007I\u0011BA\u0002\u0011-\tI\u0002\u0001B\u0001\u0002\u0003\u0006I!!\u0002\t\u001d\u0005m\u0001\u0001\"A\u0001\u0006\u0003\u0015\r\u0011\"\u0003\u0002\u001e!Y\u0011Q\u0005\u0001\u0003\u0002\u0003\u0005\u000b\u0011BA\u0010\u0011!\t9\u0003\u0001C\u0001k\u0005%\u0002BCA6\u0001E\u0005I\u0011A\u001b\u0002n!Q\u00111\u0011\u0001\u0012\u0002\u0013\u0005Q'!\"\t\u0015\u0005%\u0005!%A\u0005\u0002U\n)\tC\u0004\u0002\f\u0002!\t!!$\t\u0011\u0005-\u0005\u0001\"\u00016\u0003/Cq!a)\u0001\t\u0013\t)\u000bC\u0004\u0002<\u0002!I!!0\t\u000f\u0005M\u0007\u0001\"\u0003\u0002V\"A\u00111\u001e\u0001\u0005\u0002U\ni\u000fC\u0004\u0003\u0010\u0001!IA!\u0005\t\u000f\t=\u0001\u0001\"\u0003\u0003 !9!\u0011\b\u0001\u0005\n\tm\u0002b\u0002B!\u0001\u0011%!1I\u0004\b\u0005\u0013\u0002\u0001\u0012\u0002B&\r\u001d\u0011y\u0005\u0001E\u0005\u0005#Baa\u0017\u0011\u0005\u0002\t}\u0003b\u0002B1A\u0011\u0005#1\r\u0005\b\u0005\u0007\u0003C\u0011\tBC\u0011\u001d\u0011Y\t\tC!\u0005\u001b;\u0001Ba$2\u0011\u0003)$\u0011\u0013\u0004\baEB\t!\u000eBJ\u0011\u0019Yf\u0005\"\u0001\u0003\u001c\"I!Q\u0014\u0014C\u0002\u0013\u0005!q\u0014\u0005\t\u0005W3\u0003\u0015!\u0003\u0003\"\"I!Q\u0016\u0014C\u0002\u0013\u0005!q\u0016\u0005\t\u0005g3\u0003\u0015!\u0003\u00032\"I!Q\u0017\u0014C\u0002\u0013\u0005!q\u0017\u0005\t\u0005w3\u0003\u0015!\u0003\u0003:\"I!Q\u0018\u0014C\u0002\u0013\u0005!q\u0016\u0005\t\u0005\u007f3\u0003\u0015!\u0003\u00032\nq1\t[1o]\u0016dg)Y2u_JL(B\u0001\u001a4\u0003\u0015qW\r\u001e;z\u0015\t!T'\u0001\u0003d_J,'\"\u0001\u001c\u0002\u001bI,\u0017m\u0019;jm\u0016lwN\\4p'\t\u0001\u0001\bE\u0002:\u007f\u0005k\u0011A\u000f\u0006\u0003wq\nqa\u00195b]:,GN\u0003\u00023{)\u0011a(N\u0001\u0003S>L!\u0001\u0011\u001e\u0003%\rC\u0017M\u001c8fY&s\u0017\u000e^5bY&TXM\u001d\t\u0003s\tK!a\u0011\u001e\u0003\u000f\rC\u0017M\u001c8fY\u0006\u0019$/Z1di&4X-\\8oO>$3m\u001c:fI9,G\u000f^=%\u0007\"\fgN\\3m\r\u0006\u001cGo\u001c:zI\u0011\u001aX\u000f]3sm&\u001cxN]\u0002\u0001!\t9\u0005K\u0004\u0002I\u001dB\u0011\u0011\nT\u0007\u0002\u0015*\u00111*R\u0001\u0007yI|w\u000e\u001e \u000b\u00035\u000bQa]2bY\u0006L!a\u0014'\u0002\rA\u0013X\rZ3g\u0013\t\t&K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001f2\u000b1G]3bGRLg/Z7p]\u001e|GeY8sK\u0012rW\r\u001e;zI\rC\u0017M\u001c8fY\u001a\u000b7\r^8ss\u0012\"3m\u001c8oK\u000e$\u0018n\u001c8\u0002\u000f=\u0004H/[8ogB\u0011a+W\u0007\u0002/*\u0011\u0001,N\u0001\u0004CBL\u0017B\u0001.X\u0005YiuN\\4p\u0007>tg.Z2uS>tw\n\u001d;j_:\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0003^?\u0006\u001c\u0007C\u00010\u0001\u001b\u0005\t\u0004\"\u00021\u0005\u0001\u00041\u0015AC:va\u0016\u0014h/[:pe\")!\r\u0002a\u0001\r\u0006Q1m\u001c8oK\u000e$\u0018n\u001c8\t\u000bQ#\u0001\u0019A+\u0002[I,\u0017m\u0019;jm\u0016lwN\\4pI\r|'/\u001a\u0013oKR$\u0018\u0010J\"iC:tW\r\u001c$bGR|'/\u001f\u0013%a\u0006\u001c7.F\u0001g!\tqv-\u0003\u0002ic\t!\u0001+Y2l\u00039\u0012X-Y2uSZ,Wn\u001c8h_\u0012\u001awN]3%]\u0016$H/\u001f\u0013DQ\u0006tg.\u001a7GC\u000e$xN]=%IA\f7m\u001b\u0011\u0002iI,\u0017m\u0019;jm\u0016lwN\\4pI\r|'/\u001a\u0013oKR$\u0018\u0010J\"iC:tW\r\u001c$bGR|'/\u001f\u0013%a\u0006\u0014XM\u001c;He>,\b/F\u0001m!\tIT.\u0003\u0002ou\tqQI^3oi2{w\u000e]$s_V\u0004\u0018!\u000e:fC\u000e$\u0018N^3n_:<w\u000eJ2pe\u0016$c.\u001a;us\u0012\u001a\u0005.\u00198oK24\u0015m\u0019;pef$C\u0005]1sK:$xI]8va\u0002\nqF]3bGRLg/Z7p]\u001e|GeY8sK\u0012rW\r\u001e;zI\rC\u0017M\u001c8fY\u001a\u000b7\r^8ss\u0012\"Cn\\4hKJ,\u0012A\u001d\t\u0003grt!\u0001^=\u000f\u0005U<hBA%w\u0013\u00051\u0014B\u0001=6\u0003\u0011)H/\u001b7\n\u0005i\\\u0018A\u0003'bufdunZ4fe*\u0011\u00010N\u0005\u0003{z\u0014!\u0002T1{s2{wmZ3s\u0015\tQ80\u0001\u0019sK\u0006\u001cG/\u001b<f[>twm\u001c\u0013d_J,GE\\3uif$3\t[1o]\u0016dg)Y2u_JLH\u0005\n7pO\u001e,'\u000fI\u00014e\u0016\f7\r^5wK6|gnZ8%G>\u0014X\r\n8fiRLHe\u00115b]:,GNR1di>\u0014\u0018\u0010\n\u0013uGBtu\u000eR3mCf,\"!!\u0002\u0011\t\u0005\u001d\u0011\u0011C\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005!A.\u00198h\u0015\t\ty!\u0001\u0003kCZ\f\u0017\u0002BA\n\u0003\u0013\u0011qAQ8pY\u0016\fg.\u0001\u001bsK\u0006\u001cG/\u001b<f[>twm\u001c\u0013d_J,GE\\3uif$3\t[1o]\u0016dg)Y2u_JLH\u0005\n;da:{G)\u001a7bs\u0002\n!G]3bGRLg/Z7p]\u001e|GeY8sK\u0012rW\r\u001e;zI\rC\u0017M\u001c8fY\u001a\u000b7\r^8ss\u0012\"3.Z3q\u00032Lg/Z\u00014e\u0016\f7\r^5wK6|gnZ8%G>\u0014X\r\n8fiRLHe\u00115b]:,GNR1di>\u0014\u0018\u0010\n\u0013lK\u0016\u0004\u0018\t\\5wK\u0002\n!G]3bGRLg/Z7p]\u001e|GeY8sK\u0012rW\r\u001e;zI\rC\u0017M\u001c8fY\u001a\u000b7\r^8ss\u0012\"C/[7f_V$Xj]\u000b\u0003\u0003?\u0001B!a\u0002\u0002\"%!\u00111EA\u0005\u0005\u001dIe\u000e^3hKJ\f1G]3bGRLg/Z7p]\u001e|GeY8sK\u0012rW\r\u001e;zI\rC\u0017M\u001c8fY\u001a\u000b7\r^8ss\u0012\"C/[7f_V$Xj\u001d\u0011\u0002\r\r\u0014X-\u0019;f))\tY#!\u000e\u0002:\u0005\u0015\u0013\u0011\n\t\u0006\u0003[\t\t$Q\u0007\u0003\u0003_Q!\u0001\u001f'\n\t\u0005M\u0012q\u0006\u0002\u0004)JL\b\u0002CA\u001c#A\u0005\t\u0019\u0001$\u0002\t!|7\u000f\u001e\u0005\n\u0003w\t\u0002\u0013!a\u0001\u0003{\tA\u0001]8siB!\u0011qHA!\u001b\u0005a\u0015bAA\"\u0019\n\u0019\u0011J\u001c;\t\u0013\u0005\u001d\u0013\u0003%AA\u0002\u0005u\u0012!D7bq&#G.\u001a+j[\u0016l5\u000bC\u0004\u0002LE\u0001\r!!\u0014\u0002\u0011I,7-Z5wKJ\u0004B!a\u0014\u0002f9!\u0011\u0011KA0\u001d\u0011\t\u0019&!\u0017\u000f\u0007U\f)&C\u0002\u0002XU\na!Y2u_J\u001c\u0018\u0002BA.\u0003;\nQ!Y2u_JT1!a\u00166\u0013\u0011\t\t'a\u0019\u0002\u000fA\f7m[1hK*!\u00111LA/\u0013\u0011\t9'!\u001b\u0003\u0011\u0005\u001bGo\u001c:SK\u001aTA!!\u0019\u0002d\u0005\u00012M]3bi\u0016$C-\u001a4bk2$H%M\u000b\u0003\u0003_R3ARA9W\t\t\u0019\b\u0005\u0003\u0002v\u0005}TBAA<\u0015\u0011\tI(a\u001f\u0002\u0013Ut7\r[3dW\u0016$'bAA?\u0019\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0015q\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001E2sK\u0006$X\r\n3fM\u0006,H\u000e\u001e\u00133+\t\t9I\u000b\u0003\u0002>\u0005E\u0014\u0001E2sK\u0006$X\r\n3fM\u0006,H\u000e\u001e\u00134\u0003-Ig.\u001b;DQ\u0006tg.\u001a7\u0015\t\u0005=\u0015Q\u0013\t\u0005\u0003\u007f\t\t*C\u0002\u0002\u00142\u0013A!\u00168ji\")1(\u0006a\u0001\u0003Ra\u0011qRAM\u00037\u000bi*a(\u0002\"\")1H\u0006a\u0001\u0003\"1\u0011q\u0007\fA\u0002\u0019Cq!a\u000f\u0017\u0001\u0004\ti\u0004C\u0004\u0002HY\u0001\r!!\u0010\t\u000f\u0005-c\u00031\u0001\u0002N\u0005A1.Z=Ti>\u0014X-\u0006\u0002\u0002(B1\u0011qHAU\u0003[K1!a+M\u0005\u0019y\u0005\u000f^5p]B!\u0011qVA[\u001d\r1\u0016\u0011W\u0005\u0004\u0003g;\u0016AF'p]\u001e|7i\u001c8oK\u000e$\u0018n\u001c8PaRLwN\\:\n\t\u0005]\u0016\u0011\u0018\u0002\t\u0017\u0016L8\u000b^8sK*\u0019\u00111W,\u0002\u0015M\u001cHnQ8oi\u0016DH/\u0006\u0002\u0002@B!\u0011\u0011YAh\u001b\t\t\u0019M\u0003\u0003\u0002F\u0006\u001d\u0017aA:tY*!\u0011\u0011ZAf\u0003\rqW\r\u001e\u0006\u0003\u0003\u001b\fQA[1wCbLA!!5\u0002D\nQ1k\u0015'D_:$X\r\u001f;\u0002\u001d\rD\u0017M\u001c8fY\u001a\u000b7\r^8ssR\u0011\u0011q\u001b\t\u0005\u00033\fy.\u0004\u0002\u0002\\*\u0019\u0011Q\u001c\u001f\u0002\u0013\t|w\u000e^:ue\u0006\u0004\u0018\u0002BAq\u00037\u0014\u0011BQ8piN$(/\u00199)\u0007e\t)\u000f\u0005\u0003\u0002@\u0005\u001d\u0018bAAu\u0019\n1\u0011N\u001c7j]\u0016\fqA]3mK\u0006\u001cX\r\u0006\u0004\u0002\u0010\u0006=\u0018q \u0005\b\u0003cT\u0002\u0019AAz\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0007CBA{\u0003w\fy)\u0004\u0002\u0002x*\u0019\u0011\u0011 '\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002~\u0006](a\u0002)s_6L7/\u001a\u0005\b\u0005\u0003Q\u0002\u0019\u0001B\u0002\u0003\u001d!\u0018.\\3pkR\u0004BA!\u0002\u0003\f5\u0011!q\u0001\u0006\u0005\u0005\u0013\t90\u0001\u0005ekJ\fG/[8o\u0013\u0011\u0011iAa\u0002\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006)A-\u001a2vOR!\u0011q\u0012B\n\u0011!\u0011)b\u0007CA\u0002\t]\u0011aA7tOB)\u0011q\bB\r\r&\u0019!1\u0004'\u0003\u0011q\u0012\u0017P\\1nKzB3aGAs)\u0019\tyI!\t\u0003$!A!Q\u0003\u000f\u0005\u0002\u0004\u00119\u0002C\u0004\u0003&q\u0001\rAa\n\u0002\u000b\r\fWo]3\u0011\t\t%\"\u0011\u0007\b\u0005\u0005W\u0011yCD\u0002J\u0005[I\u0011!T\u0005\u0004\u0003Cb\u0015\u0002\u0002B\u001a\u0005k\u0011\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005\u0005D\nK\u0002\u001d\u0003K\fQ\u0001\u001e:bG\u0016$B!a$\u0003>!A!QC\u000f\u0005\u0002\u0004\u00119\u0002K\u0002\u001e\u0003K\fA!\u001b8g_R!\u0011q\u0012B#\u0011!\u0011)B\bCA\u0002\t]\u0001f\u0001\u0010\u0002f\u0006AAK];ti\u0006s\u0017\u0010E\u0002\u0003N\u0001j\u0011\u0001\u0001\u0002\t)J,8\u000f^!osN)\u0001Ea\u0015\u0003ZA!\u0011q\u0001B+\u0013\u0011\u00119&!\u0003\u0003\r=\u0013'.Z2u!\u0011\t\tMa\u0017\n\t\tu\u00131\u0019\u0002\u00111V\u0002\u0014\b\u0016:vgRl\u0015M\\1hKJ$\"Aa\u0013\u0002%\rDWmY6DY&,g\u000e\u001e+skN$X\r\u001a\u000b\u0007\u0003\u001f\u0013)Ga \t\u000f\t\u001d$\u00051\u0001\u0003j\u0005\u00111m\u001d\t\u0007\u0003\u007f\u0011YGa\u001c\n\u0007\t5DJA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0003r\tmTB\u0001B:\u0015\u0011\u0011)Ha\u001e\u0002\t\r,'\u000f\u001e\u0006\u0005\u0005s\ni!\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\u0011iHa\u001d\u0003\u001fa+\u0004'O\"feRLg-[2bi\u0016DaA!!#\u0001\u00041\u0015!A1\u0002%\rDWmY6TKJ4XM\u001d+skN$X\r\u001a\u000b\u0007\u0003\u001f\u00139I!#\t\u000f\t\u001d4\u00051\u0001\u0003j!1!\u0011Q\u0012A\u0002\u0019\u000b!cZ3u\u0003\u000e\u001cW\r\u001d;fI&\u001b8/^3sgR\u0011!\u0011N\u0001\u000f\u0007\"\fgN\\3m\r\u0006\u001cGo\u001c:z!\tqfeE\u0002'\u0005+\u0003B!a\u0010\u0003\u0018&\u0019!\u0011\u0014'\u0003\r\u0005s\u0017PU3g)\t\u0011\t*A\u0004i_N$8*Z=\u0016\u0005\t\u0005\u0006#\u0002BR\u0005O3UB\u0001BS\u0015\tAH(\u0003\u0003\u0003*\n\u0015&\u0001D!uiJL'-\u001e;f\u0017\u0016L\u0018\u0001\u00035pgR\\U-\u001f\u0011\u0002\u000fA|'\u000f^&fsV\u0011!\u0011\u0017\t\u0007\u0005G\u00139+!\u0010\u0002\u0011A|'\u000f^&fs\u0002\n1\"Y2u_J\u0014VMZ&fsV\u0011!\u0011\u0018\t\u0007\u0005G\u00139+!\u0014\u0002\u0019\u0005\u001cGo\u001c:SK\u001a\\U-\u001f\u0011\u0002\u001d5\f\u00070\u00133mKRKW.Z&fs\u0006yQ.\u0019=JI2,G+[7f\u0017\u0016L\b\u0005")
public final class ChannelFactory
extends ChannelInitializer<Channel> {
    private volatile ChannelFactory$TrustAny$ TrustAny$module;
    public final String reactivemongo$core$netty$ChannelFactory$$supervisor;
    public final String reactivemongo$core$netty$ChannelFactory$$connection;
    private final MongoConnectionOptions options;
    private final Pack reactivemongo$core$netty$ChannelFactory$$pack;
    private final EventLoopGroup reactivemongo$core$netty$ChannelFactory$$parentGroup;
    private final LazyLogger.LazyLogger reactivemongo$core$netty$ChannelFactory$$logger;
    private final Boolean reactivemongo$core$netty$ChannelFactory$$tcpNoDelay;
    private final Boolean reactivemongo$core$netty$ChannelFactory$$keepAlive;
    private final Integer reactivemongo$core$netty$ChannelFactory$$timeoutMs;

    public static AttributeKey<Object> maxIdleTimeKey() {
        return ChannelFactory$.MODULE$.maxIdleTimeKey();
    }

    public static AttributeKey<ActorRef> actorRefKey() {
        return ChannelFactory$.MODULE$.actorRefKey();
    }

    public static AttributeKey<Object> portKey() {
        return ChannelFactory$.MODULE$.portKey();
    }

    public static AttributeKey<String> hostKey() {
        return ChannelFactory$.MODULE$.hostKey();
    }

    private ChannelFactory$TrustAny$ TrustAny() {
        if (this.TrustAny$module == null) {
            this.TrustAny$lzycompute$1();
        }
        return this.TrustAny$module;
    }

    public Pack reactivemongo$core$netty$ChannelFactory$$pack() {
        return this.reactivemongo$core$netty$ChannelFactory$$pack;
    }

    public EventLoopGroup reactivemongo$core$netty$ChannelFactory$$parentGroup() {
        return this.reactivemongo$core$netty$ChannelFactory$$parentGroup;
    }

    public LazyLogger.LazyLogger reactivemongo$core$netty$ChannelFactory$$logger() {
        return this.reactivemongo$core$netty$ChannelFactory$$logger;
    }

    public Boolean reactivemongo$core$netty$ChannelFactory$$tcpNoDelay() {
        return this.reactivemongo$core$netty$ChannelFactory$$tcpNoDelay;
    }

    public Boolean reactivemongo$core$netty$ChannelFactory$$keepAlive() {
        return this.reactivemongo$core$netty$ChannelFactory$$keepAlive;
    }

    public Integer reactivemongo$core$netty$ChannelFactory$$timeoutMs() {
        return this.reactivemongo$core$netty$ChannelFactory$$timeoutMs;
    }

    public Try<Channel> create(String host, int port, int maxIdleTimeMS, ActorRef receiver) {
        if (this.reactivemongo$core$netty$ChannelFactory$$parentGroup().isShuttingDown() || this.reactivemongo$core$netty$ChannelFactory$$parentGroup().isShutdown() || this.reactivemongo$core$netty$ChannelFactory$$parentGroup().isTerminated()) {
            String msg = new StringBuilder(50).append("Cannot create channel to '").append(host).append(":").append(port).append("' from inactive factory").toString();
            this.info((Function0<String>)(Function0 & Serializable)() -> msg);
            return new Failure((Throwable)new GenericDriverException(new StringBuilder(4).append(msg).append(" (").append(this.reactivemongo$core$netty$ChannelFactory$$supervisor).append("/").append(this.reactivemongo$core$netty$ChannelFactory$$connection).append(")").toString(), GenericDriverException$.MODULE$.$lessinit$greater$default$2()));
        }
        Bootstrap f = this.channelFactory();
        f.attr(ChannelFactory$.MODULE$.hostKey(), (Object)host);
        f.attr(ChannelFactory$.MODULE$.portKey(), (Object)BoxesRunTime.boxToInteger((int)port));
        f.attr(ChannelFactory$.MODULE$.actorRefKey(), (Object)receiver);
        f.attr(ChannelFactory$.MODULE$.maxIdleTimeKey(), (Object)BoxesRunTime.boxToInteger((int)maxIdleTimeMS));
        ChannelFuture resolution = f.connect(host, port).addListener((GenericFutureListener)new ChannelFutureListener(this, host, port, receiver){
            private final /* synthetic */ ChannelFactory $outer;
            private final String host$1;
            private final int port$1;
            private final ActorRef receiver$1;

            public void operationComplete(ChannelFuture op) {
                if (!op.isSuccess()) {
                    ChannelId chanId = op.channel().id();
                    this.$outer.reactivemongo$core$netty$ChannelFactory$$debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Connection to ").append($this.host$1).append(":").append($this.port$1).append(" refused for channel #").append(chanId).toString(), op.cause());
                    ScalaActorRef qual$1 = akka.actor.package$.MODULE$.actorRef2Scala(this.receiver$1);
                    ChannelDisconnected x$1 = new ChannelDisconnected(chanId);
                    ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
                    qual$1.$bang((Object)x$1, x$2);
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.host$1 = host$1;
                this.port$1 = port$1;
                this.receiver$1 = receiver$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$operationComplete$1(reactivemongo.core.netty.ChannelFactory$$anon$1 reactivemongo.io.netty.channel.ChannelId )}, serializedLambda);
            }
        });
        Channel channel = resolution.channel();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Created new channel #").append(channel.id()).append(" to ").append(host).append(":").append(port).append(" (registered = ").append(channel.isRegistered()).append(")").toString());
        return new Success((Object)channel);
    }

    public String create$default$1() {
        return "localhost";
    }

    public int create$default$2() {
        return 27017;
    }

    public int create$default$3() {
        return this.options.maxIdleTimeMS();
    }

    public void initChannel(Channel channel) {
        String host = (String)channel.attr(ChannelFactory$.MODULE$.hostKey()).get();
        int port = BoxesRunTime.unboxToInt((Object)channel.attr(ChannelFactory$.MODULE$.portKey()).get());
        int maxIdleTimeMS = BoxesRunTime.unboxToInt((Object)channel.attr(ChannelFactory$.MODULE$.maxIdleTimeKey()).get());
        ActorRef receiver = (ActorRef)channel.attr(ChannelFactory$.MODULE$.actorRefKey()).get();
        this.initChannel(channel, host, port, maxIdleTimeMS, receiver);
    }

    public void initChannel(Channel channel, String host, int port, int maxIdleTimeMS, ActorRef receiver) {
        BoxedUnit boxedUnit;
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Initializing channel ").append(channel.id()).append(" to ").append(host).append(":").append(port).append(" (").append(receiver).append(")").toString());
        ChannelPipeline pipeline = channel.pipeline();
        long idleTimeMS = maxIdleTimeMS;
        pipeline.addLast("idleState", (ChannelHandler)new IdleStateHandler(idleTimeMS, idleTimeMS, 0L, TimeUnit.MILLISECONDS));
        if (this.options.sslEnabled()) {
            SSLEngine sslEng = SSL.createEngine(this.sslContext(), host, port);
            SslHandler sslHandler = new SslHandler(sslEng, false);
            boxedUnit = pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        pipeline.addLast(new ChannelHandler[]{new ResponseFrameDecoder(), new ResponseDecoder(), new RequestEncoder(), new MongoHandler(this.reactivemongo$core$netty$ChannelFactory$$supervisor, this.reactivemongo$core$netty$ChannelFactory$$connection, receiver)});
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(126).append("Netty channel configuration:\n- connectTimeoutMS: ").append($this.options.connectTimeoutMS()).append("\n- maxIdleTimeMS: ").append($this.options.maxIdleTimeMS()).append("ms\n- tcpNoDelay: ").append($this.options.tcpNoDelay()).append("\n- keepAlive: ").append($this.options.keepAlive()).append("\n- sslEnabled: ").append($this.options.sslEnabled()).append("\n- keyStore: ").append($this.options.keyStore().fold((Function0 & Serializable)() -> "None", (Function1 & Serializable)x$1 -> x$1.toString())).toString());
    }

    private Option<MongoConnectionOptions.KeyStore> keyStore() {
        return this.options.keyStore().orElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.props().get("javax.net.ssl.keyStore").map((Function1 & Serializable)path -> {
            URI x$1 = new File((String)path).toURI();
            String x$22 = (String)scala.sys.package$.MODULE$.props().getOrElse((Object)"javax.net.ssl.keyStoreType", (Function0 & Serializable)() -> "JKS");
            Option x$3 = scala.sys.package$.MODULE$.props().get("javax.net.ssl.keyStorePassword").map((Function1 & Serializable)x$2 -> x$2.toCharArray());
            boolean x$4 = true;
            return MongoConnectionOptions$KeyStore$.MODULE$.apply(x$1, (Option<char[]>)x$3, x$22, true);
        }));
    }

    private SSLContext sslContext() {
        LazyRef loadedStore$lzy = new LazyRef();
        Option keyManagers = this.loadedStore$1(loadedStore$lzy).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                KeyStore ks = (KeyStore)tuple2._1();
                char[] password = (char[])tuple2._2();
                KeyManagerFactory res = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                res.init(ks, password);
                KeyManagerFactory kmf = res;
                return kmf.getKeyManagers();
            }
            throw new MatchError((Object)tuple2);
        });
        return this.sslCtx$1(keyManagers, loadedStore$lzy);
    }

    private Bootstrap channelFactory() {
        return (Bootstrap)new Bootstrap().group(this.reactivemongo$core$netty$ChannelFactory$$parentGroup()).channel(this.reactivemongo$core$netty$ChannelFactory$$pack().channelClass()).option(ChannelOption.TCP_NODELAY, (Object)this.reactivemongo$core$netty$ChannelFactory$$tcpNoDelay()).option(ChannelOption.SO_KEEPALIVE, (Object)this.reactivemongo$core$netty$ChannelFactory$$keepAlive()).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.reactivemongo$core$netty$ChannelFactory$$timeoutMs()).handler((ChannelHandler)this);
    }

    public void release(Promise<BoxedUnit> callback, FiniteDuration timeout) {
        if (this.reactivemongo$core$netty$ChannelFactory$$parentGroup().iterator().hasNext()) {
            this.reactivemongo$core$netty$ChannelFactory$$parentGroup().shutdownGracefully(0L, timeout.length(), timeout.unit()).addListener((GenericFutureListener)new GenericFutureListener<Future<Object>>(this, callback){
                private final /* synthetic */ ChannelFactory $outer;
                private final Promise callback$1;

                public void operationComplete(Future<Object> f) {
                    ChannelFactory.reactivemongo$core$netty$ChannelFactory$$ok$1(this.callback$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.callback$1 = callback$1;
                }
            });
            return;
        }
        ChannelFactory.reactivemongo$core$netty$ChannelFactory$$ok$1(callback);
    }

    private void debug(Function0<String> msg) {
        this.reactivemongo$core$netty$ChannelFactory$$logger().debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(4).append("[").append($this.reactivemongo$core$netty$ChannelFactory$$supervisor).append("/").append($this.reactivemongo$core$netty$ChannelFactory$$connection).append("] ").append(msg.apply()).toString());
    }

    public void reactivemongo$core$netty$ChannelFactory$$debug(Function0<String> msg, Throwable cause) {
        this.reactivemongo$core$netty$ChannelFactory$$logger().debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(4).append("[").append($this.reactivemongo$core$netty$ChannelFactory$$supervisor).append("/").append($this.reactivemongo$core$netty$ChannelFactory$$connection).append("] ").append(msg.apply()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> cause);
    }

    private void trace(Function0<String> msg) {
        this.reactivemongo$core$netty$ChannelFactory$$logger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(4).append("[").append($this.reactivemongo$core$netty$ChannelFactory$$supervisor).append("/").append($this.reactivemongo$core$netty$ChannelFactory$$connection).append("] ").append(msg.apply()).toString());
    }

    private void info(Function0<String> msg) {
        this.reactivemongo$core$netty$ChannelFactory$$logger().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(4).append("[").append($this.reactivemongo$core$netty$ChannelFactory$$supervisor).append("/").append($this.reactivemongo$core$netty$ChannelFactory$$connection).append("] ").append(msg.apply()).toString());
    }

    private final void TrustAny$lzycompute$1() {
        ChannelFactory channelFactory = this;
        synchronized (channelFactory) {
            if (this.TrustAny$module == null) {
                this.TrustAny$module = new ChannelFactory$TrustAny$(this);
            }
        }
    }

    private final /* synthetic */ Option loadedStore$lzycompute$1(LazyRef loadedStore$lzy$1) {
        Option option;
        LazyRef lazyRef = loadedStore$lzy$1;
        synchronized (lazyRef) {
            option = loadedStore$lzy$1.initialized() ? (Option)loadedStore$lzy$1.value() : (Option)loadedStore$lzy$1.initialize((Object)this.keyStore().map((Function1 & Serializable)settings -> {
                char[] password = (char[])settings.password().getOrElse((Function0 & Serializable)() -> (char[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Char()));
                return (Tuple2)package$.MODULE$.withContent(settings.resource(), (Function1 & Serializable)storeIn -> {
                    KeyStore res = KeyStore.getInstance(settings.storeType());
                    res.load((InputStream)storeIn, password);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)res), (Object)password);
                });
            }));
        }
        return option;
    }

    private final Option loadedStore$1(LazyRef loadedStore$lzy$1) {
        if (loadedStore$lzy$1.initialized()) {
            return (Option)loadedStore$lzy$1.value();
        }
        return this.loadedStore$lzycompute$1(loadedStore$lzy$1);
    }

    private final boolean trust$1() {
        return BoxesRunTime.unboxToBoolean((Object)this.keyStore().fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> true, (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.trust())));
    }

    private final SSLContext sslCtx$1(Option keyManagers$1, LazyRef loadedStore$lzy$1) {
        SSLContext res = SSLContext.getInstance("SSL");
        TrustManager[] tm = this.options.sslAllowsInvalidCert() ? (TrustManager[])((Object[])new TrustManager[]{this.TrustAny()}) : (!this.trust$1() ? null : (TrustManager[])this.loadedStore$1(loadedStore$lzy$1).fold((Function0 & Serializable)() -> null, (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                KeyStore ks = (KeyStore)tuple2._1();
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(ks);
                return tmf.getTrustManagers();
            }
            throw new MatchError((Object)tuple2);
        }));
        Random rand = new Random(System.identityHashCode(tm));
        byte[] seed = (byte[])Array$.MODULE$.ofDim(128, (ClassTag)ClassTag$.MODULE$.Byte());
        rand.nextBytes(seed);
        res.init((KeyManager[])keyManagers$1.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), tm, new SecureRandom(seed));
        return res;
    }

    public static final void reactivemongo$core$netty$ChannelFactory$$ok$1(Promise callback$1) {
        callback$1.success((Object)BoxedUnit.UNIT);
    }

    public ChannelFactory(String supervisor, String connection, MongoConnectionOptions options) {
        this.reactivemongo$core$netty$ChannelFactory$$supervisor = supervisor;
        this.reactivemongo$core$netty$ChannelFactory$$connection = connection;
        this.options = options;
        this.reactivemongo$core$netty$ChannelFactory$$pack = Pack$.MODULE$.apply();
        this.reactivemongo$core$netty$ChannelFactory$$parentGroup = (EventLoopGroup)this.reactivemongo$core$netty$ChannelFactory$$pack().eventLoopGroup().apply();
        this.reactivemongo$core$netty$ChannelFactory$$logger = LazyLogger$.MODULE$.apply("reactivemongo.core.nodeset.ChannelFactory");
        this.reactivemongo$core$netty$ChannelFactory$$tcpNoDelay = options.tcpNoDelay();
        this.reactivemongo$core$netty$ChannelFactory$$keepAlive = options.keepAlive();
        this.reactivemongo$core$netty$ChannelFactory$$timeoutMs = options.connectTimeoutMS();
    }
}

