/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.core.protocol;

import akka.actor.ActorRef;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import java.io.Serializable;
import reactivemongo.core.actors.ChannelConnected;
import reactivemongo.core.actors.ChannelDisconnected;
import reactivemongo.core.protocol.MongoHandler$;
import reactivemongo.core.protocol.Response;
import reactivemongo.io.netty.channel.Channel;
import reactivemongo.io.netty.channel.ChannelDuplexHandler;
import reactivemongo.io.netty.channel.ChannelHandlerContext;
import reactivemongo.io.netty.channel.ChannelPromise;
import reactivemongo.io.netty.handler.timeout.IdleStateEvent;
import reactivemongo.util.LazyLogger;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005=e!B\f\u0019\u0001qq\u0002\u0002D\u0015\u0001\t\u0003\u0005)Q!A!\u0002\u0013Y\u0003\u0002\u0004\u001d\u0001\t\u0003\u0005)Q!A!\u0002\u0013Y\u0003\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u000b-\u0003A\u0011\u0001'\t\u000fQ\u0003\u0001\u0019!C\u0005+\"9!\f\u0001a\u0001\n\u0013Y\u0006BB1\u0001A\u0003&a\u000bC\u0003c\u0001\u0011\u00053\rC\u0003j\u0001\u0011\u0005#\u000eC\u0003r\u0001\u0011\u0005#\u000fC\u0004\u0002\u0004\u0001!\t%!\u0002\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010!9\u0011q\u0004\u0001\u0005B\u0005\u0005\u0002bBA\u001d\u0001\u0011\u0005\u00131\b\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'Bq!!\u0015\u0001\t\u0003\tYf\u0002\u0005\u0002faA\t\u0001HA4\r\u001d9\u0002\u0004#\u0001\u001d\u0003SBaaS\n\u0005\u0002\u0005E\u0004\"CA:'\t\u0007I\u0011AA;\u0011!\tii\u0005Q\u0001\n\u0005]$\u0001D'p]\u001e|\u0007*\u00198eY\u0016\u0014(BA\r\u001b\u0003!\u0001(o\u001c;pG>d'BA\u000e\u001d\u0003\u0011\u0019wN]3\u000b\u0003u\tQB]3bGRLg/Z7p]\u001e|7C\u0001\u0001 !\t\u0001s%D\u0001\"\u0015\t\u00113%A\u0004dQ\u0006tg.\u001a7\u000b\u0005\u0011*\u0013!\u00028fiRL(B\u0001\u0014\u001d\u0003\tIw.\u0003\u0002)C\t!2\t[1o]\u0016dG)\u001e9mKbD\u0015M\u001c3mKJ\fAG]3bGRLg/Z7p]\u001e|GeY8sK\u0012\u0002(o\u001c;pG>dG%T8oO>D\u0015M\u001c3mKJ$Ce];qKJ4\u0018n]8s\u0007\u0001\u0001\"\u0001L\u001b\u000f\u00055\u001a\u0004C\u0001\u00182\u001b\u0005y#B\u0001\u0019+\u0003\u0019a$o\\8u})\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\u00051\u0001K]3eK\u001aL!AN\u001c\u0003\rM#(/\u001b8h\u0015\t!\u0014'\u0001\u001bsK\u0006\u001cG/\u001b<f[>twm\u001c\u0013d_J,G\u0005\u001d:pi>\u001cw\u000e\u001c\u0013N_:<w\u000eS1oI2,'\u000f\n\u0013d_:tWm\u0019;j_:\f\u0001B]3dK&4XM\u001d\t\u0003w!s!\u0001P#\u000f\u0005u\u0012eB\u0001 A\u001d\tqs(C\u0001\u001e\u0013\t\tE$\u0001\u0004bGR|'o]\u0005\u0003\u0007\u0012\u000bQ!Y2u_JT!!\u0011\u000f\n\u0005\u0019;\u0015a\u00029bG.\fw-\u001a\u0006\u0003\u0007\u0012K!!\u0013&\u0003\u0011\u0005\u001bGo\u001c:SK\u001aT!AR$\u0002\rqJg.\u001b;?)\u0011iu*U*\u0011\u00059\u0003Q\"\u0001\r\t\u000bA#\u0001\u0019A\u0016\u0002\u0015M,\b/\u001a:wSN|'\u000fC\u0003S\t\u0001\u00071&\u0001\u0006d_:tWm\u0019;j_:DQ!\u000f\u0003A\u0002i\nA\u0001\\1tiV\ta\u000b\u0005\u0002X16\t\u0011'\u0003\u0002Zc\t!Aj\u001c8h\u0003!a\u0017m\u001d;`I\u0015\fHC\u0001/`!\t9V,\u0003\u0002_c\t!QK\\5u\u0011\u001d\u0001g!!AA\u0002Y\u000b1\u0001\u001f\u00132\u0003\u0015a\u0017m\u001d;!\u00035\u0019\u0007.\u00198oK2\f5\r^5wKR\u0011A\f\u001a\u0005\u0006K\"\u0001\rAZ\u0001\u0004GRD\bC\u0001\u0011h\u0013\tA\u0017EA\u000bDQ\u0006tg.\u001a7IC:$G.\u001a:D_:$X\r\u001f;\u0002%U\u001cXM]#wK:$HK]5hO\u0016\u0014X\r\u001a\u000b\u00049.d\u0007\"B3\n\u0001\u00041\u0007\"B7\n\u0001\u0004q\u0017aA3wiB\u0011qk\\\u0005\u0003aF\u00121!\u00118z\u0003=\u0019\u0007.\u00198oK2Le.Y2uSZ,GC\u0001/t\u0011\u0015)'\u00021\u0001gQ\u0011QQ/ @\u0011\u0005Y\\X\"A<\u000b\u0005aL\u0018\u0001\u00027b]\u001eT\u0011A_\u0001\u0005U\u00064\u0018-\u0003\u0002}o\n\u00012+\u001e9qe\u0016\u001c8oV1s]&twm]\u0001\u0006m\u0006dW/\u001a\u0017\u0002\u007f\u0006\u0012\u0011\u0011A\u0001\u000e\u001dVdG\u000eU1sC6,G/\u001a:\u0002\u0017\rD\u0017M\u001c8fYJ+\u0017\r\u001a\u000b\u00069\u0006\u001d\u0011\u0011\u0002\u0005\u0006K.\u0001\rA\u001a\u0005\u0007\u0003\u0017Y\u0001\u0019\u00018\u0002\u00075\u001cx-A\u0003xe&$X\rF\u0004]\u0003#\t\u0019\"!\u0006\t\u000b\u0015d\u0001\u0019\u00014\t\r\u0005-A\u00021\u0001o\u0011\u001d\t9\u0002\u0004a\u0001\u00033\tq\u0001\u001d:p[&\u001cX\rE\u0002!\u00037I1!!\b\"\u00059\u0019\u0005.\u00198oK2\u0004&o\\7jg\u0016\fq\"\u001a=dKB$\u0018n\u001c8DCV<\u0007\u000e\u001e\u000b\u00069\u0006\r\u0012Q\u0005\u0005\u0006K6\u0001\rA\u001a\u0005\b\u0003Oi\u0001\u0019AA\u0015\u0003\u0015\u0019\u0017-^:f!\u0011\tY#a\r\u000f\t\u00055\u0012\u0011\u0007\b\u0004]\u0005=\u0012\"\u0001\u001a\n\u0005\u0019\u000b\u0014\u0002BA\u001b\u0003o\u0011\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0005\u0019\u000b\u0014\u0001\u00045b]\u0012dWM]!eI\u0016$Gc\u0001/\u0002>!)QM\u0004a\u0001M\u0006!q/\u0019:o)\u0015a\u00161IA#\u0011\u0015)w\u00021\u0001g\u0011\u0019\t9e\u0004a\u0001W\u0005\t1\u000fK\u0002\u0010\u0003\u0017\u00022aVA'\u0013\r\ty%\r\u0002\u0007S:d\u0017N\\3\u0002\u00071|w\rF\u0003]\u0003+\n9\u0006C\u0003f!\u0001\u0007a\r\u0003\u0004\u0002HA\u0001\ra\u000b\u0015\u0004!\u0005-Cc\u0002/\u0002^\u0005}\u0013\u0011\r\u0005\u0006KF\u0001\rA\u001a\u0005\u0007\u0003\u000f\n\u0002\u0019A\u0016\t\u000f\u0005\u001d\u0012\u00031\u0001\u0002*!\u001a\u0011#a\u0013\u0002\u00195{gnZ8IC:$G.\u001a:\u0011\u00059\u001b2cA\n\u0002lA\u0019q+!\u001c\n\u0007\u0005=\u0014G\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003O\na\u0001\\8hO\u0016\u0014XCAA<!\u0011\tI(a\"\u000f\t\u0005m\u0014\u0011\u0011\b\u0004}\u0005u\u0014bAA@9\u0005!Q\u000f^5m\u0013\u0011\t\u0019)!\"\u0002\u00151\u000b'0\u001f'pO\u001e,'OC\u0002\u0002\u0000qIA!!#\u0002\f\nQA*\u0019>z\u0019><w-\u001a:\u000b\t\u0005\r\u0015QQ\u0001\bY><w-\u001a:!\u0001")
public class MongoHandler
extends ChannelDuplexHandler {
    public final String reactivemongo$core$protocol$MongoHandler$$supervisor;
    public final String reactivemongo$core$protocol$MongoHandler$$connection;
    private final ActorRef receiver;
    private long last;

    public static LazyLogger.LazyLogger logger() {
        return MongoHandler$.MODULE$.logger();
    }

    private long last() {
        return this.last;
    }

    private void last_$eq(long x$1) {
        this.last = x$1;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.log(ctx, "Channel is active");
        this.last_$eq(System.nanoTime());
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.receiver);
        ChannelConnected x$1 = new ChannelConnected(ctx.channel().id());
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
        super.channelActive(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        Object object = evt;
        if (object instanceof IdleStateEvent) {
            if (this.last() != -1L) {
                long now = System.nanoTime();
                this.log(ctx, new StringBuilder(40).append("Channel has been inactive for ").append(now - this.last()).append(" (last = ").append(this.last()).append(")").toString());
            }
            ctx.channel().close();
        }
        super.userEventTriggered(ctx, evt);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        long now = System.nanoTime();
        if (this.last() != -1L) {
            Channel chan = ctx.channel();
            long delay = now - this.last();
            if (delay < 500000000L) {
                this.warn(ctx, new StringBuilder(62).append(MongoHandler.msg$1(delay, chan)).append("; Please check network connectivity and the status of the set.").toString());
            } else if (chan.remoteAddress() != null) {
                this.log(ctx, MongoHandler.msg$1(delay, chan));
            }
            this.last_$eq(now);
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.receiver);
            ChannelDisconnected x$1 = new ChannelDisconnected(chan.id());
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
        }
        super.channelInactive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.last_$eq(System.nanoTime());
        Object object = msg;
        if (object instanceof Response) {
            Response response = (Response)object;
            this.log(ctx, new StringBuilder(43).append("Channel received message ").append(response).append("; Will be send to ").append(this.receiver.path()).toString());
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.receiver);
            Response x$1 = response;
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
            return;
        }
        this.log(ctx, new StringBuilder(20).append("Unexpected message: ").append(msg).toString());
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        this.log(ctx, "Channel is requested to write");
        this.last_$eq(System.nanoTime());
        super.write(ctx, msg, promise);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.log(ctx, new StringBuilder(18).append("Error on channel #").append(ctx.channel().id()).toString(), cause);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (ctx.channel().isActive()) {
            this.channelActive(ctx);
        }
        super.handlerAdded(ctx);
    }

    public void warn(ChannelHandlerContext ctx, String s) {
        MongoHandler$.MODULE$.logger().warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(15).append("[").append($this.reactivemongo$core$protocol$MongoHandler$$supervisor).append("/").append($this.reactivemongo$core$protocol$MongoHandler$$connection).append("] ").append(s).append(" (channel ").append(ctx.channel()).append(")").toString());
    }

    public void log(ChannelHandlerContext ctx, String s) {
        MongoHandler$.MODULE$.logger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(15).append("[").append($this.reactivemongo$core$protocol$MongoHandler$$supervisor).append("/").append($this.reactivemongo$core$protocol$MongoHandler$$connection).append("] ").append(s).append(" (channel ").append(ctx.channel()).append(")").toString());
    }

    public void log(ChannelHandlerContext ctx, String s, Throwable cause) {
        MongoHandler$.MODULE$.logger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(15).append("[").append($this.reactivemongo$core$protocol$MongoHandler$$supervisor).append("/").append($this.reactivemongo$core$protocol$MongoHandler$$connection).append("] ").append(s).append(" (channel ").append(ctx.channel()).append(")").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> cause);
    }

    private static final String msg$1(long delay$1, Channel chan$1) {
        return new StringBuilder(28).append("Channel is closed under ").append(delay$1).append("ns: ").append(chan$1.remoteAddress()).toString();
    }

    public MongoHandler(String supervisor, String connection, ActorRef receiver) {
        this.reactivemongo$core$protocol$MongoHandler$$supervisor = supervisor;
        this.reactivemongo$core$protocol$MongoHandler$$connection = connection;
        this.receiver = receiver;
        this.last = -1L;
    }
}

