/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.core.protocol;

import com.github.luben.zstd.Zstd;
import java.io.Serializable;
import org.xerial.snappy.Snappy;
import reactivemongo.api.Compressor;
import reactivemongo.api.ReadPreference;
import reactivemongo.api.ReadPreference$;
import reactivemongo.core.protocol.CompressedOp;
import reactivemongo.core.protocol.CompressedOp$;
import reactivemongo.core.protocol.Request;
import reactivemongo.core.protocol.RequestOp;
import reactivemongo.core.protocol.buffer.Snappy$;
import reactivemongo.core.protocol.buffer.Zlib$;
import reactivemongo.core.protocol.buffer.Zstd$;
import reactivemongo.io.netty.buffer.ByteBuf;
import reactivemongo.io.netty.buffer.Unpooled;
import reactivemongo.io.netty.channel.ChannelId;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class Request$ {
    public static final Request$ MODULE$ = new Request$();

    private ReadPreference $lessinit$greater$default$6() {
        return ReadPreference$.MODULE$.primary();
    }

    private Option<ChannelId> $lessinit$greater$default$7() {
        return None$.MODULE$;
    }

    public Request apply(String kind, int requestID, int responseTo, RequestOp op, ByteBuf documents, ReadPreference readPreference, Option<ChannelId> channelIdHint, Seq<StackTraceElement> callerSTE) {
        Request request;
        try {
            request = new Request(kind, requestID, responseTo, op, documents, readPreference, channelIdHint);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                StackTraceElement[] trace = throwable2.getStackTrace();
                ArrayBuilder callerTrace = (ArrayBuilder)Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(StackTraceElement.class)).$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])trace));
                Object object = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])trace)) ? callerTrace.$plus$eq((Object)new StackTraceElement("---", "---", "---", -1)) : BoxedUnit.UNIT;
                callerTrace.$plus$plus$eq(callerSTE);
                throwable2.setStackTrace((StackTraceElement[])callerTrace.result());
                throw throwable2;
            }
            throw throwable;
        }
        return request;
    }

    public Request apply(String kind, int requestID, int responseTo, RequestOp op, byte[] documents) {
        return new Request(kind, requestID, responseTo, op, Unpooled.wrappedBuffer((byte[])documents), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7());
    }

    public Request apply(String kind, int requestID, RequestOp op, byte[] documents) {
        return this.apply(kind, requestID, 0, op, documents);
    }

    public Request apply(String kind, int requestID, RequestOp op) {
        return this.apply(kind, requestID, op, new byte[0]);
    }

    public ReadPreference apply$default$6() {
        return ReadPreference$.MODULE$.primary();
    }

    public Option<ChannelId> apply$default$7() {
        return None$.MODULE$;
    }

    public Seq<StackTraceElement> apply$default$8() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Try<Request> compress(Request req, Compressor compressor, Function1<Object, ByteBuf> allocDirect) {
        Option option;
        Try try_;
        if (req.op().code() == CompressedOp$.MODULE$.code()) {
            return new Success((Object)req);
        }
        int uncompressedSize = req.size() - 16;
        Compressor compressor2 = compressor;
        if (Compressor.Snappy$.MODULE$.equals(compressor2)) {
            try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                int bufSize = Snappy.maxCompressedLength((int)uncompressedSize);
                return (ByteBuf)allocDirect.apply((Object)BoxesRunTime.boxToInteger((int)bufSize));
            }).flatMap((Function1 & Serializable)out -> (Try)Request$.withData$1((Function1 & Serializable)x$1 -> Snappy$.MODULE$.apply().encode(x$1, out).map((Function1 & Serializable)x$2 -> out), allocDirect, uncompressedSize, req));
        } else if (Compressor.Zstd$.MODULE$.equals(compressor2)) {
            try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                int bufSize = (int)Zstd.compressBound((long)uncompressedSize);
                return (ByteBuf)allocDirect.apply((Object)BoxesRunTime.boxToInteger((int)bufSize));
            }).flatMap((Function1 & Serializable)out -> (Try)Request$.withData$1((Function1 & Serializable)x$3 -> Zstd$.MODULE$.apply(Zstd$.MODULE$.apply$default$1(), Zstd$.MODULE$.apply$default$2(), Zstd$.MODULE$.apply$default$3()).encode(x$3, out).map((Function1 & Serializable)x$4 -> out), allocDirect, uncompressedSize, req));
        } else if (compressor2 != null && !(option = Compressor.Zlib$.MODULE$.unapply(compressor2)).isEmpty()) {
            int level = BoxesRunTime.unboxToInt((Object)option.get());
            try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                int bufSize = (int)((double)uncompressedSize * 1.2);
                return (ByteBuf)allocDirect.apply((Object)BoxesRunTime.boxToInteger((int)bufSize));
            }).flatMap((Function1 & Serializable)out -> (Try)Request$.withData$1((Function1 & Serializable)x$5 -> Zlib$.MODULE$.apply(level).encode(x$5, out).map((Function1 & Serializable)x$6 -> out), allocDirect, uncompressedSize, req));
        } else {
            try_ = new Success((Object)req.payload());
        }
        Try compressed = try_;
        return compressed.map((Function1 & Serializable)payload -> new Request(req.kind(), req.requestID(), req.responseTo(), (RequestOp)new CompressedOp(req.op().expectsResponse(), req.op().requiresPrimary(), req.op().code(), uncompressedSize, compressor.id()), (ByteBuf)payload, req.readPreference(), req.channelIdHint()));
    }

    private static final Object withData$1(Function1 f, Function1 allocDirect$1, int uncompressedSize$1, Request req$1) {
        Object object;
        ByteBuf buf = null;
        try {
            try {
                buf = (ByteBuf)allocDirect$1.apply((Object)BoxesRunTime.boxToInteger((int)uncompressedSize$1));
                req$1.op().writeTo().apply((Object)buf);
                buf.writeBytes(req$1.payload());
                object = f.apply((Object)buf);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    throw throwable2;
                }
                throw throwable;
            }
        }
        finally {
            if (buf != null) {
                buf.release();
            }
        }
        return object;
    }

    private Request$() {
    }
}

