/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.Props$;
import akka.actor.SupervisorStrategy;
import akka.actor.Terminated;
import akka.annotation.InternalApi;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import reactivemongo.api.AsyncDriver$;
import reactivemongo.api.AsyncDriver$AddConnection$;
import reactivemongo.api.AsyncDriver$SupervisorActor$;
import reactivemongo.api.AuthenticationMode;
import reactivemongo.api.FailoverStrategy;
import reactivemongo.api.MongoConnection;
import reactivemongo.api.MongoConnection$;
import reactivemongo.api.MongoConnectionOptions;
import reactivemongo.api.MongoConnectionOptions$;
import reactivemongo.api.ReadConcern;
import reactivemongo.api.ReadPreference;
import reactivemongo.api.ScramSha256Authentication$;
import reactivemongo.api.WriteConcern;
import reactivemongo.api.X509Authentication$;
import reactivemongo.core.AsyncSystemControl;
import reactivemongo.core.SystemControl;
import reactivemongo.core.SystemControl$;
import reactivemongo.core.TimedSystemControl;
import reactivemongo.core.actors.Close;
import reactivemongo.core.actors.Close$;
import reactivemongo.core.actors.Closed$;
import reactivemongo.core.actors.Exceptions;
import reactivemongo.core.actors.MongoDBSystem;
import reactivemongo.core.actors.StandardDBSystem;
import reactivemongo.core.actors.StandardDBSystemWithScramSha256;
import reactivemongo.core.actors.StandardDBSystemWithX509;
import reactivemongo.core.errors.ConnectionException;
import reactivemongo.core.nodeset.Authenticate;
import reactivemongo.util.package$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\r\rh\u0001\u0002+V\u0005iC\u0001\"\u0019\u0001\u0003\u0006\u0004%\tB\u0019\u0005\t_\u0002\u0011\t\u0011)A\u0005G\"A\u0001\u000f\u0001BC\u0002\u0013E\u0011\u000f\u0003\u0005|\u0001\t\u0005\t\u0015!\u0003s\u0011\u0015a\b\u0001\"\u0001~\u0011)\t)\u0001\u0001b\u0001\n\u00039\u0016q\u0001\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\n!A\u00111\u0004\u0001\u0005\u0002]\u000bi\u0002C\u0004\u0002&\u0001!\t!a\n\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002h!9\u0011Q\u0005\u0001\u0005\u0002\u0005U\u0004bBA\u0013\u0001\u0011\u0005\u0011q\u0010\u0005\b\u0003K\u0001A\u0011AAC\u0011\u001d\t)\u0003\u0001C\u0001\u0003\u001bCq!!\n\u0001\t\u0003\tY\fC\u0004\u0002&\u0001!\t!a5\t\u0013\u0005}\u0007\u00011A\u0005\n\u0005\u0005\b\"CAx\u0001\u0001\u0007I\u0011BAy\u0011!\ti\u0010\u0001Q!\n\u0005\r\bbBA\u0000\u0001\u0011\u0005!\u0011\u0001\u0005\n\u0005C\u0001\u0011\u0013!C\u0001\u0005GA\u0011B!\u000f\u0001\u0005\u0004%IAa\u000f\t\u0011\t\u0015\u0003\u0001)A\u0005\u0005{A\u0011Ba\u0012\u0001\u0005\u0004%)B!\u0013\t\u0011\t-\u0003\u0001)A\u0007\u0003/B!B!\u0014\u0001\u0005\u0004%)a\u0016B(\u0011!\u00119\u0006\u0001Q\u0001\u000e\tE\u0003\"\u0003B-\u0001\t\u0007IQ\u0003B.\u0011!\u0011i\u0007\u0001Q\u0001\u000e\tu\u0003\"\u0003B8\u0001\t\u0007I\u0011\u0002B9\u0011!\u0011)\t\u0001Q\u0001\n\tM\u0004b\u0002BD\u0001\u0011E!\u0011\u0012\u0004\u0007\u0005#\u0003AIa%\t\u0015\u0005u\u0014E!f\u0001\n\u0003\u0011I\u0005\u0003\u0006\u0003\"\u0006\u0012\t\u0012)A\u0005\u0003/B!\"!\u0010\"\u0005+\u0007I\u0011\u0001BR\u0011)\u0011)+\tB\tB\u0003%\u0011q\b\u0005\u000b\u0003[\n#Q3A\u0005\u0002\t\u001d\u0006B\u0003BUC\tE\t\u0015!\u0003\u0002p!Q!1V\u0011\u0003\u0016\u0004%\tAa\u0014\t\u0015\t5\u0016E!E!\u0002\u0013\u0011\t\u0006\u0003\u0004}C\u0011\u0005!q\u0016\u0005\n\u0005{\u000b\u0013\u0011!C\u0001\u0005\u007fC\u0011B!3\"#\u0003%\tAa3\t\u0013\t=\u0017%%A\u0005\u0002\tE\u0007\"\u0003BkCE\u0005I\u0011\u0001Bl\u0011%\u0011Y.II\u0001\n\u0003\u0011i\u000eC\u0005\u0003b\u0006\n\t\u0011\"\u0011\u0003d\"I!\u0011^\u0011\u0002\u0002\u0013\u0005\u0011Q\u0004\u0005\n\u0005W\f\u0013\u0011!C\u0001\u0005[D\u0011B!=\"\u0003\u0003%\tEa=\t\u0013\tu\u0018%!A\u0005\u0002\t}\b\"CB\u0002C\u0005\u0005I\u0011IB\u0003\u0011%\u0019I!IA\u0001\n\u0003\u001aY\u0001C\u0005\u0004\u000e\u0005\n\t\u0011\"\u0011\u0004\u0010!I1\u0011C\u0011\u0002\u0002\u0013\u000531C\u0004\n\u0007/\u0001\u0011\u0011!E\u0005\u000731\u0011B!%\u0001\u0003\u0003EIaa\u0007\t\rqTD\u0011AB\u001a\u0011%\u0019iAOA\u0001\n\u000b\u001ay\u0001C\u0005\u00046i\n\t\u0011\"!\u00048!I1\u0011\t\u001e\u0002\u0002\u0013\u000551\t\u0005\t\u0007#\u0002A\u0011A+\u0004T\u001911Q\u000e\u0001\u0007\u0007_BQba\u001eA\t\u0003\u0005)Q!A!\u0002\u0013q\bB\u0002?A\t\u0003\u0019I\bC\u0004\u0004\u0002\u0002#\taa!\t\u0013\r5\u0005I1A\u0005\u0002\r=\u0005\u0002CBM\u0001\u0002\u0006Ia!%\t\u000f\rm\u0005\t\"\u0001\u0004\u0010\"91Q\u0014!\u0005B\r}uaBBQ+\"\u000511\u0015\u0004\u0007)VC\ta!*\t\rqLE\u0011ABT\u0011\u001d\u0019)$\u0013C\u0001\u0007SCqa!\u000eJ\t\u0003\u0019Y\u000bC\u0004\u00046%#\taa,\t\u0013\rU\u0016J1A\u0005\n\r]\u0006\u0002CBi\u0013\u0002\u0006Ia!/\t\u0015\rM\u0017J1A\u0005\u0002U\u0013\t\b\u0003\u0005\u0004V&\u0003\u000b\u0011\u0002B:\u0011%\u00199.SI\u0001\n\u0003\u0019I\u000eC\u0005\u0004^&\u000b\n\u0011\"\u0001\u0004`\nY\u0011i]=oG\u0012\u0013\u0018N^3s\u0015\t1v+A\u0002ba&T\u0011\u0001W\u0001\u000ee\u0016\f7\r^5wK6|gnZ8\u0004\u0001M\u0011\u0001a\u0017\t\u00039~k\u0011!\u0018\u0006\u0002=\u0006)1oY1mC&\u0011\u0001-\u0018\u0002\u0007\u0003:L(+\u001a4\u0002\r\r|gNZ5h+\u0005\u0019\u0007c\u0001/eM&\u0011Q-\u0018\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u001dlW\"\u00015\u000b\u0005\u0005L'B\u00016l\u0003!!\u0018\u0010]3tC\u001a,'\"\u00017\u0002\u0007\r|W.\u0003\u0002oQ\n11i\u001c8gS\u001e\fqaY8oM&<\u0007%A\u0006dY\u0006\u001c8\u000fT8bI\u0016\u0014X#\u0001:\u0011\u0007q#7\u000f\u0005\u0002us6\tQO\u0003\u0002wo\u0006!A.\u00198h\u0015\u0005A\u0018\u0001\u00026bm\u0006L!A_;\u0003\u0017\rc\u0017m]:M_\u0006$WM]\u0001\rG2\f7o\u001d'pC\u0012,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000by\f\t!a\u0001\u0011\u0005}\u0004Q\"A+\t\u000f\u0005,\u0001\u0013!a\u0001G\"9\u0001/\u0002I\u0001\u0002\u0004\u0011\u0018AB:zgR,W.\u0006\u0002\u0002\nA!\u00111BA\u000b\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011!B1di>\u0014(BAA\n\u0003\u0011\t7n[1\n\t\u0005]\u0011Q\u0002\u0002\f\u0003\u000e$xN]*zgR,W.A\u0004tsN$X-\u001c\u0011\u0002\u001d9,XnQ8o]\u0016\u001cG/[8ogV\u0011\u0011q\u0004\t\u00049\u0006\u0005\u0012bAA\u0012;\n\u0019\u0011J\u001c;\u0002\u000f\r|gN\\3diR!\u0011\u0011FA\u001e!\u0019\tY#!\r\u000265\u0011\u0011Q\u0006\u0006\u0004\u0003_i\u0016AC2p]\u000e,(O]3oi&!\u00111GA\u0017\u0005\u00191U\u000f^;sKB\u0019q0a\u000e\n\u0007\u0005eRKA\bN_:<wnQ8o]\u0016\u001cG/[8o\u0011\u001d\ti$\u0003a\u0001\u0003\u007f\tQA\\8eKN\u0004b!!\u0011\u0002R\u0005]c\u0002BA\"\u0003\u001brA!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0004\u0003\u0013J\u0016A\u0002\u001fs_>$h(C\u0001_\u0013\r\ty%X\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019&!\u0016\u0003\u0007M+\u0017OC\u0002\u0002Pu\u0003B!!\u0017\u0002b9!\u00111LA/!\r\t)%X\u0005\u0004\u0003?j\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002d\u0005\u0015$AB*ue&twMC\u0002\u0002`u#b!!\u000b\u0002j\u0005-\u0004bBA\u001f\u0015\u0001\u0007\u0011q\b\u0005\b\u0003[R\u0001\u0019AA8\u0003\u001dy\u0007\u000f^5p]N\u00042a`A9\u0013\r\t\u0019(\u0016\u0002\u0017\u001b>twm\\\"p]:,7\r^5p]>\u0003H/[8ogRA\u0011\u0011FA<\u0003s\nY\bC\u0004\u0002>-\u0001\r!a\u0010\t\u000f\u000554\u00021\u0001\u0002p!9\u0011QP\u0006A\u0002\u0005]\u0013\u0001\u00028b[\u0016$B!!\u000b\u0002\u0002\"9\u00111\u0011\u0007A\u0002\u0005]\u0013!C;sSN#(/[2u)\u0019\tI#a\"\u0002\n\"9\u00111Q\u0007A\u0002\u0005]\u0003bBA?\u001b\u0001\u0007\u00111\u0012\t\u00059\u0012\f9&\u0006\u0003\u0002\u0010\u0006\u001dFCBA\u0015\u0003#\u000bI\fC\u0004\u0002\u0014:\u0001\r!!&\u0002\u0013A\f'o]3e+JK\u0005CBAL\u0003;\u000b\u0019KD\u0002\u0000\u00033K1!a'V\u0003=iuN\\4p\u0007>tg.Z2uS>t\u0017\u0002BAP\u0003C\u00131!\u0016*J\u0015\r\tY*\u0016\t\u0005\u0003K\u000b9\u000b\u0004\u0001\u0005\u000f\u0005%fB1\u0001\u0002,\n\tA+\u0005\u0003\u0002.\u0006M\u0006c\u0001/\u00020&\u0019\u0011\u0011W/\u0003\u000f9{G\u000f[5oOB\u0019A,!.\n\u0007\u0005]VLA\u0002B]fDq!! \u000f\u0001\u0004\tY)\u0006\u0003\u0002>\u0006\u0015G\u0003CA\u0015\u0003\u007f\u000b9-!3\t\u000f\u0005Mu\u00021\u0001\u0002BB1\u0011qSAO\u0003\u0007\u0004B!!*\u0002F\u00129\u0011\u0011V\bC\u0002\u0005-\u0006bBA?\u001f\u0001\u0007\u00111\u0012\u0005\b\u0003\u0017|\u0001\u0019AAg\u0003)\u0019HO]5di6{G-\u001a\t\u00049\u0006=\u0017bAAi;\n9!i\\8mK\u0006tW\u0003BAk\u0003;$B!!\u000b\u0002X\"9\u00111\u0013\tA\u0002\u0005e\u0007CBAL\u0003;\u000bY\u000e\u0005\u0003\u0002&\u0006uGaBAU!\t\u0007\u00111V\u0001\tG2|7/\u001a3CsV\u0011\u00111\u001d\t\u00069\u0006\u0015\u0018\u0011^\u0005\u0004\u0003Ol&!B!se\u0006L\bc\u0001;\u0002l&\u0019\u0011Q^;\u0003#M#\u0018mY6Ue\u0006\u001cW-\u00127f[\u0016tG/\u0001\u0007dY>\u001cX\r\u001a\"z?\u0012*\u0017\u000f\u0006\u0003\u0002t\u0006e\bc\u0001/\u0002v&\u0019\u0011q_/\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003w\u0014\u0012\u0011!a\u0001\u0003G\f1\u0001\u001f\u00132\u0003%\u0019Gn\\:fI\nK\b%A\u0003dY>\u001cX\r\u0006\u0003\u0003\u0004\tEA\u0003\u0002B\u0003\u0005\u000f\u0001b!a\u000b\u00022\u0005M\bb\u0002B\u0005)\u0001\u000f!1B\u0001\u0003K\u000e\u0004B!a\u000b\u0003\u000e%!!qBA\u0017\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0005\u0003\u0014Q\u0001\n\u00111\u0001\u0003\u0016\u00059A/[7f_V$\b\u0003\u0002B\f\u0005;i!A!\u0007\u000b\t\tm\u0011QF\u0001\tIV\u0014\u0018\r^5p]&!!q\u0004B\r\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\fqb\u00197pg\u0016$C-\u001a4bk2$H%M\u000b\u0003\u0005KQCA!\u0006\u0003(-\u0012!\u0011\u0006\t\u0005\u0005W\u0011)$\u0004\u0002\u0003.)!!q\u0006B\u0019\u0003%)hn\u00195fG.,GMC\u0002\u00034u\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u00119D!\f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0006tsN$X-\\\"m_N,WC\u0001B\u001f!\u001da&q\bB\"\u0005\u000bI1A!\u0011^\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003]I\nU\u0011\u0001D:zgR,Wn\u00117pg\u0016\u0004\u0013AD:va\u0016\u0014h/[:pe:\u000bW.Z\u000b\u0003\u0003/\nqb];qKJ4\u0018n]8s\u001d\u0006lW\rI\u0001\u0010gV\u0004XM\u001d<jg>\u0014\u0018i\u0019;peV\u0011!\u0011\u000b\t\u0005\u0003\u0017\u0011\u0019&\u0003\u0003\u0003V\u00055!\u0001C!di>\u0014(+\u001a4\u0002!M,\b/\u001a:wSN|'/Q2u_J\u0004\u0013AE2p]:,7\r^5p]6{g.\u001b;peN,\"A!\u0018\u0011\u0011\t}#\u0011\u000eB)\u0003ki!A!\u0019\u000b\t\t\r$QM\u0001\b[V$\u0018M\u00197f\u0015\r\u00119'X\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B6\u0005C\u00121!T1q\u0003M\u0019wN\u001c8fGRLwN\\'p]&$xN]:!\u0003E\u0019wN\u001c8fGRLwN\\\"pk:$XM]\u000b\u0003\u0005g\u0002BA!\u001e\u0003\u00026\u0011!q\u000f\u0006\u0005\u0005s\u0012Y(\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003_\u0011iHC\u0002\u0003\u0000]\fA!\u001e;jY&!!1\u0011B<\u0005)\tEo\\7jG2{gnZ\u0001\u0013G>tg.Z2uS>t7i\\;oi\u0016\u0014\b%A\u0007bg.\u001cuN\u001c8fGRLwN\u001c\u000b\t\u0003S\u0011YI!$\u0003\u0010\"9\u0011Q\b\u0011A\u0002\u0005}\u0002bBA7A\u0001\u0007\u0011q\u000e\u0005\b\u0003{\u0002\u0003\u0019AAF\u00055\tE\rZ\"p]:,7\r^5p]N1\u0011e\u0017BK\u00057\u00032\u0001\u0018BL\u0013\r\u0011I*\u0018\u0002\b!J|G-^2u!\u0011\t\tE!(\n\t\t}\u0015Q\u000b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006]\u0006lW\rI\u000b\u0003\u0003\u007f\taA\\8eKN\u0004SCAA8\u0003!y\u0007\u000f^5p]N\u0004\u0013aC7p]\u001e|7/_:uK6\fA\"\\8oO>\u001c\u0018p\u001d;f[\u0002\"\"B!-\u00036\n]&\u0011\u0018B^!\r\u0011\u0019,I\u0007\u0002\u0001!9\u0011Q\u0010\u0016A\u0002\u0005]\u0003bBA\u001fU\u0001\u0007\u0011q\b\u0005\b\u0003[R\u0003\u0019AA8\u0011\u001d\u0011YK\u000ba\u0001\u0005#\nAaY8qsRQ!\u0011\u0017Ba\u0005\u0007\u0014)Ma2\t\u0013\u0005u4\u0006%AA\u0002\u0005]\u0003\"CA\u001fWA\u0005\t\u0019AA \u0011%\tig\u000bI\u0001\u0002\u0004\ty\u0007C\u0005\u0003,.\u0002\n\u00111\u0001\u0003R\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BgU\u0011\t9Fa\n\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u001b\u0016\u0005\u0003\u007f\u00119#\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\te'\u0006BA8\u0005O\tabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0003`*\"!\u0011\u000bB\u0014\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!Q\u001d\t\u0004i\n\u001d\u0018bAA2k\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAZ\u0005_D\u0011\"a?3\u0003\u0003\u0005\r!a\b\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!>\u0011\r\t](\u0011`AZ\u001b\t\u0011)'\u0003\u0003\u0003|\n\u0015$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!4\u0004\u0002!I\u00111 \u001b\u0002\u0002\u0003\u0007\u00111W\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003f\u000e\u001d\u0001\"CA~k\u0005\u0005\t\u0019AA\u0010\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0010\u0003!!xn\u0015;sS:<GC\u0001Bs\u0003\u0019)\u0017/^1mgR!\u0011QZB\u000b\u0011%\tY\u0010OA\u0001\u0002\u0004\t\u0019,A\u0007BI\u0012\u001cuN\u001c8fGRLwN\u001c\t\u0004\u0005gS4#\u0002\u001e\u0004\u001e\r%\u0002CDB\u0010\u0007K\t9&a\u0010\u0002p\tE#\u0011W\u0007\u0003\u0007CQ1aa\t^\u0003\u001d\u0011XO\u001c;j[\u0016LAaa\n\u0004\"\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0011\t\r-2\u0011G\u0007\u0003\u0007[Q1aa\fx\u0003\tIw.\u0003\u0003\u0003 \u000e5BCAB\r\u0003\u0015\t\u0007\u000f\u001d7z))\u0011\tl!\u000f\u0004<\ru2q\b\u0005\b\u0003{j\u0004\u0019AA,\u0011\u001d\ti$\u0010a\u0001\u0003\u007fAq!!\u001c>\u0001\u0004\ty\u0007C\u0004\u0003,v\u0002\rA!\u0015\u0002\u000fUt\u0017\r\u001d9msR!1QIB'!\u0011aFma\u0012\u0011\u0017q\u001bI%a\u0016\u0002@\u0005=$\u0011K\u0005\u0004\u0007\u0017j&A\u0002+va2,G\u0007C\u0005\u0004Py\n\t\u00111\u0001\u00032\u0006\u0019\u0001\u0010\n\u0019\u0002!\u0005$GmQ8o]\u0016\u001cG/[8o\u001bN<GCCAZ\u0007+\u001a9f!\u0017\u0004\\!9\u0011QP A\u0002\u0005]\u0003bBA\u001f\u007f\u0001\u0007\u0011q\b\u0005\b\u0003[z\u0004\u0019AA8\u0011\u001d\u0011Yk\u0010a\u0001\u0005#BsaPB0\u0007K\u001a9\u0007E\u0002u\u0007CJ1aa\u0019v\u0005A\u0019V\u000f\u001d9sKN\u001cx+\u0019:oS:<7/A\u0003wC2,X\r\f\u0002\u0004j\u0005\u001211N\u0001\u0013\u001b\u0016$\bn\u001c3SKR,(O\\5oO\u0006s\u0017PA\bTkB,'O^5t_J\f5\r^8s'\u0011\u00015l!\u001d\u0011\t\u0005-11O\u0005\u0005\u0007k\niAA\u0003BGR|'/A\u001bsK\u0006\u001cG/\u001b<f[>twm\u001c\u0013ba&$\u0013i]=oG\u0012\u0013\u0018N^3sIM+\b/\u001a:wSN|'/Q2u_J$C\u0005\u001a:jm\u0016\u0014H\u0003BB>\u0007{\u00022Aa-A\u0011\u0019\u0019yH\u0011a\u0001}\u00061AM]5wKJ\fq![:F[B$\u00180\u0006\u0002\u0002N\"\u001a1ia\"\u0011\u0007q\u001bI)C\u0002\u0004\fv\u0013a!\u001b8mS:,\u0017a\u0002:fG\u0016Lg/Z\u000b\u0003\u0007#\u0003Baa%\u0004\u00166\t\u0001)\u0003\u0003\u0004\u0018\u000eM$a\u0002*fG\u0016Lg/Z\u0001\te\u0016\u001cW-\u001b<fA\u000591\r\\8tS:<\u0017\u0001\u00039pgR\u001cFo\u001c9\u0015\u0005\u0005M\u0018aC!ts:\u001cGI]5wKJ\u0004\"a`%\u0014\u0005%[FCABR)\u0005qHc\u0001@\u0004.\")\u0011\r\u0014a\u0001MR)ap!-\u00044\")\u0011-\u0014a\u0001M\")\u0001/\u0014a\u0001g\u00061An\\4hKJ,\"a!/\u0011\t\rm61\u001a\b\u0005\u0007{\u001b)M\u0004\u0003\u0004@\u000e\rg\u0002BA#\u0007\u0003L\u0011\u0001W\u0005\u0004\u0005\u007f:\u0016\u0002BBd\u0007\u0013\f!\u0002T1{s2{wmZ3s\u0015\r\u0011yhV\u0005\u0005\u0007\u001b\u001cyM\u0001\u0006MCjLHj\\4hKJTAaa2\u0004J\u00069An\\4hKJ\u0004\u0013aB2pk:$XM]\u0001\tG>,h\u000e^3sA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\"aa7+\u0007\r\u00149#A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0007CT3A\u001dB\u0014\u0001")
public final class AsyncDriver {
    private volatile AsyncDriver$AddConnection$ AddConnection$module;
    private final Option<Config> config;
    private final Option<ClassLoader> classLoader;
    private final ActorSystem system;
    private StackTraceElement[] closedBy;
    private final Function1<Option<FiniteDuration>, Future<BoxedUnit>> systemClose;
    private final String supervisorName;
    private final ActorRef supervisorActor;
    private final Map<ActorRef, MongoConnection> connectionMonitors;
    private final AtomicLong connectionCounter;

    public static Option<ClassLoader> $lessinit$greater$default$2() {
        return AsyncDriver$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Config> $lessinit$greater$default$1() {
        return AsyncDriver$.MODULE$.$lessinit$greater$default$1();
    }

    public static AsyncDriver apply(Config config, ClassLoader classLoader) {
        return AsyncDriver$.MODULE$.apply(config, classLoader);
    }

    public static AsyncDriver apply(Config config) {
        return AsyncDriver$.MODULE$.apply(config);
    }

    public static AsyncDriver apply() {
        return AsyncDriver$.MODULE$.apply();
    }

    private AsyncDriver$AddConnection$ AddConnection() {
        if (this.AddConnection$module == null) {
            this.AddConnection$lzycompute$1();
        }
        return this.AddConnection$module;
    }

    public Option<Config> config() {
        return this.config;
    }

    public Option<ClassLoader> classLoader() {
        return this.classLoader;
    }

    public ActorSystem system() {
        return this.system;
    }

    public int numConnections() {
        return this.connectionMonitors().size();
    }

    public Future<MongoConnection> connect(Seq<String> nodes) {
        return this.askConnection(nodes, MongoConnectionOptions$.MODULE$.default(), (Option<String>)Option$.MODULE$.empty());
    }

    public Future<MongoConnection> connect(Seq<String> nodes, MongoConnectionOptions options) {
        return this.askConnection(nodes, options, (Option<String>)Option$.MODULE$.empty());
    }

    public Future<MongoConnection> connect(Seq<String> nodes, MongoConnectionOptions options, String name) {
        return this.askConnection(nodes, options, (Option<String>)new Some((Object)name));
    }

    public Future<MongoConnection> connect(String uriStrict) {
        return this.connect(uriStrict, (Option<String>)None$.MODULE$);
    }

    public Future<MongoConnection> connect(String uriStrict, Option<String> name) {
        return MongoConnection$.MODULE$.fromString(uriStrict, AsyncDriver.ec$1()).flatMap((Function1 & Serializable)x$1 -> this.connect((MongoConnection.URI)x$1, name), AsyncDriver.ec$1());
    }

    public <T> Future<MongoConnection> connect(MongoConnection.URI<T> parsedURI, Option<String> name) {
        return this.connect(parsedURI, name, true);
    }

    public <T> Future<MongoConnection> connect(MongoConnection.URI<T> parsedURI, Option<String> name, boolean strictMode) {
        Future<MongoConnection> future;
        if (strictMode && parsedURI.ignoredOptions().nonEmpty()) {
            future = Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(49).append("The connection URI contains unsupported options: ").append(parsedURI.ignoredOptions().mkString(", ")).toString()));
        } else {
            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$1 = parsedURI.options().credentials();
            int x$2 = parsedURI.options().copy$default$1();
            Option<String> x$3 = parsedURI.options().copy$default$2();
            boolean x$4 = parsedURI.options().copy$default$3();
            boolean x$5 = parsedURI.options().copy$default$4();
            AuthenticationMode x$6 = parsedURI.options().copy$default$5();
            boolean x$7 = parsedURI.options().copy$default$6();
            boolean x$8 = parsedURI.options().copy$default$7();
            int x$9 = parsedURI.options().copy$default$8();
            Option<Object> x$10 = parsedURI.options().copy$default$9();
            int x$11 = parsedURI.options().copy$default$10();
            int x$12 = parsedURI.options().copy$default$11();
            WriteConcern x$13 = parsedURI.options().copy$default$12();
            ReadPreference x$14 = parsedURI.options().copy$default$13();
            FailoverStrategy x$15 = parsedURI.options().copy$default$14();
            int x$16 = parsedURI.options().copy$default$15();
            int x$17 = parsedURI.options().copy$default$16();
            int x$18 = parsedURI.options().copy$default$17();
            Option<MongoConnectionOptions.KeyStore> x$19 = parsedURI.options().copy$default$19();
            ReadConcern x$20 = parsedURI.options().copy$default$20();
            Option<String> x$21 = parsedURI.options().copy$default$21();
            future = this.askConnection((Seq<String>)((IterableOnceOps)parsedURI.hosts().map((Function1 & Serializable)h -> new StringBuilder(11).append((String)h._1()).append(':').append(h._2$mcI$sp()).toString())).toSeq(), parsedURI.options().copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$1, x$19, x$20, x$21), name);
        }
        return future;
    }

    public <T> Future<MongoConnection> connect(MongoConnection.URI<T> parsedURI) {
        return this.connect(parsedURI, (Option<String>)None$.MODULE$);
    }

    private StackTraceElement[] closedBy() {
        return this.closedBy;
    }

    private void closedBy_$eq(StackTraceElement[] x$1) {
        this.closedBy = x$1;
    }

    public Future<BoxedUnit> close(FiniteDuration timeout, ExecutionContext ec) {
        Future future;
        boolean bl;
        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("[").append(this.supervisorName()).append("] Closing instance of ReactiveMongo driver").toString());
        StackTraceElement[] callerSTE = (StackTraceElement[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace()), 3)), 3);
        Function1<Option<FiniteDuration>, Future<BoxedUnit>> function1 = this.systemClose();
        synchronized (function1) {
            boolean bl2;
            if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.closedBy()))) {
                this.closedBy_$eq(callerSTE);
                bl2 = false;
            } else {
                bl2 = true;
            }
            bl = bl2;
        }
        boolean alreadyClosing = bl;
        if (alreadyClosing) {
            AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("System already closed: ").append(this.supervisorName()).toString());
            future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        } else {
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.supervisorActor());
            Close x$1 = AsyncDriver.msg$1(timeout);
            Timeout x$22 = new Timeout(timeout);
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            future = AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$22, x$3).recover((PartialFunction)new Serializable(this, callerSTE){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ AsyncDriver $outer;
                private final StackTraceElement[] callerSTE$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    A1.setStackTrace(this.callerSTE$1);
                    AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(96).append("[").append($this.$outer.supervisorName()).append("] Fails to close connections within timeout. Continuing closing of ReactiveMongo driver anyway.").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> A1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return (B1)boxedUnit;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = true;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.callerSTE$1 = callerSTE$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(reactivemongo.api.AsyncDriver$$anonfun$close$3 ), $anonfun$applyOrElse$2(java.lang.Throwable )}, serializedLambda);
                }
            }, ec).flatMap((Function1 & Serializable)x$2 -> (Future)this.systemClose().apply((Object)new Some((Object)timeout)), ec);
        }
        return future;
    }

    public FiniteDuration close$default$1() {
        return FiniteDuration$.MODULE$.apply(2L, TimeUnit.SECONDS);
    }

    private Function1<Option<FiniteDuration>, Future<BoxedUnit>> systemClose() {
        return this.systemClose;
    }

    public final String supervisorName() {
        return this.supervisorName;
    }

    public final ActorRef supervisorActor() {
        return this.supervisorActor;
    }

    public final Map<ActorRef, MongoConnection> connectionMonitors() {
        return this.connectionMonitors;
    }

    private AtomicLong connectionCounter() {
        return this.connectionCounter;
    }

    public Future<MongoConnection> askConnection(Seq<String> nodes, MongoConnectionOptions options, Option<String> name) {
        Future future;
        if (nodes.isEmpty()) {
            future = Future$.MODULE$.failed((Throwable)new ConnectionException("No node specified"));
        } else {
            MongoConnectionOptions mongoConnectionOptions;
            LazyRef dbsystem$lzy = new LazyRef();
            String nm = (String)name.getOrElse((Function0 & Serializable)() -> new StringBuilder(11).append("Connection-").append(this.connectionCounter().incrementAndGet()).toString());
            Seq authentications = ((IterableOnceOps)options.credentials().map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String db = (String)tuple2._1();
                MongoConnectionOptions.Credential c = (MongoConnectionOptions.Credential)tuple2._2();
                Authenticate authenticate = new Authenticate(db, c.user(), c.password());
                return authenticate;
            })).toSeq();
            Option<String> option = options.appName();
            if (option instanceof Some) {
                mongoConnectionOptions = options;
            } else {
                Some x$1 = new Some((Object)new StringBuilder(1).append(this.supervisorName()).append("/").append(nm).toString());
                int x$2 = options.copy$default$1();
                Option<String> x$3 = options.copy$default$2();
                boolean x$4 = options.copy$default$3();
                boolean x$5 = options.copy$default$4();
                AuthenticationMode x$6 = options.copy$default$5();
                boolean x$7 = options.copy$default$6();
                boolean x$8 = options.copy$default$7();
                int x$9 = options.copy$default$8();
                Option<Object> x$10 = options.copy$default$9();
                int x$11 = options.copy$default$10();
                int x$12 = options.copy$default$11();
                WriteConcern x$13 = options.copy$default$12();
                ReadPreference x$14 = options.copy$default$13();
                FailoverStrategy x$15 = options.copy$default$14();
                int x$16 = options.copy$default$15();
                int x$17 = options.copy$default$16();
                int x$18 = options.copy$default$17();
                scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$19 = options.copy$default$18();
                Option<MongoConnectionOptions.KeyStore> x$20 = options.copy$default$19();
                ReadConcern x$21 = options.copy$default$20();
                mongoConnectionOptions = options.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, (Option<String>)x$1);
            }
            MongoConnectionOptions opts = mongoConnectionOptions;
            ActorRef mongosystem = this.system().actorOf(Props$.MODULE$.apply((Function0 & Serializable)() -> this.dbsystem$1(dbsystem$lzy, opts, nm, nodes, authentications), ClassTag$.MODULE$.apply(MongoDBSystem.class)), nm);
            AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append("[").append(this.supervisorName()).append("] Creating connection: ").append(nm).toString());
            future = this.connection$1(nm, nodes, opts, mongosystem).mapTo(ClassTag$.MODULE$.apply(MongoConnection.class)).map((Function1 & Serializable)c -> {
                c.history_$eq((Function0<Exceptions.InternalState>)(Function0 & Serializable)() -> this.dbsystem$1(dbsystem$lzy, opts, nm, nodes, authentications).internalState());
                return c;
            }, (ExecutionContext)this.system().dispatcher());
        }
        return future;
    }

    public Object addConnectionMsg(String name, Seq<String> nodes, MongoConnectionOptions options, ActorRef mongosystem) {
        return new AddConnection(this, name, nodes, options, mongosystem);
    }

    private final void AddConnection$lzycompute$1() {
        AsyncDriver asyncDriver = this;
        synchronized (asyncDriver) {
            if (this.AddConnection$module == null) {
                this.AddConnection$module = new AsyncDriver$AddConnection$(this);
            }
        }
    }

    public static final /* synthetic */ Config $anonfun$system$1() {
        return ConfigFactory.load();
    }

    public static final /* synthetic */ String $anonfun$system$2() {
        return "No mongo-async-driver configuration found";
    }

    private static final ExecutionContext ec$1() {
        return package$.MODULE$.sameThreadExecutionContext();
    }

    private static final Close msg$1(FiniteDuration timeout$1) {
        return Close$.MODULE$.apply("AsyncDriver.close", timeout$1);
    }

    public static final /* synthetic */ Future $anonfun$systemClose$1(Function1 close$1, Option timeout) {
        Future future;
        Try try_ = (Try)close$1.apply((Object)timeout);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable cause = failure.exception();
            future = Future$.MODULE$.failed(cause);
        } else {
            future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        return future;
    }

    public static final /* synthetic */ Future $anonfun$systemClose$2(Function0 close$2, Option x$3) {
        return (Future)close$2.apply();
    }

    public static final /* synthetic */ Future $anonfun$systemClose$3(Throwable cause$1, Option x$4) {
        return Future$.MODULE$.failed(cause$1);
    }

    public static final /* synthetic */ SupervisorActor $anonfun$supervisorActor$1(AsyncDriver $this) {
        return new SupervisorActor($this, $this);
    }

    private final /* synthetic */ MongoDBSystem dbsystem$lzycompute$1(LazyRef dbsystem$lzy$1, MongoConnectionOptions opts$1, String nm$1, Seq nodes$1, Seq authentications$1) {
        MongoDBSystem mongoDBSystem;
        LazyRef lazyRef = dbsystem$lzy$1;
        synchronized (lazyRef) {
            MongoDBSystem mongoDBSystem2;
            if (dbsystem$lzy$1.initialized()) {
                mongoDBSystem2 = (MongoDBSystem)dbsystem$lzy$1.value();
            } else {
                AuthenticationMode authenticationMode = opts$1.authenticationMechanism();
                MongoDBSystem mongoDBSystem3 = X509Authentication$.MODULE$.equals(authenticationMode) ? new StandardDBSystemWithX509(this.supervisorName(), nm$1, (Seq<String>)nodes$1, (Seq<Authenticate>)authentications$1, opts$1) : (ScramSha256Authentication$.MODULE$.equals(authenticationMode) ? new StandardDBSystemWithScramSha256(this.supervisorName(), nm$1, (Seq<String>)nodes$1, (Seq<Authenticate>)authentications$1, opts$1) : new StandardDBSystem(this.supervisorName(), nm$1, (Seq<String>)nodes$1, (Seq<Authenticate>)authentications$1, opts$1));
                mongoDBSystem2 = (MongoDBSystem)dbsystem$lzy$1.initialize((Object)mongoDBSystem3);
            }
            mongoDBSystem = mongoDBSystem2;
        }
        return mongoDBSystem;
    }

    private final MongoDBSystem dbsystem$1(LazyRef dbsystem$lzy$1, MongoConnectionOptions opts$1, String nm$1, Seq nodes$1, Seq authentications$1) {
        return dbsystem$lzy$1.initialized() ? (MongoDBSystem)dbsystem$lzy$1.value() : this.dbsystem$lzycompute$1(dbsystem$lzy$1, opts$1, nm$1, nodes$1, authentications$1);
    }

    private static final Timeout timeout$2(MongoConnectionOptions opts$1) {
        return opts$1.connectTimeoutMS() > 0 ? Timeout$.MODULE$.apply((long)opts$1.connectTimeoutMS(), TimeUnit.MILLISECONDS) : Timeout$.MODULE$.apply(10000L, TimeUnit.MILLISECONDS);
    }

    private final Future connection$1(String nm$1, Seq nodes$1, MongoConnectionOptions opts$1, ActorRef mongosystem$1) {
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.supervisorActor());
        AddConnection x$1 = new AddConnection(this, nm$1, (Seq<String>)nodes$1, opts$1, mongosystem$1);
        Timeout x$2 = AsyncDriver.timeout$2(opts$1);
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        return AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3);
    }

    /*
     * Unable to fully structure code
     */
    public AsyncDriver(Option<Config> config, Option<ClassLoader> classLoader) {
        this.config = config;
        this.classLoader = classLoader;
        super();
        reference = (Config)config.getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$system$1(), ()Lcom/typesafe/config/Config;)());
        if (!reference.hasPath("mongo-async-driver")) {
            AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$system$2(), ()Ljava/lang/String;)());
            v0 = ConfigFactory.empty();
        } else {
            v0 = reference.getConfig("mongo-async-driver");
        }
        cfg = v0;
        this.system = ActorSystem$.MODULE$.apply("reactivemongo", (Option)new Some((Object)cfg), classLoader, ActorSystem$.MODULE$.apply$default$4());
        this.closedBy = (StackTraceElement[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StackTraceElement.class));
        var6_5 = false;
        var7_6 = null;
        var8_7 = SystemControl$.MODULE$.apply(this.system());
        if (!(var8_7 instanceof Success)) ** GOTO lbl-1000
        var6_5 = true;
        var7_6 = (Success)var8_7;
        var9_8 = (SystemControl)var7_6.value();
        if (var9_8 instanceof TimedSystemControl) {
            var10_9 = (TimedSystemControl)var9_8;
            close = var10_9.close();
            var3_11 = (Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$systemClose$1(scala.Function1 scala.Option ), (Lscala/Option;)Lscala/concurrent/Future;)(close);
        } else if (var6_5 && (var12_12 = (SystemControl)var7_6.value()) instanceof AsyncSystemControl) {
            var13_13 = (AsyncSystemControl)var12_12;
            close = var13_13.close();
            var3_11 = (Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$systemClose$2(scala.Function0 scala.Option ), (Lscala/Option;)Lscala/concurrent/Future;)(close);
        } else if (var8_7 instanceof Failure) {
            var15_15 = (Failure)var8_7;
            cause = var15_15.exception();
            var3_11 = (Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$systemClose$3(java.lang.Throwable scala.Option ), (Lscala/Option;)Lscala/concurrent/Future;)((Throwable)cause);
        } else {
            throw new MatchError(var8_7);
        }
        this.systemClose = var3_11;
        this.supervisorName = new StringBuilder(11).append("Supervisor-").append(AsyncDriver$.MODULE$.counter().incrementAndGet()).toString();
        this.supervisorActor = this.system().actorOf(Props$.MODULE$.apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$supervisorActor$1(reactivemongo.api.AsyncDriver ), ()Lreactivemongo/api/AsyncDriver$SupervisorActor;)((AsyncDriver)this), ClassTag$.MODULE$.apply(SupervisorActor.class)), this.supervisorName());
        this.connectionMonitors = (Map)Map$.MODULE$.empty();
        this.connectionCounter = new AtomicLong(0L);
    }

    private class AddConnection
    implements Product,
    Serializable {
        private final String name;
        private final Seq<String> nodes;
        private final MongoConnectionOptions options;
        private final ActorRef mongosystem;
        public final /* synthetic */ AsyncDriver $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String name() {
            return this.name;
        }

        public Seq<String> nodes() {
            return this.nodes;
        }

        public MongoConnectionOptions options() {
            return this.options;
        }

        public ActorRef mongosystem() {
            return this.mongosystem;
        }

        public AddConnection copy(String name, Seq<String> nodes, MongoConnectionOptions options, ActorRef mongosystem) {
            return new AddConnection(this.reactivemongo$api$AsyncDriver$AddConnection$$$outer(), name, nodes, options, mongosystem);
        }

        public String copy$default$1() {
            return this.name();
        }

        public Seq<String> copy$default$2() {
            return this.nodes();
        }

        public MongoConnectionOptions copy$default$3() {
            return this.options();
        }

        public ActorRef copy$default$4() {
            return this.mongosystem();
        }

        public String productPrefix() {
            return "AddConnection";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.name();
                    break;
                }
                case 1: {
                    object = this.nodes();
                    break;
                }
                case 2: {
                    object = this.options();
                    break;
                }
                case 3: {
                    object = this.mongosystem();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof AddConnection;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "name";
                    break;
                }
                case 1: {
                    string = "nodes";
                    break;
                }
                case 2: {
                    string = "options";
                    break;
                }
                case 3: {
                    string = "mongosystem";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof AddConnection)) return false;
            if (((AddConnection)object).reactivemongo$api$AsyncDriver$AddConnection$$$outer() != this.reactivemongo$api$AsyncDriver$AddConnection$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            AddConnection addConnection = (AddConnection)x$1;
            String string = this.name();
            String string2 = addConnection.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Seq<String> seq = this.nodes();
            Seq<String> seq2 = addConnection.nodes();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            MongoConnectionOptions mongoConnectionOptions = this.options();
            MongoConnectionOptions mongoConnectionOptions2 = addConnection.options();
            if (mongoConnectionOptions == null) {
                if (mongoConnectionOptions2 != null) {
                    return false;
                }
            } else if (!((Object)mongoConnectionOptions).equals(mongoConnectionOptions2)) return false;
            ActorRef actorRef = this.mongosystem();
            ActorRef actorRef2 = addConnection.mongosystem();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            if (!addConnection.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ AsyncDriver reactivemongo$api$AsyncDriver$AddConnection$$$outer() {
            return this.$outer;
        }

        public AddConnection(AsyncDriver $outer, String name, Seq<String> nodes, MongoConnectionOptions options, ActorRef mongosystem) {
            this.name = name;
            this.nodes = nodes;
            this.options = options;
            this.mongosystem = mongosystem;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    private final class SupervisorActor
    implements Actor {
        public final AsyncDriver reactivemongo$api$AsyncDriver$SupervisorActor$$driver;
        private final PartialFunction<Object, BoxedUnit> receive;
        private ActorContext context;
        private ActorRef self;
        private final /* synthetic */ AsyncDriver $outer;

        public final ActorRef sender() {
            return Actor.sender$((Actor)this);
        }

        @InternalApi
        public void aroundReceive(PartialFunction<Object, BoxedUnit> receive, Object msg) {
            Actor.aroundReceive$((Actor)this, receive, (Object)msg);
        }

        @InternalApi
        public void aroundPreStart() {
            Actor.aroundPreStart$((Actor)this);
        }

        @InternalApi
        public void aroundPostStop() {
            Actor.aroundPostStop$((Actor)this);
        }

        @InternalApi
        public void aroundPreRestart(Throwable reason, Option<Object> message) {
            Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
        }

        @InternalApi
        public void aroundPostRestart(Throwable reason) {
            Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
        }

        public SupervisorStrategy supervisorStrategy() {
            return Actor.supervisorStrategy$((Actor)this);
        }

        public void preStart() throws Exception {
            Actor.preStart$((Actor)this);
        }

        public void preRestart(Throwable reason, Option<Object> message) throws Exception {
            Actor.preRestart$((Actor)this, (Throwable)reason, message);
        }

        public void postRestart(Throwable reason) throws Exception {
            Actor.postRestart$((Actor)this, (Throwable)reason);
        }

        public void unhandled(Object message) {
            Actor.unhandled$((Actor)this, (Object)message);
        }

        public ActorContext context() {
            return this.context;
        }

        public final ActorRef self() {
            return this.self;
        }

        public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
            this.context = x$1;
        }

        public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
            this.self = x$1;
        }

        public boolean isEmpty() {
            return this.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.connectionMonitors().isEmpty();
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return this.receive;
        }

        public PartialFunction<Object, BoxedUnit> closing() {
            Queue waitingForClose = (Queue)Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ActorRef[]{this.sender()}));
            return new Serializable(this, waitingForClose){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ SupervisorActor $outer;
                private final Queue waitingForClose$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Option<String> option;
                    Object object;
                    boolean bl = false;
                    Close close2 = null;
                    A1 A1 = x1;
                    if (A1 instanceof AddConnection && ((AddConnection)A1).reactivemongo$api$AsyncDriver$AddConnection$$$outer() == this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer()) {
                        AddConnection addConnection = (AddConnection)A1;
                        String name = addConnection.name();
                        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Refusing to add connection while the driver is closing: ").append(name).toString());
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    if (A1 instanceof Terminated) {
                        Terminated terminated = (Terminated)A1;
                        this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.connectionMonitors().remove((Object)terminated.actor()).foreach((Function1 & Serializable)con -> {
                            SupervisorActor$$anonfun$closing$1.$anonfun$applyOrElse$8(this, con);
                            return BoxedUnit.UNIT;
                        });
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    if (A1 instanceof Close) {
                        bl = true;
                        close2 = (Close)A1;
                        Option<String> option2 = Close$.MODULE$.unapply(close2);
                        if (!option2.isEmpty()) {
                            String src = (String)option2.get();
                            if (this.$outer.isEmpty()) {
                                AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Close the supervisor for ").append(src).toString());
                                akka.actor.package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)Closed$.MODULE$, this.$outer.self());
                                object = BoxedUnit.UNIT;
                                return (B1)object;
                            }
                        }
                    }
                    if (bl && !(option = Close$.MODULE$.unapply(close2)).isEmpty()) {
                        String src = (String)option.get();
                        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Close request received from ").append(src).append(", but already closing.").toString());
                        this.waitingForClose$1.$plus$eq((Object)this.$outer.sender());
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(Object x1) {
                    boolean bl = false;
                    Close close2 = null;
                    Object object = x1;
                    if (object instanceof AddConnection && ((AddConnection)object).reactivemongo$api$AsyncDriver$AddConnection$$$outer() == this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer()) {
                        return true;
                    }
                    if (object instanceof Terminated) {
                        return true;
                    }
                    if (object instanceof Close) {
                        bl = true;
                        close2 = (Close)object;
                        Option<String> option = Close$.MODULE$.unapply(close2);
                        if (!option.isEmpty() && this.$outer.isEmpty()) {
                            return true;
                        }
                    }
                    if (!bl) return false;
                    Option<String> option = Close$.MODULE$.unapply(close2);
                    if (option.isEmpty()) return false;
                    return true;
                }

                public static final /* synthetic */ boolean $anonfun$applyOrElse$10(ActorRef x$6) {
                    return true;
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$11(SupervisorActor$$anonfun$closing$1 $this, ActorRef x$7) {
                    akka.actor.package$.MODULE$.actorRef2Scala(x$7).$bang((Object)Closed$.MODULE$, $this.$outer.self());
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$8(SupervisorActor$$anonfun$closing$1 $this, MongoConnection con) {
                    block0: {
                        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Connection is terminated: ").append(con.name()).toString());
                        if (!$this.$outer.isEmpty()) break block0;
                        $this.$outer.context().stop($this.$outer.self());
                        $this.waitingForClose$1.dequeueAll((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SupervisorActor$$anonfun$closing$1.$anonfun$applyOrElse$10(x$6))).foreach((Function1 & Serializable)x$7 -> {
                            SupervisorActor$$anonfun$closing$1.$anonfun$applyOrElse$11($this, x$7);
                            return BoxedUnit.UNIT;
                        });
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.waitingForClose$1 = waitingForClose$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10$adapted(akka.actor.ActorRef ), $anonfun$applyOrElse$11$adapted(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$closing$1 akka.actor.ActorRef ), $anonfun$applyOrElse$12(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$closing$1 java.lang.String ), $anonfun$applyOrElse$13(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$closing$1 java.lang.String ), $anonfun$applyOrElse$7(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$closing$1 java.lang.String ), $anonfun$applyOrElse$8$adapted(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$closing$1 reactivemongo.api.MongoConnection ), $anonfun$applyOrElse$9(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$closing$1 reactivemongo.api.MongoConnection )}, serializedLambda);
                }
            };
        }

        public void postStop() {
            AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("[").append($this.$outer.supervisorName()).append("] Stopping the monitor...").toString());
        }

        public /* synthetic */ AsyncDriver reactivemongo$api$AsyncDriver$SupervisorActor$$$outer() {
            return this.$outer;
        }

        public SupervisorActor(AsyncDriver $outer, AsyncDriver driver) {
            this.reactivemongo$api$AsyncDriver$SupervisorActor$$driver = driver;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Actor.$init$((Actor)this);
            this.receive = new Serializable(this){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ SupervisorActor $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Close close2;
                    Option<String> option;
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof AddConnection && ((AddConnection)A1).reactivemongo$api$AsyncDriver$AddConnection$$$outer() == this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer()) {
                        AddConnection addConnection = (AddConnection)A1;
                        String name = addConnection.name();
                        MongoConnectionOptions opts = addConnection.options();
                        ActorRef sys = addConnection.mongosystem();
                        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Add connection to the supervisor: ").append(name).toString());
                        MongoConnection connection = new MongoConnection(this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName(), name, this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.system(), sys, opts);
                        this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.connectionMonitors().put((Object)connection.monitor(), (Object)connection);
                        this.$outer.context().watch(connection.monitor());
                        akka.actor.package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)connection, this.$outer.self());
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof Terminated) {
                        Terminated terminated = (Terminated)A1;
                        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Connection is terminated: ").append(terminated.actor().path()).toString());
                        this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.connectionMonitors().remove((Object)terminated.actor());
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof Close && !(option = Close$.MODULE$.unapply(close2 = (Close)A1)).isEmpty()) {
                        BoxedUnit boxedUnit;
                        String src = (String)option.get();
                        AsyncDriver$.MODULE$.reactivemongo$api$AsyncDriver$$logger().debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("[").append($this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Close the supervisor for ").append(src).toString());
                        if (this.$outer.isEmpty()) {
                            this.$outer.context().stop(this.$outer.self());
                            akka.actor.package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)Closed$.MODULE$, this.$outer.self());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.$outer.context().become(this.$outer.closing());
                            Future$.MODULE$.sequence((IterableOnce)this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.connectionMonitors().values().map((Function1 & Serializable)x$5 -> x$5.close(SupervisorActor$$anonfun$1.timeout$3(close2))), BuildFrom$.MODULE$.buildFromIterableOps(), this.ec$2());
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        object = boxedUnit;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Close close2;
                    Option<String> option;
                    Object object = x1;
                    boolean bl = object instanceof AddConnection && ((AddConnection)object).reactivemongo$api$AsyncDriver$AddConnection$$$outer() == this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer() ? true : (object instanceof Terminated ? true : object instanceof Close && !(option = Close$.MODULE$.unapply(close2 = (Close)object)).isEmpty());
                    return bl;
                }

                private static final FiniteDuration timeout$3(Close x5$1) {
                    return x5$1.timeout();
                }

                private final ExecutionContext ec$2() {
                    return this.$outer.context().dispatcher();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$1 java.lang.String ), $anonfun$applyOrElse$4(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$1 akka.actor.Terminated ), $anonfun$applyOrElse$5(reactivemongo.api.AsyncDriver$SupervisorActor$$anonfun$1 java.lang.String ), $anonfun$applyOrElse$6(reactivemongo.core.actors.Close reactivemongo.api.MongoConnection )}, serializedLambda);
                }
            };
            Statics.releaseFence();
        }
    }
}

