/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api;

import akka.pattern.package$;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import reactivemongo.api.Failover$;
import reactivemongo.api.FailoverStrategy;
import reactivemongo.api.MongoConnection;
import reactivemongo.api.RetryableFailure$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u00055a!\u0002\n\u0014\u0005U9\u0002\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\t\u0011U\u0002!\u0011!Q\u0001\nYB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0006\u007f!)!\t\u0001C\u0001\u0007\"9!\n\u0001b\u0001\n\u0013Y\u0005BB,\u0001A\u0003%A\nC\u0004Y\u0001\t\u0007I\u0011A-\t\ri\u0003\u0001\u0015!\u0003%\u0011\u0015Y\u0006\u0001\"\u0003]\u0011\u0015i\u0006\u0001\"\u0003_\u000f\u0019!7\u0003#\u0001\u0016K\u001a1!c\u0005E\u0001+\u0019DQAQ\u0007\u0005\u0002\u001dD\u0001\u0002[\u0007C\u0002\u0013\u00051#\u001b\u0005\u0007o6\u0001\u000b\u0011\u00026\t\u000balA\u0011A=\u0003\u0011\u0019\u000b\u0017\u000e\\8wKJT!\u0001F\u000b\u0002\u0007\u0005\u0004\u0018NC\u0001\u0017\u00035\u0011X-Y2uSZ,Wn\u001c8h_V\u0011\u0001\u0004L\n\u0003\u0001e\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0017\u0001\u00039s_\u0012,8-\u001a:\u0004\u0001A\u0019!D\t\u0013\n\u0005\rZ\"!\u0003$v]\u000e$\u0018n\u001c81!\r)\u0003FK\u0007\u0002M)\u0011qeG\u0001\u000bG>t7-\u001e:sK:$\u0018BA\u0015'\u0005\u00191U\u000f^;sKB\u00111\u0006\f\u0007\u0001\t\u0015i\u0003A1\u0001/\u0005\u0005\t\u0015CA\u00183!\tQ\u0002'\u0003\u000227\t9aj\u001c;iS:<\u0007C\u0001\u000e4\u0013\t!4DA\u0002B]f\f!bY8o]\u0016\u001cG/[8o!\t9\u0004(D\u0001\u0014\u0013\tI4CA\bN_:<wnQ8o]\u0016\u001cG/[8o\u0003A1\u0017-\u001b7pm\u0016\u00148\u000b\u001e:bi\u0016<\u0017\u0010\u0005\u00028y%\u0011Qh\u0005\u0002\u0011\r\u0006LGn\u001c<feN#(/\u0019;fOf\f!!Z2\u0011\u0005\u0015\u0002\u0015BA!'\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0005\t\u001eC\u0015\n\u0006\u0002F\rB\u0019q\u0007\u0001\u0016\t\u000by*\u00019A \t\u000b})\u0001\u0019A\u0011\t\u000bU*\u0001\u0019\u0001\u001c\t\u000bi*\u0001\u0019A\u001e\u0002\u00071tW.F\u0001M!\tiEK\u0004\u0002O%B\u0011qjG\u0007\u0002!*\u0011\u0011\u000bI\u0001\u0007yI|w\u000e\u001e \n\u0005M[\u0012A\u0002)sK\u0012,g-\u0003\u0002V-\n11\u000b\u001e:j]\u001eT!aU\u000e\u0002\t1tW\u000eI\u0001\u0007MV$XO]3\u0016\u0003\u0011\nqAZ;ukJ,\u0007%\u0001\u0003oKb$H#\u0001\u0013\u0002\tM,g\u000e\u001a\u000b\u0003I}CQ\u0001Y\u0006A\u0002\u0005\f\u0011A\u001c\t\u00035\tL!aY\u000e\u0003\u0007%sG/\u0001\u0005GC&dwN^3s!\t9Tb\u0005\u0002\u000e3Q\tQ-\u0001\u0004m_\u001e<WM]\u000b\u0002UB\u00111\u000e\u001e\b\u0003YFt!!\\8\u000f\u0005=s\u0017\"\u0001\f\n\u0005A,\u0012\u0001B;uS2L!A]:\u0002\u00151\u000b'0\u001f'pO\u001e,'O\u0003\u0002q+%\u0011QO\u001e\u0002\u000b\u0019\u0006T\u0018\u0010T8hO\u0016\u0014(B\u0001:t\u0003\u001dawnZ4fe\u0002\nQ!\u00199qYf,\"A_@\u0015\u000bm\fI!a\u0003\u0015\u0007q\f\u0019\u0001F\u0002~\u0003\u0003\u00012a\u000e\u0001\u007f!\tYs\u0010B\u0003.#\t\u0007a\u0006C\u0003?#\u0001\u000fq\b\u0003\u0004 #\u0001\u0007\u0011Q\u0001\t\u00055\t\n9\u0001E\u0002&QyDQ!N\tA\u0002YBQAO\tA\u0002m\u0002")
public final class Failover<A> {
    private final Function0<Future<A>> producer;
    private final MongoConnection connection;
    private final FailoverStrategy failoverStrategy;
    private final ExecutionContext ec;
    private final String lnm;
    private final Future<A> future;

    public static <A> Failover<A> apply(MongoConnection connection, FailoverStrategy failoverStrategy, Function0<Future<A>> producer, ExecutionContext ec) {
        return Failover$.MODULE$.apply(connection, failoverStrategy, producer, ec);
    }

    private String lnm() {
        return this.lnm;
    }

    public Future<A> future() {
        return this.future;
    }

    private Future<A> next() {
        Future future;
        try {
            future = (Future)this.producer.apply();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable producerErr = (Throwable)option.get();
            Future future2 = Future$.MODULE$.failed(producerErr);
            future = future2;
        }
        return future;
    }

    private Future<A> send(int n) {
        return this.next().map((Function1 & Serializable)x$1 -> new Success(x$1), this.ec).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Failure failure = new Failure(A1);
                return (B1)failure;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
        }, this.ec).flatMap((Function1 & Serializable)x0$1 -> {
            Future future;
            Option<Throwable> option;
            Try try_ = x0$1;
            if (try_ != null && !(option = RetryableFailure$.MODULE$.unapply(try_)).isEmpty()) {
                Future future2;
                Throwable e = (Throwable)option.get();
                if (n < $this.failoverStrategy.retries()) {
                    int n = n + 1;
                    double delayFactor = $this.failoverStrategy.delayFactor().apply$mcDI$sp(n);
                    FiniteDuration delay = (FiniteDuration)Duration$.MODULE$.unapply($this.failoverStrategy.initialDelay().$times(delayFactor)).fold((Function0 & Serializable)() -> $this.failoverStrategy.initialDelay(), (Function1 & Serializable)t -> FiniteDuration$.MODULE$.apply(t._1$mcJ$sp(), (TimeUnit)((Object)((Object)((Object)t._2())))));
                    Failover$.MODULE$.logger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("[").append(this.lnm()).append("] Got an error, retrying... (try #").append(n).append(" is scheduled in ").append(delay.toMillis()).append(" ms)").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    future2 = package$.MODULE$.after(delay, $this.connection.actorSystem().scheduler(), (Function0 & Serializable)() -> this.send(n), $this.ec);
                } else {
                    Failover$.MODULE$.logger().error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("[").append(this.lnm()).append("] Got an error, no more attempts to do. Completing with a failure... ").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    future2 = Future$.MODULE$.failed(e);
                }
                future = future2;
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                Failover$.MODULE$.logger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("[").append(this.lnm()).append("] Got an non retryable error, completing with a failure... ").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                future = Future$.MODULE$.failed(e);
            } else if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object response = success.value();
                Failover$.MODULE$.logger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("[").append(this.lnm()).append("] Got a successful result, completing...").toString());
                future = Future$.MODULE$.successful(response);
            } else {
                throw new MatchError((Object)try_);
            }
            return future;
        }, this.ec);
    }

    public Failover(Function0<Future<A>> producer, MongoConnection connection, FailoverStrategy failoverStrategy, ExecutionContext ec) {
        this.producer = producer;
        this.connection = connection;
        this.failoverStrategy = failoverStrategy;
        this.ec = ec;
        this.lnm = new StringBuilder(1).append(connection.supervisor()).append("/").append(connection.name()).toString();
        this.future = this.send(0);
    }
}

